/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.guesses;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.guesses.BaseGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SequenceGuess
extends BaseGuess {
    private static final Set<Character> START_POINTS = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('A'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('9')));
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d");

    public SequenceGuess(Context context) {
        super(context);
    }

    @Override
    public double exec(Match match) {
        char firstChar = match.token.charAt(0);
        double baseGuesses = this.determineBaseGuesses(firstChar);
        if (!match.ascending) {
            baseGuesses *= 2.0;
        }
        return baseGuesses * (double)match.tokenLength();
    }

    private double determineBaseGuesses(char firstChar) {
        if (START_POINTS.contains(Character.valueOf(firstChar))) {
            return 4.0;
        }
        if (DIGIT_PATTERN.matcher(String.valueOf(firstChar)).find()) {
            return 10.0;
        }
        return 26.0;
    }
}

