/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.CompletionStats;
import org.opensearch.client.opensearch._types.DocStats;
import org.opensearch.client.opensearch._types.FielddataStats;
import org.opensearch.client.opensearch._types.QueryCacheStats;
import org.opensearch.client.opensearch._types.SegmentsStats;
import org.opensearch.client.opensearch._types.StoreStats;
import org.opensearch.client.opensearch.cluster.stats.CharFilterTypes;
import org.opensearch.client.opensearch.cluster.stats.ClusterIndicesShards;
import org.opensearch.client.opensearch.cluster.stats.FieldTypesMappings;
import org.opensearch.client.opensearch.cluster.stats.IndicesVersions;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterIndices
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterIndices> {
    @Nullable
    private final CharFilterTypes analysis;
    @Nullable
    private final CompletionStats completion;
    @Nullable
    private final Long count;
    @Nullable
    private final DocStats docs;
    @Nullable
    private final FielddataStats fielddata;
    @Nullable
    private final FieldTypesMappings mappings;
    @Nullable
    private final QueryCacheStats queryCache;
    @Nullable
    private final SegmentsStats segments;
    @Nullable
    private final ClusterIndicesShards shards;
    @Nullable
    private final StoreStats store;
    @Nonnull
    private final List<IndicesVersions> versions;
    public static final JsonpDeserializer<ClusterIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterIndices::setupClusterIndicesDeserializer);

    private ClusterIndices(Builder builder) {
        this.analysis = builder.analysis;
        this.completion = builder.completion;
        this.count = builder.count;
        this.docs = builder.docs;
        this.fielddata = builder.fielddata;
        this.mappings = builder.mappings;
        this.queryCache = builder.queryCache;
        this.segments = builder.segments;
        this.shards = builder.shards;
        this.store = builder.store;
        this.versions = ApiTypeHelper.unmodifiable(builder.versions);
    }

    public static ClusterIndices of(Function<Builder, ObjectBuilder<ClusterIndices>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CharFilterTypes analysis() {
        return this.analysis;
    }

    @Nullable
    public final CompletionStats completion() {
        return this.completion;
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final DocStats docs() {
        return this.docs;
    }

    @Nullable
    public final FielddataStats fielddata() {
        return this.fielddata;
    }

    @Nullable
    public final FieldTypesMappings mappings() {
        return this.mappings;
    }

    @Nullable
    public final QueryCacheStats queryCache() {
        return this.queryCache;
    }

    @Nullable
    public final SegmentsStats segments() {
        return this.segments;
    }

    @Nullable
    public final ClusterIndicesShards shards() {
        return this.shards;
    }

    @Nullable
    public final StoreStats store() {
        return this.store;
    }

    @Nonnull
    public final List<IndicesVersions> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysis != null) {
            generator.writeKey("analysis");
            this.analysis.serialize(generator, mapper);
        }
        if (this.completion != null) {
            generator.writeKey("completion");
            this.completion.serialize(generator, mapper);
        }
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.docs != null) {
            generator.writeKey("docs");
            this.docs.serialize(generator, mapper);
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.queryCache != null) {
            generator.writeKey("query_cache");
            this.queryCache.serialize(generator, mapper);
        }
        if (this.segments != null) {
            generator.writeKey("segments");
            this.segments.serialize(generator, mapper);
        }
        if (this.shards != null) {
            generator.writeKey("shards");
            this.shards.serialize(generator, mapper);
        }
        if (this.store != null) {
            generator.writeKey("store");
            this.store.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (IndicesVersions item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterIndicesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analysis, CharFilterTypes._DESERIALIZER, "analysis");
        op.add(Builder::completion, CompletionStats._DESERIALIZER, "completion");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::docs, DocStats._DESERIALIZER, "docs");
        op.add(Builder::fielddata, FielddataStats._DESERIALIZER, "fielddata");
        op.add(Builder::mappings, FieldTypesMappings._DESERIALIZER, "mappings");
        op.add(Builder::queryCache, QueryCacheStats._DESERIALIZER, "query_cache");
        op.add(Builder::segments, SegmentsStats._DESERIALIZER, "segments");
        op.add(Builder::shards, ClusterIndicesShards._DESERIALIZER, "shards");
        op.add(Builder::store, StoreStats._DESERIALIZER, "store");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(IndicesVersions._DESERIALIZER), "versions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analysis);
        result = 31 * result + Objects.hashCode(this.completion);
        result = 31 * result + Objects.hashCode(this.count);
        result = 31 * result + Objects.hashCode(this.docs);
        result = 31 * result + Objects.hashCode(this.fielddata);
        result = 31 * result + Objects.hashCode(this.mappings);
        result = 31 * result + Objects.hashCode(this.queryCache);
        result = 31 * result + Objects.hashCode(this.segments);
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Objects.hashCode(this.store);
        result = 31 * result + Objects.hashCode(this.versions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIndices other = (ClusterIndices)o;
        return Objects.equals(this.analysis, other.analysis) && Objects.equals(this.completion, other.completion) && Objects.equals(this.count, other.count) && Objects.equals(this.docs, other.docs) && Objects.equals(this.fielddata, other.fielddata) && Objects.equals(this.mappings, other.mappings) && Objects.equals(this.queryCache, other.queryCache) && Objects.equals(this.segments, other.segments) && Objects.equals(this.shards, other.shards) && Objects.equals(this.store, other.store) && Objects.equals(this.versions, other.versions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterIndices> {
        @Nullable
        private CharFilterTypes analysis;
        @Nullable
        private CompletionStats completion;
        @Nullable
        private Long count;
        @Nullable
        private DocStats docs;
        @Nullable
        private FielddataStats fielddata;
        @Nullable
        private FieldTypesMappings mappings;
        @Nullable
        private QueryCacheStats queryCache;
        @Nullable
        private SegmentsStats segments;
        @Nullable
        private ClusterIndicesShards shards;
        @Nullable
        private StoreStats store;
        @Nullable
        private List<IndicesVersions> versions;

        public Builder() {
        }

        private Builder(ClusterIndices o) {
            this.analysis = o.analysis;
            this.completion = o.completion;
            this.count = o.count;
            this.docs = o.docs;
            this.fielddata = o.fielddata;
            this.mappings = o.mappings;
            this.queryCache = o.queryCache;
            this.segments = o.segments;
            this.shards = o.shards;
            this.store = o.store;
            this.versions = Builder._listCopy(o.versions);
        }

        private Builder(Builder o) {
            this.analysis = o.analysis;
            this.completion = o.completion;
            this.count = o.count;
            this.docs = o.docs;
            this.fielddata = o.fielddata;
            this.mappings = o.mappings;
            this.queryCache = o.queryCache;
            this.segments = o.segments;
            this.shards = o.shards;
            this.store = o.store;
            this.versions = Builder._listCopy(o.versions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analysis(@Nullable CharFilterTypes value) {
            this.analysis = value;
            return this;
        }

        @Nonnull
        public final Builder analysis(Function<CharFilterTypes.Builder, ObjectBuilder<CharFilterTypes>> fn) {
            return this.analysis(fn.apply(new CharFilterTypes.Builder()).build());
        }

        @Nonnull
        public final Builder completion(@Nullable CompletionStats value) {
            this.completion = value;
            return this;
        }

        @Nonnull
        public final Builder completion(Function<CompletionStats.Builder, ObjectBuilder<CompletionStats>> fn) {
            return this.completion(fn.apply(new CompletionStats.Builder()).build());
        }

        @Nonnull
        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder docs(@Nullable DocStats value) {
            this.docs = value;
            return this;
        }

        @Nonnull
        public final Builder docs(Function<DocStats.Builder, ObjectBuilder<DocStats>> fn) {
            return this.docs(fn.apply(new DocStats.Builder()).build());
        }

        @Nonnull
        public final Builder fielddata(@Nullable FielddataStats value) {
            this.fielddata = value;
            return this;
        }

        @Nonnull
        public final Builder fielddata(Function<FielddataStats.Builder, ObjectBuilder<FielddataStats>> fn) {
            return this.fielddata(fn.apply(new FielddataStats.Builder()).build());
        }

        @Nonnull
        public final Builder mappings(@Nullable FieldTypesMappings value) {
            this.mappings = value;
            return this;
        }

        @Nonnull
        public final Builder mappings(Function<FieldTypesMappings.Builder, ObjectBuilder<FieldTypesMappings>> fn) {
            return this.mappings(fn.apply(new FieldTypesMappings.Builder()).build());
        }

        @Nonnull
        public final Builder queryCache(@Nullable QueryCacheStats value) {
            this.queryCache = value;
            return this;
        }

        @Nonnull
        public final Builder queryCache(Function<QueryCacheStats.Builder, ObjectBuilder<QueryCacheStats>> fn) {
            return this.queryCache(fn.apply(new QueryCacheStats.Builder()).build());
        }

        @Nonnull
        public final Builder segments(@Nullable SegmentsStats value) {
            this.segments = value;
            return this;
        }

        @Nonnull
        public final Builder segments(Function<SegmentsStats.Builder, ObjectBuilder<SegmentsStats>> fn) {
            return this.segments(fn.apply(new SegmentsStats.Builder()).build());
        }

        @Nonnull
        public final Builder shards(@Nullable ClusterIndicesShards value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ClusterIndicesShards.Builder, ObjectBuilder<ClusterIndicesShards>> fn) {
            return this.shards(fn.apply(new ClusterIndicesShards.Builder()).build());
        }

        @Nonnull
        public final Builder store(@Nullable StoreStats value) {
            this.store = value;
            return this;
        }

        @Nonnull
        public final Builder store(Function<StoreStats.Builder, ObjectBuilder<StoreStats>> fn) {
            return this.store(fn.apply(new StoreStats.Builder()).build());
        }

        @Nonnull
        public final Builder versions(List<IndicesVersions> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        @Nonnull
        public final Builder versions(IndicesVersions value, IndicesVersions ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        @Nonnull
        public final Builder versions(Function<IndicesVersions.Builder, ObjectBuilder<IndicesVersions>> fn) {
            return this.versions(fn.apply(new IndicesVersions.Builder()).build(), new IndicesVersions[0]);
        }

        @Override
        @Nonnull
        public ClusterIndices build() {
            this._checkSingleUse();
            return new ClusterIndices(this);
        }
    }
}

