/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.single.extractor;

import java.util.HashSet;
import org.apache.lucene.search.Query;
import org.opensearch.neuralsearch.highlight.single.extractor.QueryTextExtractor;
import org.opensearch.neuralsearch.highlight.single.extractor.QueryTextExtractorRegistry;
import org.opensearch.neuralsearch.query.HybridQuery;

public class HybridQueryTextExtractor
implements QueryTextExtractor {
    private final QueryTextExtractorRegistry registry;

    public HybridQueryTextExtractor(QueryTextExtractorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String extractQueryText(Query query, String fieldName) {
        HybridQuery hybridQuery = this.toQueryType(query, HybridQuery.class);
        HashSet<String> queryTexts = new HashSet<String>();
        for (Query subQuery : hybridQuery.getSubQueries()) {
            String extractedText = this.registry.extractQueryText(subQuery, fieldName);
            if (extractedText == null || extractedText.isEmpty()) continue;
            queryTexts.add(extractedText);
        }
        return String.join((CharSequence)" ", queryTexts).trim();
    }
}

