/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.libsvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Logger;
import libsvm.svm_parameter;
import org.tribuo.Output;
import org.tribuo.common.libsvm.KernelType;
import org.tribuo.common.libsvm.SVMType;

public class SVMParameters<T extends Output<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SVMParameters.class.getName());
    protected final SVMType<T> svmType;
    protected final KernelType kernelType;
    protected final svm_parameter parameters = new svm_parameter();

    public SVMParameters(SVMType<T> svmType, KernelType kernelType) {
        this.svmType = svmType;
        this.kernelType = kernelType;
        this.parameters.svm_type = svmType.getNativeType();
        this.parameters.kernel_type = kernelType.getNativeType();
        this.parameters.degree = 3;
        this.parameters.gamma = 0.0;
        this.parameters.coef0 = 0.0;
        this.parameters.nu = 0.5;
        this.parameters.cache_size = 500.0;
        this.parameters.C = 1.0;
        this.parameters.eps = 0.001;
        this.parameters.p = 0.1;
        this.parameters.shrinking = 1;
        this.parameters.probability = 0;
        this.parameters.nr_weight = 0;
        this.parameters.weight_label = new int[0];
        this.parameters.weight = new double[0];
    }

    public SVMType<T> getSvmType() {
        return this.svmType;
    }

    public KernelType getKernelType() {
        return this.kernelType;
    }

    public svm_parameter getParameters() {
        return this.parameters;
    }

    public String toString() {
        return SVMParameters.svmParamsToString(this.parameters);
    }

    public void setProbability() {
        this.parameters.probability = 1;
    }

    public void setCost(double c) {
        if (this.svmType.isNu() || !this.svmType.isClassification()) {
            logger.warning(String.format("Setting cost %f for non-C_SVC model", c));
        }
        this.parameters.C = c;
    }

    public void setNu(double nu) {
        if (!this.svmType.isNu()) {
            logger.warning(String.format("Setting nu %f for non-NU_SVM model", nu));
        }
        this.parameters.nu = nu;
    }

    public void setCoeff(double coeff) {
        this.parameters.coef0 = coeff;
    }

    public void setEpsilon(double epsilon) {
        this.parameters.p = epsilon;
    }

    public void setDegree(int degree) {
        this.parameters.degree = degree;
    }

    public void setGamma(double gamma) {
        this.parameters.gamma = gamma;
    }

    public double getGamma() {
        return this.parameters.gamma;
    }

    public void setCacheSize(double cacheMB) {
        if (cacheMB <= 0.0) {
            throw new IllegalArgumentException("Cache must be larger than 0MB");
        }
        this.parameters.cache_size = cacheMB;
    }

    public static svm_parameter copyParameters(svm_parameter input) {
        svm_parameter copy = new svm_parameter();
        copy.svm_type = input.svm_type;
        copy.kernel_type = input.kernel_type;
        copy.degree = input.degree;
        copy.gamma = input.gamma;
        copy.coef0 = input.coef0;
        copy.cache_size = input.cache_size;
        copy.eps = input.eps;
        copy.C = input.C;
        copy.nr_weight = input.nr_weight;
        copy.nu = input.nu;
        copy.p = input.p;
        copy.shrinking = input.shrinking;
        copy.probability = input.probability;
        copy.weight_label = input.weight_label != null ? Arrays.copyOf(input.weight_label, input.weight_label.length) : null;
        copy.weight = input.weight != null ? Arrays.copyOf(input.weight, input.weight.length) : null;
        return copy;
    }

    public static String svmParamsToString(svm_parameter param) {
        StringBuilder sb = new StringBuilder();
        sb.append("svm_parameter(svm_type=");
        sb.append(param.svm_type);
        sb.append(", kernel_type=");
        sb.append(param.kernel_type);
        sb.append(", degree=");
        sb.append(param.degree);
        sb.append(", gamma=");
        sb.append(param.gamma);
        sb.append(", coef0=");
        sb.append(param.coef0);
        sb.append(", cache_size=");
        sb.append(param.coef0);
        sb.append(", eps=");
        sb.append(param.eps);
        sb.append(", C=");
        sb.append(param.C);
        sb.append(", nr_weight=");
        sb.append(param.nr_weight);
        if (param.weight_label != null) {
            sb.append(", weight_label=");
            sb.append(Arrays.toString(param.weight_label));
        }
        if (param.weight != null) {
            sb.append(", weight=");
            sb.append(Arrays.toString(param.weight));
        }
        sb.append(", nu=");
        sb.append(param.nu);
        sb.append(", p=");
        sb.append(param.p);
        sb.append(", shrinking=");
        sb.append(param.shrinking);
        sb.append(", probability=");
        sb.append(param.probability);
        sb.append(')');
        return sb.toString();
    }
}

