/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexSettingsLifecycleStep;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSettingsLifecycle
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSettingsLifecycle> {
    @Nullable
    private final Boolean indexingComplete;
    @Nonnull
    private final String name;
    @Nullable
    private final Long originationDate;
    @Nullable
    private final Boolean parseOriginationDate;
    @Nullable
    private final String rolloverAlias;
    @Nullable
    private final IndexSettingsLifecycleStep step;
    public static final JsonpDeserializer<IndexSettingsLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsLifecycle::setupIndexSettingsLifecycleDeserializer);

    private IndexSettingsLifecycle(Builder builder) {
        this.indexingComplete = builder.indexingComplete;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.originationDate = builder.originationDate;
        this.parseOriginationDate = builder.parseOriginationDate;
        this.rolloverAlias = builder.rolloverAlias;
        this.step = builder.step;
    }

    public static IndexSettingsLifecycle of(Function<Builder, ObjectBuilder<IndexSettingsLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean indexingComplete() {
        return this.indexingComplete;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Long originationDate() {
        return this.originationDate;
    }

    @Nullable
    public final Boolean parseOriginationDate() {
        return this.parseOriginationDate;
    }

    @Nullable
    public final String rolloverAlias() {
        return this.rolloverAlias;
    }

    @Nullable
    public final IndexSettingsLifecycleStep step() {
        return this.step;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexingComplete != null) {
            generator.writeKey("indexing_complete");
            generator.write(this.indexingComplete.booleanValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.originationDate != null) {
            generator.writeKey("origination_date");
            generator.write(this.originationDate.longValue());
        }
        if (this.parseOriginationDate != null) {
            generator.writeKey("parse_origination_date");
            generator.write(this.parseOriginationDate.booleanValue());
        }
        if (this.rolloverAlias != null) {
            generator.writeKey("rollover_alias");
            generator.write(this.rolloverAlias);
        }
        if (this.step != null) {
            generator.writeKey("step");
            this.step.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSettingsLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexingComplete, JsonpDeserializer.booleanDeserializer(), "indexing_complete");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::originationDate, JsonpDeserializer.longDeserializer(), "origination_date");
        op.add(Builder::parseOriginationDate, JsonpDeserializer.booleanDeserializer(), "parse_origination_date");
        op.add(Builder::rolloverAlias, JsonpDeserializer.stringDeserializer(), "rollover_alias");
        op.add(Builder::step, IndexSettingsLifecycleStep._DESERIALIZER, "step");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.indexingComplete);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.originationDate);
        result = 31 * result + Objects.hashCode(this.parseOriginationDate);
        result = 31 * result + Objects.hashCode(this.rolloverAlias);
        result = 31 * result + Objects.hashCode(this.step);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsLifecycle other = (IndexSettingsLifecycle)o;
        return Objects.equals(this.indexingComplete, other.indexingComplete) && this.name.equals(other.name) && Objects.equals(this.originationDate, other.originationDate) && Objects.equals(this.parseOriginationDate, other.parseOriginationDate) && Objects.equals(this.rolloverAlias, other.rolloverAlias) && Objects.equals(this.step, other.step);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSettingsLifecycle> {
        @Nullable
        private Boolean indexingComplete;
        private String name;
        @Nullable
        private Long originationDate;
        @Nullable
        private Boolean parseOriginationDate;
        @Nullable
        private String rolloverAlias;
        @Nullable
        private IndexSettingsLifecycleStep step;

        public Builder() {
        }

        private Builder(IndexSettingsLifecycle o) {
            this.indexingComplete = o.indexingComplete;
            this.name = o.name;
            this.originationDate = o.originationDate;
            this.parseOriginationDate = o.parseOriginationDate;
            this.rolloverAlias = o.rolloverAlias;
            this.step = o.step;
        }

        private Builder(Builder o) {
            this.indexingComplete = o.indexingComplete;
            this.name = o.name;
            this.originationDate = o.originationDate;
            this.parseOriginationDate = o.parseOriginationDate;
            this.rolloverAlias = o.rolloverAlias;
            this.step = o.step;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indexingComplete(@Nullable Boolean value) {
            this.indexingComplete = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder originationDate(@Nullable Long value) {
            this.originationDate = value;
            return this;
        }

        @Nonnull
        public final Builder parseOriginationDate(@Nullable Boolean value) {
            this.parseOriginationDate = value;
            return this;
        }

        @Nonnull
        public final Builder rolloverAlias(@Nullable String value) {
            this.rolloverAlias = value;
            return this;
        }

        @Nonnull
        public final Builder step(@Nullable IndexSettingsLifecycleStep value) {
            this.step = value;
            return this;
        }

        @Nonnull
        public final Builder step(Function<IndexSettingsLifecycleStep.Builder, ObjectBuilder<IndexSettingsLifecycleStep>> fn) {
            return this.step(fn.apply(new IndexSettingsLifecycleStep.Builder()).build());
        }

        @Override
        @Nonnull
        public IndexSettingsLifecycle build() {
            this._checkSingleUse();
            return new IndexSettingsLifecycle(this);
        }
    }
}

