/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class CatRequestBase
extends RequestBase {
    @Nonnull
    private final List<String> headers;
    @Nonnull
    private final List<String> sort;

    protected CatRequestBase() {
        this.headers = ApiTypeHelper.undefinedList();
        this.sort = ApiTypeHelper.undefinedList();
    }

    protected CatRequestBase(AbstractBuilder<?> builder) {
        super(builder);
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    @Nonnull
    public final List<String> headers() {
        return this.headers;
    }

    @Nonnull
    public final List<String> sort() {
        return this.sort;
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.headers)) {
            params.put("h", String.join((CharSequence)",", this.headers));
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            params.put("s", String.join((CharSequence)",", this.sort));
        }
        params.put("format", "json");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends RequestBase.AbstractBuilder<BuilderT> {
        @Nullable
        protected List<String> headers;
        @Nullable
        protected List<String> sort;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(CatRequestBase o) {
            super(o);
            this.headers = AbstractBuilder._listCopy(o.headers);
            this.sort = AbstractBuilder._listCopy(o.sort);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.headers = AbstractBuilder._listCopy(o.headers);
            this.sort = AbstractBuilder._listCopy(o.sort);
        }

        @Nonnull
        public final BuilderT headers(List<String> values) {
            this.headers = AbstractBuilder._listAddAll(this.headers, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT headers(String value, String ... values) {
            this.headers = AbstractBuilder._listAdd(this.headers, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sort(List<String> values) {
            this.sort = AbstractBuilder._listAddAll(this.sort, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sort(String value, String ... values) {
            this.sort = AbstractBuilder._listAdd(this.sort, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

