/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.DecayFunction;
import org.opensearch.client.opensearch._types.query_dsl.FieldValueFactorScoreFunction;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreVariant;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RandomScoreFunction;
import org.opensearch.client.opensearch._types.query_dsl.ScriptScoreFunction;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class FunctionScore
implements TaggedUnion<Kind, FunctionScoreVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final FunctionScoreVariant _value;
    @Nullable
    private final Query filter;
    @Nullable
    private final Float weight;
    public static final JsonpDeserializer<FunctionScore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FunctionScore::setupFunctionScoreDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final FunctionScoreVariant _get() {
        return this._value;
    }

    public FunctionScore(FunctionScoreVariant value) {
        if (value != null) {
            this._kind = ApiTypeHelper.requireNonNull(value._functionScoreKind(), this, "<variant kind>");
            this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        } else {
            this._kind = null;
            this._value = null;
        }
        this.filter = null;
        this.weight = null;
    }

    private FunctionScore(Builder builder) {
        this.filter = builder.filter;
        this.weight = builder.weight;
        if (builder._kind != null) {
            this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
            this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        } else {
            this._kind = null;
            this._value = null;
        }
    }

    public static FunctionScore of(Function<Builder, ObjectBuilder<FunctionScore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Float weight() {
        return this.weight;
    }

    public boolean isExp() {
        return this._kind == Kind.Exp;
    }

    public DecayFunction exp() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Exp);
    }

    public boolean isFieldValueFactor() {
        return this._kind == Kind.FieldValueFactor;
    }

    public FieldValueFactorScoreFunction fieldValueFactor() {
        return (FieldValueFactorScoreFunction)TaggedUnionUtils.get(this, Kind.FieldValueFactor);
    }

    public boolean isGauss() {
        return this._kind == Kind.Gauss;
    }

    public DecayFunction gauss() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Gauss);
    }

    public boolean isLinear() {
        return this._kind == Kind.Linear;
    }

    public DecayFunction linear() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Linear);
    }

    public boolean isRandomScore() {
        return this._kind == Kind.RandomScore;
    }

    public RandomScoreFunction randomScore() {
        return (RandomScoreFunction)TaggedUnionUtils.get(this, Kind.RandomScore);
    }

    public boolean isScriptScore() {
        return this._kind == Kind.ScriptScore;
    }

    public ScriptScoreFunction scriptScore() {
        return (ScriptScoreFunction)TaggedUnionUtils.get(this, Kind.ScriptScore);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write((double)this.weight.floatValue());
        }
        if (this._kind != null) {
            generator.writeKey(this._kind.jsonValue());
            if (this._value instanceof JsonpSerializable) {
                ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
            }
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFunctionScoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::weight, JsonpDeserializer.floatDeserializer(), "weight");
        op.add(Builder::exp, DecayFunction._DESERIALIZER, "exp");
        op.add(Builder::fieldValueFactor, FieldValueFactorScoreFunction._DESERIALIZER, "field_value_factor");
        op.add(Builder::gauss, DecayFunction._DESERIALIZER, "gauss");
        op.add(Builder::linear, DecayFunction._DESERIALIZER, "linear");
        op.add(Builder::randomScore, RandomScoreFunction._DESERIALIZER, "random_score");
        op.add(Builder::scriptScore, ScriptScoreFunction._DESERIALIZER, "script_score");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.weight);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScore other = (FunctionScore)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value) && Objects.equals(this.filter, other.filter) && Objects.equals(this.weight, other.weight);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FunctionScore> {
        private Kind _kind;
        private FunctionScoreVariant _value;
        @Nullable
        private Query filter;
        @Nullable
        private Float weight;

        public Builder() {
        }

        private Builder(FunctionScore o) {
            this.filter = o.filter;
            this.weight = o.weight;
            this._kind = o._kind;
            this._value = o._value;
        }

        @Nonnull
        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder weight(@Nullable Float value) {
            this.weight = value;
            return this;
        }

        public ContainerBuilder exp(DecayFunction v) {
            this._kind = Kind.Exp;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder exp(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.exp(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder fieldValueFactor(FieldValueFactorScoreFunction v) {
            this._kind = Kind.FieldValueFactor;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder fieldValueFactor(Function<FieldValueFactorScoreFunction.Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
            return this.fieldValueFactor(fn.apply(new FieldValueFactorScoreFunction.Builder()).build());
        }

        public ContainerBuilder gauss(DecayFunction v) {
            this._kind = Kind.Gauss;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder gauss(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.gauss(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder linear(DecayFunction v) {
            this._kind = Kind.Linear;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder linear(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.linear(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder randomScore(RandomScoreFunction v) {
            this._kind = Kind.RandomScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder randomScore(Function<RandomScoreFunction.Builder, ObjectBuilder<RandomScoreFunction>> fn) {
            return this.randomScore(fn.apply(new RandomScoreFunction.Builder()).build());
        }

        public ContainerBuilder scriptScore(ScriptScoreFunction v) {
            this._kind = Kind.ScriptScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptScore(Function<ScriptScoreFunction.Builder, ObjectBuilder<ScriptScoreFunction>> fn) {
            return this.scriptScore(fn.apply(new ScriptScoreFunction.Builder()).build());
        }

        @Override
        public FunctionScore build() {
            this._checkSingleUse();
            return new FunctionScore(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<FunctionScore> {
            private ContainerBuilder() {
            }

            @Nonnull
            public final ContainerBuilder filter(@Nullable Query value) {
                Builder.this.filter = value;
                return this;
            }

            @Nonnull
            public final ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.filter(fn.apply(new Query.Builder()).build());
            }

            @Nonnull
            public final ContainerBuilder weight(@Nullable Float value) {
                Builder.this.weight = value;
                return this;
            }

            @Override
            public FunctionScore build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Exp("exp"),
        FieldValueFactor("field_value_factor"),
        Gauss("gauss"),
        Linear("linear"),
        RandomScore("random_score"),
        ScriptScore("script_score");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

