/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ParseContext
implements Serializable {
    private static final long serialVersionUID = -5921436862145826534L;
    private final Map<String, Object> context = new HashMap<String, Object>();

    public <T> void set(Class<T> key, T value) {
        if (value != null) {
            this.context.put(key.getName(), value);
        } else {
            this.context.remove(key.getName());
        }
    }

    public <T> T get(Class<T> key) {
        return (T)this.context.get(key.getName());
    }

    public <T> T get(Class<T> key, T defaultValue) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isEmpty() {
        return this.context.size() == 0;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.context.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseContext that = (ParseContext)o;
        return this.context.equals(that.context);
    }

    public int hashCode() {
        return this.context.hashCode();
    }
}

