"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class OpensearchService {
  constructor(driver) {
    _defineProperty(this, "getIndex", async (context, req, res) => {
      const dataSourceRefId = req.query.dataSourceId;
      try {
        if (dataSourceRefId) {
          const remoteDataSourceClient = context.dataSource.opensearch.legacy.getClient(dataSourceRefId).callAPI;
          const {
            index
          } = req.body;
          const indices = await remoteDataSourceClient('cat.indices', {
            index,
            format: 'json',
            h: 'health,index,status'
          });
        } else {
          const {
            callAsCurrentUser
          } = this.driver.asScoped(req);
          const {
            index
          } = req.body;
          const indices = await callAsCurrentUser;
        }
        return res.ok({
          body: {
            ok: true,
            resp: indices
          }
        });
      } catch (err) {
        // Opensearch throws an index_not_found_exception which we'll treat as a success
        if (err.statusCode === 404) {
          return res.ok({
            body: {
              ok: false,
              resp: []
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false,
              resp: err.message
            }
          });
        }
      }
    });
    this.driver = driver;
  }
}
exports.default = OpensearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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