"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvOptions = exports.rawConfigServiceMock = exports.configServiceMock = exports.configMock = void 0;
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// these CANT be exported by the main entrypoint, as it cause ts check failures
// in `src/test` and `src/xpack/test` projects due to definition conflicts between
// mocha and jest declaring the same globals such as `it` or `beforeAll`, as the test
// files imports types from `core` that is importing the main `@osd/config` entrypoint.
// For now, these should be imported using `import {} from '@osd/config/target/mocks'`
var config_mock_1 = require("./config.mock");
Object.defineProperty(exports, "configMock", { enumerable: true, get: function () { return config_mock_1.configMock; } });
var config_service_mock_1 = require("./config_service.mock");
Object.defineProperty(exports, "configServiceMock", { enumerable: true, get: function () { return config_service_mock_1.configServiceMock; } });
var raw_config_service_mock_1 = require("./raw/raw_config_service.mock");
Object.defineProperty(exports, "rawConfigServiceMock", { enumerable: true, get: function () { return raw_config_service_mock_1.rawConfigServiceMock; } });
var env_1 = require("./__mocks__/env");
Object.defineProperty(exports, "getEnvOptions", { enumerable: true, get: function () { return env_1.getEnvOptions; } });
