function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { forwardRef, useImperativeHandle, useRef } from 'react';
import classNames from 'classnames';
import { OuiNotificationBadge } from '../../badge/notification_badge/badge_notification';
import { OuiIcon } from '../../icon';
import { OuiButtonEmpty } from '../../button';
import { OuiHideFor, OuiShowFor } from '../../responsive';
export var OuiHeaderSectionItemButton = /*#__PURE__*/forwardRef(function (_ref,
/**
 * Allows for animating with .ouiAnimate()
 */
ref) {
  var children = _ref.children,
    className = _ref.className,
    notification = _ref.notification,
    _ref$notificationColo = _ref.notificationColor,
    notificationColor = _ref$notificationColo === void 0 ? 'accent' : _ref$notificationColo,
    rest = _objectWithoutProperties(_ref, ["children", "className", "notification", "notificationColor"]);
  var buttonRef = useRef(null);
  var animationTargetRef = useRef(null);
  useImperativeHandle(ref, function () {
    buttonRef.current.ouiAnimate = function () {
      var _animationTargetRef$c;
      var keyframes = [{
        transform: 'rotate(0)',
        offset: 0,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(30deg)',
        offset: 0.01,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-28deg)',
        offset: 0.03,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(34deg)',
        offset: 0.05,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-32deg)',
        offset: 0.07,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(30deg)',
        offset: 0.09,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-28deg)',
        offset: 0.11,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(26deg)',
        offset: 0.13,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-24deg)',
        offset: 0.15,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(22deg)',
        offset: 0.17,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-20deg)',
        offset: 0.19,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(18deg)',
        offset: 0.21,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-16deg)',
        offset: 0.23,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(14deg)',
        offset: 0.25,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-12deg)',
        offset: 0.27,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(10deg)',
        offset: 0.29,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-8deg)',
        offset: 0.31,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(6deg)',
        offset: 0.33,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-4deg)',
        offset: 0.35,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(2deg)',
        offset: 0.37,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(-1deg)',
        offset: 0.39,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(1deg)',
        offset: 0.41,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(0)',
        offset: 0.43,
        easing: 'ease-in-out'
      }, {
        transform: 'rotate(0)',
        offset: 1,
        easing: 'ease-in-out'
      }];
      (_animationTargetRef$c = animationTargetRef.current) === null || _animationTargetRef$c === void 0 ? void 0 : _animationTargetRef$c.animate(keyframes, {
        duration: 5000
      });
    };
    return buttonRef.current;
  }, []);
  var classes = classNames('ouiHeaderSectionItemButton', className);
  var animationClasses = classNames(['ouiHeaderSectionItemButton__content']);
  var notificationDot = /*#__PURE__*/React.createElement(OuiIcon, {
    className: "ouiHeaderSectionItemButton__notification ouiHeaderSectionItemButton__notification--dot",
    color: notificationColor,
    type: "dot",
    size: "l"
  });
  var buttonNotification;
  if (notification === true) {
    buttonNotification = notificationDot;
  } else if (notification) {
    buttonNotification = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(OuiHideFor, {
      sizes: ['xs']
    }, /*#__PURE__*/React.createElement(OuiNotificationBadge, {
      className: "ouiHeaderSectionItemButton__notification ouiHeaderSectionItemButton__notification--badge",
      color: notificationColor
    }, notification)), /*#__PURE__*/React.createElement(OuiShowFor, {
      sizes: ['xs']
    }, notificationDot));
  }
  return /*#__PURE__*/React.createElement(OuiButtonEmpty, _extends({
    className: classes,
    color: "text",
    buttonRef: buttonRef
  }, rest), /*#__PURE__*/React.createElement("span", {
    ref: animationTargetRef,
    className: animationClasses
  }, children), buttonNotification);
});
OuiHeaderSectionItemButton.displayName = 'OuiHeaderSectionItemButton';

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { EuiHeaderSectionItemButton } from '../../../eui_components/header/header_section/header_section_item_button';