"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SQLService = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable no-console */

class SQLService {
  constructor(http) {
    _defineProperty(this, "http", void 0);
    _defineProperty(this, "fetch", async (params, dataSourceMDSId, errorHandler) => {
      const query = {
        dataSourceMDSId
      };
      return this.http.post('/api/observability/query/jobs', {
        body: JSON.stringify(params),
        query
      }).catch(error => {
        console.error('fetch error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    _defineProperty(this, "fetchWithJobId", async (params, dataSourceMDSId, errorHandler) => {
      return this.http.get(`/api/observability/query/jobs/${params.queryId}/${dataSourceMDSId !== null && dataSourceMDSId !== void 0 ? dataSourceMDSId : ''}`).catch(error => {
        console.error('fetch error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    _defineProperty(this, "deleteWithJobId", async (params, errorHandler) => {
      return this.http.delete(`/api/observability/query/jobs/${params.queryId}`).catch(error => {
        console.error('delete error: ', error.body);
        if (errorHandler) errorHandler(error);
        throw error;
      });
    });
    this.http = http;
  }
}
exports.SQLService = SQLService;