/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import java.util.Arrays;

public class BoundingBox
implements IBoundingBoxView {
    protected final float[] minValues;
    protected final float[] maxValues;
    protected double rangeSum;

    public BoundingBox(float[] point) {
        this.maxValues = point;
        this.minValues = point;
        this.rangeSum = 0.0;
    }

    public BoundingBox(float[] minValues, float[] maxValues, double sum) {
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.rangeSum = sum;
    }

    public BoundingBox(float[] first, float[] second) {
        CommonUtils.checkArgument(first.length == second.length, " incorrect lengths in box");
        this.minValues = new float[first.length];
        this.maxValues = new float[first.length];
        this.rangeSum = 0.0;
        for (int i = 0; i < this.minValues.length; ++i) {
            this.minValues[i] = Math.min(first[i], second[i]);
            this.maxValues[i] = Math.max(first[i], second[i]);
            this.rangeSum += (double)(this.maxValues[i] - this.minValues[i]);
        }
    }

    @Override
    public BoundingBox copy() {
        return new BoundingBox(Arrays.copyOf(this.minValues, this.minValues.length), Arrays.copyOf(this.maxValues, this.maxValues.length), this.rangeSum);
    }

    @Override
    public BoundingBox getMergedBox(IBoundingBoxView otherBox) {
        float[] minValuesMerged = new float[this.minValues.length];
        float[] maxValuesMerged = new float[this.minValues.length];
        double sum = 0.0;
        for (int i = 0; i < this.minValues.length; ++i) {
            minValuesMerged[i] = Math.min(this.minValues[i], (float)otherBox.getMinValue(i));
            maxValuesMerged[i] = Math.max(this.maxValues[i], (float)otherBox.getMaxValue(i));
            sum += (double)(maxValuesMerged[i] - minValuesMerged[i]);
        }
        return new BoundingBox(minValuesMerged, maxValuesMerged, sum);
    }

    public double probabilityOfCut(float[] point) {
        int i;
        double range = 0.0;
        for (i = 0; i < point.length; ++i) {
            range += (double)Math.max(this.minValues[i] - point[i], 0.0f);
        }
        for (i = 0; i < point.length; ++i) {
            range += (double)Math.max(point[i] - this.maxValues[i], 0.0f);
        }
        if (range == 0.0) {
            return 0.0;
        }
        if (this.rangeSum == 0.0) {
            return 1.0;
        }
        return range / (range + this.rangeSum);
    }

    @Override
    public BoundingBox getMergedBox(float[] point) {
        CommonUtils.checkArgument(point.length == this.minValues.length, "incorrect length");
        return this.copy().addPoint(point);
    }

    public float[] getMaxValues() {
        return this.maxValues;
    }

    public float[] getMinValues() {
        return this.minValues;
    }

    public BoundingBox addPoint(float[] point) {
        int i;
        CommonUtils.checkArgument(this.minValues.length == point.length, "incorrect length");
        CommonUtils.checkArgument(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (i = 0; i < point.length; ++i) {
            this.minValues[i] = Math.min(this.minValues[i], point[i]);
        }
        for (i = 0; i < point.length; ++i) {
            this.maxValues[i] = Math.max(this.maxValues[i], point[i]);
        }
        for (i = 0; i < point.length; ++i) {
            this.rangeSum += (double)(this.maxValues[i] - this.minValues[i]);
        }
        return this;
    }

    public BoundingBox addBox(BoundingBox otherBox) {
        int i;
        CommonUtils.checkState(this.minValues != this.maxValues, "not a mutable box");
        this.rangeSum = 0.0;
        for (i = 0; i < this.minValues.length; ++i) {
            this.minValues[i] = Math.min(this.minValues[i], otherBox.minValues[i]);
        }
        for (i = 0; i < this.minValues.length; ++i) {
            this.maxValues[i] = Math.max(this.maxValues[i], otherBox.maxValues[i]);
        }
        for (i = 0; i < this.minValues.length; ++i) {
            this.rangeSum += (double)(this.maxValues[i] - this.minValues[i]);
        }
        return this;
    }

    @Override
    public int getDimensions() {
        return this.minValues.length;
    }

    @Override
    public double getRangeSum() {
        return this.rangeSum;
    }

    @Override
    public double getMaxValue(int dimension) {
        return this.maxValues[dimension];
    }

    @Override
    public double getMinValue(int dimension) {
        return this.minValues[dimension];
    }

    public boolean contains(float[] point) {
        CommonUtils.checkArgument(point.length == this.minValues.length, " incorrect lengths");
        for (int i = 0; i < this.minValues.length; ++i) {
            if (!(this.minValues[i] > point[i]) && !(this.maxValues[i] < point[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BoundingBox otherBox) {
        CommonUtils.checkArgument(otherBox.minValues.length == this.minValues.length, " incorrect lengths");
        return this.contains(otherBox.minValues) && this.contains(otherBox.maxValues);
    }

    @Override
    public double getRange(int dimension) {
        return this.maxValues[dimension] - this.minValues[dimension];
    }

    public String toString() {
        return String.format("BoundingBox(%s, %s)", Arrays.toString(this.minValues), Arrays.toString(this.maxValues));
    }

    public boolean equals(Object other) {
        if (!(other instanceof BoundingBox)) {
            return false;
        }
        BoundingBox otherBox = (BoundingBox)other;
        return Arrays.equals(this.minValues, otherBox.minValues) && Arrays.equals(this.maxValues, otherBox.maxValues);
    }
}

