/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.transport.SuggestConfigParamResponse;

public class HistorySuggest {
    private Config config;
    private User user;
    private SearchFeatureDao searchFeatureDao;
    private IntervalTimeConfiguration intervalRecommended;
    private Map<String, Object> topEntity;
    private Clock clock;

    public HistorySuggest(Config config, User user, SearchFeatureDao searchFeatureDao, IntervalTimeConfiguration intervalRecommended, Map<String, Object> topEntity, Clock clock) {
        this.config = config;
        this.user = user;
        this.searchFeatureDao = searchFeatureDao;
        this.intervalRecommended = intervalRecommended;
        this.topEntity = topEntity;
        this.clock = clock;
    }

    public void suggestHistory(ActionListener<SuggestConfigParamResponse> listener) {
        if (this.intervalRecommended == null) {
            listener.onResponse((Object)new SuggestConfigParamResponse.Builder().history(this.config.getDefaultHistory()).build());
            return;
        }
        this.searchFeatureDao.getDateRangeOfSourceData(this.config, this.user, this.topEntity, (ActionListener<Pair<Long, Long>>)ActionListener.wrap(minMax -> {
            long minEpoch = (Long)minMax.getLeft();
            long maxEpoch = (Long)minMax.getRight();
            if (maxEpoch > this.clock.millis()) {
                maxEpoch = this.clock.millis();
            }
            int history = this.getNumberOfIntervals(minEpoch, maxEpoch, this.intervalRecommended);
            listener.onResponse((Object)new SuggestConfigParamResponse.Builder().history(Math.max(this.config.getDefaultHistory(), Math.min(history, 10000))).build());
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private int getNumberOfIntervals(long startEpochMillis, long endEpochMillis, IntervalTimeConfiguration intervalConfig) {
        if (endEpochMillis <= startEpochMillis) {
            return 0;
        }
        Duration intervalDuration = intervalConfig.toDuration();
        long intervalMillis = intervalDuration.toMillis();
        if (intervalMillis <= 0L) {
            throw new IllegalArgumentException("Interval duration must be positive");
        }
        long totalRangeMillis = endEpochMillis - startEpochMillis;
        return (int)(totalRangeMillis / intervalMillis);
    }
}

