/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.common;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.ObjectMap;

public class ObjectMapProtoUtils {
    private ObjectMapProtoUtils() {
    }

    public static ObjectMap.Value toProto(Object javaObject) {
        ObjectMap.Value.Builder valueBuilder = ObjectMap.Value.newBuilder();
        ObjectMapProtoUtils.toProto(javaObject, valueBuilder);
        return valueBuilder.build();
    }

    public static void toProto(Object javaObject, ObjectMap.Value.Builder valueBuilder) {
        if (javaObject == null) {
            valueBuilder.setNullValue(NullValue.NULL_VALUE_NULL);
            return;
        }
        Object object = javaObject;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, Enum.class, List.class, Map.class}, (Object)object2, n)) {
            case 0: {
                String s = (String)object2;
                valueBuilder.setString(s);
                break;
            }
            case 1: {
                Integer i = (Integer)object2;
                valueBuilder.setInt32(i.intValue());
                break;
            }
            case 2: {
                Long l = (Long)object2;
                valueBuilder.setInt64(l.longValue());
                break;
            }
            case 3: {
                Double d = (Double)object2;
                valueBuilder.setDouble(d.doubleValue());
                break;
            }
            case 4: {
                Float f = (Float)object2;
                valueBuilder.setFloat(f.floatValue());
                break;
            }
            case 5: {
                Boolean b = (Boolean)object2;
                valueBuilder.setBool(b.booleanValue());
                break;
            }
            case 6: {
                Enum e = (Enum)object2;
                valueBuilder.setString(e.toString());
                break;
            }
            case 7: {
                List list = (List)object2;
                ObjectMapProtoUtils.handleListValue(list, valueBuilder);
                break;
            }
            case 8: {
                Map m;
                Map map = m = (Map)object2;
                ObjectMapProtoUtils.handleMapValue(map, valueBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(javaObject) + " to google.protobuf.Struct");
            }
        }
    }

    private static void handleListValue(List<?> list, ObjectMap.Value.Builder valueBuilder) {
        ObjectMap.ListValue.Builder listBuilder = ObjectMap.ListValue.newBuilder();
        for (Object listEntry : list) {
            ObjectMap.Value.Builder entryBuilder = ObjectMap.Value.newBuilder();
            ObjectMapProtoUtils.toProto(listEntry, entryBuilder);
            listBuilder.addValue(entryBuilder.build());
        }
        valueBuilder.setListValue(listBuilder.build());
    }

    private static void handleMapValue(Map<String, Object> map, ObjectMap.Value.Builder valueBuilder) {
        ObjectMap.Builder objectMapBuilder = ObjectMap.newBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ObjectMap.Value.Builder entryValueBuilder = ObjectMap.Value.newBuilder();
            ObjectMapProtoUtils.toProto(entry.getValue(), entryValueBuilder);
            objectMapBuilder.putFields(entry.getKey(), entryValueBuilder.build());
        }
        valueBuilder.setObjectMap(objectMapBuilder.build());
    }
}

