/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent.bootstrap;

import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AgentPolicy {
    private static final Logger LOGGER = Logger.getLogger(AgentPolicy.class.getName());
    private static volatile Policy policy;
    private static volatile Set<String> trustedHosts;
    private static volatile Set<String> trustedFileSystems;
    private static volatile BiFunction<Class<?>, Collection<Class<?>>, Boolean> classesThatCanExit;

    private AgentPolicy() {
    }

    public static void setPolicy(Policy policy) {
        AgentPolicy.setPolicy(policy, Set.of(), Set.of(), new NoneCanExit());
    }

    public static void setPolicy(Policy policy, Set<String> trustedHosts, Set<String> trustedFileSystems, BiFunction<Class<?>, Collection<Class<?>>, Boolean> classesThatCanExit) {
        if (AgentPolicy.policy != null) {
            throw new SecurityException("The Policy has been set already: " + String.valueOf(AgentPolicy.policy));
        }
        AgentPolicy.policy = policy;
        AgentPolicy.trustedHosts = Collections.unmodifiableSet(trustedHosts);
        AgentPolicy.trustedFileSystems = Collections.unmodifiableSet(trustedFileSystems);
        AgentPolicy.classesThatCanExit = classesThatCanExit;
        LOGGER.info("Policy attached successfully: " + String.valueOf(policy));
    }

    public static void checkPermission(Permission permission) {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        List callers = walker.walk(frames -> frames.map(StackWalker.StackFrame::getDeclaringClass).map(Class::getProtectionDomain).distinct().collect(Collectors.toList()));
        for (ProtectionDomain domain : callers) {
            if (policy.implies(domain, permission)) continue;
            throw new SecurityException("Denied access: " + String.valueOf(permission));
        }
    }

    public static Policy getPolicy() {
        return policy;
    }

    public static boolean isTrustedHost(String hostname) {
        return trustedHosts.contains(hostname);
    }

    public static boolean isTrustedFileSystem(String fileSystem) {
        return trustedFileSystems.contains(fileSystem);
    }

    public static boolean isChainThatCanExit(Class<?> caller, Collection<Class<?>> chain) {
        return classesThatCanExit.apply(caller, chain);
    }

    public static final class NoneCanExit
    implements BiFunction<Class<?>, Collection<Class<?>>, Boolean> {
        @Override
        public Boolean apply(Class<?> caller, Collection<Class<?>> chain) {
            return true;
        }
    }

    public static final class AnyCanExit
    implements BiFunction<Class<?>, Collection<Class<?>>, Boolean> {
        private final String[] classesThatCanExit;

        public AnyCanExit(String[] classesThatCanExit) {
            this.classesThatCanExit = classesThatCanExit;
        }

        @Override
        public Boolean apply(Class<?> caller, Collection<Class<?>> chain) {
            for (Class<?> clazz : chain) {
                for (String classThatCanExit : this.classesThatCanExit) {
                    if (!clazz.getName().matches(classThatCanExit)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static final class CallerCanExit
    implements BiFunction<Class<?>, Stream<Class<?>>, Boolean> {
        private final String[] classesThatCanExit;

        public CallerCanExit(String[] classesThatCanExit) {
            this.classesThatCanExit = classesThatCanExit;
        }

        @Override
        public Boolean apply(Class<?> caller, Stream<Class<?>> chain) {
            for (String classThatCanExit : this.classesThatCanExit) {
                if (!caller.getName().equalsIgnoreCase(classThatCanExit)) continue;
                return true;
            }
            return false;
        }
    }
}

