/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.List;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.pipeline.Pipeline;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.ProcessorExecutionDetail;
import org.opensearch.search.pipeline.SystemGeneratedPipelineHolder;

public final class PipelinedRequest
extends SearchRequest {
    private final Pipeline pipeline;
    private final PipelineProcessingContext requestContext;
    private final SystemGeneratedPipelineHolder systemGeneratedPipelineHolder;

    PipelinedRequest(Pipeline pipeline, SearchRequest transformedRequest, PipelineProcessingContext requestContext, SystemGeneratedPipelineHolder systemGeneratedPipelineHolder) {
        super(transformedRequest);
        this.pipeline = pipeline;
        this.requestContext = requestContext;
        this.systemGeneratedPipelineHolder = systemGeneratedPipelineHolder;
    }

    PipelinedRequest(SearchRequest transformedRequest, PipelinedRequest original) {
        super(transformedRequest);
        this.pipeline = original.pipeline;
        this.requestContext = original.requestContext;
        this.systemGeneratedPipelineHolder = original.systemGeneratedPipelineHolder;
    }

    public void transformRequest(ActionListener<SearchRequest> requestListener) {
        List<Pipeline> pipelines = this.getPipelines();
        ActionListener currentListener = requestListener;
        boolean hasProcessor = false;
        for (int i = pipelines.size() - 1; i >= 0; --i) {
            Pipeline p = pipelines.get(i);
            if (p.getSearchRequestProcessors().isEmpty()) continue;
            hasProcessor = true;
            ActionListener nextListener = currentListener;
            currentListener = ActionListener.wrap(searchRequest -> p.transformRequest((PipelinedRequest)searchRequest, (ActionListener<SearchRequest>)nextListener), arg_0 -> requestListener.onFailure(arg_0));
        }
        if (hasProcessor) {
            currentListener.onResponse((Object)this);
        } else {
            requestListener.onResponse((Object)this);
        }
    }

    public ActionListener<SearchResponse> transformResponseListener(ActionListener<SearchResponse> responseListener) {
        List<Pipeline> pipelines = this.getPipelines();
        ActionListener<SearchResponse> currentListener = ActionListener.wrap(response -> {
            List<ProcessorExecutionDetail> details = this.requestContext.getProcessorExecutionDetails();
            if (!details.isEmpty() && response.getInternalResponse() != null) {
                response.getInternalResponse().getProcessorResult().addAll(details);
            }
            responseListener.onResponse(response);
        }, arg_0 -> responseListener.onFailure(arg_0));
        for (int i = pipelines.size() - 1; i >= 0; --i) {
            Pipeline p = pipelines.get(i);
            if (p.getSearchResponseProcessors().isEmpty()) continue;
            ActionListener<SearchResponse> nextListener = currentListener;
            currentListener = p.transformResponseListener(this, nextListener);
        }
        return currentListener;
    }

    public <Result extends SearchPhaseResult> void transformSearchPhaseResults(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext searchPhaseContext, String currentPhase, String nextPhase) {
        List<Pipeline> pipelines = this.getPipelines();
        for (Pipeline p : pipelines) {
            if (p.getSearchPhaseResultsProcessors().isEmpty()) continue;
            p.runSearchPhaseResultsTransformer(searchPhaseResult, searchPhaseContext, currentPhase, nextPhase, this.requestContext);
        }
    }

    private List<Pipeline> getPipelines() {
        return List.of(this.systemGeneratedPipelineHolder.prePipeline(), this.pipeline, this.systemGeneratedPipelineHolder.postPipeline());
    }

    Pipeline getPipeline() {
        return this.pipeline;
    }

    public PipelineProcessingContext getPipelineProcessingContext() {
        return this.requestContext;
    }

    public SystemGeneratedPipelineHolder getSystemGeneratedPipelineHolder() {
        return this.systemGeneratedPipelineHolder;
    }
}

