/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated CSharp file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

using System;
using System.Text;
using System.Runtime.InteropServices;

namespace Lib3MF {

	/// <summary>
	/// Exception class for Lib3MF errors
	/// </summary>
	public class ELib3MFException : Exception
	{
		private readonly int _errorCode;
		private readonly string _errorMessage;

		/// <summary>
		/// Initializes a new instance of the ELib3MFException class
		/// </summary>
		/// <param name="errorCode">The error code</param>
		/// <param name="errorMessage">The error message</param>
		public ELib3MFException(int errorCode, string errorMessage = "") : base(FormatMessage(errorCode, errorMessage))
		{
			_errorCode = errorCode;
			_errorMessage = errorMessage;
		}

		/// <summary>
		/// Gets the error code
		/// </summary>
		public int ErrorCode => _errorCode;

		/// <summary>
		/// Gets the custom error message
		/// </summary>
		public string ErrorMessage => _errorMessage;

		/// <summary>
		/// Gets the error name (constant name)
		/// </summary>
		public string ErrorName
		{
			get
			{
				switch (_errorCode)
				{
					case 0: return "SUCCESS";
					case 1: return "NOTIMPLEMENTED";
					case 2: return "INVALIDPARAM";
					case 3: return "INVALIDCAST";
					case 4: return "BUFFERTOOSMALL";
					case 5: return "GENERICEXCEPTION";
					case 6: return "COULDNOTLOADLIBRARY";
					case 7: return "COULDNOTFINDLIBRARYEXPORT";
					case 8: return "INCOMPATIBLEBINARYVERSION";
					case 10: return "CALCULATIONABORTED";
					case 11: return "SHOULDNOTBECALLED";
					case 100: return "READERCLASSUNKNOWN";
					case 101: return "WRITERCLASSUNKNOWN";
					case 102: return "ITERATORINVALIDINDEX";
					case 103: return "INVALIDMODELRESOURCE";
					case 104: return "RESOURCENOTFOUND";
					case 105: return "INVALIDMODEL";
					case 106: return "INVALIDOBJECT";
					case 107: return "INVALIDMESHOBJECT";
					case 108: return "INVALIDCOMPONENTSOBJECT";
					case 109: return "INVALIDCOMPONENT";
					case 110: return "INVALIDBUILDITEM";
					case 111: return "INVALIDBASEMATERIALGROUP";
					case 112: return "INVALIDSLICESTACKRESOURCE";
					case 113: return "INVALIDTEXTURERESOURCE";
					case 114: return "INVALIDCOLORGROUP";
					case 115: return "INVALIDTEXTURE2DGROUP";
					case 116: return "INVALIDCOMPOSITEMATERIALS";
					case 117: return "INVALIDMULTIPROPERTYGROUP";
					case 120: return "INVALIDRESOURCEINDEX";
					case 121: return "ATTACHMENTNOTFOUND";
					case 130: return "FORBIDDENCYCLICREFERENCE";
					case 131: return "INVALIDATTACHMENTSTREAM";
					case 132: return "INVALIDPROPERTYCOUNT";
					case 140: return "UNKOWNPROGRESSIDENTIFIER";
					case 141: return "ELEMENTCOUNTEXCEEDSLIMIT";
					case 142: return "INVALIDRESOURCE";
					case 143: return "INVALIDLEVELSET";
					case 144: return "COULDNOTFINDTRIANGLESET";
					case 145: return "INVALIDTRIANGLESETINDEX";
					case 2000: return "BEAMLATTICE_INVALID_OBJECTTYPE";
					case 3000: return "INVALIDKEYSTORE";
					case 3001: return "INVALIDKEYSTORECONSUMER";
					case 3002: return "KEYSTORECONSUMERNOTFOUND";
					case 3003: return "KEYSTORERESOURCEDATANOTFOUND";
					case 3004: return "SECURECONTEXTNOTREGISTERED";
					case 3005: return "INVALIDKEYSIZE";
					case 4000: return "INCOMPATIBLEPORTTYPES";
					case 4001: return "GRAPHISCYCLIC";
					case 4002: return "INPUTNOTSET";
					case 4003: return "INVALIDNODECONFIGURATION";
					default: return "UNKNOWN";
				}
			}
		}

		/// <summary>
		/// Gets the error description (human-readable)
		/// </summary>
		public string ErrorDescription
		{
			get
			{
				switch (_errorCode)
				{
					case 0: return "success";
					case 1: return "functionality not implemented";
					case 2: return "an invalid parameter was passed";
					case 3: return "a type cast failed";
					case 4: return "a provided buffer is too small";
					case 5: return "a generic exception occurred";
					case 6: return "the library could not be loaded";
					case 7: return "a required exported symbol could not be found in the library";
					case 8: return "the version of the binary interface does not match the bindings interface";
					case 10: return "a calculation has been aborted";
					case 11: return "functionality should not be called";
					case 100: return "the queried reader class is unknown";
					case 101: return "the queried writer class is unknown";
					case 102: return "the current index of an iterator is invalid";
					case 103: return "no Model Resource has been given";
					case 104: return "Resource not found";
					case 105: return "A model is invalid";
					case 106: return "An object is invalid";
					case 107: return "A mesh object is invalid";
					case 108: return "A components object is invalid";
					case 109: return "A component is invalid";
					case 110: return "A build item is invalid";
					case 111: return "A basematerialgroup is invalid";
					case 112: return "A slicestack resource is invalid";
					case 113: return "A texture resource is invalid";
					case 114: return "A color group resource is invalid";
					case 115: return "A texture2d group resource is invalid";
					case 116: return "A composite materials resource is invalid";
					case 117: return "A MultiPropertyGroup resource is invalid";
					case 120: return "A resource index is invalid";
					case 121: return "Attachment not found";
					case 130: return "A component references one of its ancestors";
					case 131: return "An attachment stream is invalid";
					case 132: return "Invalid property count.";
					case 140: return "A progress identifier is unknown";
					case 141: return "An element buffer exceeds its spec limit";
					case 142: return "A resource is invalid";
					case 143: return "A level set is invalid";
					case 144: return "Could not find triangle set";
					case 145: return "Invalid triangle set index";
					case 2000: return "This object type is not valid for beamlattices";
					case 3000: return "The keystore object is invalid";
					case 3001: return "The consumer keystore object is invalid";
					case 3002: return "A consumer has not been found";
					case 3003: return "A resource data has not been found";
					case 3004: return "A Key or Conentent encryption callback has not been registered";
					case 3005: return "The key size is invalid";
					case 4000: return "Link could not be added, the port types are incompatible";
					case 4001: return "The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.";
					case 4002: return "The input of a node is not set.";
					case 4003: return "The selected node configuration is not supported";
					default: return "unknown error";
				}
			}
		}

		private static string FormatMessage(int errorCode, string errorMessage)
		{
			string errorName = GetErrorName(errorCode);
			string errorDesc = GetErrorDescription(errorCode);
			if (!string.IsNullOrEmpty(errorMessage))
				return $"ELib3MFException {errorName} ({errorCode}): {errorDesc} - {errorMessage}";
			else
				return $"ELib3MFException {errorName} ({errorCode}): {errorDesc}";
		}

		private static string GetErrorName(int errorCode)
		{
			switch (errorCode)
			{
				case 0: return "SUCCESS";
				case 1: return "NOTIMPLEMENTED";
				case 2: return "INVALIDPARAM";
				case 3: return "INVALIDCAST";
				case 4: return "BUFFERTOOSMALL";
				case 5: return "GENERICEXCEPTION";
				case 6: return "COULDNOTLOADLIBRARY";
				case 7: return "COULDNOTFINDLIBRARYEXPORT";
				case 8: return "INCOMPATIBLEBINARYVERSION";
				case 10: return "CALCULATIONABORTED";
				case 11: return "SHOULDNOTBECALLED";
				case 100: return "READERCLASSUNKNOWN";
				case 101: return "WRITERCLASSUNKNOWN";
				case 102: return "ITERATORINVALIDINDEX";
				case 103: return "INVALIDMODELRESOURCE";
				case 104: return "RESOURCENOTFOUND";
				case 105: return "INVALIDMODEL";
				case 106: return "INVALIDOBJECT";
				case 107: return "INVALIDMESHOBJECT";
				case 108: return "INVALIDCOMPONENTSOBJECT";
				case 109: return "INVALIDCOMPONENT";
				case 110: return "INVALIDBUILDITEM";
				case 111: return "INVALIDBASEMATERIALGROUP";
				case 112: return "INVALIDSLICESTACKRESOURCE";
				case 113: return "INVALIDTEXTURERESOURCE";
				case 114: return "INVALIDCOLORGROUP";
				case 115: return "INVALIDTEXTURE2DGROUP";
				case 116: return "INVALIDCOMPOSITEMATERIALS";
				case 117: return "INVALIDMULTIPROPERTYGROUP";
				case 120: return "INVALIDRESOURCEINDEX";
				case 121: return "ATTACHMENTNOTFOUND";
				case 130: return "FORBIDDENCYCLICREFERENCE";
				case 131: return "INVALIDATTACHMENTSTREAM";
				case 132: return "INVALIDPROPERTYCOUNT";
				case 140: return "UNKOWNPROGRESSIDENTIFIER";
				case 141: return "ELEMENTCOUNTEXCEEDSLIMIT";
				case 142: return "INVALIDRESOURCE";
				case 143: return "INVALIDLEVELSET";
				case 144: return "COULDNOTFINDTRIANGLESET";
				case 145: return "INVALIDTRIANGLESETINDEX";
				case 2000: return "BEAMLATTICE_INVALID_OBJECTTYPE";
				case 3000: return "INVALIDKEYSTORE";
				case 3001: return "INVALIDKEYSTORECONSUMER";
				case 3002: return "KEYSTORECONSUMERNOTFOUND";
				case 3003: return "KEYSTORERESOURCEDATANOTFOUND";
				case 3004: return "SECURECONTEXTNOTREGISTERED";
				case 3005: return "INVALIDKEYSIZE";
				case 4000: return "INCOMPATIBLEPORTTYPES";
				case 4001: return "GRAPHISCYCLIC";
				case 4002: return "INPUTNOTSET";
				case 4003: return "INVALIDNODECONFIGURATION";
				default: return "UNKNOWN";
			}
		}

		private static string GetErrorDescription(int errorCode)
		{
			switch (errorCode)
			{
				case 0: return "success";
				case 1: return "functionality not implemented";
				case 2: return "an invalid parameter was passed";
				case 3: return "a type cast failed";
				case 4: return "a provided buffer is too small";
				case 5: return "a generic exception occurred";
				case 6: return "the library could not be loaded";
				case 7: return "a required exported symbol could not be found in the library";
				case 8: return "the version of the binary interface does not match the bindings interface";
				case 10: return "a calculation has been aborted";
				case 11: return "functionality should not be called";
				case 100: return "the queried reader class is unknown";
				case 101: return "the queried writer class is unknown";
				case 102: return "the current index of an iterator is invalid";
				case 103: return "no Model Resource has been given";
				case 104: return "Resource not found";
				case 105: return "A model is invalid";
				case 106: return "An object is invalid";
				case 107: return "A mesh object is invalid";
				case 108: return "A components object is invalid";
				case 109: return "A component is invalid";
				case 110: return "A build item is invalid";
				case 111: return "A basematerialgroup is invalid";
				case 112: return "A slicestack resource is invalid";
				case 113: return "A texture resource is invalid";
				case 114: return "A color group resource is invalid";
				case 115: return "A texture2d group resource is invalid";
				case 116: return "A composite materials resource is invalid";
				case 117: return "A MultiPropertyGroup resource is invalid";
				case 120: return "A resource index is invalid";
				case 121: return "Attachment not found";
				case 130: return "A component references one of its ancestors";
				case 131: return "An attachment stream is invalid";
				case 132: return "Invalid property count.";
				case 140: return "A progress identifier is unknown";
				case 141: return "An element buffer exceeds its spec limit";
				case 142: return "A resource is invalid";
				case 143: return "A level set is invalid";
				case 144: return "Could not find triangle set";
				case 145: return "Invalid triangle set index";
				case 2000: return "This object type is not valid for beamlattices";
				case 3000: return "The keystore object is invalid";
				case 3001: return "The consumer keystore object is invalid";
				case 3002: return "A consumer has not been found";
				case 3003: return "A resource data has not been found";
				case 3004: return "A Key or Conentent encryption callback has not been registered";
				case 3005: return "The key size is invalid";
				case 4000: return "Link could not be added, the port types are incompatible";
				case 4001: return "The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.";
				case 4002: return "The input of a node is not set.";
				case 4003: return "The selected node configuration is not supported";
				default: return "unknown error";
			}
		}
	}

	public enum ePropertyType {
		NoPropertyType = 0,
		BaseMaterial = 1,
		TexCoord = 2,
		Colors = 3,
		Composite = 4,
		Multi = 5
	};

	public enum eSlicesMeshResolution {
		Fullres = 0,
		Lowres = 1
	};

	public enum eModelUnit {
		MicroMeter = 0,
		MilliMeter = 1,
		CentiMeter = 2,
		Inch = 3,
		Foot = 4,
		Meter = 5
	};

	public enum eObjectType {
		Other = 0,
		Model = 1,
		Support = 2,
		SolidSupport = 3,
		Surface = 4
	};

	public enum eTextureType {
		Unknown = 0,
		PNG = 1,
		JPEG = 2
	};

	public enum eTextureTileStyle {
		Wrap = 0,
		Mirror = 1,
		Clamp = 2,
		NoTileStyle = 3
	};

	public enum eTextureFilter {
		Auto = 0,
		Linear = 1,
		Nearest = 2
	};

	public enum eBeamLatticeCapMode {
		Sphere = 0,
		HemiSphere = 1,
		Butt = 2
	};

	public enum eBeamLatticeClipMode {
		NoClipMode = 0,
		Inside = 1,
		Outside = 2
	};

	public enum eBeamLatticeBallMode {
		BeamLatticeBallModeNone = 0,
		Mixed = 1,
		All = 2
	};

	public enum eProgressIdentifier {
		QUERYCANCELED = 0,
		DONE = 1,
		CLEANUP = 2,
		READSTREAM = 3,
		EXTRACTOPCPACKAGE = 4,
		READNONROOTMODELS = 5,
		READROOTMODEL = 6,
		READRESOURCES = 7,
		READMESH = 8,
		READSLICES = 9,
		READBUILD = 10,
		READCUSTOMATTACHMENT = 11,
		READTEXTURETACHMENTS = 12,
		CREATEOPCPACKAGE = 13,
		WRITEMODELSTOSTREAM = 14,
		WRITEROOTMODEL = 15,
		WRITENONROOTMODELS = 16,
		WRITEATTACHMENTS = 17,
		WRITECONTENTTYPES = 18,
		WRITENOBJECTS = 19,
		WRITENODES = 20,
		WRITETRIANGLES = 21,
		WRITESLICES = 22,
		WRITEKEYSTORE = 23
	};

	public enum eBlendMethod {
		NoBlendMethod = 0,
		Mix = 1,
		Multiply = 2
	};

	public enum eChannelName {
		Red = 0,
		Green = 1,
		Blue = 2,
		Alpha = 3
	};

	public enum eCompositionMethod {
		WeightedSum = 0,
		Multiply = 1,
		Min = 2,
		Max = 3,
		Mask = 4
	};

	public enum eCompositionSpace {
		Raw = 0,
		LinearColor = 1
	};

	public enum eImplicitNodeType {
		Addition = 0,
		Subtraction = 1,
		Multiplication = 2,
		Division = 3,
		Constant = 4,
		ConstVec = 5,
		ConstMat = 6,
		ComposeVector = 7,
		DecomposeVector = 8,
		ComposeMatrix = 9,
		MatrixFromColumns = 10,
		MatrixFromRows = 11,
		Dot = 12,
		Cross = 13,
		MatVecMultiplication = 14,
		Transpose = 15,
		Inverse = 16,
		Sinus = 17,
		Cosinus = 18,
		Tan = 19,
		ArcSin = 20,
		ArcCos = 21,
		ArcTan = 22,
		ArcTan2 = 23,
		Min = 24,
		Max = 25,
		Abs = 26,
		Fmod = 27,
		Pow = 28,
		Sqrt = 29,
		Exp = 30,
		Log = 31,
		Log2 = 32,
		Log10 = 33,
		Select = 34,
		Clamp = 35,
		Sinh = 36,
		Cosh = 37,
		Tanh = 38,
		Round = 39,
		Ceil = 40,
		Floor = 41,
		Sign = 42,
		Fract = 43,
		FunctionCall = 44,
		Mesh = 45,
		Length = 46,
		ConstResourceID = 47,
		VectorFromScalar = 48,
		UnsignedMesh = 49,
		Mod = 50,
		BeamLattice = 51,
		FunctionGradient = 52,
		NormalizeDistance = 53
	};

	public enum eImplicitPortType {
		Scalar = 0,
		Vector = 1,
		Matrix = 2,
		ResourceID = 3
	};

	public enum eImplicitNodeConfiguration {
		Default = 0,
		ScalarToScalar = 1,
		VectorToVector = 2,
		MatrixToMatrix = 3
	};

	public enum eEncryptionAlgorithm {
		AES256_GCM = 1
	};

	public enum eWrappingAlgorithm {
		RSA_OAEP = 0
	};

	public enum eMgfAlgorithm {
		MGF1_SHA1 = 160,
		MGF1_SHA224 = 224,
		MGF1_SHA256 = 256,
		MGF1_SHA384 = 384,
		MGF1_SHA512 = 512
	};

	public enum eDigestMethod {
		SHA1 = 160,
		SHA256 = 256
	};

	public enum eCompression {
		NoCompression = 0,
		Deflate = 1
	};

	public struct sTriangle
	{
		public UInt32[] Indices;
	}

	public struct sTriangleProperties
	{
		public UInt32 ResourceID;
		public UInt32[] PropertyIDs;
	}

	public struct sPosition
	{
		public Single[] Coordinates;
	}

	public struct sPosition2D
	{
		public Single[] Coordinates;
	}

	public struct sCompositeConstituent
	{
		public UInt32 PropertyID;
		public Double MixingRatio;
	}

	public struct sMultiPropertyLayer
	{
		public UInt32 ResourceID;
		public eBlendMethod TheBlendMethod;
	}

	public struct sTex2Coord
	{
		public Double U;
		public Double V;
	}

	public struct sTransform
	{
		public Single[][] Fields;
	}

	public struct sBox
	{
		public Single[] MinCoordinate;
		public Single[] MaxCoordinate;
	}

	public struct sColor
	{
		public Byte Red;
		public Byte Green;
		public Byte Blue;
		public Byte Alpha;
	}

	public struct sBeam
	{
		public UInt32[] Indices;
		public Double[] Radii;
		public eBeamLatticeCapMode[] CapModes;
	}

	public struct sBall
	{
		public UInt32 Index;
		public Double Radius;
	}

	public struct sVector
	{
		public Double[] Coordinates;
	}

	public struct sMatrix4x4
	{
		public Double[][] Field;
	}


	namespace Internal {

		[StructLayout(LayoutKind.Explicit, Size=12)]
		public unsafe struct InternalTriangle
		{
			[FieldOffset(0)] public fixed UInt32 Indices[3];
		}

		[StructLayout(LayoutKind.Explicit, Size=16)]
		public unsafe struct InternalTriangleProperties
		{
			[FieldOffset(0)] public UInt32 ResourceID;
			[FieldOffset(4)] public fixed UInt32 PropertyIDs[3];
		}

		[StructLayout(LayoutKind.Explicit, Size=12)]
		public unsafe struct InternalPosition
		{
			[FieldOffset(0)] public fixed Single Coordinates[3];
		}

		[StructLayout(LayoutKind.Explicit, Size=8)]
		public unsafe struct InternalPosition2D
		{
			[FieldOffset(0)] public fixed Single Coordinates[2];
		}

		[StructLayout(LayoutKind.Explicit, Size=12)]
		public unsafe struct InternalCompositeConstituent
		{
			[FieldOffset(0)] public UInt32 PropertyID;
			[FieldOffset(4)] public Double MixingRatio;
		}

		[StructLayout(LayoutKind.Explicit, Size=8)]
		public unsafe struct InternalMultiPropertyLayer
		{
			[FieldOffset(0)] public UInt32 ResourceID;
			[FieldOffset(4)] public Int32 TheBlendMethod;
		}

		[StructLayout(LayoutKind.Explicit, Size=16)]
		public unsafe struct InternalTex2Coord
		{
			[FieldOffset(0)] public Double U;
			[FieldOffset(8)] public Double V;
		}

		[StructLayout(LayoutKind.Explicit, Size=48)]
		public unsafe struct InternalTransform
		{
			[FieldOffset(0)] public fixed Single Fields[12];
		}

		[StructLayout(LayoutKind.Explicit, Size=24)]
		public unsafe struct InternalBox
		{
			[FieldOffset(0)] public fixed Single MinCoordinate[3];
			[FieldOffset(12)] public fixed Single MaxCoordinate[3];
		}

		[StructLayout(LayoutKind.Explicit, Size=4)]
		public unsafe struct InternalColor
		{
			[FieldOffset(0)] public Byte Red;
			[FieldOffset(1)] public Byte Green;
			[FieldOffset(2)] public Byte Blue;
			[FieldOffset(3)] public Byte Alpha;
		}

		[StructLayout(LayoutKind.Explicit, Size=32)]
		public unsafe struct InternalBeam
		{
			[FieldOffset(0)] public fixed UInt32 Indices[2];
			[FieldOffset(8)] public fixed Double Radii[2];
			[FieldOffset(24)] public fixed Int32 CapModes[2];
		}

		[StructLayout(LayoutKind.Explicit, Size=12)]
		public unsafe struct InternalBall
		{
			[FieldOffset(0)] public UInt32 Index;
			[FieldOffset(4)] public Double Radius;
		}

		[StructLayout(LayoutKind.Explicit, Size=24)]
		public unsafe struct InternalVector
		{
			[FieldOffset(0)] public fixed Double Coordinates[3];
		}

		[StructLayout(LayoutKind.Explicit, Size=128)]
		public unsafe struct InternalMatrix4x4
		{
			[FieldOffset(0)] public fixed Double Field[16];
		}


		public class Lib3MFWrapper
		{
			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_base_classtypeid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Base_ClassTypeId (IntPtr Handle, out UInt64 AClassTypeId);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_writetofile", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_WriteToFile (IntPtr Handle, byte[] AFilename);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_getstreamsize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_GetStreamSize (IntPtr Handle, out UInt64 AStreamSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_writetobuffer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_WriteToBuffer (IntPtr Handle, UInt64 sizeBuffer, out UInt64 neededBuffer, IntPtr dataBuffer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_writetocallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_WriteToCallback (IntPtr Handle, IntPtr ATheWriteCallback, IntPtr ATheSeekCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_setprogresscallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_SetProgressCallback (IntPtr Handle, IntPtr AProgressCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_getdecimalprecision", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_GetDecimalPrecision (IntPtr Handle, out UInt32 ADecimalPrecision);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_setdecimalprecision", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_SetDecimalPrecision (IntPtr Handle, UInt32 ADecimalPrecision);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_setstrictmodeactive", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_SetStrictModeActive (IntPtr Handle, Byte AStrictModeActive);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_getstrictmodeactive", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_GetStrictModeActive (IntPtr Handle, out Byte AStrictModeActive);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_getwarning", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_GetWarning (IntPtr Handle, UInt32 AIndex, out UInt32 AErrorCode, UInt32 sizeWarning, out UInt32 neededWarning, IntPtr dataWarning);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_getwarningcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_GetWarningCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_addkeywrappingcallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_AddKeyWrappingCallback (IntPtr Handle, byte[] AConsumerID, IntPtr ATheCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_writer_setcontentencryptioncallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Writer_SetContentEncryptionCallback (IntPtr Handle, IntPtr ATheCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_readfromfile", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_ReadFromFile (IntPtr Handle, byte[] AFilename);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_readfrombuffer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_ReadFromBuffer (IntPtr Handle, UInt64 sizeBuffer, IntPtr dataBuffer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_readfromcallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_ReadFromCallback (IntPtr Handle, IntPtr ATheReadCallback, UInt64 AStreamSize, IntPtr ATheSeekCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_setprogresscallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_SetProgressCallback (IntPtr Handle, IntPtr AProgressCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_addrelationtoread", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_AddRelationToRead (IntPtr Handle, byte[] ARelationShipType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_removerelationtoread", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_RemoveRelationToRead (IntPtr Handle, byte[] ARelationShipType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_setstrictmodeactive", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_SetStrictModeActive (IntPtr Handle, Byte AStrictModeActive);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_getstrictmodeactive", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_GetStrictModeActive (IntPtr Handle, out Byte AStrictModeActive);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_getwarning", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_GetWarning (IntPtr Handle, UInt32 AIndex, out UInt32 AErrorCode, UInt32 sizeWarning, out UInt32 neededWarning, IntPtr dataWarning);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_getwarningcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_GetWarningCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_addkeywrappingcallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_AddKeyWrappingCallback (IntPtr Handle, byte[] AConsumerID, IntPtr ATheCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_reader_setcontentencryptioncallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Reader_SetContentEncryptionCallback (IntPtr Handle, IntPtr ATheCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_packagepart_getpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 PackagePart_GetPath (IntPtr Handle, UInt32 sizePath, out UInt32 neededPath, IntPtr dataPath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_packagepart_setpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 PackagePart_SetPath (IntPtr Handle, byte[] APath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resource_getresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Resource_GetResourceID (IntPtr Handle, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resource_getuniqueresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Resource_GetUniqueResourceID (IntPtr Handle, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resource_packagepart", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Resource_PackagePart (IntPtr Handle, out IntPtr APackagePart);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resource_setpackagepart", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Resource_SetPackagePart (IntPtr Handle, IntPtr APackagePart);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resource_getmodelresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Resource_GetModelResourceID (IntPtr Handle, out UInt32 AModelResourceId);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceiterator_movenext", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIterator_MoveNext (IntPtr Handle, out Byte AHasNext);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceiterator_moveprevious", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIterator_MovePrevious (IntPtr Handle, out Byte AHasPrevious);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceiterator_getcurrent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIterator_GetCurrent (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceiterator_clone", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIterator_Clone (IntPtr Handle, out IntPtr AOutResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceiterator_count", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIterator_Count (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestackiterator_getcurrentslicestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStackIterator_GetCurrentSliceStack (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_objectiterator_getcurrentobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ObjectIterator_GetCurrentObject (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobjectiterator_getcurrentmeshobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObjectIterator_GetCurrentMeshObject (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_componentsobjectiterator_getcurrentcomponentsobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComponentsObjectIterator_GetCurrentComponentsObject (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2diterator_getcurrenttexture2d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DIterator_GetCurrentTexture2D (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroupiterator_getcurrentcolorgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroupIterator_GetCurrentColorGroup (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroupIterator_GetCurrentTexture2DGroup (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerialsiterator_getcurrentcompositematerials", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterialsIterator_GetCurrentCompositeMaterials (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_image3diterator_getcurrentimage3d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Image3DIterator_GetCurrentImage3D (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functioniterator_getcurrentfunction", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionIterator_GetCurrentFunction (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelsetiterator_getcurrentlevelset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSetIterator_GetCurrentLevelSet (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_getnamespace", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetNameSpace (IntPtr Handle, UInt32 sizeNameSpace, out UInt32 neededNameSpace, IntPtr dataNameSpace);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_setnamespace", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_SetNameSpace (IntPtr Handle, byte[] ANameSpace);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetName (IntPtr Handle, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_SetName (IntPtr Handle, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_getkey", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetKey (IntPtr Handle, UInt32 sizeKey, out UInt32 neededKey, IntPtr dataKey);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_getmustpreserve", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetMustPreserve (IntPtr Handle, out Byte AMustPreserve);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_setmustpreserve", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_SetMustPreserve (IntPtr Handle, Byte AMustPreserve);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_gettype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetType (IntPtr Handle, UInt32 sizeType, out UInt32 neededType, IntPtr dataType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_settype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_SetType (IntPtr Handle, byte[] AType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_getvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_GetValue (IntPtr Handle, UInt32 sizeValue, out UInt32 neededValue, IntPtr dataValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadata_setvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaData_SetValue (IntPtr Handle, byte[] AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_getmetadatacount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_GetMetaDataCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_getmetadata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_GetMetaData (IntPtr Handle, UInt32 AIndex, out IntPtr AMetaData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_getmetadatabykey", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_GetMetaDataByKey (IntPtr Handle, byte[] ANameSpace, byte[] AName, out IntPtr AMetaData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_removemetadatabyindex", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_RemoveMetaDataByIndex (IntPtr Handle, UInt32 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_removemetadata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_RemoveMetaData (IntPtr Handle, IntPtr ATheMetaData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_metadatagroup_addmetadata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MetaDataGroup_AddMetaData (IntPtr Handle, byte[] ANameSpace, byte[] AName, byte[] AValue, byte[] AType, Byte AMustPreserve, out IntPtr AMetaData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_SetName (IntPtr Handle, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_GetName (IntPtr Handle, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_setidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_SetIdentifier (IntPtr Handle, byte[] AIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_getidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_GetIdentifier (IntPtr Handle, UInt32 sizeIdentifier, out UInt32 neededIdentifier, IntPtr dataIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_addtriangle", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_AddTriangle (IntPtr Handle, UInt32 ATriangleIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_removetriangle", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_RemoveTriangle (IntPtr Handle, UInt32 ATriangleIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_clear", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_Clear (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_settrianglelist", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_SetTriangleList (IntPtr Handle, UInt64 sizeTriangleIndices, IntPtr dataTriangleIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_gettrianglelist", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_GetTriangleList (IntPtr Handle, UInt64 sizeTriangleIndices, out UInt64 neededTriangleIndices, IntPtr dataTriangleIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_addtrianglelist", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_AddTriangleList (IntPtr Handle, UInt64 sizeTriangleIndices, IntPtr dataTriangleIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_merge", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_Merge (IntPtr Handle, IntPtr AOtherTriangleSet, Byte ADeleteOther);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_deleteset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_DeleteSet (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_triangleset_duplicate", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TriangleSet_Duplicate (IntPtr Handle, byte[] AIdentifier, out IntPtr ANewSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_gettype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetType (IntPtr Handle, out Int32 AObjectType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_settype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetType (IntPtr Handle, Int32 AObjectType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetName (IntPtr Handle, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetName (IntPtr Handle, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getpartnumber", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetPartNumber (IntPtr Handle, UInt32 sizePartNumber, out UInt32 neededPartNumber, IntPtr dataPartNumber);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_setpartnumber", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetPartNumber (IntPtr Handle, byte[] APartNumber);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_ismeshobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_IsMeshObject (IntPtr Handle, out Byte AIsMeshObject);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_iscomponentsobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_IsComponentsObject (IntPtr Handle, out Byte AIsComponentsObject);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_islevelsetobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_IsLevelSetObject (IntPtr Handle, out Byte AIsLevelSetObject);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_isvalid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_IsValid (IntPtr Handle, out Byte AIsValid);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_setattachmentasthumbnail", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetAttachmentAsThumbnail (IntPtr Handle, IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getthumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetThumbnailAttachment (IntPtr Handle, out IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_clearthumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_ClearThumbnailAttachment (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getoutbox", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetOutbox (IntPtr Handle, out InternalBox AOutbox);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetUUID (IntPtr Handle, out Byte AHasUUID, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_setuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetUUID (IntPtr Handle, byte[] AUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getmetadatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetMetaDataGroup (IntPtr Handle, out IntPtr AMetaDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_setslicesmeshresolution", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_SetSlicesMeshResolution (IntPtr Handle, Int32 AMeshResolution);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getslicesmeshresolution", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetSlicesMeshResolution (IntPtr Handle, out Int32 AMeshResolution);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_hasslices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_HasSlices (IntPtr Handle, Byte ARecursive, out Byte AHasSlices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_clearslicestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_ClearSliceStack (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_getslicestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_GetSliceStack (IntPtr Handle, out IntPtr ASliceStackInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_object_assignslicestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Object_AssignSliceStack (IntPtr Handle, IntPtr ASliceStackInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getvertexcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetVertexCount (IntPtr Handle, out UInt32 AVertexCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettrianglecount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangleCount (IntPtr Handle, out UInt32 AVertexCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getvertex", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetVertex (IntPtr Handle, UInt32 AIndex, out InternalPosition ACoordinates);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_setvertex", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetVertex (IntPtr Handle, UInt32 AIndex, ref InternalPosition ACoordinates);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_addvertex", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_AddVertex (IntPtr Handle, ref InternalPosition ACoordinates, out UInt32 ANewIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getvertices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetVertices (IntPtr Handle, UInt64 sizeVertices, out UInt64 neededVertices, IntPtr dataVertices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettriangle", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangle (IntPtr Handle, UInt32 AIndex, out InternalTriangle AIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_settriangle", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetTriangle (IntPtr Handle, UInt32 AIndex, ref InternalTriangle AIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_addtriangle", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_AddTriangle (IntPtr Handle, ref InternalTriangle AIndices, out UInt32 ANewIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettriangleindices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangleIndices (IntPtr Handle, UInt64 sizeIndices, out UInt64 neededIndices, IntPtr dataIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_setobjectlevelproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetObjectLevelProperty (IntPtr Handle, UInt32 AUniqueResourceID, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getobjectlevelproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetObjectLevelProperty (IntPtr Handle, out UInt32 AUniqueResourceID, out UInt32 APropertyID, out Byte AHasObjectLevelProperty);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_settriangleproperties", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetTriangleProperties (IntPtr Handle, UInt32 AIndex, ref InternalTriangleProperties AProperties);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettriangleproperties", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangleProperties (IntPtr Handle, UInt32 AIndex, out InternalTriangleProperties AProperty);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_setalltriangleproperties", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetAllTriangleProperties (IntPtr Handle, UInt64 sizePropertiesArray, IntPtr dataPropertiesArray);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getalltriangleproperties", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetAllTriangleProperties (IntPtr Handle, UInt64 sizePropertiesArray, out UInt64 neededPropertiesArray, IntPtr dataPropertiesArray);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_clearallproperties", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_ClearAllProperties (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_setgeometry", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetGeometry (IntPtr Handle, UInt64 sizeVertices, IntPtr dataVertices, UInt64 sizeIndices, IntPtr dataIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_ismanifoldandoriented", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_IsManifoldAndOriented (IntPtr Handle, out Byte AIsManifoldAndOriented);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_beamlattice", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_BeamLattice (IntPtr Handle, out IntPtr ATheBeamLattice);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_getvolumedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetVolumeData (IntPtr Handle, out IntPtr ATheVolumeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_setvolumedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_SetVolumeData (IntPtr Handle, IntPtr ATheVolumeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_addtriangleset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_AddTriangleSet (IntPtr Handle, byte[] AIdentifier, byte[] AName, out IntPtr ATheTriangleSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_hastriangleset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_HasTriangleSet (IntPtr Handle, byte[] AIdentifier, out Byte ATriangleSetExists);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_findtriangleset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_FindTriangleSet (IntPtr Handle, byte[] AIdentifier, out IntPtr ATheTriangleSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettrianglesetcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangleSetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshobject_gettriangleset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshObject_GetTriangleSet (IntPtr Handle, UInt32 AIndex, out IntPtr ATheTriangleSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getfunction", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetFunction (IntPtr Handle, out IntPtr ATheFunction);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setfunction", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetFunction (IntPtr Handle, IntPtr ATheFunction);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_gettransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetTransform (IntPtr Handle, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_settransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetTransform (IntPtr Handle, ref InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getchannelname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetChannelName (IntPtr Handle, UInt32 sizeChannelName, out UInt32 neededChannelName, IntPtr dataChannelName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setchannelname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetChannelName (IntPtr Handle, byte[] AChannelName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setminfeaturesize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetMinFeatureSize (IntPtr Handle, Double AMinFeatureSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getminfeaturesize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetMinFeatureSize (IntPtr Handle, out Double AMinFeatureSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setfallbackvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetFallBackValue (IntPtr Handle, Double AFallBackValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getfallbackvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetFallBackValue (IntPtr Handle, out Double AFallBackValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setmeshbboxonly", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetMeshBBoxOnly (IntPtr Handle, Byte AMeshBBoxOnly);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getmeshbboxonly", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetMeshBBoxOnly (IntPtr Handle, out Byte AMeshBBoxOnly);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setmesh", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetMesh (IntPtr Handle, IntPtr ATheMesh);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getmesh", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetMesh (IntPtr Handle, out IntPtr ATheMesh);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_getvolumedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_GetVolumeData (IntPtr Handle, out IntPtr ATheVolumeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_levelset_setvolumedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 LevelSet_SetVolumeData (IntPtr Handle, IntPtr ATheVolumeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getminlength", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetMinLength (IntPtr Handle, out Double AMinLength);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setminlength", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetMinLength (IntPtr Handle, Double AMinLength);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getclipping", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetClipping (IntPtr Handle, out Int32 AClipMode, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setclipping", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetClipping (IntPtr Handle, Int32 AClipMode, UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getrepresentation", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetRepresentation (IntPtr Handle, out Byte AHasRepresentation, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setrepresentation", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetRepresentation (IntPtr Handle, UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getballoptions", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBallOptions (IntPtr Handle, out Int32 ABallMode, out Double ABallRadius);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setballoptions", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetBallOptions (IntPtr Handle, Int32 ABallMode, Double ABallRadius);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getbeamcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBeamCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getbeam", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBeam (IntPtr Handle, UInt32 AIndex, out InternalBeam ABeamInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_addbeam", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_AddBeam (IntPtr Handle, ref InternalBeam ABeamInfo, out UInt32 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setbeam", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetBeam (IntPtr Handle, UInt32 AIndex, ref InternalBeam ABeamInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setbeams", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetBeams (IntPtr Handle, UInt64 sizeBeamInfo, IntPtr dataBeamInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getbeams", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBeams (IntPtr Handle, UInt64 sizeBeamInfo, out UInt64 neededBeamInfo, IntPtr dataBeamInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getballcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBallCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getball", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBall (IntPtr Handle, UInt32 AIndex, out InternalBall ABallInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_addball", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_AddBall (IntPtr Handle, ref InternalBall ABallInfo, out UInt32 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setball", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetBall (IntPtr Handle, UInt32 AIndex, ref InternalBall ABallInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_setballs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_SetBalls (IntPtr Handle, UInt64 sizeBallInfo, IntPtr dataBallInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getballs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBalls (IntPtr Handle, UInt64 sizeBallInfo, out UInt64 neededBallInfo, IntPtr dataBallInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getbeamsetcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBeamSetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_addbeamset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_AddBeamSet (IntPtr Handle, out IntPtr ABeamSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlattice_getbeamset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLattice_GetBeamSet (IntPtr Handle, UInt32 AIndex, out IntPtr ABeamSet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_getfunctionresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_GetFunctionResourceID (IntPtr Handle, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_setfunctionresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_SetFunctionResourceID (IntPtr Handle, UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_gettransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_GetTransform (IntPtr Handle, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_settransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_SetTransform (IntPtr Handle, ref InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_getchannelname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_GetChannelName (IntPtr Handle, UInt32 sizeChannelName, out UInt32 neededChannelName, IntPtr dataChannelName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_setchannelname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_SetChannelName (IntPtr Handle, byte[] AChannelName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_setminfeaturesize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_SetMinFeatureSize (IntPtr Handle, Double AMinFeatureSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_getminfeaturesize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_GetMinFeatureSize (IntPtr Handle, out Double AMinFeatureSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_setfallbackvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_SetFallBackValue (IntPtr Handle, Double AFallBackValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionreference_getfallbackvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionReference_GetFallBackValue (IntPtr Handle, out Double AFallBackValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_getbasematerialgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_GetBaseMaterialGroup (IntPtr Handle, out IntPtr ABaseMaterialGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_setbasematerialgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_SetBaseMaterialGroup (IntPtr Handle, IntPtr ABaseMaterialGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_getmaterialmappingcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_GetMaterialMappingCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_getmaterialmapping", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_GetMaterialMapping (IntPtr Handle, UInt32 AIndex, out IntPtr ATheMaterialMapping);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_addmaterialmapping", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_AddMaterialMapping (IntPtr Handle, ref InternalTransform ATransform, out IntPtr ATheMaterialMapping);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedatacomposite_removematerialmapping", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataComposite_RemoveMaterialMapping (IntPtr Handle, UInt32 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedataproperty_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataProperty_GetName (IntPtr Handle, UInt32 sizePropertyName, out UInt32 neededPropertyName, IntPtr dataPropertyName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedataproperty_setisrequired", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataProperty_SetIsRequired (IntPtr Handle, Byte AIsRequired);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedataproperty_isrequired", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeDataProperty_IsRequired (IntPtr Handle, out Byte AIsRequired);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_getcomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_GetComposite (IntPtr Handle, out IntPtr ATheCompositeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_createnewcomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_CreateNewComposite (IntPtr Handle, out IntPtr ATheCompositeData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_removecomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_RemoveComposite (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_getcolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_GetColor (IntPtr Handle, out IntPtr ATheColorData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_createnewcolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_CreateNewColor (IntPtr Handle, IntPtr ATheFunction, out IntPtr ATheColorData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_removecolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_RemoveColor (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_getpropertycount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_GetPropertyCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_getproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_GetProperty (IntPtr Handle, UInt32 AIndex, out IntPtr ATheVolumeDataProperty);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_addpropertyfromfunction", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_AddPropertyFromFunction (IntPtr Handle, byte[] AName, IntPtr ATheFunction, out IntPtr ATheVolumeDataProperty);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_volumedata_removeproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 VolumeData_RemoveProperty (IntPtr Handle, UInt32 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_getobjectresource", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_GetObjectResource (IntPtr Handle, out IntPtr AObjectResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_getobjectresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_GetObjectResourceID (IntPtr Handle, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_getuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_GetUUID (IntPtr Handle, out Byte AHasUUID, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_setuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_SetUUID (IntPtr Handle, byte[] AUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_hastransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_HasTransform (IntPtr Handle, out Byte AHasTransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_gettransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_GetTransform (IntPtr Handle, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_component_settransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Component_SetTransform (IntPtr Handle, ref InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_componentsobject_addcomponent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComponentsObject_AddComponent (IntPtr Handle, IntPtr AObjectResource, ref InternalTransform ATransform, out IntPtr AComponentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_componentsobject_getcomponent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComponentsObject_GetComponent (IntPtr Handle, UInt32 AIndex, out IntPtr AComponentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_componentsobject_getcomponentcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComponentsObject_GetComponentCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_SetName (IntPtr Handle, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetName (IntPtr Handle, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_setidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_SetIdentifier (IntPtr Handle, byte[] AIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetIdentifier (IntPtr Handle, UInt32 sizeIdentifier, out UInt32 neededIdentifier, IntPtr dataIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getreferencecount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetReferenceCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_setreferences", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_SetReferences (IntPtr Handle, UInt64 sizeReferences, IntPtr dataReferences);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getreferences", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetReferences (IntPtr Handle, UInt64 sizeReferences, out UInt64 neededReferences, IntPtr dataReferences);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getballreferencecount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetBallReferenceCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_setballreferences", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_SetBallReferences (IntPtr Handle, UInt64 sizeBallReferences, IntPtr dataBallReferences);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamset_getballreferences", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamSet_GetBallReferences (IntPtr Handle, UInt64 sizeBallReferences, out UInt64 neededBallReferences, IntPtr dataBallReferences);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_getcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_GetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_getallpropertyids", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_GetAllPropertyIDs (IntPtr Handle, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_addmaterial", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_AddMaterial (IntPtr Handle, byte[] AName, ref InternalColor ADisplayColor, out UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_removematerial", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_RemoveMaterial (IntPtr Handle, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_GetName (IntPtr Handle, UInt32 APropertyID, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_SetName (IntPtr Handle, UInt32 APropertyID, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_setdisplaycolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_SetDisplayColor (IntPtr Handle, UInt32 APropertyID, ref InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_basematerialgroup_getdisplaycolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BaseMaterialGroup_GetDisplayColor (IntPtr Handle, UInt32 APropertyID, out InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_getcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_GetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_getallpropertyids", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_GetAllPropertyIDs (IntPtr Handle, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_addcolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_AddColor (IntPtr Handle, ref InternalColor ATheColor, out UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_removecolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_RemoveColor (IntPtr Handle, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_setcolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_SetColor (IntPtr Handle, UInt32 APropertyID, ref InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colorgroup_getcolor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ColorGroup_GetColor (IntPtr Handle, UInt32 APropertyID, out InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_getcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_GetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_getallpropertyids", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_GetAllPropertyIDs (IntPtr Handle, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_addtex2coord", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_AddTex2Coord (IntPtr Handle, ref InternalTex2Coord AUVCoordinate, out UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_gettex2coord", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_GetTex2Coord (IntPtr Handle, UInt32 APropertyID, out InternalTex2Coord AUVCoordinate);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_removetex2coord", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_RemoveTex2Coord (IntPtr Handle, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2dgroup_gettexture2d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2DGroup_GetTexture2D (IntPtr Handle, out IntPtr ATexture2DInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_getcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_GetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_getallpropertyids", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_GetAllPropertyIDs (IntPtr Handle, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_getbasematerialgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_GetBaseMaterialGroup (IntPtr Handle, out IntPtr ABaseMaterialGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_addcomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_AddComposite (IntPtr Handle, UInt64 sizeComposite, IntPtr dataComposite, out UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_removecomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_RemoveComposite (IntPtr Handle, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_compositematerials_getcomposite", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 CompositeMaterials_GetComposite (IntPtr Handle, UInt32 APropertyID, UInt64 sizeComposite, out UInt64 neededComposite, IntPtr dataComposite);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_getcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_GetCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_getallpropertyids", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_GetAllPropertyIDs (IntPtr Handle, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_addmultiproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_AddMultiProperty (IntPtr Handle, UInt64 sizePropertyIDs, IntPtr dataPropertyIDs, out UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_setmultiproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_SetMultiProperty (IntPtr Handle, UInt32 APropertyID, UInt64 sizePropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_getmultiproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_GetMultiProperty (IntPtr Handle, UInt32 APropertyID, UInt64 sizePropertyIDs, out UInt64 neededPropertyIDs, IntPtr dataPropertyIDs);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_removemultiproperty", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_RemoveMultiProperty (IntPtr Handle, UInt32 APropertyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_getlayercount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_GetLayerCount (IntPtr Handle, out UInt32 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_addlayer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_AddLayer (IntPtr Handle, ref InternalMultiPropertyLayer ATheLayer, out UInt32 ALayerIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_getlayer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_GetLayer (IntPtr Handle, UInt32 ALayerIndex, out InternalMultiPropertyLayer ATheLayer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_multipropertygroup_removelayer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MultiPropertyGroup_RemoveLayer (IntPtr Handle, UInt32 ALayerIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_image3d_getname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Image3D_GetName (IntPtr Handle, UInt32 sizeName, out UInt32 neededName, IntPtr dataName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_image3d_setname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Image3D_SetName (IntPtr Handle, byte[] AName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_image3d_isimagestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Image3D_IsImageStack (IntPtr Handle, out Byte AIsImageStack);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_getrowcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_GetRowCount (IntPtr Handle, out UInt32 ARowCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_setrowcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_SetRowCount (IntPtr Handle, UInt32 ARowCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_getcolumncount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_GetColumnCount (IntPtr Handle, out UInt32 AColumnCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_setcolumncount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_SetColumnCount (IntPtr Handle, UInt32 AColumnCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_getsheetcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_GetSheetCount (IntPtr Handle, out UInt32 ASheetCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_getsheet", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_GetSheet (IntPtr Handle, UInt32 AIndex, out IntPtr ASheet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_setsheet", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_SetSheet (IntPtr Handle, UInt32 AIndex, IntPtr ASheet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_createemptysheet", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_CreateEmptySheet (IntPtr Handle, UInt32 AIndex, byte[] APath, out IntPtr ASheet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_createsheetfrombuffer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_CreateSheetFromBuffer (IntPtr Handle, UInt32 AIndex, byte[] APath, UInt64 sizeData, IntPtr dataData, out IntPtr ASheet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_imagestack_createsheetfromfile", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImageStack_CreateSheetFromFile (IntPtr Handle, UInt32 AIndex, byte[] APath, byte[] AFileName, out IntPtr ASheet);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_getpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_GetPath (IntPtr Handle, UInt32 sizePath, out UInt32 neededPath, IntPtr dataPath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_setpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_SetPath (IntPtr Handle, byte[] APath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_packagepart", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_PackagePart (IntPtr Handle, out IntPtr APackagePart);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_getrelationshiptype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_GetRelationShipType (IntPtr Handle, UInt32 sizePath, out UInt32 neededPath, IntPtr dataPath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_setrelationshiptype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_SetRelationShipType (IntPtr Handle, byte[] APath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_writetofile", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_WriteToFile (IntPtr Handle, byte[] AFileName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_readfromfile", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_ReadFromFile (IntPtr Handle, byte[] AFileName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_readfromcallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_ReadFromCallback (IntPtr Handle, IntPtr ATheReadCallback, UInt64 AStreamSize, IntPtr ATheSeekCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_getstreamsize", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_GetStreamSize (IntPtr Handle, out UInt64 AStreamSize);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_writetobuffer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_WriteToBuffer (IntPtr Handle, UInt64 sizeBuffer, out UInt64 neededBuffer, IntPtr dataBuffer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_attachment_readfrombuffer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Attachment_ReadFromBuffer (IntPtr Handle, UInt64 sizeBuffer, IntPtr dataBuffer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_getattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_GetAttachment (IntPtr Handle, out IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_setattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_SetAttachment (IntPtr Handle, IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_getcontenttype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_GetContentType (IntPtr Handle, out Int32 AContentType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_setcontenttype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_SetContentType (IntPtr Handle, Int32 AContentType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_gettilestyleuv", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_GetTileStyleUV (IntPtr Handle, out Int32 ATileStyleU, out Int32 ATileStyleV);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_settilestyleuv", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_SetTileStyleUV (IntPtr Handle, Int32 ATileStyleU, Int32 ATileStyleV);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_getfilter", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_GetFilter (IntPtr Handle, out Int32 AFilter);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_texture2d_setfilter", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Texture2D_SetFilter (IntPtr Handle, Int32 AFilter);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_getidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_GetIdentifier (IntPtr Handle, UInt32 sizeIdentifier, out UInt32 neededIdentifier, IntPtr dataIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_setidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_SetIdentifier (IntPtr Handle, byte[] AIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_getdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_GetDisplayName (IntPtr Handle, UInt32 sizeDisplayName, out UInt32 neededDisplayName, IntPtr dataDisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_setdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_SetDisplayName (IntPtr Handle, byte[] ADisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_settype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_SetType (IntPtr Handle, Int32 AImplicitPortType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_gettype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_GetType (IntPtr Handle, out Int32 AImplicitPortType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_getreference", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_GetReference (IntPtr Handle, UInt32 sizeReference, out UInt32 neededReference, IntPtr dataReference);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitport_setreference", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPort_SetReference (IntPtr Handle, byte[] AReference);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_iterator_movenext", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Iterator_MoveNext (IntPtr Handle, out Byte AHasNext);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_iterator_moveprevious", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Iterator_MovePrevious (IntPtr Handle, out Byte AHasPrevious);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_iterator_count", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Iterator_Count (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitportiterator_getcurrent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitPortIterator_GetCurrent (IntPtr Handle, out IntPtr APort);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_getidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetIdentifier (IntPtr Handle, UInt32 sizeIdentifier, out UInt32 neededIdentifier, IntPtr dataIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_setidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_SetIdentifier (IntPtr Handle, byte[] AIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_getdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetDisplayName (IntPtr Handle, UInt32 sizeDisplayName, out UInt32 neededDisplayName, IntPtr dataDisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_setdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_SetDisplayName (IntPtr Handle, byte[] ADisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_gettag", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetTag (IntPtr Handle, UInt32 sizeTag, out UInt32 neededTag, IntPtr dataTag);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_settag", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_SetTag (IntPtr Handle, byte[] ATag);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_getnodetype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetNodeType (IntPtr Handle, out Int32 AType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_addinput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_AddInput (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, out IntPtr APort);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_getinputs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetInputs (IntPtr Handle, out IntPtr AIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_addoutput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_AddOutput (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, out IntPtr APort);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_getoutputs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_GetOutputs (IntPtr Handle, out IntPtr AIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_findinput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_FindInput (IntPtr Handle, byte[] AIdentifier, out IntPtr AInput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_findoutput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_FindOutput (IntPtr Handle, byte[] AIdentifier, out IntPtr AOutput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitnode_aretypesvalid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitNode_AreTypesValid (IntPtr Handle, out Byte AValid);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_oneinputnode_getinputa", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 OneInputNode_GetInputA (IntPtr Handle, out IntPtr AInput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_oneinputnode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 OneInputNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceidnode_setresource", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIdNode_SetResource (IntPtr Handle, IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceidnode_getresource", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIdNode_GetResource (IntPtr Handle, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourceidnode_getoutputvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceIdNode_GetOutputValue (IntPtr Handle, out IntPtr AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_twoinputnode_getinputb", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 TwoInputNode_GetInputB (IntPtr Handle, out IntPtr AB);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_selectnode_getinputb", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SelectNode_GetInputB (IntPtr Handle, out IntPtr AB);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_selectnode_getinputc", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SelectNode_GetInputC (IntPtr Handle, out IntPtr AC);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_selectnode_getinputd", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SelectNode_GetInputD (IntPtr Handle, out IntPtr AD);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_clampnode_getinputmin", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ClampNode_GetInputMin (IntPtr Handle, out IntPtr AMin);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_clampnode_getinputmax", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ClampNode_GetInputMax (IntPtr Handle, out IntPtr AMax);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composevectornode_getinputx", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeVectorNode_GetInputX (IntPtr Handle, out IntPtr AX);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composevectornode_getinputy", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeVectorNode_GetInputY (IntPtr Handle, out IntPtr AY);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composevectornode_getinputz", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeVectorNode_GetInputZ (IntPtr Handle, out IntPtr AZ);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composevectornode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeVectorNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_decomposevectornode_getinputa", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 DecomposeVectorNode_GetInputA (IntPtr Handle, out IntPtr AA);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_decomposevectornode_getoutputx", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 DecomposeVectorNode_GetOutputX (IntPtr Handle, out IntPtr AX);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_decomposevectornode_getoutputy", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 DecomposeVectorNode_GetOutputY (IntPtr Handle, out IntPtr AY);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_decomposevectornode_getoutputz", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 DecomposeVectorNode_GetOutputZ (IntPtr Handle, out IntPtr AZ);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm00", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM00 (IntPtr Handle, out IntPtr AM00);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm01", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM01 (IntPtr Handle, out IntPtr AM01);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm02", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM02 (IntPtr Handle, out IntPtr AM02);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm03", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM03 (IntPtr Handle, out IntPtr AM03);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm10", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM10 (IntPtr Handle, out IntPtr AM10);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm11", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM11 (IntPtr Handle, out IntPtr AM11);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm12", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM12 (IntPtr Handle, out IntPtr AM12);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm13", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM13 (IntPtr Handle, out IntPtr AM13);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm20", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM20 (IntPtr Handle, out IntPtr AM20);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm21", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM21 (IntPtr Handle, out IntPtr AM21);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm22", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM22 (IntPtr Handle, out IntPtr AM22);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm23", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM23 (IntPtr Handle, out IntPtr AM23);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm30", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM30 (IntPtr Handle, out IntPtr AM30);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm31", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM31 (IntPtr Handle, out IntPtr AM31);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm32", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM32 (IntPtr Handle, out IntPtr AM32);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getinputm33", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetInputM33 (IntPtr Handle, out IntPtr AM33);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_composematrixnode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ComposeMatrixNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromrowsnode_getinputa", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromRowsNode_GetInputA (IntPtr Handle, out IntPtr ARow0);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromrowsnode_getinputb", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromRowsNode_GetInputB (IntPtr Handle, out IntPtr ARow1);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromrowsnode_getinputc", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromRowsNode_GetInputC (IntPtr Handle, out IntPtr ARow2);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromrowsnode_getinputd", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromRowsNode_GetInputD (IntPtr Handle, out IntPtr ARow3);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromrowsnode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromRowsNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromcolumnsnode_getinputa", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromColumnsNode_GetInputA (IntPtr Handle, out IntPtr AColumn0);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromcolumnsnode_getinputb", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromColumnsNode_GetInputB (IntPtr Handle, out IntPtr AColumn1);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromcolumnsnode_getinputc", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromColumnsNode_GetInputC (IntPtr Handle, out IntPtr AColumn2);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromcolumnsnode_getinputd", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromColumnsNode_GetInputD (IntPtr Handle, out IntPtr AColumn3);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_matrixfromcolumnsnode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MatrixFromColumnsNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constantnode_setconstant", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstantNode_SetConstant (IntPtr Handle, Double AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constantnode_getconstant", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstantNode_GetConstant (IntPtr Handle, out Double AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constantnode_getoutputvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstantNode_GetOutputValue (IntPtr Handle, out IntPtr AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constvecnode_setvector", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstVecNode_SetVector (IntPtr Handle, ref InternalVector AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constvecnode_getvector", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstVecNode_GetVector (IntPtr Handle, out InternalVector AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constvecnode_getoutputvector", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstVecNode_GetOutputVector (IntPtr Handle, out IntPtr AVector);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constmatnode_setmatrix", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstMatNode_SetMatrix (IntPtr Handle, ref InternalMatrix4x4 AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constmatnode_getmatrix", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstMatNode_GetMatrix (IntPtr Handle, out InternalMatrix4x4 AValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_constmatnode_getoutputmatrix", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ConstMatNode_GetOutputMatrix (IntPtr Handle, out IntPtr AMatrix);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshnode_getinputmesh", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshNode_GetInputMesh (IntPtr Handle, out IntPtr AMesh);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshnode_getinputpos", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshNode_GetInputPos (IntPtr Handle, out IntPtr APos);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_meshnode_getoutputdistance", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 MeshNode_GetOutputDistance (IntPtr Handle, out IntPtr ADistance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_unsignedmeshnode_getinputmesh", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 UnsignedMeshNode_GetInputMesh (IntPtr Handle, out IntPtr AMesh);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_unsignedmeshnode_getinputpos", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 UnsignedMeshNode_GetInputPos (IntPtr Handle, out IntPtr APos);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_unsignedmeshnode_getoutputdistance", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 UnsignedMeshNode_GetOutputDistance (IntPtr Handle, out IntPtr ADistance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlatticenode_getinputbeamlattice", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLatticeNode_GetInputBeamLattice (IntPtr Handle, out IntPtr ABeamLattice);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlatticenode_getinputpos", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLatticeNode_GetInputPos (IntPtr Handle, out IntPtr APos);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlatticenode_getoutputdistance", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLatticeNode_GetOutputDistance (IntPtr Handle, out IntPtr ADistance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlatticenode_setaccuraterange", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLatticeNode_SetAccurateRange (IntPtr Handle, Double AAccurateRange);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_beamlatticenode_getaccuraterange", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BeamLatticeNode_GetAccurateRange (IntPtr Handle, out Double AAccurateRange);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getinputfunctionid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetInputFunctionID (IntPtr Handle, out IntPtr AFunction);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getinputpos", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetInputPos (IntPtr Handle, out IntPtr APos);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getinputstep", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetInputStep (IntPtr Handle, out IntPtr AStep);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_setscalaroutputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_SetScalarOutputName (IntPtr Handle, byte[] AScalarOutputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getscalaroutputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetScalarOutputName (IntPtr Handle, UInt32 sizeScalarOutputName, out UInt32 neededScalarOutputName, IntPtr dataScalarOutputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_setvectorinputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_SetVectorInputName (IntPtr Handle, byte[] AVectorInputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getvectorinputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetVectorInputName (IntPtr Handle, UInt32 sizeVectorInputName, out UInt32 neededVectorInputName, IntPtr dataVectorInputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getoutputnormalizedgradient", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetOutputNormalizedGradient (IntPtr Handle, out IntPtr ANormalizedGradient);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getoutputgradient", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetOutputGradient (IntPtr Handle, out IntPtr AGradient);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functiongradientnode_getoutputmagnitude", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionGradientNode_GetOutputMagnitude (IntPtr Handle, out IntPtr AMagnitude);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getinputfunctionid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetInputFunctionID (IntPtr Handle, out IntPtr AFunction);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getinputpos", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetInputPos (IntPtr Handle, out IntPtr APos);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getinputstep", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetInputStep (IntPtr Handle, out IntPtr AStep);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_setscalaroutputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_SetScalarOutputName (IntPtr Handle, byte[] AScalarOutputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getscalaroutputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetScalarOutputName (IntPtr Handle, UInt32 sizeScalarOutputName, out UInt32 neededScalarOutputName, IntPtr dataScalarOutputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_setvectorinputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_SetVectorInputName (IntPtr Handle, byte[] AVectorInputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getvectorinputname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetVectorInputName (IntPtr Handle, UInt32 sizeVectorInputName, out UInt32 neededVectorInputName, IntPtr dataVectorInputName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_normalizedistancenode_getoutputresult", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NormalizeDistanceNode_GetOutputResult (IntPtr Handle, out IntPtr AResult);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functioncallnode_getinputfunctionid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionCallNode_GetInputFunctionID (IntPtr Handle, out IntPtr AFunction);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_nodeiterator_getcurrent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 NodeIterator_GetCurrent (IntPtr Handle, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_getdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_GetDisplayName (IntPtr Handle, UInt32 sizeDisplayName, out UInt32 neededDisplayName, IntPtr dataDisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_setdisplayname", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_SetDisplayName (IntPtr Handle, byte[] ADisplayName);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_addinput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_AddInput (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, Int32 AType, out IntPtr APort);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_getinputs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_GetInputs (IntPtr Handle, out IntPtr AIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_removeinput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_RemoveInput (IntPtr Handle, IntPtr AInput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_addoutput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_AddOutput (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, Int32 AType, out IntPtr APort);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_getoutputs", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_GetOutputs (IntPtr Handle, out IntPtr AIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_removeoutput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_RemoveOutput (IntPtr Handle, IntPtr AOutput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_findinput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_FindInput (IntPtr Handle, byte[] AIdentifier, out IntPtr AInput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_function_findoutput", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Function_FindOutput (IntPtr Handle, byte[] AIdentifier, out IntPtr AOutput);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_getidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_GetIdentifier (IntPtr Handle, UInt32 sizeIdentifier, out UInt32 neededIdentifier, IntPtr dataIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_setidentifier", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_SetIdentifier (IntPtr Handle, byte[] AIdentifier);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddNode (IntPtr Handle, Int32 ANodeType, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addsinnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSinNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addcosnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddCosNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addtannode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddTanNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addarcsinnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddArcSinNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addarccosnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddArcCosNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addarctan2node", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddArcTan2Node (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addsinhnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSinhNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addcoshnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddCoshNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addtanhnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddTanhNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addroundnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddRoundNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addceilnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddCeilNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addfloornode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddFloorNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addsignnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSignNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addfractnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddFractNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addabsnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddAbsNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addexpnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddExpNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlognode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLogNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlog2node", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLog2Node (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlog10node", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLog10Node (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlengthnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLengthNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addtransposenode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddTransposeNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addinversenode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddInverseNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addsqrtnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSqrtNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addresourceidnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddResourceIdNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addadditionnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddAdditionNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addsubtractionnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSubtractionNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmultiplicationnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMultiplicationNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_adddivisionnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddDivisionNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_adddotnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddDotNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addcrossnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddCrossNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmatvecmultiplicationnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMatVecMultiplicationNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addminnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMinNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmaxnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMaxNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addfmodnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddFmodNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addpownode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddPowNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addselectnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddSelectNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addclampnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddClampNode (IntPtr Handle, byte[] AIdentifier, Int32 AConfiguration, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addcomposevectornode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddComposeVectorNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addvectorfromscalarnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddVectorFromScalarNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_adddecomposevectornode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddDecomposeVectorNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addcomposematrixnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddComposeMatrixNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmatrixfromrowsnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMatrixFromRowsNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmatrixfromcolumnsnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMatrixFromColumnsNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addconstantnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddConstantNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addconstvecnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddConstVecNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addconstmatnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddConstMatNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addmeshnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddMeshNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addunsignedmeshnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddUnsignedMeshNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addbeamlatticenode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddBeamLatticeNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addfunctiongradientnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddFunctionGradientNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addnormalizedistancenode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddNormalizeDistanceNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addfunctioncallnode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddFunctionCallNode (IntPtr Handle, byte[] AIdentifier, byte[] ADisplayName, byte[] ATag, out IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_getnodes", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_GetNodes (IntPtr Handle, out IntPtr AIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_removenode", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_RemoveNode (IntPtr Handle, IntPtr ANode);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlink", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLink (IntPtr Handle, IntPtr ASource, IntPtr ATarget);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_addlinkbynames", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_AddLinkByNames (IntPtr Handle, byte[] ASource, byte[] ATarget);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_clear", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_Clear (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_implicitfunction_sortnodestopologically", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ImplicitFunction_SortNodesTopologically (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_getimage3d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_GetImage3D (IntPtr Handle, out IntPtr AImage3D);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_setimage3d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_SetImage3D (IntPtr Handle, IntPtr AImage3D);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_setfilter", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_SetFilter (IntPtr Handle, Int32 AFilter);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_getfilter", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_GetFilter (IntPtr Handle, out Int32 AFilter);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_settilestyles", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_SetTileStyles (IntPtr Handle, Int32 ATileStyleU, Int32 ATileStyleV, Int32 ATileStyleW);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_gettilestyles", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_GetTileStyles (IntPtr Handle, out Int32 ATileStyleU, out Int32 ATileStyleV, out Int32 ATileStyleW);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_getoffset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_GetOffset (IntPtr Handle, out Double AOffset);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_setoffset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_SetOffset (IntPtr Handle, Double AOffset);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_getscale", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_GetScale (IntPtr Handle, out Double AScale);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_functionfromimage3d_setscale", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 FunctionFromImage3D_SetScale (IntPtr Handle, Double AScale);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getobjectresource", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetObjectResource (IntPtr Handle, out IntPtr AObjectResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetUUID (IntPtr Handle, out Byte AHasUUID, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_setuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_SetUUID (IntPtr Handle, byte[] AUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getobjectresourceid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetObjectResourceID (IntPtr Handle, out UInt32 AUniqueResourceID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_hasobjecttransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_HasObjectTransform (IntPtr Handle, out Byte AHasTransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getobjecttransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetObjectTransform (IntPtr Handle, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_setobjecttransform", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_SetObjectTransform (IntPtr Handle, ref InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getpartnumber", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetPartNumber (IntPtr Handle, UInt32 sizePartNumber, out UInt32 neededPartNumber, IntPtr dataPartNumber);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_setpartnumber", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_SetPartNumber (IntPtr Handle, byte[] ASetPartnumber);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getmetadatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetMetaDataGroup (IntPtr Handle, out IntPtr AMetaDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditem_getoutbox", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItem_GetOutbox (IntPtr Handle, out InternalBox AOutbox);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditemiterator_movenext", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItemIterator_MoveNext (IntPtr Handle, out Byte AHasNext);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditemiterator_moveprevious", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItemIterator_MovePrevious (IntPtr Handle, out Byte AHasPrevious);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditemiterator_getcurrent", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItemIterator_GetCurrent (IntPtr Handle, out IntPtr ABuildItem);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditemiterator_clone", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItemIterator_Clone (IntPtr Handle, out IntPtr AOutBuildItemIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_builditemiterator_count", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 BuildItemIterator_Count (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_setvertices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_SetVertices (IntPtr Handle, UInt64 sizeVertices, IntPtr dataVertices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getvertices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetVertices (IntPtr Handle, UInt64 sizeVertices, out UInt64 neededVertices, IntPtr dataVertices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getvertexcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetVertexCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_addpolygon", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_AddPolygon (IntPtr Handle, UInt64 sizeIndices, IntPtr dataIndices, out UInt64 AIndex);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getpolygoncount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetPolygonCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_setpolygonindices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_SetPolygonIndices (IntPtr Handle, UInt64 AIndex, UInt64 sizeIndices, IntPtr dataIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getpolygonindices", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetPolygonIndices (IntPtr Handle, UInt64 AIndex, UInt64 sizeIndices, out UInt64 neededIndices, IntPtr dataIndices);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getpolygonindexcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetPolygonIndexCount (IntPtr Handle, UInt64 AIndex, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slice_getztop", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Slice_GetZTop (IntPtr Handle, out Double AZTop);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getbottomz", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetBottomZ (IntPtr Handle, out Double AZBottom);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getslicecount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetSliceCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getslice", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetSlice (IntPtr Handle, UInt64 ASliceIndex, out IntPtr ATheSlice);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_addslice", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_AddSlice (IntPtr Handle, Double AZTop, out IntPtr ATheSlice);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getslicerefcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetSliceRefCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_addslicestackreference", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_AddSliceStackReference (IntPtr Handle, IntPtr ATheSliceStack);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getslicestackreference", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetSliceStackReference (IntPtr Handle, UInt64 ASliceRefIndex, out IntPtr ATheSliceStack);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_collapseslicereferences", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_CollapseSliceReferences (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_setownpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_SetOwnPath (IntPtr Handle, byte[] APath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_slicestack_getownpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 SliceStack_GetOwnPath (IntPtr Handle, UInt32 sizePath, out UInt32 neededPath, IntPtr dataPath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_consumer_getconsumerid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Consumer_GetConsumerID (IntPtr Handle, UInt32 sizeConsumerID, out UInt32 neededConsumerID, IntPtr dataConsumerID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_consumer_getkeyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Consumer_GetKeyID (IntPtr Handle, UInt32 sizeKeyID, out UInt32 neededKeyID, IntPtr dataKeyID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_consumer_getkeyvalue", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Consumer_GetKeyValue (IntPtr Handle, UInt32 sizeKeyValue, out UInt32 neededKeyValue, IntPtr dataKeyValue);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_accessright_getconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 AccessRight_GetConsumer (IntPtr Handle, out IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_accessright_getwrappingalgorithm", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 AccessRight_GetWrappingAlgorithm (IntPtr Handle, out Int32 AAlgorithm);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_accessright_getmgfalgorithm", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 AccessRight_GetMgfAlgorithm (IntPtr Handle, out Int32 AAlgorithm);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_accessright_getdigestmethod", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 AccessRight_GetDigestMethod (IntPtr Handle, out Int32 AAlgorithm);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getencryptionalgorithm", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetEncryptionAlgorithm (IntPtr Handle, out Int32 AAlgorithm);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getkey", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetKey (IntPtr Handle, UInt64 sizeByteData, out UInt64 neededByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getinitializationvector", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetInitializationVector (IntPtr Handle, UInt64 sizeByteData, out UInt64 neededByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getauthenticationtag", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetAuthenticationTag (IntPtr Handle, UInt64 sizeByteData, out UInt64 neededByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_setauthenticationtag", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_SetAuthenticationTag (IntPtr Handle, UInt64 sizeByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getadditionalauthenticationdata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetAdditionalAuthenticationData (IntPtr Handle, UInt64 sizeByteData, out UInt64 neededByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getdescriptor", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetDescriptor (IntPtr Handle, out UInt64 ADescriptor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_contentencryptionparams_getkeyuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ContentEncryptionParams_GetKeyUUID (IntPtr Handle, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedata_getpath", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceData_GetPath (IntPtr Handle, out IntPtr APath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedata_getencryptionalgorithm", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceData_GetEncryptionAlgorithm (IntPtr Handle, out Int32 AEncryptionAlgorithm);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedata_getcompression", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceData_GetCompression (IntPtr Handle, out Int32 ACompression);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedata_getadditionalauthenticationdata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceData_GetAdditionalAuthenticationData (IntPtr Handle, UInt64 sizeByteData, out UInt64 neededByteData, IntPtr dataByteData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedatagroup_getkeyuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceDataGroup_GetKeyUUID (IntPtr Handle, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedatagroup_addaccessright", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceDataGroup_AddAccessRight (IntPtr Handle, IntPtr AConsumer, Int32 AWrappingAlgorithm, Int32 AMgfAlgorithm, Int32 ADigestMethod, out IntPtr ATheAccessRight);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedatagroup_findaccessrightbyconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceDataGroup_FindAccessRightByConsumer (IntPtr Handle, IntPtr AConsumer, out IntPtr ATheAccessRight);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_resourcedatagroup_removeaccessright", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 ResourceDataGroup_RemoveAccessRight (IntPtr Handle, IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_addconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_AddConsumer (IntPtr Handle, byte[] AConsumerID, byte[] AKeyID, byte[] AKeyValue, out IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getconsumercount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetConsumerCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetConsumer (IntPtr Handle, UInt64 AConsumerIndex, out IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_removeconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_RemoveConsumer (IntPtr Handle, IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_findconsumer", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_FindConsumer (IntPtr Handle, byte[] AConsumerID, out IntPtr AConsumer);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getresourcedatagroupcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetResourceDataGroupCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_addresourcedatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_AddResourceDataGroup (IntPtr Handle, out IntPtr AResourceDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getresourcedatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetResourceDataGroup (IntPtr Handle, UInt64 AResourceDataIndex, out IntPtr AResourceDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_removeresourcedatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_RemoveResourceDataGroup (IntPtr Handle, IntPtr AResourceDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_findresourcedatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_FindResourceDataGroup (IntPtr Handle, IntPtr APartPath, out IntPtr AResourceDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_addresourcedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_AddResourceData (IntPtr Handle, IntPtr AResourceDataGroup, IntPtr APartPath, Int32 AAlgorithm, Int32 ACompression, UInt64 sizeAdditionalAuthenticationData, IntPtr dataAdditionalAuthenticationData, out IntPtr AResourceData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_removeresourcedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_RemoveResourceData (IntPtr Handle, IntPtr AResourceData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_findresourcedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_FindResourceData (IntPtr Handle, IntPtr AResourcePath, out IntPtr AResourceData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getresourcedatacount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetResourceDataCount (IntPtr Handle, out UInt64 ACount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getresourcedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetResourceData (IntPtr Handle, UInt64 AResourceDataIndex, out IntPtr AResourceData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_getuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_GetUUID (IntPtr Handle, out Byte AHasUUID, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_keystore_setuuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 KeyStore_SetUUID (IntPtr Handle, byte[] AUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_rootmodelpart", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RootModelPart (IntPtr Handle, out IntPtr ARootModelPart);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_findorcreatepackagepart", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_FindOrCreatePackagePart (IntPtr Handle, byte[] AAbsolutePath, out IntPtr AModelPart);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_setunit", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_SetUnit (IntPtr Handle, Int32 AUnit);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getunit", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetUnit (IntPtr Handle, out Int32 AUnit);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getlanguage", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetLanguage (IntPtr Handle, UInt32 sizeLanguage, out UInt32 neededLanguage, IntPtr dataLanguage);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_setlanguage", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_SetLanguage (IntPtr Handle, byte[] ALanguage);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_querywriter", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_QueryWriter (IntPtr Handle, byte[] AWriterClass, out IntPtr AWriterInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_queryreader", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_QueryReader (IntPtr Handle, byte[] AReaderClass, out IntPtr AReaderInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getresourcebyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetResourceByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_gettexture2dbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetTexture2DByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ATextureInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getpropertytypebyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetPropertyTypeByID (IntPtr Handle, UInt32 AUniqueResourceID, out Int32 AThePropertyType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getbasematerialgroupbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetBaseMaterialGroupByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ABaseMaterialGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_gettexture2dgroupbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetTexture2DGroupByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ATexture2DGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcompositematerialsbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetCompositeMaterialsByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ACompositeMaterialsInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getmultipropertygroupbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetMultiPropertyGroupByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AMultiPropertyGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getmeshobjectbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetMeshObjectByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AMeshObjectInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcomponentsobjectbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetComponentsObjectByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AComponentsObjectInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcolorgroupbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetColorGroupByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AColorGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getslicestackbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetSliceStackByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ASliceStacInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getlevelsetbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetLevelSetByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr ALevelSetObjectInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getbuilduuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetBuildUUID (IntPtr Handle, out Byte AHasUUID, UInt32 sizeUUID, out UInt32 neededUUID, IntPtr dataUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_setbuilduuid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_SetBuildUUID (IntPtr Handle, byte[] AUUID);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getbuilditems", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetBuildItems (IntPtr Handle, out IntPtr ABuildItemIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getoutbox", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetOutbox (IntPtr Handle, out InternalBox AOutbox);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getresources", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetResources (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getobjects", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetObjects (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getmeshobjects", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetMeshObjects (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcomponentsobjects", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetComponentsObjects (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_gettexture2ds", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetTexture2Ds (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getbasematerialgroups", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetBaseMaterialGroups (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcolorgroups", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetColorGroups (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_gettexture2dgroups", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetTexture2DGroups (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getcompositematerials", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetCompositeMaterials (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getmultipropertygroups", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetMultiPropertyGroups (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getslicestacks", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetSliceStacks (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getimage3ds", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetImage3Ds (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_mergetomodel", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_MergeToModel (IntPtr Handle, out IntPtr AMergedModelInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_mergefrommodel", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_MergeFromModel (IntPtr Handle, IntPtr AModelInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addmeshobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddMeshObject (IntPtr Handle, out IntPtr AMeshObjectInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addcomponentsobject", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddComponentsObject (IntPtr Handle, out IntPtr AComponentsObjectInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addslicestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddSliceStack (IntPtr Handle, Double AZBottom, out IntPtr ASliceStackInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addtexture2dfromattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddTexture2DFromAttachment (IntPtr Handle, IntPtr ATextureAttachment, out IntPtr ATexture2DInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addbasematerialgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddBaseMaterialGroup (IntPtr Handle, out IntPtr ABaseMaterialGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addcolorgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddColorGroup (IntPtr Handle, out IntPtr AColorGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addtexture2dgroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddTexture2DGroup (IntPtr Handle, IntPtr ATexture2DInstance, out IntPtr ATexture2DGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addcompositematerials", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddCompositeMaterials (IntPtr Handle, IntPtr ABaseMaterialGroupInstance, out IntPtr ACompositeMaterialsInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addmultipropertygroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddMultiPropertyGroup (IntPtr Handle, out IntPtr AMultiPropertyGroupInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addimagestack", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddImageStack (IntPtr Handle, UInt32 AColumnCount, UInt32 ARowCount, UInt32 ASheetCount, out IntPtr AInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getimagestackbyid", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetImageStackByID (IntPtr Handle, UInt32 AUniqueResourceID, out IntPtr AImageStackInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addbuilditem", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddBuildItem (IntPtr Handle, IntPtr AObject, ref InternalTransform ATransform, out IntPtr ABuildItemInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_removebuilditem", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RemoveBuildItem (IntPtr Handle, IntPtr ABuildItemInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getmetadatagroup", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetMetaDataGroup (IntPtr Handle, out IntPtr ATheMetaDataGroup);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddAttachment (IntPtr Handle, byte[] AURI, byte[] ARelationShipType, out IntPtr AAttachmentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_removeattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RemoveAttachment (IntPtr Handle, IntPtr AAttachmentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetAttachment (IntPtr Handle, UInt32 AIndex, out IntPtr AAttachmentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_findattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_FindAttachment (IntPtr Handle, byte[] AURI, out IntPtr AAttachmentInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getattachmentcount", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetAttachmentCount (IntPtr Handle, out UInt32 AAttachmentCount);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_haspackagethumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_HasPackageThumbnailAttachment (IntPtr Handle, out Byte AHasThumbnail);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_createpackagethumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_CreatePackageThumbnailAttachment (IntPtr Handle, out IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getpackagethumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetPackageThumbnailAttachment (IntPtr Handle, out IntPtr AAttachment);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_removepackagethumbnailattachment", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RemovePackageThumbnailAttachment (IntPtr Handle);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addcustomcontenttype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddCustomContentType (IntPtr Handle, byte[] AExtension, byte[] AContentType);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_removecustomcontenttype", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RemoveCustomContentType (IntPtr Handle, byte[] AExtension);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_setrandomnumbercallback", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_SetRandomNumberCallback (IntPtr Handle, IntPtr ATheCallback, UInt64 AUserData);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getkeystore", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetKeyStore (IntPtr Handle, out IntPtr AKeyStore);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getfunctions", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetFunctions (IntPtr Handle, out IntPtr ATheResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addimplicitfunction", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddImplicitFunction (IntPtr Handle, out IntPtr AFunctionInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addfunctionfromimage3d", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddFunctionFromImage3D (IntPtr Handle, IntPtr AImage3DInstance, out IntPtr AFunctionInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addvolumedata", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddVolumeData (IntPtr Handle, out IntPtr AVolumeDataInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_addlevelset", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_AddLevelSet (IntPtr Handle, out IntPtr ALevelSetInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_getlevelsets", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_GetLevelSets (IntPtr Handle, out IntPtr AResourceIterator);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_model_removeresource", CallingConvention=CallingConvention.Cdecl)]
			public unsafe extern static Int32 Model_RemoveResource (IntPtr Handle, IntPtr AResource);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getlibraryversion", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetLibraryVersion (out UInt32 AMajor, out UInt32 AMinor, out UInt32 AMicro);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getprereleaseinformation", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetPrereleaseInformation (out Byte AHasPrereleaseInfo, UInt32 sizePrereleaseInfo, out UInt32 neededPrereleaseInfo, IntPtr dataPrereleaseInfo);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getbuildinformation", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetBuildInformation (out Byte AHasBuildInfo, UInt32 sizeBuildInformation, out UInt32 neededBuildInformation, IntPtr dataBuildInformation);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getspecificationversion", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetSpecificationVersion (byte[] ASpecificationURL, out Byte AIsSupported, out UInt32 AMajor, out UInt32 AMinor, out UInt32 AMicro);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_createmodel", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 CreateModel (out IntPtr AModel);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_release", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 Release (IntPtr AInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_acquire", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 Acquire (IntPtr AInstance);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_setjournal", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 SetJournal (byte[] AJournalPath);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getlasterror", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetLastError (IntPtr AInstance, UInt32 sizeLastErrorString, out UInt32 neededLastErrorString, IntPtr dataLastErrorString, out Byte AHasLastError);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getsymbollookupmethod", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetSymbolLookupMethod (out UInt64 ASymbolLookupMethod);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_retrieveprogressmessage", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 RetrieveProgressMessage (Int32 ATheProgressIdentifier, UInt32 sizeProgressMessage, out UInt32 neededProgressMessage, IntPtr dataProgressMessage);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_rgbatocolor", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 RGBAToColor (Byte ARed, Byte AGreen, Byte ABlue, Byte AAlpha, out InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_floatrgbatocolor", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 FloatRGBAToColor (Single ARed, Single AGreen, Single ABlue, Single AAlpha, out InternalColor ATheColor);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colortorgba", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 ColorToRGBA (ref InternalColor ATheColor, out Byte ARed, out Byte AGreen, out Byte ABlue, out Byte AAlpha);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_colortofloatrgba", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 ColorToFloatRGBA (ref InternalColor ATheColor, out Single ARed, out Single AGreen, out Single ABlue, out Single AAlpha);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getidentitytransform", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetIdentityTransform (out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getuniformscaletransform", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetUniformScaleTransform (Single AFactor, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_getscaletransform", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetScaleTransform (Single AFactorX, Single AFactorY, Single AFactorZ, out InternalTransform ATransform);

			[DllImport("lib3mf.dll", EntryPoint = "lib3mf_gettranslationtransform", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
			public extern static Int32 GetTranslationTransform (Single AVectorX, Single AVectorY, Single AVectorZ, out InternalTransform ATransform);

			public unsafe static sTriangle convertInternalToStruct_Triangle (InternalTriangle intTriangle)
			{
				sTriangle Triangle;
				Triangle.Indices = new UInt32[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					Triangle.Indices[rowIndex] = intTriangle.Indices[rowIndex];
				}

				return Triangle;
			}

			public unsafe static InternalTriangle convertStructToInternal_Triangle (sTriangle Triangle)
			{
				InternalTriangle intTriangle;
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intTriangle.Indices[rowIndex] = Triangle.Indices[rowIndex];
				}

				return intTriangle;
			}

			public unsafe static sTriangleProperties convertInternalToStruct_TriangleProperties (InternalTriangleProperties intTriangleProperties)
			{
				sTriangleProperties TriangleProperties;
				TriangleProperties.ResourceID = intTriangleProperties.ResourceID;
				TriangleProperties.PropertyIDs = new UInt32[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					TriangleProperties.PropertyIDs[rowIndex] = intTriangleProperties.PropertyIDs[rowIndex];
				}

				return TriangleProperties;
			}

			public unsafe static InternalTriangleProperties convertStructToInternal_TriangleProperties (sTriangleProperties TriangleProperties)
			{
				InternalTriangleProperties intTriangleProperties;
				intTriangleProperties.ResourceID = TriangleProperties.ResourceID;
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intTriangleProperties.PropertyIDs[rowIndex] = TriangleProperties.PropertyIDs[rowIndex];
				}

				return intTriangleProperties;
			}

			public unsafe static sPosition convertInternalToStruct_Position (InternalPosition intPosition)
			{
				sPosition Position;
				Position.Coordinates = new Single[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					Position.Coordinates[rowIndex] = intPosition.Coordinates[rowIndex];
				}

				return Position;
			}

			public unsafe static InternalPosition convertStructToInternal_Position (sPosition Position)
			{
				InternalPosition intPosition;
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intPosition.Coordinates[rowIndex] = Position.Coordinates[rowIndex];
				}

				return intPosition;
			}

			public unsafe static sPosition2D convertInternalToStruct_Position2D (InternalPosition2D intPosition2D)
			{
				sPosition2D Position2D;
				Position2D.Coordinates = new Single[2];
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					Position2D.Coordinates[rowIndex] = intPosition2D.Coordinates[rowIndex];
				}

				return Position2D;
			}

			public unsafe static InternalPosition2D convertStructToInternal_Position2D (sPosition2D Position2D)
			{
				InternalPosition2D intPosition2D;
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					intPosition2D.Coordinates[rowIndex] = Position2D.Coordinates[rowIndex];
				}

				return intPosition2D;
			}

			public unsafe static sCompositeConstituent convertInternalToStruct_CompositeConstituent (InternalCompositeConstituent intCompositeConstituent)
			{
				sCompositeConstituent CompositeConstituent;
				CompositeConstituent.PropertyID = intCompositeConstituent.PropertyID;
				CompositeConstituent.MixingRatio = intCompositeConstituent.MixingRatio;
				return CompositeConstituent;
			}

			public unsafe static InternalCompositeConstituent convertStructToInternal_CompositeConstituent (sCompositeConstituent CompositeConstituent)
			{
				InternalCompositeConstituent intCompositeConstituent;
				intCompositeConstituent.PropertyID = CompositeConstituent.PropertyID;
				intCompositeConstituent.MixingRatio = CompositeConstituent.MixingRatio;
				return intCompositeConstituent;
			}

			public unsafe static sMultiPropertyLayer convertInternalToStruct_MultiPropertyLayer (InternalMultiPropertyLayer intMultiPropertyLayer)
			{
				sMultiPropertyLayer MultiPropertyLayer;
				MultiPropertyLayer.ResourceID = intMultiPropertyLayer.ResourceID;
				MultiPropertyLayer.TheBlendMethod = (eBlendMethod) intMultiPropertyLayer.TheBlendMethod;
				return MultiPropertyLayer;
			}

			public unsafe static InternalMultiPropertyLayer convertStructToInternal_MultiPropertyLayer (sMultiPropertyLayer MultiPropertyLayer)
			{
				InternalMultiPropertyLayer intMultiPropertyLayer;
				intMultiPropertyLayer.ResourceID = MultiPropertyLayer.ResourceID;
				intMultiPropertyLayer.TheBlendMethod = (Int32) MultiPropertyLayer.TheBlendMethod;
				return intMultiPropertyLayer;
			}

			public unsafe static sTex2Coord convertInternalToStruct_Tex2Coord (InternalTex2Coord intTex2Coord)
			{
				sTex2Coord Tex2Coord;
				Tex2Coord.U = intTex2Coord.U;
				Tex2Coord.V = intTex2Coord.V;
				return Tex2Coord;
			}

			public unsafe static InternalTex2Coord convertStructToInternal_Tex2Coord (sTex2Coord Tex2Coord)
			{
				InternalTex2Coord intTex2Coord;
				intTex2Coord.U = Tex2Coord.U;
				intTex2Coord.V = Tex2Coord.V;
				return intTex2Coord;
			}

			public unsafe static sTransform convertInternalToStruct_Transform (InternalTransform intTransform)
			{
				sTransform Transform;
				Transform.Fields = new Single[4][];
				for (int colIndex = 0; colIndex < 4; colIndex++) {
					Transform.Fields[colIndex] = new Single[3];
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						Transform.Fields[colIndex][rowIndex] = intTransform.Fields[colIndex * 3 + rowIndex];
					}
				}

				return Transform;
			}

			public unsafe static InternalTransform convertStructToInternal_Transform (sTransform Transform)
			{
				InternalTransform intTransform;
				for (int colIndex = 0; colIndex < 4; colIndex++) {
					for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
						intTransform.Fields[colIndex * 3 + rowIndex] = Transform.Fields[colIndex][rowIndex];
					}
				}

				return intTransform;
			}

			public unsafe static sBox convertInternalToStruct_Box (InternalBox intBox)
			{
				sBox Box;
				Box.MinCoordinate = new Single[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					Box.MinCoordinate[rowIndex] = intBox.MinCoordinate[rowIndex];
				}

				Box.MaxCoordinate = new Single[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					Box.MaxCoordinate[rowIndex] = intBox.MaxCoordinate[rowIndex];
				}

				return Box;
			}

			public unsafe static InternalBox convertStructToInternal_Box (sBox Box)
			{
				InternalBox intBox;
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intBox.MinCoordinate[rowIndex] = Box.MinCoordinate[rowIndex];
				}

				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intBox.MaxCoordinate[rowIndex] = Box.MaxCoordinate[rowIndex];
				}

				return intBox;
			}

			public unsafe static sColor convertInternalToStruct_Color (InternalColor intColor)
			{
				sColor Color;
				Color.Red = intColor.Red;
				Color.Green = intColor.Green;
				Color.Blue = intColor.Blue;
				Color.Alpha = intColor.Alpha;
				return Color;
			}

			public unsafe static InternalColor convertStructToInternal_Color (sColor Color)
			{
				InternalColor intColor;
				intColor.Red = Color.Red;
				intColor.Green = Color.Green;
				intColor.Blue = Color.Blue;
				intColor.Alpha = Color.Alpha;
				return intColor;
			}

			public unsafe static sBeam convertInternalToStruct_Beam (InternalBeam intBeam)
			{
				sBeam Beam;
				Beam.Indices = new UInt32[2];
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					Beam.Indices[rowIndex] = intBeam.Indices[rowIndex];
				}

				Beam.Radii = new Double[2];
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					Beam.Radii[rowIndex] = intBeam.Radii[rowIndex];
				}

				Beam.CapModes = new eBeamLatticeCapMode[2];
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					Beam.CapModes[rowIndex] = (eBeamLatticeCapMode) intBeam.CapModes[rowIndex];
				}

				return Beam;
			}

			public unsafe static InternalBeam convertStructToInternal_Beam (sBeam Beam)
			{
				InternalBeam intBeam;
				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					intBeam.Indices[rowIndex] = Beam.Indices[rowIndex];
				}

				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					intBeam.Radii[rowIndex] = Beam.Radii[rowIndex];
				}

				for (int rowIndex = 0; rowIndex < 2; rowIndex++) {
					intBeam.CapModes[rowIndex] = (Int32) Beam.CapModes[rowIndex];
				}

				return intBeam;
			}

			public unsafe static sBall convertInternalToStruct_Ball (InternalBall intBall)
			{
				sBall Ball;
				Ball.Index = intBall.Index;
				Ball.Radius = intBall.Radius;
				return Ball;
			}

			public unsafe static InternalBall convertStructToInternal_Ball (sBall Ball)
			{
				InternalBall intBall;
				intBall.Index = Ball.Index;
				intBall.Radius = Ball.Radius;
				return intBall;
			}

			public unsafe static sVector convertInternalToStruct_Vector (InternalVector intVector)
			{
				sVector Vector;
				Vector.Coordinates = new Double[3];
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					Vector.Coordinates[rowIndex] = intVector.Coordinates[rowIndex];
				}

				return Vector;
			}

			public unsafe static InternalVector convertStructToInternal_Vector (sVector Vector)
			{
				InternalVector intVector;
				for (int rowIndex = 0; rowIndex < 3; rowIndex++) {
					intVector.Coordinates[rowIndex] = Vector.Coordinates[rowIndex];
				}

				return intVector;
			}

			public unsafe static sMatrix4x4 convertInternalToStruct_Matrix4x4 (InternalMatrix4x4 intMatrix4x4)
			{
				sMatrix4x4 Matrix4x4;
				Matrix4x4.Field = new Double[4][];
				for (int colIndex = 0; colIndex < 4; colIndex++) {
					Matrix4x4.Field[colIndex] = new Double[4];
					for (int rowIndex = 0; rowIndex < 4; rowIndex++) {
						Matrix4x4.Field[colIndex][rowIndex] = intMatrix4x4.Field[colIndex * 4 + rowIndex];
					}
				}

				return Matrix4x4;
			}

			public unsafe static InternalMatrix4x4 convertStructToInternal_Matrix4x4 (sMatrix4x4 Matrix4x4)
			{
				InternalMatrix4x4 intMatrix4x4;
				for (int colIndex = 0; colIndex < 4; colIndex++) {
					for (int rowIndex = 0; rowIndex < 4; rowIndex++) {
						intMatrix4x4.Field[colIndex * 4 + rowIndex] = Matrix4x4.Field[colIndex][rowIndex];
					}
				}

				return intMatrix4x4;
			}

			public static void ThrowError(IntPtr Handle, Int32 errorCode)
			{
				String sMessage = "Lib3MF Error";
				if (Handle != IntPtr.Zero) {
					UInt32 sizeMessage = 0;
					UInt32 neededMessage = 0;
					Byte hasLastError = 0;
					Int32 resultCode1 = GetLastError (Handle, sizeMessage, out neededMessage, IntPtr.Zero, out hasLastError);
					if ((resultCode1 == 0) && (hasLastError != 0)) {
						sizeMessage = neededMessage;
						byte[] bytesMessage = new byte[sizeMessage];

						GCHandle dataMessage = GCHandle.Alloc(bytesMessage, GCHandleType.Pinned);
						Int32 resultCode2 = GetLastError(Handle, sizeMessage, out neededMessage, dataMessage.AddrOfPinnedObject(), out hasLastError);
						dataMessage.Free();

						if ((resultCode2 == 0) && (hasLastError != 0)) {
							sMessage = sMessage + ": " + Encoding.UTF8.GetString(bytesMessage).TrimEnd(char.MinValue);
						}
					}
				}

				throw new ELib3MFException(errorCode, sMessage);
			}

			/**
			 * IMPORTANT: PolymorphicFactory method should not be used by application directly.
			 *            It's designed to be used on Handle object only once.
			 *            If it's used on any existing object as a form of dynamic cast then
			 *            Lib3MFWrapper::AcquireInstance(CBase object) must be called after instantiating new object.
			 *            This is important to keep reference count matching between application and library sides.
			*/
			public static T PolymorphicFactory<T>(IntPtr Handle) where T : class
			{
				T Object;
				if (Handle == IntPtr.Zero)
					return System.Activator.CreateInstance(typeof(T), Handle) as T;
				
				UInt64 resultClassTypeId = 0;
				Int32 errorCode = Base_ClassTypeId (Handle, out resultClassTypeId);
				if (errorCode != 0)
					ThrowError (IntPtr.Zero, errorCode);
				switch (resultClassTypeId) {
					case 0x856632D0BAF1D8B7: Object = new CBase(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Base"
					case 0xE76F642F363FD7E9: Object = new CWriter(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
					case 0x2D86831DA59FBE72: Object = new CReader(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
					case 0x0E55A826D377483E: Object = new CPackagePart(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
					case 0xDFE3889D1B269CBB: Object = new CResource(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
					case 0x460F3515E2621DBE: Object = new CResourceIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
					case 0x69684DB99FA813F6: Object = new CSliceStackIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
					case 0xDE92510BD2112288: Object = new CObjectIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
					case 0xF4196034E2B9FDE6: Object = new CMeshObjectIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
					case 0x564DE4217ED7614A: Object = new CComponentsObjectIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
					case 0x4BD32B4870FFC03B: Object = new CTexture2DIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
					case 0x65E6EDD9362C79CB: Object = new CBaseMaterialGroupIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
					case 0x10274A1757C729C0: Object = new CColorGroupIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
					case 0x30D55F4DB88FE0CA: Object = new CTexture2DGroupIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
					case 0xA99CC6C3F70FB6F9: Object = new CCompositeMaterialsIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
					case 0xC2BDF5D8CBBDB1F0: Object = new CMultiPropertyGroupIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
					case 0xC4B8EC00A82BF336: Object = new CImage3DIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3DIterator"
					case 0x40E9035363ACE65E: Object = new CFunctionIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionIterator"
					case 0xA0C005C035D5371D: Object = new CLevelSetIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSetIterator"
					case 0xD17716D063DE2C22: Object = new CMetaData(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
					case 0x0C3B85369E9B25D3: Object = new CMetaDataGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
					case 0x5950BB3EE8A82090: Object = new CTriangleSet(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::TriangleSet"
					case 0x2DA2136F577A779C: Object = new CObject(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
					case 0x3B3A6DC6EC610497: Object = new CMeshObject(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
					case 0xE8A7D9C192EFD0E2: Object = new CLevelSet(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSet"
					case 0x63B3B461B30B4BA5: Object = new CBeamLattice(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
					case 0x4DF17E76926221C2: Object = new CFunctionReference(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionReference"
					case 0xD85B5B6143E787E3: Object = new CVolumeDataColor(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataColor"
					case 0x241FE6B4817C3FE4: Object = new CMaterialMapping(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MaterialMapping"
					case 0x46F1DAC40581B304: Object = new CVolumeDataComposite(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataComposite"
					case 0xFC368AA44ACE42DA: Object = new CVolumeDataProperty(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataProperty"
					case 0x9200586FB91587A7: Object = new CVolumeData(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeData"
					case 0x4ECDB6A6F69F2BEB: Object = new CComponent(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
					case 0x6522CF04EB283FED: Object = new CComponentsObject(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
					case 0x30CCDBE90E00B55B: Object = new CBeamSet(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
					case 0xB27D4656E16609FA: Object = new CBaseMaterialGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
					case 0xD085FB2E49CDB5B1: Object = new CColorGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
					case 0xBC1208397E37055D: Object = new CTexture2DGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
					case 0xCE16224D688B86F2: Object = new CCompositeMaterials(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
					case 0xB989E02E43158FE6: Object = new CMultiPropertyGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
					case 0xBD938FF2D2663D61: Object = new CImage3D(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3D"
					case 0x13A2561F0CFB712A: Object = new CImageStack(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ImageStack"
					case 0x8CE7A1191A63A35D: Object = new CAttachment(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
					case 0xE0441CF976B36319: Object = new CTexture2D(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
					case 0xD5C49B04AF1963CD: Object = new CImplicitPort(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPort"
					case 0x52F06268CD098EFE: Object = new CIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Iterator"
					case 0xC62268F2D7C7012C: Object = new CImplicitPortIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPortIterator"
					case 0xE72592A7725AB29B: Object = new CImplicitNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitNode"
					case 0xB19B9FDA94B0A5E7: Object = new COneInputNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::OneInputNode"
					case 0xD5AEA50A56306722: Object = new CSinNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SinNode"
					case 0x59BC328F6FB5C5FF: Object = new CCosNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CosNode"
					case 0x2614CC572AF350B7: Object = new CTanNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::TanNode"
					case 0xE554C8A7E72AAF4D: Object = new CArcSinNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcSinNode"
					case 0x943AF6AE0EFD2B8A: Object = new CArcCosNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcCosNode"
					case 0xE47D547615816BAD: Object = new CArcTanNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTanNode"
					case 0x3C7756A456F2D089: Object = new CSinhNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SinhNode"
					case 0x4A993F91E1DE256D: Object = new CCoshNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CoshNode"
					case 0xCF077B19B0B78E9D: Object = new CTanhNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::TanhNode"
					case 0xD9F5A53C657765AE: Object = new CRoundNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::RoundNode"
					case 0x627E211653E11D93: Object = new CCeilNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CeilNode"
					case 0x392A0F4C041D249C: Object = new CFloorNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FloorNode"
					case 0x8A45165E6C9646D7: Object = new CSignNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SignNode"
					case 0x53E62FD67F4D9A65: Object = new CFractNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FractNode"
					case 0x6B641C7060040BE3: Object = new CAbsNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::AbsNode"
					case 0x3390243A8E2410F3: Object = new CExpNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ExpNode"
					case 0x0070021D73AA89FD: Object = new CLogNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::LogNode"
					case 0xE8C0ABF7C5DC7068: Object = new CLog2Node(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Log2Node"
					case 0x87740AD53454E0DF: Object = new CLog10Node(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Log10Node"
					case 0xD85889E2739A74B1: Object = new CLengthNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::LengthNode"
					case 0xA808B7599C158CE6: Object = new CTransposeNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::TransposeNode"
					case 0xE8601F66A23A0540: Object = new CInverseNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::InverseNode"
					case 0x9F831944A3DE31DA: Object = new CSqrtNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SqrtNode"
					case 0xCA86A77C71CD3FAE: Object = new CResourceIdNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIdNode"
					case 0x7DE3951BA4C1064C: Object = new CTwoInputNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::TwoInputNode"
					case 0x57A2236998DF5248: Object = new CAdditionNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::AdditionNode"
					case 0x6079B12FFF345D02: Object = new CSubtractionNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SubtractionNode"
					case 0xA3C27CF54C2AA76C: Object = new CMultiplicationNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiplicationNode"
					case 0xB896B6413C08CF39: Object = new CDivisionNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::DivisionNode"
					case 0xFE60932A66375FAD: Object = new CDotNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::DotNode"
					case 0x106182D38CA5CFE3: Object = new CCrossNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::CrossNode"
					case 0xB6153EF5DE7E5E11: Object = new CArcTan2Node(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTan2Node"
					case 0x7570C43B9721D0C0: Object = new CMatVecMultiplicationNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MatVecMultiplicationNode"
					case 0x846AFDE9A091E997: Object = new CMinNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MinNode"
					case 0x073F910381BF250D: Object = new CMaxNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MaxNode"
					case 0x1EF703D298223F2A: Object = new CFmodNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FmodNode"
					case 0xEA57335849379F22: Object = new CModNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ModNode"
					case 0x7700AA17CA1AC0F8: Object = new CPowNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::PowNode"
					case 0x1127ED71E05A9BD4: Object = new CSelectNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SelectNode"
					case 0x77AF68C971B1485F: Object = new CClampNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ClampNode"
					case 0x49C24B8840C01F7E: Object = new CComposeVectorNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeVectorNode"
					case 0x2E417B93351375E2: Object = new CVectorFromScalarNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::VectorFromScalarNode"
					case 0xCC4F8D561CCE35D4: Object = new CDecomposeVectorNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::DecomposeVectorNode"
					case 0x9EF9EB54A53AA40D: Object = new CComposeMatrixNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeMatrixNode"
					case 0xD6DFD0A7EB64AC33: Object = new CMatrixFromRowsNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromRowsNode"
					case 0x0DCBEAFCF83F3AAC: Object = new CMatrixFromColumnsNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromColumnsNode"
					case 0x3F8E5D082F966B1B: Object = new CConstantNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstantNode"
					case 0x9C9363B3F708D556: Object = new CConstVecNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstVecNode"
					case 0xF85C90EDCE6F90A4: Object = new CConstMatNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstMatNode"
					case 0x53601FD432E3DEF4: Object = new CMeshNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshNode"
					case 0x29985A628251A9CD: Object = new CUnsignedMeshNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::UnsignedMeshNode"
					case 0x0F3A4EE98F7FEC0C: Object = new CBeamLatticeNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLatticeNode"
					case 0x0437E27AEF740121: Object = new CFunctionGradientNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionGradientNode"
					case 0x817D2E566E73AA8F: Object = new CNormalizeDistanceNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::NormalizeDistanceNode"
					case 0x0765C17C952F24E3: Object = new CFunctionCallNode(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionCallNode"
					case 0xFC006BC888CAB4D0: Object = new CNodeIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::NodeIterator"
					case 0x9EFB2757CA1A5231: Object = new CFunction(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Function"
					case 0x6CE54469EEA83BC1: Object = new CImplicitFunction(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitFunction"
					case 0x9BD7D3C2026B8CE8: Object = new CFunctionFromImage3D(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionFromImage3D"
					case 0x68FB2D5FFC4BA12A: Object = new CBuildItem(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
					case 0xA7D21BD364910860: Object = new CBuildItemIterator(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
					case 0x2198BCF4D8DF9C40: Object = new CSlice(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
					case 0x6594B031B6096238: Object = new CSliceStack(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
					case 0xD9E46D5E6D8118EE: Object = new CConsumer(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
					case 0x385C42FC5609498A: Object = new CAccessRight(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
					case 0x7FB36B91D4CE4671: Object = new CContentEncryptionParams(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
					case 0x1A47A5E258E22EF9: Object = new CResourceData(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
					case 0xD59067227E428AA4: Object = new CResourceDataGroup(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
					case 0x1CC9E0CC082253C6: Object = new CKeyStore(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
					case 0x5A8164ECEDB03F09: Object = new CModel(Handle) as T; break; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
					default: Object = System.Activator.CreateInstance(typeof(T), Handle) as T; break;
				}
				return Object;
			}

		}
	}


	public class CBase : IDisposable
	{
		protected IntPtr Handle;

		public CBase (IntPtr NewHandle)
		{
			Handle = NewHandle;
		}

		protected virtual void Dispose(bool disposing)
		{
			if (disposing)
			{
				// dispose managed state (managed objects).
			}
			if (Handle != IntPtr.Zero) {
				Internal.Lib3MFWrapper.Release (Handle);
				Handle = IntPtr.Zero;
			}
		}

		public void Dispose()
		{
			// Dispose of unmanaged resources.
			Dispose(true);
			// Suppress finalization.
			GC.SuppressFinalize(this);
		}

		~CBase () => Dispose(false);

		protected void CheckError (Int32 errorCode)
		{
			if (errorCode != 0) {
				Internal.Lib3MFWrapper.ThrowError (Handle, errorCode);
			}
		}

		public IntPtr GetHandle ()
		{
			return Handle;
		}

		public UInt64 ClassTypeId ()
		{
			UInt64 resultClassTypeId = 0;

			CheckError(Internal.Lib3MFWrapper.Base_ClassTypeId (Handle, out resultClassTypeId));
			return resultClassTypeId;
		}

	}

	public class CWriter : CBase
	{
		public CWriter (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void WriteToFile (String AFilename)
		{
			byte[] byteFilename = Encoding.UTF8.GetBytes(AFilename + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Writer_WriteToFile (Handle, byteFilename));
		}

		public UInt64 GetStreamSize ()
		{
			UInt64 resultStreamSize = 0;

			CheckError(Internal.Lib3MFWrapper.Writer_GetStreamSize (Handle, out resultStreamSize));
			return resultStreamSize;
		}

		public void WriteToBuffer (out Byte[] ABuffer)
		{
			UInt64 sizeBuffer = 0;
			UInt64 neededBuffer = 0;
			CheckError(Internal.Lib3MFWrapper.Writer_WriteToBuffer (Handle, sizeBuffer, out neededBuffer, IntPtr.Zero));
			sizeBuffer = neededBuffer;
			ABuffer = new Byte[sizeBuffer];
			GCHandle dataBuffer = GCHandle.Alloc(ABuffer, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Writer_WriteToBuffer (Handle, sizeBuffer, out neededBuffer, dataBuffer.AddrOfPinnedObject()));
			dataBuffer.Free();
		}

		public void WriteToCallback (IntPtr ATheWriteCallback, IntPtr ATheSeekCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Writer_WriteToCallback (Handle, ATheWriteCallback, ATheSeekCallback, AUserData));
		}

		public void SetProgressCallback (IntPtr AProgressCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Writer_SetProgressCallback (Handle, AProgressCallback, AUserData));
		}

		public UInt32 GetDecimalPrecision ()
		{
			UInt32 resultDecimalPrecision = 0;

			CheckError(Internal.Lib3MFWrapper.Writer_GetDecimalPrecision (Handle, out resultDecimalPrecision));
			return resultDecimalPrecision;
		}

		public void SetDecimalPrecision (UInt32 ADecimalPrecision)
		{

			CheckError(Internal.Lib3MFWrapper.Writer_SetDecimalPrecision (Handle, ADecimalPrecision));
		}

		public void SetStrictModeActive (bool AStrictModeActive)
		{

			CheckError(Internal.Lib3MFWrapper.Writer_SetStrictModeActive (Handle, (Byte)( AStrictModeActive ? 1 : 0 )));
		}

		public bool GetStrictModeActive ()
		{
			Byte resultStrictModeActive = 0;

			CheckError(Internal.Lib3MFWrapper.Writer_GetStrictModeActive (Handle, out resultStrictModeActive));
			return (resultStrictModeActive != 0);
		}

		public String GetWarning (UInt32 AIndex, out UInt32 AErrorCode)
		{
			UInt32 sizeWarning = 0;
			UInt32 neededWarning = 0;
			CheckError(Internal.Lib3MFWrapper.Writer_GetWarning (Handle, AIndex, out AErrorCode, sizeWarning, out neededWarning, IntPtr.Zero));
			sizeWarning = neededWarning;
			byte[] bytesWarning = new byte[sizeWarning];
			GCHandle dataWarning = GCHandle.Alloc(bytesWarning, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Writer_GetWarning (Handle, AIndex, out AErrorCode, sizeWarning, out neededWarning, dataWarning.AddrOfPinnedObject()));
			dataWarning.Free();
			return Encoding.UTF8.GetString(bytesWarning).TrimEnd(char.MinValue);
		}

		public UInt32 GetWarningCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Writer_GetWarningCount (Handle, out resultCount));
			return resultCount;
		}

		public void AddKeyWrappingCallback (String AConsumerID, IntPtr ATheCallback, UInt64 AUserData)
		{
			byte[] byteConsumerID = Encoding.UTF8.GetBytes(AConsumerID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Writer_AddKeyWrappingCallback (Handle, byteConsumerID, ATheCallback, AUserData));
		}

		public void SetContentEncryptionCallback (IntPtr ATheCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Writer_SetContentEncryptionCallback (Handle, ATheCallback, AUserData));
		}

	}

	public class CReader : CBase
	{
		public CReader (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void ReadFromFile (String AFilename)
		{
			byte[] byteFilename = Encoding.UTF8.GetBytes(AFilename + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Reader_ReadFromFile (Handle, byteFilename));
		}

		public void ReadFromBuffer (Byte[] ABuffer)
		{
			GCHandle dataBuffer = GCHandle.Alloc(ABuffer, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Reader_ReadFromBuffer (Handle, (UInt64) ABuffer.Length, dataBuffer.AddrOfPinnedObject()));
			dataBuffer.Free ();
		}

		public void ReadFromCallback (IntPtr ATheReadCallback, UInt64 AStreamSize, IntPtr ATheSeekCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Reader_ReadFromCallback (Handle, ATheReadCallback, AStreamSize, ATheSeekCallback, AUserData));
		}

		public void SetProgressCallback (IntPtr AProgressCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Reader_SetProgressCallback (Handle, AProgressCallback, AUserData));
		}

		public void AddRelationToRead (String ARelationShipType)
		{
			byte[] byteRelationShipType = Encoding.UTF8.GetBytes(ARelationShipType + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Reader_AddRelationToRead (Handle, byteRelationShipType));
		}

		public void RemoveRelationToRead (String ARelationShipType)
		{
			byte[] byteRelationShipType = Encoding.UTF8.GetBytes(ARelationShipType + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Reader_RemoveRelationToRead (Handle, byteRelationShipType));
		}

		public void SetStrictModeActive (bool AStrictModeActive)
		{

			CheckError(Internal.Lib3MFWrapper.Reader_SetStrictModeActive (Handle, (Byte)( AStrictModeActive ? 1 : 0 )));
		}

		public bool GetStrictModeActive ()
		{
			Byte resultStrictModeActive = 0;

			CheckError(Internal.Lib3MFWrapper.Reader_GetStrictModeActive (Handle, out resultStrictModeActive));
			return (resultStrictModeActive != 0);
		}

		public String GetWarning (UInt32 AIndex, out UInt32 AErrorCode)
		{
			UInt32 sizeWarning = 0;
			UInt32 neededWarning = 0;
			CheckError(Internal.Lib3MFWrapper.Reader_GetWarning (Handle, AIndex, out AErrorCode, sizeWarning, out neededWarning, IntPtr.Zero));
			sizeWarning = neededWarning;
			byte[] bytesWarning = new byte[sizeWarning];
			GCHandle dataWarning = GCHandle.Alloc(bytesWarning, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Reader_GetWarning (Handle, AIndex, out AErrorCode, sizeWarning, out neededWarning, dataWarning.AddrOfPinnedObject()));
			dataWarning.Free();
			return Encoding.UTF8.GetString(bytesWarning).TrimEnd(char.MinValue);
		}

		public UInt32 GetWarningCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Reader_GetWarningCount (Handle, out resultCount));
			return resultCount;
		}

		public void AddKeyWrappingCallback (String AConsumerID, IntPtr ATheCallback, UInt64 AUserData)
		{
			byte[] byteConsumerID = Encoding.UTF8.GetBytes(AConsumerID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Reader_AddKeyWrappingCallback (Handle, byteConsumerID, ATheCallback, AUserData));
		}

		public void SetContentEncryptionCallback (IntPtr ATheCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Reader_SetContentEncryptionCallback (Handle, ATheCallback, AUserData));
		}

	}

	public class CPackagePart : CBase
	{
		public CPackagePart (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetPath ()
		{
			UInt32 sizePath = 0;
			UInt32 neededPath = 0;
			CheckError(Internal.Lib3MFWrapper.PackagePart_GetPath (Handle, sizePath, out neededPath, IntPtr.Zero));
			sizePath = neededPath;
			byte[] bytesPath = new byte[sizePath];
			GCHandle dataPath = GCHandle.Alloc(bytesPath, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.PackagePart_GetPath (Handle, sizePath, out neededPath, dataPath.AddrOfPinnedObject()));
			dataPath.Free();
			return Encoding.UTF8.GetString(bytesPath).TrimEnd(char.MinValue);
		}

		public void SetPath (String APath)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.PackagePart_SetPath (Handle, bytePath));
		}

	}

	public class CResource : CBase
	{
		public CResource (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetResourceID ()
		{
			UInt32 resultUniqueResourceID = 0;

			CheckError(Internal.Lib3MFWrapper.Resource_GetResourceID (Handle, out resultUniqueResourceID));
			return resultUniqueResourceID;
		}

		public UInt32 GetUniqueResourceID ()
		{
			UInt32 resultUniqueResourceID = 0;

			CheckError(Internal.Lib3MFWrapper.Resource_GetUniqueResourceID (Handle, out resultUniqueResourceID));
			return resultUniqueResourceID;
		}

		public CPackagePart PackagePart ()
		{
			IntPtr newPackagePart = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Resource_PackagePart (Handle, out newPackagePart));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPackagePart>(newPackagePart);
		}

		public void SetPackagePart (CPackagePart APackagePart)
		{
			IntPtr APackagePartHandle = IntPtr.Zero;
			if (APackagePart != null)
				APackagePartHandle = APackagePart.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Resource_SetPackagePart (Handle, APackagePartHandle));
		}

		public UInt32 GetModelResourceID ()
		{
			UInt32 resultModelResourceId = 0;

			CheckError(Internal.Lib3MFWrapper.Resource_GetModelResourceID (Handle, out resultModelResourceId));
			return resultModelResourceId;
		}

	}

	public class CResourceIterator : CBase
	{
		public CResourceIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public bool MoveNext ()
		{
			Byte resultHasNext = 0;

			CheckError(Internal.Lib3MFWrapper.ResourceIterator_MoveNext (Handle, out resultHasNext));
			return (resultHasNext != 0);
		}

		public bool MovePrevious ()
		{
			Byte resultHasPrevious = 0;

			CheckError(Internal.Lib3MFWrapper.ResourceIterator_MovePrevious (Handle, out resultHasPrevious));
			return (resultHasPrevious != 0);
		}

		public CResource GetCurrent ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceIterator_GetCurrent (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResource>(newResource);
		}

		public CResourceIterator Clone ()
		{
			IntPtr newOutResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceIterator_Clone (Handle, out newOutResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceIterator>(newOutResourceIterator);
		}

		public UInt64 Count ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.ResourceIterator_Count (Handle, out resultCount));
			return resultCount;
		}

	}

	public class CSliceStackIterator : CResourceIterator
	{
		public CSliceStackIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CSliceStack GetCurrentSliceStack ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SliceStackIterator_GetCurrentSliceStack (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStack>(newResource);
		}

	}

	public class CObjectIterator : CResourceIterator
	{
		public CObjectIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CObject GetCurrentObject ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ObjectIterator_GetCurrentObject (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CObject>(newResource);
		}

	}

	public class CMeshObjectIterator : CResourceIterator
	{
		public CMeshObjectIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CMeshObject GetCurrentMeshObject ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObjectIterator_GetCurrentMeshObject (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshObject>(newResource);
		}

	}

	public class CComponentsObjectIterator : CResourceIterator
	{
		public CComponentsObjectIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CComponentsObject GetCurrentComponentsObject ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComponentsObjectIterator_GetCurrentComponentsObject (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponentsObject>(newResource);
		}

	}

	public class CTexture2DIterator : CResourceIterator
	{
		public CTexture2DIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CTexture2D GetCurrentTexture2D ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Texture2DIterator_GetCurrentTexture2D (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2D>(newResource);
		}

	}

	public class CBaseMaterialGroupIterator : CResourceIterator
	{
		public CBaseMaterialGroupIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CBaseMaterialGroup GetCurrentBaseMaterialGroup ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroup>(newResource);
		}

	}

	public class CColorGroupIterator : CResourceIterator
	{
		public CColorGroupIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CColorGroup GetCurrentColorGroup ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ColorGroupIterator_GetCurrentColorGroup (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CColorGroup>(newResource);
		}

	}

	public class CTexture2DGroupIterator : CResourceIterator
	{
		public CTexture2DGroupIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CTexture2DGroup GetCurrentTexture2DGroup ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Texture2DGroupIterator_GetCurrentTexture2DGroup (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2DGroup>(newResource);
		}

	}

	public class CCompositeMaterialsIterator : CResourceIterator
	{
		public CCompositeMaterialsIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CCompositeMaterials GetCurrentCompositeMaterials ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.CompositeMaterialsIterator_GetCurrentCompositeMaterials (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCompositeMaterials>(newResource);
		}

	}

	public class CMultiPropertyGroupIterator : CResourceIterator
	{
		public CMultiPropertyGroupIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CMultiPropertyGroup GetCurrentMultiPropertyGroup ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMultiPropertyGroup>(newResource);
		}

	}

	public class CImage3DIterator : CResourceIterator
	{
		public CImage3DIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImage3D GetCurrentImage3D ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Image3DIterator_GetCurrentImage3D (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImage3D>(newResource);
		}

	}

	public class CFunctionIterator : CResourceIterator
	{
		public CFunctionIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CFunction GetCurrentFunction ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionIterator_GetCurrentFunction (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunction>(newResource);
		}

	}

	public class CLevelSetIterator : CResourceIterator
	{
		public CLevelSetIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CLevelSet GetCurrentLevelSet ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.LevelSetIterator_GetCurrentLevelSet (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLevelSet>(newResource);
		}

	}

	public class CMetaData : CBase
	{
		public CMetaData (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetNameSpace ()
		{
			UInt32 sizeNameSpace = 0;
			UInt32 neededNameSpace = 0;
			CheckError(Internal.Lib3MFWrapper.MetaData_GetNameSpace (Handle, sizeNameSpace, out neededNameSpace, IntPtr.Zero));
			sizeNameSpace = neededNameSpace;
			byte[] bytesNameSpace = new byte[sizeNameSpace];
			GCHandle dataNameSpace = GCHandle.Alloc(bytesNameSpace, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MetaData_GetNameSpace (Handle, sizeNameSpace, out neededNameSpace, dataNameSpace.AddrOfPinnedObject()));
			dataNameSpace.Free();
			return Encoding.UTF8.GetString(bytesNameSpace).TrimEnd(char.MinValue);
		}

		public void SetNameSpace (String ANameSpace)
		{
			byte[] byteNameSpace = Encoding.UTF8.GetBytes(ANameSpace + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.MetaData_SetNameSpace (Handle, byteNameSpace));
		}

		public String GetName ()
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.MetaData_GetName (Handle, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MetaData_GetName (Handle, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetName (String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.MetaData_SetName (Handle, byteName));
		}

		public String GetKey ()
		{
			UInt32 sizeKey = 0;
			UInt32 neededKey = 0;
			CheckError(Internal.Lib3MFWrapper.MetaData_GetKey (Handle, sizeKey, out neededKey, IntPtr.Zero));
			sizeKey = neededKey;
			byte[] bytesKey = new byte[sizeKey];
			GCHandle dataKey = GCHandle.Alloc(bytesKey, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MetaData_GetKey (Handle, sizeKey, out neededKey, dataKey.AddrOfPinnedObject()));
			dataKey.Free();
			return Encoding.UTF8.GetString(bytesKey).TrimEnd(char.MinValue);
		}

		public bool GetMustPreserve ()
		{
			Byte resultMustPreserve = 0;

			CheckError(Internal.Lib3MFWrapper.MetaData_GetMustPreserve (Handle, out resultMustPreserve));
			return (resultMustPreserve != 0);
		}

		public void SetMustPreserve (bool AMustPreserve)
		{

			CheckError(Internal.Lib3MFWrapper.MetaData_SetMustPreserve (Handle, (Byte)( AMustPreserve ? 1 : 0 )));
		}

		public String GetType ()
		{
			UInt32 sizeType = 0;
			UInt32 neededType = 0;
			CheckError(Internal.Lib3MFWrapper.MetaData_GetType (Handle, sizeType, out neededType, IntPtr.Zero));
			sizeType = neededType;
			byte[] bytesType = new byte[sizeType];
			GCHandle dataType = GCHandle.Alloc(bytesType, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MetaData_GetType (Handle, sizeType, out neededType, dataType.AddrOfPinnedObject()));
			dataType.Free();
			return Encoding.UTF8.GetString(bytesType).TrimEnd(char.MinValue);
		}

		public void SetType (String AType)
		{
			byte[] byteType = Encoding.UTF8.GetBytes(AType + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.MetaData_SetType (Handle, byteType));
		}

		public String GetValue ()
		{
			UInt32 sizeValue = 0;
			UInt32 neededValue = 0;
			CheckError(Internal.Lib3MFWrapper.MetaData_GetValue (Handle, sizeValue, out neededValue, IntPtr.Zero));
			sizeValue = neededValue;
			byte[] bytesValue = new byte[sizeValue];
			GCHandle dataValue = GCHandle.Alloc(bytesValue, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MetaData_GetValue (Handle, sizeValue, out neededValue, dataValue.AddrOfPinnedObject()));
			dataValue.Free();
			return Encoding.UTF8.GetString(bytesValue).TrimEnd(char.MinValue);
		}

		public void SetValue (String AValue)
		{
			byte[] byteValue = Encoding.UTF8.GetBytes(AValue + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.MetaData_SetValue (Handle, byteValue));
		}

	}

	public class CMetaDataGroup : CBase
	{
		public CMetaDataGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetMetaDataCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_GetMetaDataCount (Handle, out resultCount));
			return resultCount;
		}

		public CMetaData GetMetaData (UInt32 AIndex)
		{
			IntPtr newMetaData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_GetMetaData (Handle, AIndex, out newMetaData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaData>(newMetaData);
		}

		public CMetaData GetMetaDataByKey (String ANameSpace, String AName)
		{
			byte[] byteNameSpace = Encoding.UTF8.GetBytes(ANameSpace + char.MinValue);
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);
			IntPtr newMetaData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_GetMetaDataByKey (Handle, byteNameSpace, byteName, out newMetaData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaData>(newMetaData);
		}

		public void RemoveMetaDataByIndex (UInt32 AIndex)
		{

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_RemoveMetaDataByIndex (Handle, AIndex));
		}

		public void RemoveMetaData (CMetaData ATheMetaData)
		{
			IntPtr ATheMetaDataHandle = IntPtr.Zero;
			if (ATheMetaData != null)
				ATheMetaDataHandle = ATheMetaData.GetHandle();

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_RemoveMetaData (Handle, ATheMetaDataHandle));
		}

		public CMetaData AddMetaData (String ANameSpace, String AName, String AValue, String AType, bool AMustPreserve)
		{
			byte[] byteNameSpace = Encoding.UTF8.GetBytes(ANameSpace + char.MinValue);
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);
			byte[] byteValue = Encoding.UTF8.GetBytes(AValue + char.MinValue);
			byte[] byteType = Encoding.UTF8.GetBytes(AType + char.MinValue);
			IntPtr newMetaData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MetaDataGroup_AddMetaData (Handle, byteNameSpace, byteName, byteValue, byteType, (Byte)( AMustPreserve ? 1 : 0 ), out newMetaData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaData>(newMetaData);
		}

	}

	public class CTriangleSet : CBase
	{
		public CTriangleSet (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetName (String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_SetName (Handle, byteName));
		}

		public String GetName ()
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetName (Handle, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetName (Handle, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetIdentifier (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_SetIdentifier (Handle, byteIdentifier));
		}

		public String GetIdentifier ()
		{
			UInt32 sizeIdentifier = 0;
			UInt32 neededIdentifier = 0;
			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, IntPtr.Zero));
			sizeIdentifier = neededIdentifier;
			byte[] bytesIdentifier = new byte[sizeIdentifier];
			GCHandle dataIdentifier = GCHandle.Alloc(bytesIdentifier, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, dataIdentifier.AddrOfPinnedObject()));
			dataIdentifier.Free();
			return Encoding.UTF8.GetString(bytesIdentifier).TrimEnd(char.MinValue);
		}

		public void AddTriangle (UInt32 ATriangleIndex)
		{

			CheckError(Internal.Lib3MFWrapper.TriangleSet_AddTriangle (Handle, ATriangleIndex));
		}

		public void RemoveTriangle (UInt32 ATriangleIndex)
		{

			CheckError(Internal.Lib3MFWrapper.TriangleSet_RemoveTriangle (Handle, ATriangleIndex));
		}

		public void Clear ()
		{

			CheckError(Internal.Lib3MFWrapper.TriangleSet_Clear (Handle));
		}

		public void SetTriangleList (UInt32[] ATriangleIndices)
		{
			GCHandle dataTriangleIndices = GCHandle.Alloc(ATriangleIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_SetTriangleList (Handle, (UInt64) ATriangleIndices.Length, dataTriangleIndices.AddrOfPinnedObject()));
			dataTriangleIndices.Free ();
		}

		public void GetTriangleList (out UInt32[] ATriangleIndices)
		{
			UInt64 sizeTriangleIndices = 0;
			UInt64 neededTriangleIndices = 0;
			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetTriangleList (Handle, sizeTriangleIndices, out neededTriangleIndices, IntPtr.Zero));
			sizeTriangleIndices = neededTriangleIndices;
			ATriangleIndices = new UInt32[sizeTriangleIndices];
			GCHandle dataTriangleIndices = GCHandle.Alloc(ATriangleIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_GetTriangleList (Handle, sizeTriangleIndices, out neededTriangleIndices, dataTriangleIndices.AddrOfPinnedObject()));
			dataTriangleIndices.Free();
		}

		public void AddTriangleList (UInt32[] ATriangleIndices)
		{
			GCHandle dataTriangleIndices = GCHandle.Alloc(ATriangleIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.TriangleSet_AddTriangleList (Handle, (UInt64) ATriangleIndices.Length, dataTriangleIndices.AddrOfPinnedObject()));
			dataTriangleIndices.Free ();
		}

		public void Merge (CTriangleSet AOtherTriangleSet, bool ADeleteOther)
		{
			IntPtr AOtherTriangleSetHandle = IntPtr.Zero;
			if (AOtherTriangleSet != null)
				AOtherTriangleSetHandle = AOtherTriangleSet.GetHandle();

			CheckError(Internal.Lib3MFWrapper.TriangleSet_Merge (Handle, AOtherTriangleSetHandle, (Byte)( ADeleteOther ? 1 : 0 )));
		}

		public void DeleteSet ()
		{

			CheckError(Internal.Lib3MFWrapper.TriangleSet_DeleteSet (Handle));
		}

		public CTriangleSet Duplicate (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newNewSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.TriangleSet_Duplicate (Handle, byteIdentifier, out newNewSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTriangleSet>(newNewSet);
		}

	}

	public class CObject : CResource
	{
		public CObject (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public eObjectType GetType ()
		{
			Int32 resultObjectType = 0;

			CheckError(Internal.Lib3MFWrapper.Object_GetType (Handle, out resultObjectType));
			return (eObjectType) (resultObjectType);
		}

		public void SetType (eObjectType AObjectType)
		{
			Int32 enumObjectType = (Int32) AObjectType;

			CheckError(Internal.Lib3MFWrapper.Object_SetType (Handle, enumObjectType));
		}

		public String GetName ()
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.Object_GetName (Handle, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Object_GetName (Handle, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetName (String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Object_SetName (Handle, byteName));
		}

		public String GetPartNumber ()
		{
			UInt32 sizePartNumber = 0;
			UInt32 neededPartNumber = 0;
			CheckError(Internal.Lib3MFWrapper.Object_GetPartNumber (Handle, sizePartNumber, out neededPartNumber, IntPtr.Zero));
			sizePartNumber = neededPartNumber;
			byte[] bytesPartNumber = new byte[sizePartNumber];
			GCHandle dataPartNumber = GCHandle.Alloc(bytesPartNumber, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Object_GetPartNumber (Handle, sizePartNumber, out neededPartNumber, dataPartNumber.AddrOfPinnedObject()));
			dataPartNumber.Free();
			return Encoding.UTF8.GetString(bytesPartNumber).TrimEnd(char.MinValue);
		}

		public void SetPartNumber (String APartNumber)
		{
			byte[] bytePartNumber = Encoding.UTF8.GetBytes(APartNumber + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Object_SetPartNumber (Handle, bytePartNumber));
		}

		public bool IsMeshObject ()
		{
			Byte resultIsMeshObject = 0;

			CheckError(Internal.Lib3MFWrapper.Object_IsMeshObject (Handle, out resultIsMeshObject));
			return (resultIsMeshObject != 0);
		}

		public bool IsComponentsObject ()
		{
			Byte resultIsComponentsObject = 0;

			CheckError(Internal.Lib3MFWrapper.Object_IsComponentsObject (Handle, out resultIsComponentsObject));
			return (resultIsComponentsObject != 0);
		}

		public bool IsLevelSetObject ()
		{
			Byte resultIsLevelSetObject = 0;

			CheckError(Internal.Lib3MFWrapper.Object_IsLevelSetObject (Handle, out resultIsLevelSetObject));
			return (resultIsLevelSetObject != 0);
		}

		public bool IsValid ()
		{
			Byte resultIsValid = 0;

			CheckError(Internal.Lib3MFWrapper.Object_IsValid (Handle, out resultIsValid));
			return (resultIsValid != 0);
		}

		public void SetAttachmentAsThumbnail (CAttachment AAttachment)
		{
			IntPtr AAttachmentHandle = IntPtr.Zero;
			if (AAttachment != null)
				AAttachmentHandle = AAttachment.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Object_SetAttachmentAsThumbnail (Handle, AAttachmentHandle));
		}

		public CAttachment GetThumbnailAttachment ()
		{
			IntPtr newAttachment = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Object_GetThumbnailAttachment (Handle, out newAttachment));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachment);
		}

		public void ClearThumbnailAttachment ()
		{

			CheckError(Internal.Lib3MFWrapper.Object_ClearThumbnailAttachment (Handle));
		}

		public sBox GetOutbox ()
		{
			Internal.InternalBox intresultOutbox;

			CheckError(Internal.Lib3MFWrapper.Object_GetOutbox (Handle, out intresultOutbox));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Box (intresultOutbox);
		}

		public String GetUUID (out bool AHasUUID)
		{
			Byte resultHasUUID = 0;
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.Object_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Object_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			AHasUUID = (resultHasUUID != 0);
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public void SetUUID (String AUUID)
		{
			byte[] byteUUID = Encoding.UTF8.GetBytes(AUUID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Object_SetUUID (Handle, byteUUID));
		}

		public CMetaDataGroup GetMetaDataGroup ()
		{
			IntPtr newMetaDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Object_GetMetaDataGroup (Handle, out newMetaDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaDataGroup>(newMetaDataGroup);
		}

		public void SetSlicesMeshResolution (eSlicesMeshResolution AMeshResolution)
		{
			Int32 enumMeshResolution = (Int32) AMeshResolution;

			CheckError(Internal.Lib3MFWrapper.Object_SetSlicesMeshResolution (Handle, enumMeshResolution));
		}

		public eSlicesMeshResolution GetSlicesMeshResolution ()
		{
			Int32 resultMeshResolution = 0;

			CheckError(Internal.Lib3MFWrapper.Object_GetSlicesMeshResolution (Handle, out resultMeshResolution));
			return (eSlicesMeshResolution) (resultMeshResolution);
		}

		public bool HasSlices (bool ARecursive)
		{
			Byte resultHasSlices = 0;

			CheckError(Internal.Lib3MFWrapper.Object_HasSlices (Handle, (Byte)( ARecursive ? 1 : 0 ), out resultHasSlices));
			return (resultHasSlices != 0);
		}

		public void ClearSliceStack ()
		{

			CheckError(Internal.Lib3MFWrapper.Object_ClearSliceStack (Handle));
		}

		public CSliceStack GetSliceStack ()
		{
			IntPtr newSliceStackInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Object_GetSliceStack (Handle, out newSliceStackInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStack>(newSliceStackInstance);
		}

		public void AssignSliceStack (CSliceStack ASliceStackInstance)
		{
			IntPtr ASliceStackInstanceHandle = IntPtr.Zero;
			if (ASliceStackInstance != null)
				ASliceStackInstanceHandle = ASliceStackInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Object_AssignSliceStack (Handle, ASliceStackInstanceHandle));
		}

	}

	public class CMeshObject : CObject
	{
		public CMeshObject (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetVertexCount ()
		{
			UInt32 resultVertexCount = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetVertexCount (Handle, out resultVertexCount));
			return resultVertexCount;
		}

		public UInt32 GetTriangleCount ()
		{
			UInt32 resultVertexCount = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleCount (Handle, out resultVertexCount));
			return resultVertexCount;
		}

		public sPosition GetVertex (UInt32 AIndex)
		{
			Internal.InternalPosition intresultCoordinates;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetVertex (Handle, AIndex, out intresultCoordinates));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Position (intresultCoordinates);
		}

		public void SetVertex (UInt32 AIndex, sPosition ACoordinates)
		{
			Internal.InternalPosition intCoordinates = Internal.Lib3MFWrapper.convertStructToInternal_Position (ACoordinates);

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetVertex (Handle, AIndex, ref intCoordinates));
		}

		public UInt32 AddVertex (sPosition ACoordinates)
		{
			Internal.InternalPosition intCoordinates = Internal.Lib3MFWrapper.convertStructToInternal_Position (ACoordinates);
			UInt32 resultNewIndex = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_AddVertex (Handle, ref intCoordinates, out resultNewIndex));
			return resultNewIndex;
		}

		public void GetVertices (out sPosition[] AVertices)
		{
			UInt64 sizeVertices = 0;
			UInt64 neededVertices = 0;
			CheckError(Internal.Lib3MFWrapper.MeshObject_GetVertices (Handle, sizeVertices, out neededVertices, IntPtr.Zero));
			sizeVertices = neededVertices;
			var arrayVertices = new Internal.InternalPosition[sizeVertices];
			GCHandle dataVertices = GCHandle.Alloc(arrayVertices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetVertices (Handle, sizeVertices, out neededVertices, dataVertices.AddrOfPinnedObject()));
			dataVertices.Free();
			AVertices = new sPosition[sizeVertices];
			for (int index = 0; index < AVertices.Length; index++)
				AVertices[index] = Internal.Lib3MFWrapper.convertInternalToStruct_Position(arrayVertices[index]);
		}

		public sTriangle GetTriangle (UInt32 AIndex)
		{
			Internal.InternalTriangle intresultIndices;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangle (Handle, AIndex, out intresultIndices));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Triangle (intresultIndices);
		}

		public void SetTriangle (UInt32 AIndex, sTriangle AIndices)
		{
			Internal.InternalTriangle intIndices = Internal.Lib3MFWrapper.convertStructToInternal_Triangle (AIndices);

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetTriangle (Handle, AIndex, ref intIndices));
		}

		public UInt32 AddTriangle (sTriangle AIndices)
		{
			Internal.InternalTriangle intIndices = Internal.Lib3MFWrapper.convertStructToInternal_Triangle (AIndices);
			UInt32 resultNewIndex = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_AddTriangle (Handle, ref intIndices, out resultNewIndex));
			return resultNewIndex;
		}

		public void GetTriangleIndices (out sTriangle[] AIndices)
		{
			UInt64 sizeIndices = 0;
			UInt64 neededIndices = 0;
			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleIndices (Handle, sizeIndices, out neededIndices, IntPtr.Zero));
			sizeIndices = neededIndices;
			var arrayIndices = new Internal.InternalTriangle[sizeIndices];
			GCHandle dataIndices = GCHandle.Alloc(arrayIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleIndices (Handle, sizeIndices, out neededIndices, dataIndices.AddrOfPinnedObject()));
			dataIndices.Free();
			AIndices = new sTriangle[sizeIndices];
			for (int index = 0; index < AIndices.Length; index++)
				AIndices[index] = Internal.Lib3MFWrapper.convertInternalToStruct_Triangle(arrayIndices[index]);
		}

		public void SetObjectLevelProperty (UInt32 AUniqueResourceID, UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetObjectLevelProperty (Handle, AUniqueResourceID, APropertyID));
		}

		public bool GetObjectLevelProperty (out UInt32 AUniqueResourceID, out UInt32 APropertyID)
		{
			Byte resultHasObjectLevelProperty = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetObjectLevelProperty (Handle, out AUniqueResourceID, out APropertyID, out resultHasObjectLevelProperty));
			return (resultHasObjectLevelProperty != 0);
		}

		public void SetTriangleProperties (UInt32 AIndex, sTriangleProperties AProperties)
		{
			Internal.InternalTriangleProperties intProperties = Internal.Lib3MFWrapper.convertStructToInternal_TriangleProperties (AProperties);

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetTriangleProperties (Handle, AIndex, ref intProperties));
		}

		public void GetTriangleProperties (UInt32 AIndex, out sTriangleProperties AProperty)
		{
			Internal.InternalTriangleProperties intresultProperty;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleProperties (Handle, AIndex, out intresultProperty));
			AProperty = Internal.Lib3MFWrapper.convertInternalToStruct_TriangleProperties (intresultProperty);
		}

		public void SetAllTriangleProperties (sTriangleProperties[] APropertiesArray)
		{
			Internal.InternalTriangleProperties[] intdataPropertiesArray = new Internal.InternalTriangleProperties[APropertiesArray.Length];
			for (int index = 0; index < APropertiesArray.Length; index++)
				intdataPropertiesArray[index] = Internal.Lib3MFWrapper.convertStructToInternal_TriangleProperties(APropertiesArray[index]);
			GCHandle dataPropertiesArray = GCHandle.Alloc(intdataPropertiesArray, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetAllTriangleProperties (Handle, (UInt64) APropertiesArray.Length, dataPropertiesArray.AddrOfPinnedObject()));
			dataPropertiesArray.Free ();
		}

		public void GetAllTriangleProperties (out sTriangleProperties[] APropertiesArray)
		{
			UInt64 sizePropertiesArray = 0;
			UInt64 neededPropertiesArray = 0;
			CheckError(Internal.Lib3MFWrapper.MeshObject_GetAllTriangleProperties (Handle, sizePropertiesArray, out neededPropertiesArray, IntPtr.Zero));
			sizePropertiesArray = neededPropertiesArray;
			var arrayPropertiesArray = new Internal.InternalTriangleProperties[sizePropertiesArray];
			GCHandle dataPropertiesArray = GCHandle.Alloc(arrayPropertiesArray, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetAllTriangleProperties (Handle, sizePropertiesArray, out neededPropertiesArray, dataPropertiesArray.AddrOfPinnedObject()));
			dataPropertiesArray.Free();
			APropertiesArray = new sTriangleProperties[sizePropertiesArray];
			for (int index = 0; index < APropertiesArray.Length; index++)
				APropertiesArray[index] = Internal.Lib3MFWrapper.convertInternalToStruct_TriangleProperties(arrayPropertiesArray[index]);
		}

		public void ClearAllProperties ()
		{

			CheckError(Internal.Lib3MFWrapper.MeshObject_ClearAllProperties (Handle));
		}

		public void SetGeometry (sPosition[] AVertices, sTriangle[] AIndices)
		{
			Internal.InternalPosition[] intdataVertices = new Internal.InternalPosition[AVertices.Length];
			for (int index = 0; index < AVertices.Length; index++)
				intdataVertices[index] = Internal.Lib3MFWrapper.convertStructToInternal_Position(AVertices[index]);
			GCHandle dataVertices = GCHandle.Alloc(intdataVertices, GCHandleType.Pinned);
			Internal.InternalTriangle[] intdataIndices = new Internal.InternalTriangle[AIndices.Length];
			for (int index = 0; index < AIndices.Length; index++)
				intdataIndices[index] = Internal.Lib3MFWrapper.convertStructToInternal_Triangle(AIndices[index]);
			GCHandle dataIndices = GCHandle.Alloc(intdataIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetGeometry (Handle, (UInt64) AVertices.Length, dataVertices.AddrOfPinnedObject(), (UInt64) AIndices.Length, dataIndices.AddrOfPinnedObject()));
			dataVertices.Free ();
			dataIndices.Free ();
		}

		public bool IsManifoldAndOriented ()
		{
			Byte resultIsManifoldAndOriented = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_IsManifoldAndOriented (Handle, out resultIsManifoldAndOriented));
			return (resultIsManifoldAndOriented != 0);
		}

		public CBeamLattice BeamLattice ()
		{
			IntPtr newTheBeamLattice = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObject_BeamLattice (Handle, out newTheBeamLattice));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBeamLattice>(newTheBeamLattice);
		}

		public CVolumeData GetVolumeData ()
		{
			IntPtr newTheVolumeData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetVolumeData (Handle, out newTheVolumeData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeData>(newTheVolumeData);
		}

		public void SetVolumeData (CVolumeData ATheVolumeData)
		{
			IntPtr ATheVolumeDataHandle = IntPtr.Zero;
			if (ATheVolumeData != null)
				ATheVolumeDataHandle = ATheVolumeData.GetHandle();

			CheckError(Internal.Lib3MFWrapper.MeshObject_SetVolumeData (Handle, ATheVolumeDataHandle));
		}

		public CTriangleSet AddTriangleSet (String AIdentifier, String AName)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);
			IntPtr newTheTriangleSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObject_AddTriangleSet (Handle, byteIdentifier, byteName, out newTheTriangleSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTriangleSet>(newTheTriangleSet);
		}

		public bool HasTriangleSet (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Byte resultTriangleSetExists = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_HasTriangleSet (Handle, byteIdentifier, out resultTriangleSetExists));
			return (resultTriangleSetExists != 0);
		}

		public CTriangleSet FindTriangleSet (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newTheTriangleSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObject_FindTriangleSet (Handle, byteIdentifier, out newTheTriangleSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTriangleSet>(newTheTriangleSet);
		}

		public UInt32 GetTriangleSetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleSetCount (Handle, out resultCount));
			return resultCount;
		}

		public CTriangleSet GetTriangleSet (UInt32 AIndex)
		{
			IntPtr newTheTriangleSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshObject_GetTriangleSet (Handle, AIndex, out newTheTriangleSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTriangleSet>(newTheTriangleSet);
		}

	}

	public class CLevelSet : CObject
	{
		public CLevelSet (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CFunction GetFunction ()
		{
			IntPtr newTheFunction = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetFunction (Handle, out newTheFunction));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunction>(newTheFunction);
		}

		public void SetFunction (CFunction ATheFunction)
		{
			IntPtr ATheFunctionHandle = IntPtr.Zero;
			if (ATheFunction != null)
				ATheFunctionHandle = ATheFunction.GetHandle();

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetFunction (Handle, ATheFunctionHandle));
		}

		public sTransform GetTransform ()
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetTransform (Handle, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public void SetTransform (sTransform ATransform)
		{
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetTransform (Handle, ref intTransform));
		}

		public String GetChannelName ()
		{
			UInt32 sizeChannelName = 0;
			UInt32 neededChannelName = 0;
			CheckError(Internal.Lib3MFWrapper.LevelSet_GetChannelName (Handle, sizeChannelName, out neededChannelName, IntPtr.Zero));
			sizeChannelName = neededChannelName;
			byte[] bytesChannelName = new byte[sizeChannelName];
			GCHandle dataChannelName = GCHandle.Alloc(bytesChannelName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetChannelName (Handle, sizeChannelName, out neededChannelName, dataChannelName.AddrOfPinnedObject()));
			dataChannelName.Free();
			return Encoding.UTF8.GetString(bytesChannelName).TrimEnd(char.MinValue);
		}

		public void SetChannelName (String AChannelName)
		{
			byte[] byteChannelName = Encoding.UTF8.GetBytes(AChannelName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetChannelName (Handle, byteChannelName));
		}

		public void SetMinFeatureSize (Double AMinFeatureSize)
		{

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetMinFeatureSize (Handle, AMinFeatureSize));
		}

		public Double GetMinFeatureSize ()
		{
			Double resultMinFeatureSize = 0;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetMinFeatureSize (Handle, out resultMinFeatureSize));
			return resultMinFeatureSize;
		}

		public void SetFallBackValue (Double AFallBackValue)
		{

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetFallBackValue (Handle, AFallBackValue));
		}

		public Double GetFallBackValue ()
		{
			Double resultFallBackValue = 0;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetFallBackValue (Handle, out resultFallBackValue));
			return resultFallBackValue;
		}

		public void SetMeshBBoxOnly (bool AMeshBBoxOnly)
		{

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetMeshBBoxOnly (Handle, (Byte)( AMeshBBoxOnly ? 1 : 0 )));
		}

		public bool GetMeshBBoxOnly ()
		{
			Byte resultMeshBBoxOnly = 0;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetMeshBBoxOnly (Handle, out resultMeshBBoxOnly));
			return (resultMeshBBoxOnly != 0);
		}

		public void SetMesh (CMeshObject ATheMesh)
		{
			IntPtr ATheMeshHandle = IntPtr.Zero;
			if (ATheMesh != null)
				ATheMeshHandle = ATheMesh.GetHandle();

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetMesh (Handle, ATheMeshHandle));
		}

		public CMeshObject GetMesh ()
		{
			IntPtr newTheMesh = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetMesh (Handle, out newTheMesh));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshObject>(newTheMesh);
		}

		public CVolumeData GetVolumeData ()
		{
			IntPtr newTheVolumeData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.LevelSet_GetVolumeData (Handle, out newTheVolumeData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeData>(newTheVolumeData);
		}

		public void SetVolumeData (CVolumeData ATheVolumeData)
		{
			IntPtr ATheVolumeDataHandle = IntPtr.Zero;
			if (ATheVolumeData != null)
				ATheVolumeDataHandle = ATheVolumeData.GetHandle();

			CheckError(Internal.Lib3MFWrapper.LevelSet_SetVolumeData (Handle, ATheVolumeDataHandle));
		}

	}

	public class CBeamLattice : CBase
	{
		public CBeamLattice (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public Double GetMinLength ()
		{
			Double resultMinLength = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetMinLength (Handle, out resultMinLength));
			return resultMinLength;
		}

		public void SetMinLength (Double AMinLength)
		{

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetMinLength (Handle, AMinLength));
		}

		public void GetClipping (out eBeamLatticeClipMode AClipMode, out UInt32 AUniqueResourceID)
		{
			Int32 resultClipMode = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetClipping (Handle, out resultClipMode, out AUniqueResourceID));
			AClipMode = (eBeamLatticeClipMode) (resultClipMode);
		}

		public void SetClipping (eBeamLatticeClipMode AClipMode, UInt32 AUniqueResourceID)
		{
			Int32 enumClipMode = (Int32) AClipMode;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetClipping (Handle, enumClipMode, AUniqueResourceID));
		}

		public bool GetRepresentation (out UInt32 AUniqueResourceID)
		{
			Byte resultHasRepresentation = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetRepresentation (Handle, out resultHasRepresentation, out AUniqueResourceID));
			return (resultHasRepresentation != 0);
		}

		public void SetRepresentation (UInt32 AUniqueResourceID)
		{

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetRepresentation (Handle, AUniqueResourceID));
		}

		public void GetBallOptions (out eBeamLatticeBallMode ABallMode, out Double ABallRadius)
		{
			Int32 resultBallMode = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBallOptions (Handle, out resultBallMode, out ABallRadius));
			ABallMode = (eBeamLatticeBallMode) (resultBallMode);
		}

		public void SetBallOptions (eBeamLatticeBallMode ABallMode, Double ABallRadius)
		{
			Int32 enumBallMode = (Int32) ABallMode;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetBallOptions (Handle, enumBallMode, ABallRadius));
		}

		public UInt32 GetBeamCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeamCount (Handle, out resultCount));
			return resultCount;
		}

		public sBeam GetBeam (UInt32 AIndex)
		{
			Internal.InternalBeam intresultBeamInfo;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeam (Handle, AIndex, out intresultBeamInfo));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Beam (intresultBeamInfo);
		}

		public UInt32 AddBeam (sBeam ABeamInfo)
		{
			Internal.InternalBeam intBeamInfo = Internal.Lib3MFWrapper.convertStructToInternal_Beam (ABeamInfo);
			UInt32 resultIndex = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_AddBeam (Handle, ref intBeamInfo, out resultIndex));
			return resultIndex;
		}

		public void SetBeam (UInt32 AIndex, sBeam ABeamInfo)
		{
			Internal.InternalBeam intBeamInfo = Internal.Lib3MFWrapper.convertStructToInternal_Beam (ABeamInfo);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetBeam (Handle, AIndex, ref intBeamInfo));
		}

		public void SetBeams (sBeam[] ABeamInfo)
		{
			Internal.InternalBeam[] intdataBeamInfo = new Internal.InternalBeam[ABeamInfo.Length];
			for (int index = 0; index < ABeamInfo.Length; index++)
				intdataBeamInfo[index] = Internal.Lib3MFWrapper.convertStructToInternal_Beam(ABeamInfo[index]);
			GCHandle dataBeamInfo = GCHandle.Alloc(intdataBeamInfo, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetBeams (Handle, (UInt64) ABeamInfo.Length, dataBeamInfo.AddrOfPinnedObject()));
			dataBeamInfo.Free ();
		}

		public void GetBeams (out sBeam[] ABeamInfo)
		{
			UInt64 sizeBeamInfo = 0;
			UInt64 neededBeamInfo = 0;
			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeams (Handle, sizeBeamInfo, out neededBeamInfo, IntPtr.Zero));
			sizeBeamInfo = neededBeamInfo;
			var arrayBeamInfo = new Internal.InternalBeam[sizeBeamInfo];
			GCHandle dataBeamInfo = GCHandle.Alloc(arrayBeamInfo, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeams (Handle, sizeBeamInfo, out neededBeamInfo, dataBeamInfo.AddrOfPinnedObject()));
			dataBeamInfo.Free();
			ABeamInfo = new sBeam[sizeBeamInfo];
			for (int index = 0; index < ABeamInfo.Length; index++)
				ABeamInfo[index] = Internal.Lib3MFWrapper.convertInternalToStruct_Beam(arrayBeamInfo[index]);
		}

		public UInt32 GetBallCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBallCount (Handle, out resultCount));
			return resultCount;
		}

		public sBall GetBall (UInt32 AIndex)
		{
			Internal.InternalBall intresultBallInfo;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBall (Handle, AIndex, out intresultBallInfo));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Ball (intresultBallInfo);
		}

		public UInt32 AddBall (sBall ABallInfo)
		{
			Internal.InternalBall intBallInfo = Internal.Lib3MFWrapper.convertStructToInternal_Ball (ABallInfo);
			UInt32 resultIndex = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_AddBall (Handle, ref intBallInfo, out resultIndex));
			return resultIndex;
		}

		public void SetBall (UInt32 AIndex, sBall ABallInfo)
		{
			Internal.InternalBall intBallInfo = Internal.Lib3MFWrapper.convertStructToInternal_Ball (ABallInfo);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetBall (Handle, AIndex, ref intBallInfo));
		}

		public void SetBalls (sBall[] ABallInfo)
		{
			Internal.InternalBall[] intdataBallInfo = new Internal.InternalBall[ABallInfo.Length];
			for (int index = 0; index < ABallInfo.Length; index++)
				intdataBallInfo[index] = Internal.Lib3MFWrapper.convertStructToInternal_Ball(ABallInfo[index]);
			GCHandle dataBallInfo = GCHandle.Alloc(intdataBallInfo, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_SetBalls (Handle, (UInt64) ABallInfo.Length, dataBallInfo.AddrOfPinnedObject()));
			dataBallInfo.Free ();
		}

		public void GetBalls (out sBall[] ABallInfo)
		{
			UInt64 sizeBallInfo = 0;
			UInt64 neededBallInfo = 0;
			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBalls (Handle, sizeBallInfo, out neededBallInfo, IntPtr.Zero));
			sizeBallInfo = neededBallInfo;
			var arrayBallInfo = new Internal.InternalBall[sizeBallInfo];
			GCHandle dataBallInfo = GCHandle.Alloc(arrayBallInfo, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBalls (Handle, sizeBallInfo, out neededBallInfo, dataBallInfo.AddrOfPinnedObject()));
			dataBallInfo.Free();
			ABallInfo = new sBall[sizeBallInfo];
			for (int index = 0; index < ABallInfo.Length; index++)
				ABallInfo[index] = Internal.Lib3MFWrapper.convertInternalToStruct_Ball(arrayBallInfo[index]);
		}

		public UInt32 GetBeamSetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeamSetCount (Handle, out resultCount));
			return resultCount;
		}

		public CBeamSet AddBeamSet ()
		{
			IntPtr newBeamSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_AddBeamSet (Handle, out newBeamSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBeamSet>(newBeamSet);
		}

		public CBeamSet GetBeamSet (UInt32 AIndex)
		{
			IntPtr newBeamSet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BeamLattice_GetBeamSet (Handle, AIndex, out newBeamSet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBeamSet>(newBeamSet);
		}

	}

	public class CFunctionReference : CBase
	{
		public CFunctionReference (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetFunctionResourceID ()
		{
			UInt32 resultUniqueResourceID = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetFunctionResourceID (Handle, out resultUniqueResourceID));
			return resultUniqueResourceID;
		}

		public void SetFunctionResourceID (UInt32 AUniqueResourceID)
		{

			CheckError(Internal.Lib3MFWrapper.FunctionReference_SetFunctionResourceID (Handle, AUniqueResourceID));
		}

		public sTransform GetTransform ()
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetTransform (Handle, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public void SetTransform (sTransform ATransform)
		{
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);

			CheckError(Internal.Lib3MFWrapper.FunctionReference_SetTransform (Handle, ref intTransform));
		}

		public String GetChannelName ()
		{
			UInt32 sizeChannelName = 0;
			UInt32 neededChannelName = 0;
			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetChannelName (Handle, sizeChannelName, out neededChannelName, IntPtr.Zero));
			sizeChannelName = neededChannelName;
			byte[] bytesChannelName = new byte[sizeChannelName];
			GCHandle dataChannelName = GCHandle.Alloc(bytesChannelName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetChannelName (Handle, sizeChannelName, out neededChannelName, dataChannelName.AddrOfPinnedObject()));
			dataChannelName.Free();
			return Encoding.UTF8.GetString(bytesChannelName).TrimEnd(char.MinValue);
		}

		public void SetChannelName (String AChannelName)
		{
			byte[] byteChannelName = Encoding.UTF8.GetBytes(AChannelName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.FunctionReference_SetChannelName (Handle, byteChannelName));
		}

		public void SetMinFeatureSize (Double AMinFeatureSize)
		{

			CheckError(Internal.Lib3MFWrapper.FunctionReference_SetMinFeatureSize (Handle, AMinFeatureSize));
		}

		public Double GetMinFeatureSize ()
		{
			Double resultMinFeatureSize = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetMinFeatureSize (Handle, out resultMinFeatureSize));
			return resultMinFeatureSize;
		}

		public void SetFallBackValue (Double AFallBackValue)
		{

			CheckError(Internal.Lib3MFWrapper.FunctionReference_SetFallBackValue (Handle, AFallBackValue));
		}

		public Double GetFallBackValue ()
		{
			Double resultFallBackValue = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionReference_GetFallBackValue (Handle, out resultFallBackValue));
			return resultFallBackValue;
		}

	}

	public class CVolumeDataColor : CFunctionReference
	{
		public CVolumeDataColor (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CMaterialMapping : CFunctionReference
	{
		public CMaterialMapping (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CVolumeDataComposite : CBase
	{
		public CVolumeDataComposite (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CBaseMaterialGroup GetBaseMaterialGroup ()
		{
			IntPtr newBaseMaterialGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_GetBaseMaterialGroup (Handle, out newBaseMaterialGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroup>(newBaseMaterialGroupInstance);
		}

		public void SetBaseMaterialGroup (CBaseMaterialGroup ABaseMaterialGroupInstance)
		{
			IntPtr ABaseMaterialGroupInstanceHandle = IntPtr.Zero;
			if (ABaseMaterialGroupInstance != null)
				ABaseMaterialGroupInstanceHandle = ABaseMaterialGroupInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_SetBaseMaterialGroup (Handle, ABaseMaterialGroupInstanceHandle));
		}

		public UInt32 GetMaterialMappingCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_GetMaterialMappingCount (Handle, out resultCount));
			return resultCount;
		}

		public CMaterialMapping GetMaterialMapping (UInt32 AIndex)
		{
			IntPtr newTheMaterialMapping = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_GetMaterialMapping (Handle, AIndex, out newTheMaterialMapping));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMaterialMapping>(newTheMaterialMapping);
		}

		public CMaterialMapping AddMaterialMapping (sTransform ATransform)
		{
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);
			IntPtr newTheMaterialMapping = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_AddMaterialMapping (Handle, ref intTransform, out newTheMaterialMapping));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMaterialMapping>(newTheMaterialMapping);
		}

		public void RemoveMaterialMapping (UInt32 AIndex)
		{

			CheckError(Internal.Lib3MFWrapper.VolumeDataComposite_RemoveMaterialMapping (Handle, AIndex));
		}

	}

	public class CVolumeDataProperty : CFunctionReference
	{
		public CVolumeDataProperty (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetName ()
		{
			UInt32 sizePropertyName = 0;
			UInt32 neededPropertyName = 0;
			CheckError(Internal.Lib3MFWrapper.VolumeDataProperty_GetName (Handle, sizePropertyName, out neededPropertyName, IntPtr.Zero));
			sizePropertyName = neededPropertyName;
			byte[] bytesPropertyName = new byte[sizePropertyName];
			GCHandle dataPropertyName = GCHandle.Alloc(bytesPropertyName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.VolumeDataProperty_GetName (Handle, sizePropertyName, out neededPropertyName, dataPropertyName.AddrOfPinnedObject()));
			dataPropertyName.Free();
			return Encoding.UTF8.GetString(bytesPropertyName).TrimEnd(char.MinValue);
		}

		public void SetIsRequired (bool AIsRequired)
		{

			CheckError(Internal.Lib3MFWrapper.VolumeDataProperty_SetIsRequired (Handle, (Byte)( AIsRequired ? 1 : 0 )));
		}

		public bool IsRequired ()
		{
			Byte resultIsRequired = 0;

			CheckError(Internal.Lib3MFWrapper.VolumeDataProperty_IsRequired (Handle, out resultIsRequired));
			return (resultIsRequired != 0);
		}

	}

	public class CVolumeData : CResource
	{
		public CVolumeData (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CVolumeDataComposite GetComposite ()
		{
			IntPtr newTheCompositeData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_GetComposite (Handle, out newTheCompositeData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataComposite>(newTheCompositeData);
		}

		public CVolumeDataComposite CreateNewComposite ()
		{
			IntPtr newTheCompositeData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_CreateNewComposite (Handle, out newTheCompositeData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataComposite>(newTheCompositeData);
		}

		public void RemoveComposite ()
		{

			CheckError(Internal.Lib3MFWrapper.VolumeData_RemoveComposite (Handle));
		}

		public CVolumeDataColor GetColor ()
		{
			IntPtr newTheColorData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_GetColor (Handle, out newTheColorData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataColor>(newTheColorData);
		}

		public CVolumeDataColor CreateNewColor (CFunction ATheFunction)
		{
			IntPtr ATheFunctionHandle = IntPtr.Zero;
			if (ATheFunction != null)
				ATheFunctionHandle = ATheFunction.GetHandle();
			IntPtr newTheColorData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_CreateNewColor (Handle, ATheFunctionHandle, out newTheColorData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataColor>(newTheColorData);
		}

		public void RemoveColor ()
		{

			CheckError(Internal.Lib3MFWrapper.VolumeData_RemoveColor (Handle));
		}

		public UInt32 GetPropertyCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.VolumeData_GetPropertyCount (Handle, out resultCount));
			return resultCount;
		}

		public CVolumeDataProperty GetProperty (UInt32 AIndex)
		{
			IntPtr newTheVolumeDataProperty = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_GetProperty (Handle, AIndex, out newTheVolumeDataProperty));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataProperty>(newTheVolumeDataProperty);
		}

		public CVolumeDataProperty AddPropertyFromFunction (String AName, CFunction ATheFunction)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);
			IntPtr ATheFunctionHandle = IntPtr.Zero;
			if (ATheFunction != null)
				ATheFunctionHandle = ATheFunction.GetHandle();
			IntPtr newTheVolumeDataProperty = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.VolumeData_AddPropertyFromFunction (Handle, byteName, ATheFunctionHandle, out newTheVolumeDataProperty));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeDataProperty>(newTheVolumeDataProperty);
		}

		public void RemoveProperty (UInt32 AIndex)
		{

			CheckError(Internal.Lib3MFWrapper.VolumeData_RemoveProperty (Handle, AIndex));
		}

	}

	public class CComponent : CBase
	{
		public CComponent (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CObject GetObjectResource ()
		{
			IntPtr newObjectResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Component_GetObjectResource (Handle, out newObjectResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CObject>(newObjectResource);
		}

		public UInt32 GetObjectResourceID ()
		{
			UInt32 resultUniqueResourceID = 0;

			CheckError(Internal.Lib3MFWrapper.Component_GetObjectResourceID (Handle, out resultUniqueResourceID));
			return resultUniqueResourceID;
		}

		public String GetUUID (out bool AHasUUID)
		{
			Byte resultHasUUID = 0;
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.Component_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Component_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			AHasUUID = (resultHasUUID != 0);
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public void SetUUID (String AUUID)
		{
			byte[] byteUUID = Encoding.UTF8.GetBytes(AUUID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Component_SetUUID (Handle, byteUUID));
		}

		public bool HasTransform ()
		{
			Byte resultHasTransform = 0;

			CheckError(Internal.Lib3MFWrapper.Component_HasTransform (Handle, out resultHasTransform));
			return (resultHasTransform != 0);
		}

		public sTransform GetTransform ()
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.Component_GetTransform (Handle, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public void SetTransform (sTransform ATransform)
		{
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);

			CheckError(Internal.Lib3MFWrapper.Component_SetTransform (Handle, ref intTransform));
		}

	}

	public class CComponentsObject : CObject
	{
		public CComponentsObject (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CComponent AddComponent (CObject AObjectResource, sTransform ATransform)
		{
			IntPtr AObjectResourceHandle = IntPtr.Zero;
			if (AObjectResource != null)
				AObjectResourceHandle = AObjectResource.GetHandle();
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);
			IntPtr newComponentInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComponentsObject_AddComponent (Handle, AObjectResourceHandle, ref intTransform, out newComponentInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponent>(newComponentInstance);
		}

		public CComponent GetComponent (UInt32 AIndex)
		{
			IntPtr newComponentInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComponentsObject_GetComponent (Handle, AIndex, out newComponentInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponent>(newComponentInstance);
		}

		public UInt32 GetComponentCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.ComponentsObject_GetComponentCount (Handle, out resultCount));
			return resultCount;
		}

	}

	public class CBeamSet : CBase
	{
		public CBeamSet (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetName (String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.BeamSet_SetName (Handle, byteName));
		}

		public String GetName ()
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.BeamSet_GetName (Handle, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetName (Handle, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetIdentifier (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.BeamSet_SetIdentifier (Handle, byteIdentifier));
		}

		public String GetIdentifier ()
		{
			UInt32 sizeIdentifier = 0;
			UInt32 neededIdentifier = 0;
			CheckError(Internal.Lib3MFWrapper.BeamSet_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, IntPtr.Zero));
			sizeIdentifier = neededIdentifier;
			byte[] bytesIdentifier = new byte[sizeIdentifier];
			GCHandle dataIdentifier = GCHandle.Alloc(bytesIdentifier, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, dataIdentifier.AddrOfPinnedObject()));
			dataIdentifier.Free();
			return Encoding.UTF8.GetString(bytesIdentifier).TrimEnd(char.MinValue);
		}

		public UInt32 GetReferenceCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetReferenceCount (Handle, out resultCount));
			return resultCount;
		}

		public void SetReferences (UInt32[] AReferences)
		{
			GCHandle dataReferences = GCHandle.Alloc(AReferences, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_SetReferences (Handle, (UInt64) AReferences.Length, dataReferences.AddrOfPinnedObject()));
			dataReferences.Free ();
		}

		public void GetReferences (out UInt32[] AReferences)
		{
			UInt64 sizeReferences = 0;
			UInt64 neededReferences = 0;
			CheckError(Internal.Lib3MFWrapper.BeamSet_GetReferences (Handle, sizeReferences, out neededReferences, IntPtr.Zero));
			sizeReferences = neededReferences;
			AReferences = new UInt32[sizeReferences];
			GCHandle dataReferences = GCHandle.Alloc(AReferences, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetReferences (Handle, sizeReferences, out neededReferences, dataReferences.AddrOfPinnedObject()));
			dataReferences.Free();
		}

		public UInt32 GetBallReferenceCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetBallReferenceCount (Handle, out resultCount));
			return resultCount;
		}

		public void SetBallReferences (UInt32[] ABallReferences)
		{
			GCHandle dataBallReferences = GCHandle.Alloc(ABallReferences, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_SetBallReferences (Handle, (UInt64) ABallReferences.Length, dataBallReferences.AddrOfPinnedObject()));
			dataBallReferences.Free ();
		}

		public void GetBallReferences (out UInt32[] ABallReferences)
		{
			UInt64 sizeBallReferences = 0;
			UInt64 neededBallReferences = 0;
			CheckError(Internal.Lib3MFWrapper.BeamSet_GetBallReferences (Handle, sizeBallReferences, out neededBallReferences, IntPtr.Zero));
			sizeBallReferences = neededBallReferences;
			ABallReferences = new UInt32[sizeBallReferences];
			GCHandle dataBallReferences = GCHandle.Alloc(ABallReferences, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BeamSet_GetBallReferences (Handle, sizeBallReferences, out neededBallReferences, dataBallReferences.AddrOfPinnedObject()));
			dataBallReferences.Free();
		}

	}

	public class CBaseMaterialGroup : CResource
	{
		public CBaseMaterialGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetCount (Handle, out resultCount));
			return resultCount;
		}

		public void GetAllPropertyIDs (out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public UInt32 AddMaterial (String AName, sColor ADisplayColor)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);
			Internal.InternalColor intDisplayColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ADisplayColor);
			UInt32 resultPropertyID = 0;

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_AddMaterial (Handle, byteName, ref intDisplayColor, out resultPropertyID));
			return resultPropertyID;
		}

		public void RemoveMaterial (UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_RemoveMaterial (Handle, APropertyID));
		}

		public String GetName (UInt32 APropertyID)
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetName (Handle, APropertyID, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetName (Handle, APropertyID, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetName (UInt32 APropertyID, String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_SetName (Handle, APropertyID, byteName));
		}

		public void SetDisplayColor (UInt32 APropertyID, sColor ATheColor)
		{
			Internal.InternalColor intTheColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ATheColor);

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_SetDisplayColor (Handle, APropertyID, ref intTheColor));
		}

		public sColor GetDisplayColor (UInt32 APropertyID)
		{
			Internal.InternalColor intresultTheColor;

			CheckError(Internal.Lib3MFWrapper.BaseMaterialGroup_GetDisplayColor (Handle, APropertyID, out intresultTheColor));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Color (intresultTheColor);
		}

	}

	public class CColorGroup : CResource
	{
		public CColorGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.ColorGroup_GetCount (Handle, out resultCount));
			return resultCount;
		}

		public void GetAllPropertyIDs (out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.ColorGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ColorGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public UInt32 AddColor (sColor ATheColor)
		{
			Internal.InternalColor intTheColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ATheColor);
			UInt32 resultPropertyID = 0;

			CheckError(Internal.Lib3MFWrapper.ColorGroup_AddColor (Handle, ref intTheColor, out resultPropertyID));
			return resultPropertyID;
		}

		public void RemoveColor (UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.ColorGroup_RemoveColor (Handle, APropertyID));
		}

		public void SetColor (UInt32 APropertyID, sColor ATheColor)
		{
			Internal.InternalColor intTheColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ATheColor);

			CheckError(Internal.Lib3MFWrapper.ColorGroup_SetColor (Handle, APropertyID, ref intTheColor));
		}

		public sColor GetColor (UInt32 APropertyID)
		{
			Internal.InternalColor intresultTheColor;

			CheckError(Internal.Lib3MFWrapper.ColorGroup_GetColor (Handle, APropertyID, out intresultTheColor));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Color (intresultTheColor);
		}

	}

	public class CTexture2DGroup : CResource
	{
		public CTexture2DGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_GetCount (Handle, out resultCount));
			return resultCount;
		}

		public void GetAllPropertyIDs (out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public UInt32 AddTex2Coord (sTex2Coord AUVCoordinate)
		{
			Internal.InternalTex2Coord intUVCoordinate = Internal.Lib3MFWrapper.convertStructToInternal_Tex2Coord (AUVCoordinate);
			UInt32 resultPropertyID = 0;

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_AddTex2Coord (Handle, ref intUVCoordinate, out resultPropertyID));
			return resultPropertyID;
		}

		public sTex2Coord GetTex2Coord (UInt32 APropertyID)
		{
			Internal.InternalTex2Coord intresultUVCoordinate;

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_GetTex2Coord (Handle, APropertyID, out intresultUVCoordinate));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Tex2Coord (intresultUVCoordinate);
		}

		public void RemoveTex2Coord (UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_RemoveTex2Coord (Handle, APropertyID));
		}

		public CTexture2D GetTexture2D ()
		{
			IntPtr newTexture2DInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Texture2DGroup_GetTexture2D (Handle, out newTexture2DInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2D>(newTexture2DInstance);
		}

	}

	public class CCompositeMaterials : CResource
	{
		public CCompositeMaterials (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetCount (Handle, out resultCount));
			return resultCount;
		}

		public void GetAllPropertyIDs (out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public CBaseMaterialGroup GetBaseMaterialGroup ()
		{
			IntPtr newBaseMaterialGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetBaseMaterialGroup (Handle, out newBaseMaterialGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroup>(newBaseMaterialGroupInstance);
		}

		public UInt32 AddComposite (sCompositeConstituent[] AComposite)
		{
			Internal.InternalCompositeConstituent[] intdataComposite = new Internal.InternalCompositeConstituent[AComposite.Length];
			for (int index = 0; index < AComposite.Length; index++)
				intdataComposite[index] = Internal.Lib3MFWrapper.convertStructToInternal_CompositeConstituent(AComposite[index]);
			GCHandle dataComposite = GCHandle.Alloc(intdataComposite, GCHandleType.Pinned);
			UInt32 resultPropertyID = 0;

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_AddComposite (Handle, (UInt64) AComposite.Length, dataComposite.AddrOfPinnedObject(), out resultPropertyID));
			dataComposite.Free ();
			return resultPropertyID;
		}

		public void RemoveComposite (UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_RemoveComposite (Handle, APropertyID));
		}

		public void GetComposite (UInt32 APropertyID, out sCompositeConstituent[] AComposite)
		{
			UInt64 sizeComposite = 0;
			UInt64 neededComposite = 0;
			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetComposite (Handle, APropertyID, sizeComposite, out neededComposite, IntPtr.Zero));
			sizeComposite = neededComposite;
			var arrayComposite = new Internal.InternalCompositeConstituent[sizeComposite];
			GCHandle dataComposite = GCHandle.Alloc(arrayComposite, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.CompositeMaterials_GetComposite (Handle, APropertyID, sizeComposite, out neededComposite, dataComposite.AddrOfPinnedObject()));
			dataComposite.Free();
			AComposite = new sCompositeConstituent[sizeComposite];
			for (int index = 0; index < AComposite.Length; index++)
				AComposite[index] = Internal.Lib3MFWrapper.convertInternalToStruct_CompositeConstituent(arrayComposite[index]);
		}

	}

	public class CMultiPropertyGroup : CResource
	{
		public CMultiPropertyGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetCount (Handle, out resultCount));
			return resultCount;
		}

		public void GetAllPropertyIDs (out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetAllPropertyIDs (Handle, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public UInt32 AddMultiProperty (UInt32[] APropertyIDs)
		{
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);
			UInt32 resultPropertyID = 0;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_AddMultiProperty (Handle, (UInt64) APropertyIDs.Length, dataPropertyIDs.AddrOfPinnedObject(), out resultPropertyID));
			dataPropertyIDs.Free ();
			return resultPropertyID;
		}

		public void SetMultiProperty (UInt32 APropertyID, UInt32[] APropertyIDs)
		{
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_SetMultiProperty (Handle, APropertyID, (UInt64) APropertyIDs.Length, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free ();
		}

		public void GetMultiProperty (UInt32 APropertyID, out UInt32[] APropertyIDs)
		{
			UInt64 sizePropertyIDs = 0;
			UInt64 neededPropertyIDs = 0;
			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetMultiProperty (Handle, APropertyID, sizePropertyIDs, out neededPropertyIDs, IntPtr.Zero));
			sizePropertyIDs = neededPropertyIDs;
			APropertyIDs = new UInt32[sizePropertyIDs];
			GCHandle dataPropertyIDs = GCHandle.Alloc(APropertyIDs, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetMultiProperty (Handle, APropertyID, sizePropertyIDs, out neededPropertyIDs, dataPropertyIDs.AddrOfPinnedObject()));
			dataPropertyIDs.Free();
		}

		public void RemoveMultiProperty (UInt32 APropertyID)
		{

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_RemoveMultiProperty (Handle, APropertyID));
		}

		public UInt32 GetLayerCount ()
		{
			UInt32 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetLayerCount (Handle, out resultCount));
			return resultCount;
		}

		public UInt32 AddLayer (sMultiPropertyLayer ATheLayer)
		{
			Internal.InternalMultiPropertyLayer intTheLayer = Internal.Lib3MFWrapper.convertStructToInternal_MultiPropertyLayer (ATheLayer);
			UInt32 resultLayerIndex = 0;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_AddLayer (Handle, ref intTheLayer, out resultLayerIndex));
			return resultLayerIndex;
		}

		public sMultiPropertyLayer GetLayer (UInt32 ALayerIndex)
		{
			Internal.InternalMultiPropertyLayer intresultTheLayer;

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_GetLayer (Handle, ALayerIndex, out intresultTheLayer));
			return Internal.Lib3MFWrapper.convertInternalToStruct_MultiPropertyLayer (intresultTheLayer);
		}

		public void RemoveLayer (UInt32 ALayerIndex)
		{

			CheckError(Internal.Lib3MFWrapper.MultiPropertyGroup_RemoveLayer (Handle, ALayerIndex));
		}

	}

	public class CImage3D : CResource
	{
		public CImage3D (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetName ()
		{
			UInt32 sizeName = 0;
			UInt32 neededName = 0;
			CheckError(Internal.Lib3MFWrapper.Image3D_GetName (Handle, sizeName, out neededName, IntPtr.Zero));
			sizeName = neededName;
			byte[] bytesName = new byte[sizeName];
			GCHandle dataName = GCHandle.Alloc(bytesName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Image3D_GetName (Handle, sizeName, out neededName, dataName.AddrOfPinnedObject()));
			dataName.Free();
			return Encoding.UTF8.GetString(bytesName).TrimEnd(char.MinValue);
		}

		public void SetName (String AName)
		{
			byte[] byteName = Encoding.UTF8.GetBytes(AName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Image3D_SetName (Handle, byteName));
		}

		public bool IsImageStack ()
		{
			Byte resultIsImageStack = 0;

			CheckError(Internal.Lib3MFWrapper.Image3D_IsImageStack (Handle, out resultIsImageStack));
			return (resultIsImageStack != 0);
		}

	}

	public class CImageStack : CImage3D
	{
		public CImageStack (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public UInt32 GetRowCount ()
		{
			UInt32 resultRowCount = 0;

			CheckError(Internal.Lib3MFWrapper.ImageStack_GetRowCount (Handle, out resultRowCount));
			return resultRowCount;
		}

		public void SetRowCount (UInt32 ARowCount)
		{

			CheckError(Internal.Lib3MFWrapper.ImageStack_SetRowCount (Handle, ARowCount));
		}

		public UInt32 GetColumnCount ()
		{
			UInt32 resultColumnCount = 0;

			CheckError(Internal.Lib3MFWrapper.ImageStack_GetColumnCount (Handle, out resultColumnCount));
			return resultColumnCount;
		}

		public void SetColumnCount (UInt32 AColumnCount)
		{

			CheckError(Internal.Lib3MFWrapper.ImageStack_SetColumnCount (Handle, AColumnCount));
		}

		public UInt32 GetSheetCount ()
		{
			UInt32 resultSheetCount = 0;

			CheckError(Internal.Lib3MFWrapper.ImageStack_GetSheetCount (Handle, out resultSheetCount));
			return resultSheetCount;
		}

		public CAttachment GetSheet (UInt32 AIndex)
		{
			IntPtr newSheet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImageStack_GetSheet (Handle, AIndex, out newSheet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newSheet);
		}

		public void SetSheet (UInt32 AIndex, CAttachment ASheet)
		{
			IntPtr ASheetHandle = IntPtr.Zero;
			if (ASheet != null)
				ASheetHandle = ASheet.GetHandle();

			CheckError(Internal.Lib3MFWrapper.ImageStack_SetSheet (Handle, AIndex, ASheetHandle));
		}

		public CAttachment CreateEmptySheet (UInt32 AIndex, String APath)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);
			IntPtr newSheet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImageStack_CreateEmptySheet (Handle, AIndex, bytePath, out newSheet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newSheet);
		}

		public CAttachment CreateSheetFromBuffer (UInt32 AIndex, String APath, Byte[] AData)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);
			GCHandle dataData = GCHandle.Alloc(AData, GCHandleType.Pinned);
			IntPtr newSheet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImageStack_CreateSheetFromBuffer (Handle, AIndex, bytePath, (UInt64) AData.Length, dataData.AddrOfPinnedObject(), out newSheet));
			dataData.Free ();
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newSheet);
		}

		public CAttachment CreateSheetFromFile (UInt32 AIndex, String APath, String AFileName)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);
			byte[] byteFileName = Encoding.UTF8.GetBytes(AFileName + char.MinValue);
			IntPtr newSheet = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImageStack_CreateSheetFromFile (Handle, AIndex, bytePath, byteFileName, out newSheet));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newSheet);
		}

	}

	public class CAttachment : CBase
	{
		public CAttachment (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetPath ()
		{
			UInt32 sizePath = 0;
			UInt32 neededPath = 0;
			CheckError(Internal.Lib3MFWrapper.Attachment_GetPath (Handle, sizePath, out neededPath, IntPtr.Zero));
			sizePath = neededPath;
			byte[] bytesPath = new byte[sizePath];
			GCHandle dataPath = GCHandle.Alloc(bytesPath, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Attachment_GetPath (Handle, sizePath, out neededPath, dataPath.AddrOfPinnedObject()));
			dataPath.Free();
			return Encoding.UTF8.GetString(bytesPath).TrimEnd(char.MinValue);
		}

		public void SetPath (String APath)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Attachment_SetPath (Handle, bytePath));
		}

		public CPackagePart PackagePart ()
		{
			IntPtr newPackagePart = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Attachment_PackagePart (Handle, out newPackagePart));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPackagePart>(newPackagePart);
		}

		public String GetRelationShipType ()
		{
			UInt32 sizePath = 0;
			UInt32 neededPath = 0;
			CheckError(Internal.Lib3MFWrapper.Attachment_GetRelationShipType (Handle, sizePath, out neededPath, IntPtr.Zero));
			sizePath = neededPath;
			byte[] bytesPath = new byte[sizePath];
			GCHandle dataPath = GCHandle.Alloc(bytesPath, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Attachment_GetRelationShipType (Handle, sizePath, out neededPath, dataPath.AddrOfPinnedObject()));
			dataPath.Free();
			return Encoding.UTF8.GetString(bytesPath).TrimEnd(char.MinValue);
		}

		public void SetRelationShipType (String APath)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Attachment_SetRelationShipType (Handle, bytePath));
		}

		public void WriteToFile (String AFileName)
		{
			byte[] byteFileName = Encoding.UTF8.GetBytes(AFileName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Attachment_WriteToFile (Handle, byteFileName));
		}

		public void ReadFromFile (String AFileName)
		{
			byte[] byteFileName = Encoding.UTF8.GetBytes(AFileName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Attachment_ReadFromFile (Handle, byteFileName));
		}

		public void ReadFromCallback (IntPtr ATheReadCallback, UInt64 AStreamSize, IntPtr ATheSeekCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Attachment_ReadFromCallback (Handle, ATheReadCallback, AStreamSize, ATheSeekCallback, AUserData));
		}

		public UInt64 GetStreamSize ()
		{
			UInt64 resultStreamSize = 0;

			CheckError(Internal.Lib3MFWrapper.Attachment_GetStreamSize (Handle, out resultStreamSize));
			return resultStreamSize;
		}

		public void WriteToBuffer (out Byte[] ABuffer)
		{
			UInt64 sizeBuffer = 0;
			UInt64 neededBuffer = 0;
			CheckError(Internal.Lib3MFWrapper.Attachment_WriteToBuffer (Handle, sizeBuffer, out neededBuffer, IntPtr.Zero));
			sizeBuffer = neededBuffer;
			ABuffer = new Byte[sizeBuffer];
			GCHandle dataBuffer = GCHandle.Alloc(ABuffer, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Attachment_WriteToBuffer (Handle, sizeBuffer, out neededBuffer, dataBuffer.AddrOfPinnedObject()));
			dataBuffer.Free();
		}

		public void ReadFromBuffer (Byte[] ABuffer)
		{
			GCHandle dataBuffer = GCHandle.Alloc(ABuffer, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Attachment_ReadFromBuffer (Handle, (UInt64) ABuffer.Length, dataBuffer.AddrOfPinnedObject()));
			dataBuffer.Free ();
		}

	}

	public class CTexture2D : CResource
	{
		public CTexture2D (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CAttachment GetAttachment ()
		{
			IntPtr newAttachment = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Texture2D_GetAttachment (Handle, out newAttachment));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachment);
		}

		public void SetAttachment (CAttachment AAttachment)
		{
			IntPtr AAttachmentHandle = IntPtr.Zero;
			if (AAttachment != null)
				AAttachmentHandle = AAttachment.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Texture2D_SetAttachment (Handle, AAttachmentHandle));
		}

		public eTextureType GetContentType ()
		{
			Int32 resultContentType = 0;

			CheckError(Internal.Lib3MFWrapper.Texture2D_GetContentType (Handle, out resultContentType));
			return (eTextureType) (resultContentType);
		}

		public void SetContentType (eTextureType AContentType)
		{
			Int32 enumContentType = (Int32) AContentType;

			CheckError(Internal.Lib3MFWrapper.Texture2D_SetContentType (Handle, enumContentType));
		}

		public void GetTileStyleUV (out eTextureTileStyle ATileStyleU, out eTextureTileStyle ATileStyleV)
		{
			Int32 resultTileStyleU = 0;
			Int32 resultTileStyleV = 0;

			CheckError(Internal.Lib3MFWrapper.Texture2D_GetTileStyleUV (Handle, out resultTileStyleU, out resultTileStyleV));
			ATileStyleU = (eTextureTileStyle) (resultTileStyleU);
			ATileStyleV = (eTextureTileStyle) (resultTileStyleV);
		}

		public void SetTileStyleUV (eTextureTileStyle ATileStyleU, eTextureTileStyle ATileStyleV)
		{
			Int32 enumTileStyleU = (Int32) ATileStyleU;
			Int32 enumTileStyleV = (Int32) ATileStyleV;

			CheckError(Internal.Lib3MFWrapper.Texture2D_SetTileStyleUV (Handle, enumTileStyleU, enumTileStyleV));
		}

		public eTextureFilter GetFilter ()
		{
			Int32 resultFilter = 0;

			CheckError(Internal.Lib3MFWrapper.Texture2D_GetFilter (Handle, out resultFilter));
			return (eTextureFilter) (resultFilter);
		}

		public void SetFilter (eTextureFilter AFilter)
		{
			Int32 enumFilter = (Int32) AFilter;

			CheckError(Internal.Lib3MFWrapper.Texture2D_SetFilter (Handle, enumFilter));
		}

	}

	public class CImplicitPort : CBase
	{
		public CImplicitPort (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetIdentifier ()
		{
			UInt32 sizeIdentifier = 0;
			UInt32 neededIdentifier = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, IntPtr.Zero));
			sizeIdentifier = neededIdentifier;
			byte[] bytesIdentifier = new byte[sizeIdentifier];
			GCHandle dataIdentifier = GCHandle.Alloc(bytesIdentifier, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, dataIdentifier.AddrOfPinnedObject()));
			dataIdentifier.Free();
			return Encoding.UTF8.GetString(bytesIdentifier).TrimEnd(char.MinValue);
		}

		public void SetIdentifier (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_SetIdentifier (Handle, byteIdentifier));
		}

		public String GetDisplayName ()
		{
			UInt32 sizeDisplayName = 0;
			UInt32 neededDisplayName = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, IntPtr.Zero));
			sizeDisplayName = neededDisplayName;
			byte[] bytesDisplayName = new byte[sizeDisplayName];
			GCHandle dataDisplayName = GCHandle.Alloc(bytesDisplayName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, dataDisplayName.AddrOfPinnedObject()));
			dataDisplayName.Free();
			return Encoding.UTF8.GetString(bytesDisplayName).TrimEnd(char.MinValue);
		}

		public void SetDisplayName (String ADisplayName)
		{
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_SetDisplayName (Handle, byteDisplayName));
		}

		public void SetType (eImplicitPortType AImplicitPortType)
		{
			Int32 enumImplicitPortType = (Int32) AImplicitPortType;

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_SetType (Handle, enumImplicitPortType));
		}

		public eImplicitPortType GetType ()
		{
			Int32 resultImplicitPortType = 0;

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetType (Handle, out resultImplicitPortType));
			return (eImplicitPortType) (resultImplicitPortType);
		}

		public String GetReference ()
		{
			UInt32 sizeReference = 0;
			UInt32 neededReference = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetReference (Handle, sizeReference, out neededReference, IntPtr.Zero));
			sizeReference = neededReference;
			byte[] bytesReference = new byte[sizeReference];
			GCHandle dataReference = GCHandle.Alloc(bytesReference, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_GetReference (Handle, sizeReference, out neededReference, dataReference.AddrOfPinnedObject()));
			dataReference.Free();
			return Encoding.UTF8.GetString(bytesReference).TrimEnd(char.MinValue);
		}

		public void SetReference (String AReference)
		{
			byte[] byteReference = Encoding.UTF8.GetBytes(AReference + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitPort_SetReference (Handle, byteReference));
		}

	}

	public class CIterator : CBase
	{
		public CIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public bool MoveNext ()
		{
			Byte resultHasNext = 0;

			CheckError(Internal.Lib3MFWrapper.Iterator_MoveNext (Handle, out resultHasNext));
			return (resultHasNext != 0);
		}

		public bool MovePrevious ()
		{
			Byte resultHasPrevious = 0;

			CheckError(Internal.Lib3MFWrapper.Iterator_MovePrevious (Handle, out resultHasPrevious));
			return (resultHasPrevious != 0);
		}

		public UInt64 Count ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Iterator_Count (Handle, out resultCount));
			return resultCount;
		}

	}

	public class CImplicitPortIterator : CIterator
	{
		public CImplicitPortIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetCurrent ()
		{
			IntPtr newPort = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitPortIterator_GetCurrent (Handle, out newPort));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPort);
		}

	}

	public class CImplicitNode : CBase
	{
		public CImplicitNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetIdentifier ()
		{
			UInt32 sizeIdentifier = 0;
			UInt32 neededIdentifier = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, IntPtr.Zero));
			sizeIdentifier = neededIdentifier;
			byte[] bytesIdentifier = new byte[sizeIdentifier];
			GCHandle dataIdentifier = GCHandle.Alloc(bytesIdentifier, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, dataIdentifier.AddrOfPinnedObject()));
			dataIdentifier.Free();
			return Encoding.UTF8.GetString(bytesIdentifier).TrimEnd(char.MinValue);
		}

		public void SetIdentifier (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_SetIdentifier (Handle, byteIdentifier));
		}

		public String GetDisplayName ()
		{
			UInt32 sizeDisplayName = 0;
			UInt32 neededDisplayName = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, IntPtr.Zero));
			sizeDisplayName = neededDisplayName;
			byte[] bytesDisplayName = new byte[sizeDisplayName];
			GCHandle dataDisplayName = GCHandle.Alloc(bytesDisplayName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, dataDisplayName.AddrOfPinnedObject()));
			dataDisplayName.Free();
			return Encoding.UTF8.GetString(bytesDisplayName).TrimEnd(char.MinValue);
		}

		public void SetDisplayName (String ADisplayName)
		{
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_SetDisplayName (Handle, byteDisplayName));
		}

		public String GetTag ()
		{
			UInt32 sizeTag = 0;
			UInt32 neededTag = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetTag (Handle, sizeTag, out neededTag, IntPtr.Zero));
			sizeTag = neededTag;
			byte[] bytesTag = new byte[sizeTag];
			GCHandle dataTag = GCHandle.Alloc(bytesTag, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetTag (Handle, sizeTag, out neededTag, dataTag.AddrOfPinnedObject()));
			dataTag.Free();
			return Encoding.UTF8.GetString(bytesTag).TrimEnd(char.MinValue);
		}

		public void SetTag (String ATag)
		{
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_SetTag (Handle, byteTag));
		}

		public eImplicitNodeType GetNodeType ()
		{
			Int32 resultType = 0;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetNodeType (Handle, out resultType));
			return (eImplicitNodeType) (resultType);
		}

		public CImplicitPort AddInput (String AIdentifier, String ADisplayName)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			IntPtr newPort = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_AddInput (Handle, byteIdentifier, byteDisplayName, out newPort));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPort);
		}

		public CImplicitPortIterator GetInputs ()
		{
			IntPtr newIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetInputs (Handle, out newIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPortIterator>(newIterator);
		}

		public CImplicitPort AddOutput (String AIdentifier, String ADisplayName)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			IntPtr newPort = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_AddOutput (Handle, byteIdentifier, byteDisplayName, out newPort));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPort);
		}

		public CImplicitPortIterator GetOutputs ()
		{
			IntPtr newIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_GetOutputs (Handle, out newIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPortIterator>(newIterator);
		}

		public CImplicitPort FindInput (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newInput = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_FindInput (Handle, byteIdentifier, out newInput));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newInput);
		}

		public CImplicitPort FindOutput (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newOutput = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_FindOutput (Handle, byteIdentifier, out newOutput));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newOutput);
		}

		public bool AreTypesValid ()
		{
			Byte resultValid = 0;

			CheckError(Internal.Lib3MFWrapper.ImplicitNode_AreTypesValid (Handle, out resultValid));
			return (resultValid != 0);
		}

	}

	public class COneInputNode : CImplicitNode
	{
		public COneInputNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputA ()
		{
			IntPtr newInput = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.OneInputNode_GetInputA (Handle, out newInput));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newInput);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.OneInputNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CSinNode : COneInputNode
	{
		public CSinNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CCosNode : COneInputNode
	{
		public CCosNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CTanNode : COneInputNode
	{
		public CTanNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CArcSinNode : COneInputNode
	{
		public CArcSinNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CArcCosNode : COneInputNode
	{
		public CArcCosNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CArcTanNode : COneInputNode
	{
		public CArcTanNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CSinhNode : COneInputNode
	{
		public CSinhNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CCoshNode : COneInputNode
	{
		public CCoshNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CTanhNode : COneInputNode
	{
		public CTanhNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CRoundNode : COneInputNode
	{
		public CRoundNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CCeilNode : COneInputNode
	{
		public CCeilNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CFloorNode : COneInputNode
	{
		public CFloorNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CSignNode : COneInputNode
	{
		public CSignNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CFractNode : COneInputNode
	{
		public CFractNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CAbsNode : COneInputNode
	{
		public CAbsNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CExpNode : COneInputNode
	{
		public CExpNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CLogNode : COneInputNode
	{
		public CLogNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CLog2Node : COneInputNode
	{
		public CLog2Node (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CLog10Node : COneInputNode
	{
		public CLog10Node (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CLengthNode : COneInputNode
	{
		public CLengthNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CTransposeNode : COneInputNode
	{
		public CTransposeNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CInverseNode : COneInputNode
	{
		public CInverseNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CSqrtNode : COneInputNode
	{
		public CSqrtNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CResourceIdNode : CImplicitNode
	{
		public CResourceIdNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetResource (CResource AResource)
		{
			IntPtr AResourceHandle = IntPtr.Zero;
			if (AResource != null)
				AResourceHandle = AResource.GetHandle();

			CheckError(Internal.Lib3MFWrapper.ResourceIdNode_SetResource (Handle, AResourceHandle));
		}

		public CResource GetResource ()
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceIdNode_GetResource (Handle, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResource>(newResource);
		}

		public CImplicitPort GetOutputValue ()
		{
			IntPtr newValue = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceIdNode_GetOutputValue (Handle, out newValue));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newValue);
		}

	}

	public class CTwoInputNode : COneInputNode
	{
		public CTwoInputNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputB ()
		{
			IntPtr newB = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.TwoInputNode_GetInputB (Handle, out newB));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newB);
		}

	}

	public class CAdditionNode : CTwoInputNode
	{
		public CAdditionNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CSubtractionNode : CTwoInputNode
	{
		public CSubtractionNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CMultiplicationNode : CTwoInputNode
	{
		public CMultiplicationNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CDivisionNode : CTwoInputNode
	{
		public CDivisionNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CDotNode : CTwoInputNode
	{
		public CDotNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CCrossNode : CTwoInputNode
	{
		public CCrossNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CArcTan2Node : CTwoInputNode
	{
		public CArcTan2Node (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CMatVecMultiplicationNode : CTwoInputNode
	{
		public CMatVecMultiplicationNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CMinNode : CTwoInputNode
	{
		public CMinNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CMaxNode : CTwoInputNode
	{
		public CMaxNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CFmodNode : CTwoInputNode
	{
		public CFmodNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CModNode : CTwoInputNode
	{
		public CModNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CPowNode : CTwoInputNode
	{
		public CPowNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CSelectNode : COneInputNode
	{
		public CSelectNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputB ()
		{
			IntPtr newB = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SelectNode_GetInputB (Handle, out newB));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newB);
		}

		public CImplicitPort GetInputC ()
		{
			IntPtr newC = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SelectNode_GetInputC (Handle, out newC));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newC);
		}

		public CImplicitPort GetInputD ()
		{
			IntPtr newD = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SelectNode_GetInputD (Handle, out newD));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newD);
		}

	}

	public class CClampNode : COneInputNode
	{
		public CClampNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputMin ()
		{
			IntPtr newMin = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ClampNode_GetInputMin (Handle, out newMin));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMin);
		}

		public CImplicitPort GetInputMax ()
		{
			IntPtr newMax = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ClampNode_GetInputMax (Handle, out newMax));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMax);
		}

	}

	public class CComposeVectorNode : CImplicitNode
	{
		public CComposeVectorNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputX ()
		{
			IntPtr newX = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeVectorNode_GetInputX (Handle, out newX));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newX);
		}

		public CImplicitPort GetInputY ()
		{
			IntPtr newY = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeVectorNode_GetInputY (Handle, out newY));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newY);
		}

		public CImplicitPort GetInputZ ()
		{
			IntPtr newZ = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeVectorNode_GetInputZ (Handle, out newZ));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newZ);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeVectorNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CVectorFromScalarNode : COneInputNode
	{
		public CVectorFromScalarNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

	}

	public class CDecomposeVectorNode : CImplicitNode
	{
		public CDecomposeVectorNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputA ()
		{
			IntPtr newA = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.DecomposeVectorNode_GetInputA (Handle, out newA));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newA);
		}

		public CImplicitPort GetOutputX ()
		{
			IntPtr newX = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.DecomposeVectorNode_GetOutputX (Handle, out newX));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newX);
		}

		public CImplicitPort GetOutputY ()
		{
			IntPtr newY = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.DecomposeVectorNode_GetOutputY (Handle, out newY));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newY);
		}

		public CImplicitPort GetOutputZ ()
		{
			IntPtr newZ = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.DecomposeVectorNode_GetOutputZ (Handle, out newZ));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newZ);
		}

	}

	public class CComposeMatrixNode : CImplicitNode
	{
		public CComposeMatrixNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputM00 ()
		{
			IntPtr newM00 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM00 (Handle, out newM00));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM00);
		}

		public CImplicitPort GetInputM01 ()
		{
			IntPtr newM01 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM01 (Handle, out newM01));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM01);
		}

		public CImplicitPort GetInputM02 ()
		{
			IntPtr newM02 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM02 (Handle, out newM02));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM02);
		}

		public CImplicitPort GetInputM03 ()
		{
			IntPtr newM03 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM03 (Handle, out newM03));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM03);
		}

		public CImplicitPort GetInputM10 ()
		{
			IntPtr newM10 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM10 (Handle, out newM10));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM10);
		}

		public CImplicitPort GetInputM11 ()
		{
			IntPtr newM11 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM11 (Handle, out newM11));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM11);
		}

		public CImplicitPort GetInputM12 ()
		{
			IntPtr newM12 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM12 (Handle, out newM12));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM12);
		}

		public CImplicitPort GetInputM13 ()
		{
			IntPtr newM13 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM13 (Handle, out newM13));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM13);
		}

		public CImplicitPort GetInputM20 ()
		{
			IntPtr newM20 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM20 (Handle, out newM20));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM20);
		}

		public CImplicitPort GetInputM21 ()
		{
			IntPtr newM21 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM21 (Handle, out newM21));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM21);
		}

		public CImplicitPort GetInputM22 ()
		{
			IntPtr newM22 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM22 (Handle, out newM22));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM22);
		}

		public CImplicitPort GetInputM23 ()
		{
			IntPtr newM23 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM23 (Handle, out newM23));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM23);
		}

		public CImplicitPort GetInputM30 ()
		{
			IntPtr newM30 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM30 (Handle, out newM30));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM30);
		}

		public CImplicitPort GetInputM31 ()
		{
			IntPtr newM31 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM31 (Handle, out newM31));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM31);
		}

		public CImplicitPort GetInputM32 ()
		{
			IntPtr newM32 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM32 (Handle, out newM32));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM32);
		}

		public CImplicitPort GetInputM33 ()
		{
			IntPtr newM33 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetInputM33 (Handle, out newM33));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newM33);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ComposeMatrixNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CMatrixFromRowsNode : CImplicitNode
	{
		public CMatrixFromRowsNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputA ()
		{
			IntPtr newRow0 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromRowsNode_GetInputA (Handle, out newRow0));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newRow0);
		}

		public CImplicitPort GetInputB ()
		{
			IntPtr newRow1 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromRowsNode_GetInputB (Handle, out newRow1));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newRow1);
		}

		public CImplicitPort GetInputC ()
		{
			IntPtr newRow2 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromRowsNode_GetInputC (Handle, out newRow2));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newRow2);
		}

		public CImplicitPort GetInputD ()
		{
			IntPtr newRow3 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromRowsNode_GetInputD (Handle, out newRow3));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newRow3);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromRowsNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CMatrixFromColumnsNode : CImplicitNode
	{
		public CMatrixFromColumnsNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputA ()
		{
			IntPtr newColumn0 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromColumnsNode_GetInputA (Handle, out newColumn0));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newColumn0);
		}

		public CImplicitPort GetInputB ()
		{
			IntPtr newColumn1 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromColumnsNode_GetInputB (Handle, out newColumn1));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newColumn1);
		}

		public CImplicitPort GetInputC ()
		{
			IntPtr newColumn2 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromColumnsNode_GetInputC (Handle, out newColumn2));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newColumn2);
		}

		public CImplicitPort GetInputD ()
		{
			IntPtr newColumn3 = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromColumnsNode_GetInputD (Handle, out newColumn3));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newColumn3);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MatrixFromColumnsNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CConstantNode : CImplicitNode
	{
		public CConstantNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetConstant (Double AValue)
		{

			CheckError(Internal.Lib3MFWrapper.ConstantNode_SetConstant (Handle, AValue));
		}

		public Double GetConstant ()
		{
			Double resultValue = 0;

			CheckError(Internal.Lib3MFWrapper.ConstantNode_GetConstant (Handle, out resultValue));
			return resultValue;
		}

		public CImplicitPort GetOutputValue ()
		{
			IntPtr newValue = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ConstantNode_GetOutputValue (Handle, out newValue));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newValue);
		}

	}

	public class CConstVecNode : CImplicitNode
	{
		public CConstVecNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetVector (sVector AValue)
		{
			Internal.InternalVector intValue = Internal.Lib3MFWrapper.convertStructToInternal_Vector (AValue);

			CheckError(Internal.Lib3MFWrapper.ConstVecNode_SetVector (Handle, ref intValue));
		}

		public sVector GetVector ()
		{
			Internal.InternalVector intresultValue;

			CheckError(Internal.Lib3MFWrapper.ConstVecNode_GetVector (Handle, out intresultValue));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Vector (intresultValue);
		}

		public CImplicitPort GetOutputVector ()
		{
			IntPtr newVector = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ConstVecNode_GetOutputVector (Handle, out newVector));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newVector);
		}

	}

	public class CConstMatNode : CImplicitNode
	{
		public CConstMatNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetMatrix (sMatrix4x4 AValue)
		{
			Internal.InternalMatrix4x4 intValue = Internal.Lib3MFWrapper.convertStructToInternal_Matrix4x4 (AValue);

			CheckError(Internal.Lib3MFWrapper.ConstMatNode_SetMatrix (Handle, ref intValue));
		}

		public sMatrix4x4 GetMatrix ()
		{
			Internal.InternalMatrix4x4 intresultValue;

			CheckError(Internal.Lib3MFWrapper.ConstMatNode_GetMatrix (Handle, out intresultValue));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Matrix4x4 (intresultValue);
		}

		public CImplicitPort GetOutputMatrix ()
		{
			IntPtr newMatrix = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ConstMatNode_GetOutputMatrix (Handle, out newMatrix));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMatrix);
		}

	}

	public class CMeshNode : CImplicitNode
	{
		public CMeshNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputMesh ()
		{
			IntPtr newMesh = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshNode_GetInputMesh (Handle, out newMesh));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMesh);
		}

		public CImplicitPort GetInputPos ()
		{
			IntPtr newPos = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshNode_GetInputPos (Handle, out newPos));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPos);
		}

		public CImplicitPort GetOutputDistance ()
		{
			IntPtr newDistance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.MeshNode_GetOutputDistance (Handle, out newDistance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newDistance);
		}

	}

	public class CUnsignedMeshNode : CImplicitNode
	{
		public CUnsignedMeshNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputMesh ()
		{
			IntPtr newMesh = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.UnsignedMeshNode_GetInputMesh (Handle, out newMesh));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMesh);
		}

		public CImplicitPort GetInputPos ()
		{
			IntPtr newPos = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.UnsignedMeshNode_GetInputPos (Handle, out newPos));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPos);
		}

		public CImplicitPort GetOutputDistance ()
		{
			IntPtr newDistance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.UnsignedMeshNode_GetOutputDistance (Handle, out newDistance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newDistance);
		}

	}

	public class CBeamLatticeNode : CImplicitNode
	{
		public CBeamLatticeNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputBeamLattice ()
		{
			IntPtr newBeamLattice = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BeamLatticeNode_GetInputBeamLattice (Handle, out newBeamLattice));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newBeamLattice);
		}

		public CImplicitPort GetInputPos ()
		{
			IntPtr newPos = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BeamLatticeNode_GetInputPos (Handle, out newPos));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPos);
		}

		public CImplicitPort GetOutputDistance ()
		{
			IntPtr newDistance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BeamLatticeNode_GetOutputDistance (Handle, out newDistance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newDistance);
		}

		public void SetAccurateRange (Double AAccurateRange)
		{

			CheckError(Internal.Lib3MFWrapper.BeamLatticeNode_SetAccurateRange (Handle, AAccurateRange));
		}

		public Double GetAccurateRange ()
		{
			Double resultAccurateRange = 0;

			CheckError(Internal.Lib3MFWrapper.BeamLatticeNode_GetAccurateRange (Handle, out resultAccurateRange));
			return resultAccurateRange;
		}

	}

	public class CFunctionGradientNode : CImplicitNode
	{
		public CFunctionGradientNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputFunctionID ()
		{
			IntPtr newFunction = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetInputFunctionID (Handle, out newFunction));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newFunction);
		}

		public CImplicitPort GetInputPos ()
		{
			IntPtr newPos = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetInputPos (Handle, out newPos));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPos);
		}

		public CImplicitPort GetInputStep ()
		{
			IntPtr newStep = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetInputStep (Handle, out newStep));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newStep);
		}

		public void SetScalarOutputName (String AScalarOutputName)
		{
			byte[] byteScalarOutputName = Encoding.UTF8.GetBytes(AScalarOutputName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_SetScalarOutputName (Handle, byteScalarOutputName));
		}

		public String GetScalarOutputName ()
		{
			UInt32 sizeScalarOutputName = 0;
			UInt32 neededScalarOutputName = 0;
			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetScalarOutputName (Handle, sizeScalarOutputName, out neededScalarOutputName, IntPtr.Zero));
			sizeScalarOutputName = neededScalarOutputName;
			byte[] bytesScalarOutputName = new byte[sizeScalarOutputName];
			GCHandle dataScalarOutputName = GCHandle.Alloc(bytesScalarOutputName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetScalarOutputName (Handle, sizeScalarOutputName, out neededScalarOutputName, dataScalarOutputName.AddrOfPinnedObject()));
			dataScalarOutputName.Free();
			return Encoding.UTF8.GetString(bytesScalarOutputName).TrimEnd(char.MinValue);
		}

		public void SetVectorInputName (String AVectorInputName)
		{
			byte[] byteVectorInputName = Encoding.UTF8.GetBytes(AVectorInputName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_SetVectorInputName (Handle, byteVectorInputName));
		}

		public String GetVectorInputName ()
		{
			UInt32 sizeVectorInputName = 0;
			UInt32 neededVectorInputName = 0;
			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetVectorInputName (Handle, sizeVectorInputName, out neededVectorInputName, IntPtr.Zero));
			sizeVectorInputName = neededVectorInputName;
			byte[] bytesVectorInputName = new byte[sizeVectorInputName];
			GCHandle dataVectorInputName = GCHandle.Alloc(bytesVectorInputName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetVectorInputName (Handle, sizeVectorInputName, out neededVectorInputName, dataVectorInputName.AddrOfPinnedObject()));
			dataVectorInputName.Free();
			return Encoding.UTF8.GetString(bytesVectorInputName).TrimEnd(char.MinValue);
		}

		public CImplicitPort GetOutputNormalizedGradient ()
		{
			IntPtr newNormalizedGradient = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetOutputNormalizedGradient (Handle, out newNormalizedGradient));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newNormalizedGradient);
		}

		public CImplicitPort GetOutputGradient ()
		{
			IntPtr newGradient = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetOutputGradient (Handle, out newGradient));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newGradient);
		}

		public CImplicitPort GetOutputMagnitude ()
		{
			IntPtr newMagnitude = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionGradientNode_GetOutputMagnitude (Handle, out newMagnitude));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newMagnitude);
		}

	}

	public class CNormalizeDistanceNode : CImplicitNode
	{
		public CNormalizeDistanceNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputFunctionID ()
		{
			IntPtr newFunction = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetInputFunctionID (Handle, out newFunction));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newFunction);
		}

		public CImplicitPort GetInputPos ()
		{
			IntPtr newPos = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetInputPos (Handle, out newPos));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPos);
		}

		public CImplicitPort GetInputStep ()
		{
			IntPtr newStep = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetInputStep (Handle, out newStep));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newStep);
		}

		public void SetScalarOutputName (String AScalarOutputName)
		{
			byte[] byteScalarOutputName = Encoding.UTF8.GetBytes(AScalarOutputName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_SetScalarOutputName (Handle, byteScalarOutputName));
		}

		public String GetScalarOutputName ()
		{
			UInt32 sizeScalarOutputName = 0;
			UInt32 neededScalarOutputName = 0;
			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetScalarOutputName (Handle, sizeScalarOutputName, out neededScalarOutputName, IntPtr.Zero));
			sizeScalarOutputName = neededScalarOutputName;
			byte[] bytesScalarOutputName = new byte[sizeScalarOutputName];
			GCHandle dataScalarOutputName = GCHandle.Alloc(bytesScalarOutputName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetScalarOutputName (Handle, sizeScalarOutputName, out neededScalarOutputName, dataScalarOutputName.AddrOfPinnedObject()));
			dataScalarOutputName.Free();
			return Encoding.UTF8.GetString(bytesScalarOutputName).TrimEnd(char.MinValue);
		}

		public void SetVectorInputName (String AVectorInputName)
		{
			byte[] byteVectorInputName = Encoding.UTF8.GetBytes(AVectorInputName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_SetVectorInputName (Handle, byteVectorInputName));
		}

		public String GetVectorInputName ()
		{
			UInt32 sizeVectorInputName = 0;
			UInt32 neededVectorInputName = 0;
			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetVectorInputName (Handle, sizeVectorInputName, out neededVectorInputName, IntPtr.Zero));
			sizeVectorInputName = neededVectorInputName;
			byte[] bytesVectorInputName = new byte[sizeVectorInputName];
			GCHandle dataVectorInputName = GCHandle.Alloc(bytesVectorInputName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetVectorInputName (Handle, sizeVectorInputName, out neededVectorInputName, dataVectorInputName.AddrOfPinnedObject()));
			dataVectorInputName.Free();
			return Encoding.UTF8.GetString(bytesVectorInputName).TrimEnd(char.MinValue);
		}

		public CImplicitPort GetOutputResult ()
		{
			IntPtr newResult = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.NormalizeDistanceNode_GetOutputResult (Handle, out newResult));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newResult);
		}

	}

	public class CFunctionCallNode : CImplicitNode
	{
		public CFunctionCallNode (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitPort GetInputFunctionID ()
		{
			IntPtr newFunction = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionCallNode_GetInputFunctionID (Handle, out newFunction));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newFunction);
		}

	}

	public class CNodeIterator : CIterator
	{
		public CNodeIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImplicitNode GetCurrent ()
		{
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.NodeIterator_GetCurrent (Handle, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitNode>(newNode);
		}

	}

	public class CFunction : CResource
	{
		public CFunction (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetDisplayName ()
		{
			UInt32 sizeDisplayName = 0;
			UInt32 neededDisplayName = 0;
			CheckError(Internal.Lib3MFWrapper.Function_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, IntPtr.Zero));
			sizeDisplayName = neededDisplayName;
			byte[] bytesDisplayName = new byte[sizeDisplayName];
			GCHandle dataDisplayName = GCHandle.Alloc(bytesDisplayName, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Function_GetDisplayName (Handle, sizeDisplayName, out neededDisplayName, dataDisplayName.AddrOfPinnedObject()));
			dataDisplayName.Free();
			return Encoding.UTF8.GetString(bytesDisplayName).TrimEnd(char.MinValue);
		}

		public void SetDisplayName (String ADisplayName)
		{
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Function_SetDisplayName (Handle, byteDisplayName));
		}

		public CImplicitPort AddInput (String AIdentifier, String ADisplayName, eImplicitPortType AType)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			Int32 enumType = (Int32) AType;
			IntPtr newPort = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_AddInput (Handle, byteIdentifier, byteDisplayName, enumType, out newPort));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPort);
		}

		public CImplicitPortIterator GetInputs ()
		{
			IntPtr newIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_GetInputs (Handle, out newIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPortIterator>(newIterator);
		}

		public void RemoveInput (CImplicitPort AInput)
		{
			IntPtr AInputHandle = IntPtr.Zero;
			if (AInput != null)
				AInputHandle = AInput.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Function_RemoveInput (Handle, AInputHandle));
		}

		public CImplicitPort AddOutput (String AIdentifier, String ADisplayName, eImplicitPortType AType)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			Int32 enumType = (Int32) AType;
			IntPtr newPort = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_AddOutput (Handle, byteIdentifier, byteDisplayName, enumType, out newPort));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newPort);
		}

		public CImplicitPortIterator GetOutputs ()
		{
			IntPtr newIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_GetOutputs (Handle, out newIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPortIterator>(newIterator);
		}

		public void RemoveOutput (CImplicitPort AOutput)
		{
			IntPtr AOutputHandle = IntPtr.Zero;
			if (AOutput != null)
				AOutputHandle = AOutput.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Function_RemoveOutput (Handle, AOutputHandle));
		}

		public CImplicitPort FindInput (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newInput = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_FindInput (Handle, byteIdentifier, out newInput));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newInput);
		}

		public CImplicitPort FindOutput (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			IntPtr newOutput = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Function_FindOutput (Handle, byteIdentifier, out newOutput));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitPort>(newOutput);
		}

	}

	public class CImplicitFunction : CFunction
	{
		public CImplicitFunction (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetIdentifier ()
		{
			UInt32 sizeIdentifier = 0;
			UInt32 neededIdentifier = 0;
			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, IntPtr.Zero));
			sizeIdentifier = neededIdentifier;
			byte[] bytesIdentifier = new byte[sizeIdentifier];
			GCHandle dataIdentifier = GCHandle.Alloc(bytesIdentifier, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_GetIdentifier (Handle, sizeIdentifier, out neededIdentifier, dataIdentifier.AddrOfPinnedObject()));
			dataIdentifier.Free();
			return Encoding.UTF8.GetString(bytesIdentifier).TrimEnd(char.MinValue);
		}

		public void SetIdentifier (String AIdentifier)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_SetIdentifier (Handle, byteIdentifier));
		}

		public CImplicitNode AddNode (eImplicitNodeType ANodeType, String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			Int32 enumNodeType = (Int32) ANodeType;
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddNode (Handle, enumNodeType, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitNode>(newNode);
		}

		public CSinNode AddSinNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSinNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSinNode>(newNode);
		}

		public CCosNode AddCosNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddCosNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCosNode>(newNode);
		}

		public CTanNode AddTanNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddTanNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTanNode>(newNode);
		}

		public CArcSinNode AddArcSinNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddArcSinNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CArcSinNode>(newNode);
		}

		public CArcCosNode AddArcCosNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddArcCosNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CArcCosNode>(newNode);
		}

		public CArcTan2Node AddArcTan2Node (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddArcTan2Node (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CArcTan2Node>(newNode);
		}

		public CSinhNode AddSinhNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSinhNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSinhNode>(newNode);
		}

		public CCoshNode AddCoshNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddCoshNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCoshNode>(newNode);
		}

		public CTanhNode AddTanhNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddTanhNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTanhNode>(newNode);
		}

		public CRoundNode AddRoundNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddRoundNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CRoundNode>(newNode);
		}

		public CCeilNode AddCeilNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddCeilNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCeilNode>(newNode);
		}

		public CFloorNode AddFloorNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddFloorNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFloorNode>(newNode);
		}

		public CSignNode AddSignNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSignNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSignNode>(newNode);
		}

		public CFractNode AddFractNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddFractNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFractNode>(newNode);
		}

		public CAbsNode AddAbsNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddAbsNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAbsNode>(newNode);
		}

		public CExpNode AddExpNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddExpNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CExpNode>(newNode);
		}

		public CLogNode AddLogNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLogNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLogNode>(newNode);
		}

		public CLog2Node AddLog2Node (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLog2Node (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLog2Node>(newNode);
		}

		public CLog10Node AddLog10Node (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLog10Node (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLog10Node>(newNode);
		}

		public CLengthNode AddLengthNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLengthNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLengthNode>(newNode);
		}

		public CTransposeNode AddTransposeNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddTransposeNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTransposeNode>(newNode);
		}

		public CInverseNode AddInverseNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddInverseNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CInverseNode>(newNode);
		}

		public CSqrtNode AddSqrtNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSqrtNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSqrtNode>(newNode);
		}

		public CResourceIdNode AddResourceIdNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddResourceIdNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceIdNode>(newNode);
		}

		public CAdditionNode AddAdditionNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddAdditionNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAdditionNode>(newNode);
		}

		public CSubtractionNode AddSubtractionNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSubtractionNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSubtractionNode>(newNode);
		}

		public CMultiplicationNode AddMultiplicationNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMultiplicationNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMultiplicationNode>(newNode);
		}

		public CDivisionNode AddDivisionNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddDivisionNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CDivisionNode>(newNode);
		}

		public CDotNode AddDotNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddDotNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CDotNode>(newNode);
		}

		public CCrossNode AddCrossNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddCrossNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCrossNode>(newNode);
		}

		public CMatVecMultiplicationNode AddMatVecMultiplicationNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMatVecMultiplicationNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMatVecMultiplicationNode>(newNode);
		}

		public CMinNode AddMinNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMinNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMinNode>(newNode);
		}

		public CMaxNode AddMaxNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMaxNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMaxNode>(newNode);
		}

		public CFmodNode AddFmodNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddFmodNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFmodNode>(newNode);
		}

		public CPowNode AddPowNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddPowNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPowNode>(newNode);
		}

		public CSelectNode AddSelectNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddSelectNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSelectNode>(newNode);
		}

		public CClampNode AddClampNode (String AIdentifier, eImplicitNodeConfiguration AConfiguration, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			Int32 enumConfiguration = (Int32) AConfiguration;
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddClampNode (Handle, byteIdentifier, enumConfiguration, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CClampNode>(newNode);
		}

		public CComposeVectorNode AddComposeVectorNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddComposeVectorNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComposeVectorNode>(newNode);
		}

		public CVectorFromScalarNode AddVectorFromScalarNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddVectorFromScalarNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVectorFromScalarNode>(newNode);
		}

		public CDecomposeVectorNode AddDecomposeVectorNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddDecomposeVectorNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CDecomposeVectorNode>(newNode);
		}

		public CComposeMatrixNode AddComposeMatrixNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddComposeMatrixNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComposeMatrixNode>(newNode);
		}

		public CMatrixFromRowsNode AddMatrixFromRowsNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMatrixFromRowsNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMatrixFromRowsNode>(newNode);
		}

		public CMatrixFromColumnsNode AddMatrixFromColumnsNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMatrixFromColumnsNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMatrixFromColumnsNode>(newNode);
		}

		public CConstantNode AddConstantNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddConstantNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConstantNode>(newNode);
		}

		public CConstVecNode AddConstVecNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddConstVecNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConstVecNode>(newNode);
		}

		public CConstMatNode AddConstMatNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddConstMatNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConstMatNode>(newNode);
		}

		public CMeshNode AddMeshNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddMeshNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshNode>(newNode);
		}

		public CUnsignedMeshNode AddUnsignedMeshNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddUnsignedMeshNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CUnsignedMeshNode>(newNode);
		}

		public CBeamLatticeNode AddBeamLatticeNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddBeamLatticeNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBeamLatticeNode>(newNode);
		}

		public CFunctionGradientNode AddFunctionGradientNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddFunctionGradientNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunctionGradientNode>(newNode);
		}

		public CNormalizeDistanceNode AddNormalizeDistanceNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddNormalizeDistanceNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CNormalizeDistanceNode>(newNode);
		}

		public CFunctionCallNode AddFunctionCallNode (String AIdentifier, String ADisplayName, String ATag)
		{
			byte[] byteIdentifier = Encoding.UTF8.GetBytes(AIdentifier + char.MinValue);
			byte[] byteDisplayName = Encoding.UTF8.GetBytes(ADisplayName + char.MinValue);
			byte[] byteTag = Encoding.UTF8.GetBytes(ATag + char.MinValue);
			IntPtr newNode = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddFunctionCallNode (Handle, byteIdentifier, byteDisplayName, byteTag, out newNode));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunctionCallNode>(newNode);
		}

		public CNodeIterator GetNodes ()
		{
			IntPtr newIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_GetNodes (Handle, out newIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CNodeIterator>(newIterator);
		}

		public void RemoveNode (CImplicitNode ANode)
		{
			IntPtr ANodeHandle = IntPtr.Zero;
			if (ANode != null)
				ANodeHandle = ANode.GetHandle();

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_RemoveNode (Handle, ANodeHandle));
		}

		public void AddLink (CImplicitPort ASource, CImplicitPort ATarget)
		{
			IntPtr ASourceHandle = IntPtr.Zero;
			if (ASource != null)
				ASourceHandle = ASource.GetHandle();
			IntPtr ATargetHandle = IntPtr.Zero;
			if (ATarget != null)
				ATargetHandle = ATarget.GetHandle();

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLink (Handle, ASourceHandle, ATargetHandle));
		}

		public void AddLinkByNames (String ASource, String ATarget)
		{
			byte[] byteSource = Encoding.UTF8.GetBytes(ASource + char.MinValue);
			byte[] byteTarget = Encoding.UTF8.GetBytes(ATarget + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_AddLinkByNames (Handle, byteSource, byteTarget));
		}

		public void Clear ()
		{

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_Clear (Handle));
		}

		public void SortNodesTopologically ()
		{

			CheckError(Internal.Lib3MFWrapper.ImplicitFunction_SortNodesTopologically (Handle));
		}

	}

	public class CFunctionFromImage3D : CFunction
	{
		public CFunctionFromImage3D (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CImage3D GetImage3D ()
		{
			IntPtr newImage3D = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_GetImage3D (Handle, out newImage3D));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImage3D>(newImage3D);
		}

		public void SetImage3D (CImage3D AImage3D)
		{
			IntPtr AImage3DHandle = IntPtr.Zero;
			if (AImage3D != null)
				AImage3DHandle = AImage3D.GetHandle();

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_SetImage3D (Handle, AImage3DHandle));
		}

		public void SetFilter (eTextureFilter AFilter)
		{
			Int32 enumFilter = (Int32) AFilter;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_SetFilter (Handle, enumFilter));
		}

		public eTextureFilter GetFilter ()
		{
			Int32 resultFilter = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_GetFilter (Handle, out resultFilter));
			return (eTextureFilter) (resultFilter);
		}

		public void SetTileStyles (eTextureTileStyle ATileStyleU, eTextureTileStyle ATileStyleV, eTextureTileStyle ATileStyleW)
		{
			Int32 enumTileStyleU = (Int32) ATileStyleU;
			Int32 enumTileStyleV = (Int32) ATileStyleV;
			Int32 enumTileStyleW = (Int32) ATileStyleW;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_SetTileStyles (Handle, enumTileStyleU, enumTileStyleV, enumTileStyleW));
		}

		public void GetTileStyles (out eTextureTileStyle ATileStyleU, out eTextureTileStyle ATileStyleV, out eTextureTileStyle ATileStyleW)
		{
			Int32 resultTileStyleU = 0;
			Int32 resultTileStyleV = 0;
			Int32 resultTileStyleW = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_GetTileStyles (Handle, out resultTileStyleU, out resultTileStyleV, out resultTileStyleW));
			ATileStyleU = (eTextureTileStyle) (resultTileStyleU);
			ATileStyleV = (eTextureTileStyle) (resultTileStyleV);
			ATileStyleW = (eTextureTileStyle) (resultTileStyleW);
		}

		public Double GetOffset ()
		{
			Double resultOffset = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_GetOffset (Handle, out resultOffset));
			return resultOffset;
		}

		public void SetOffset (Double AOffset)
		{

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_SetOffset (Handle, AOffset));
		}

		public Double GetScale ()
		{
			Double resultScale = 0;

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_GetScale (Handle, out resultScale));
			return resultScale;
		}

		public void SetScale (Double AScale)
		{

			CheckError(Internal.Lib3MFWrapper.FunctionFromImage3D_SetScale (Handle, AScale));
		}

	}

	public class CBuildItem : CBase
	{
		public CBuildItem (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CObject GetObjectResource ()
		{
			IntPtr newObjectResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetObjectResource (Handle, out newObjectResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CObject>(newObjectResource);
		}

		public String GetUUID (out bool AHasUUID)
		{
			Byte resultHasUUID = 0;
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.BuildItem_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			AHasUUID = (resultHasUUID != 0);
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public void SetUUID (String AUUID)
		{
			byte[] byteUUID = Encoding.UTF8.GetBytes(AUUID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.BuildItem_SetUUID (Handle, byteUUID));
		}

		public UInt32 GetObjectResourceID ()
		{
			UInt32 resultUniqueResourceID = 0;

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetObjectResourceID (Handle, out resultUniqueResourceID));
			return resultUniqueResourceID;
		}

		public bool HasObjectTransform ()
		{
			Byte resultHasTransform = 0;

			CheckError(Internal.Lib3MFWrapper.BuildItem_HasObjectTransform (Handle, out resultHasTransform));
			return (resultHasTransform != 0);
		}

		public sTransform GetObjectTransform ()
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetObjectTransform (Handle, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public void SetObjectTransform (sTransform ATransform)
		{
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);

			CheckError(Internal.Lib3MFWrapper.BuildItem_SetObjectTransform (Handle, ref intTransform));
		}

		public String GetPartNumber ()
		{
			UInt32 sizePartNumber = 0;
			UInt32 neededPartNumber = 0;
			CheckError(Internal.Lib3MFWrapper.BuildItem_GetPartNumber (Handle, sizePartNumber, out neededPartNumber, IntPtr.Zero));
			sizePartNumber = neededPartNumber;
			byte[] bytesPartNumber = new byte[sizePartNumber];
			GCHandle dataPartNumber = GCHandle.Alloc(bytesPartNumber, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetPartNumber (Handle, sizePartNumber, out neededPartNumber, dataPartNumber.AddrOfPinnedObject()));
			dataPartNumber.Free();
			return Encoding.UTF8.GetString(bytesPartNumber).TrimEnd(char.MinValue);
		}

		public void SetPartNumber (String ASetPartnumber)
		{
			byte[] byteSetPartnumber = Encoding.UTF8.GetBytes(ASetPartnumber + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.BuildItem_SetPartNumber (Handle, byteSetPartnumber));
		}

		public CMetaDataGroup GetMetaDataGroup ()
		{
			IntPtr newMetaDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetMetaDataGroup (Handle, out newMetaDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaDataGroup>(newMetaDataGroup);
		}

		public sBox GetOutbox ()
		{
			Internal.InternalBox intresultOutbox;

			CheckError(Internal.Lib3MFWrapper.BuildItem_GetOutbox (Handle, out intresultOutbox));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Box (intresultOutbox);
		}

	}

	public class CBuildItemIterator : CBase
	{
		public CBuildItemIterator (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public bool MoveNext ()
		{
			Byte resultHasNext = 0;

			CheckError(Internal.Lib3MFWrapper.BuildItemIterator_MoveNext (Handle, out resultHasNext));
			return (resultHasNext != 0);
		}

		public bool MovePrevious ()
		{
			Byte resultHasPrevious = 0;

			CheckError(Internal.Lib3MFWrapper.BuildItemIterator_MovePrevious (Handle, out resultHasPrevious));
			return (resultHasPrevious != 0);
		}

		public CBuildItem GetCurrent ()
		{
			IntPtr newBuildItem = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BuildItemIterator_GetCurrent (Handle, out newBuildItem));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBuildItem>(newBuildItem);
		}

		public CBuildItemIterator Clone ()
		{
			IntPtr newOutBuildItemIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.BuildItemIterator_Clone (Handle, out newOutBuildItemIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBuildItemIterator>(newOutBuildItemIterator);
		}

		public UInt64 Count ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.BuildItemIterator_Count (Handle, out resultCount));
			return resultCount;
		}

	}

	public class CSlice : CBase
	{
		public CSlice (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public void SetVertices (sPosition2D[] AVertices)
		{
			Internal.InternalPosition2D[] intdataVertices = new Internal.InternalPosition2D[AVertices.Length];
			for (int index = 0; index < AVertices.Length; index++)
				intdataVertices[index] = Internal.Lib3MFWrapper.convertStructToInternal_Position2D(AVertices[index]);
			GCHandle dataVertices = GCHandle.Alloc(intdataVertices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Slice_SetVertices (Handle, (UInt64) AVertices.Length, dataVertices.AddrOfPinnedObject()));
			dataVertices.Free ();
		}

		public void GetVertices (out sPosition2D[] AVertices)
		{
			UInt64 sizeVertices = 0;
			UInt64 neededVertices = 0;
			CheckError(Internal.Lib3MFWrapper.Slice_GetVertices (Handle, sizeVertices, out neededVertices, IntPtr.Zero));
			sizeVertices = neededVertices;
			var arrayVertices = new Internal.InternalPosition2D[sizeVertices];
			GCHandle dataVertices = GCHandle.Alloc(arrayVertices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Slice_GetVertices (Handle, sizeVertices, out neededVertices, dataVertices.AddrOfPinnedObject()));
			dataVertices.Free();
			AVertices = new sPosition2D[sizeVertices];
			for (int index = 0; index < AVertices.Length; index++)
				AVertices[index] = Internal.Lib3MFWrapper.convertInternalToStruct_Position2D(arrayVertices[index]);
		}

		public UInt64 GetVertexCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Slice_GetVertexCount (Handle, out resultCount));
			return resultCount;
		}

		public UInt64 AddPolygon (UInt32[] AIndices)
		{
			GCHandle dataIndices = GCHandle.Alloc(AIndices, GCHandleType.Pinned);
			UInt64 resultIndex = 0;

			CheckError(Internal.Lib3MFWrapper.Slice_AddPolygon (Handle, (UInt64) AIndices.Length, dataIndices.AddrOfPinnedObject(), out resultIndex));
			dataIndices.Free ();
			return resultIndex;
		}

		public UInt64 GetPolygonCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Slice_GetPolygonCount (Handle, out resultCount));
			return resultCount;
		}

		public void SetPolygonIndices (UInt64 AIndex, UInt32[] AIndices)
		{
			GCHandle dataIndices = GCHandle.Alloc(AIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Slice_SetPolygonIndices (Handle, AIndex, (UInt64) AIndices.Length, dataIndices.AddrOfPinnedObject()));
			dataIndices.Free ();
		}

		public void GetPolygonIndices (UInt64 AIndex, out UInt32[] AIndices)
		{
			UInt64 sizeIndices = 0;
			UInt64 neededIndices = 0;
			CheckError(Internal.Lib3MFWrapper.Slice_GetPolygonIndices (Handle, AIndex, sizeIndices, out neededIndices, IntPtr.Zero));
			sizeIndices = neededIndices;
			AIndices = new UInt32[sizeIndices];
			GCHandle dataIndices = GCHandle.Alloc(AIndices, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Slice_GetPolygonIndices (Handle, AIndex, sizeIndices, out neededIndices, dataIndices.AddrOfPinnedObject()));
			dataIndices.Free();
		}

		public UInt64 GetPolygonIndexCount (UInt64 AIndex)
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.Slice_GetPolygonIndexCount (Handle, AIndex, out resultCount));
			return resultCount;
		}

		public Double GetZTop ()
		{
			Double resultZTop = 0;

			CheckError(Internal.Lib3MFWrapper.Slice_GetZTop (Handle, out resultZTop));
			return resultZTop;
		}

	}

	public class CSliceStack : CResource
	{
		public CSliceStack (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public Double GetBottomZ ()
		{
			Double resultZBottom = 0;

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetBottomZ (Handle, out resultZBottom));
			return resultZBottom;
		}

		public UInt64 GetSliceCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetSliceCount (Handle, out resultCount));
			return resultCount;
		}

		public CSlice GetSlice (UInt64 ASliceIndex)
		{
			IntPtr newTheSlice = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetSlice (Handle, ASliceIndex, out newTheSlice));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSlice>(newTheSlice);
		}

		public CSlice AddSlice (Double AZTop)
		{
			IntPtr newTheSlice = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SliceStack_AddSlice (Handle, AZTop, out newTheSlice));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSlice>(newTheSlice);
		}

		public UInt64 GetSliceRefCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetSliceRefCount (Handle, out resultCount));
			return resultCount;
		}

		public void AddSliceStackReference (CSliceStack ATheSliceStack)
		{
			IntPtr ATheSliceStackHandle = IntPtr.Zero;
			if (ATheSliceStack != null)
				ATheSliceStackHandle = ATheSliceStack.GetHandle();

			CheckError(Internal.Lib3MFWrapper.SliceStack_AddSliceStackReference (Handle, ATheSliceStackHandle));
		}

		public CSliceStack GetSliceStackReference (UInt64 ASliceRefIndex)
		{
			IntPtr newTheSliceStack = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetSliceStackReference (Handle, ASliceRefIndex, out newTheSliceStack));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStack>(newTheSliceStack);
		}

		public void CollapseSliceReferences ()
		{

			CheckError(Internal.Lib3MFWrapper.SliceStack_CollapseSliceReferences (Handle));
		}

		public void SetOwnPath (String APath)
		{
			byte[] bytePath = Encoding.UTF8.GetBytes(APath + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.SliceStack_SetOwnPath (Handle, bytePath));
		}

		public String GetOwnPath ()
		{
			UInt32 sizePath = 0;
			UInt32 neededPath = 0;
			CheckError(Internal.Lib3MFWrapper.SliceStack_GetOwnPath (Handle, sizePath, out neededPath, IntPtr.Zero));
			sizePath = neededPath;
			byte[] bytesPath = new byte[sizePath];
			GCHandle dataPath = GCHandle.Alloc(bytesPath, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.SliceStack_GetOwnPath (Handle, sizePath, out neededPath, dataPath.AddrOfPinnedObject()));
			dataPath.Free();
			return Encoding.UTF8.GetString(bytesPath).TrimEnd(char.MinValue);
		}

	}

	public class CConsumer : CBase
	{
		public CConsumer (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetConsumerID ()
		{
			UInt32 sizeConsumerID = 0;
			UInt32 neededConsumerID = 0;
			CheckError(Internal.Lib3MFWrapper.Consumer_GetConsumerID (Handle, sizeConsumerID, out neededConsumerID, IntPtr.Zero));
			sizeConsumerID = neededConsumerID;
			byte[] bytesConsumerID = new byte[sizeConsumerID];
			GCHandle dataConsumerID = GCHandle.Alloc(bytesConsumerID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Consumer_GetConsumerID (Handle, sizeConsumerID, out neededConsumerID, dataConsumerID.AddrOfPinnedObject()));
			dataConsumerID.Free();
			return Encoding.UTF8.GetString(bytesConsumerID).TrimEnd(char.MinValue);
		}

		public String GetKeyID ()
		{
			UInt32 sizeKeyID = 0;
			UInt32 neededKeyID = 0;
			CheckError(Internal.Lib3MFWrapper.Consumer_GetKeyID (Handle, sizeKeyID, out neededKeyID, IntPtr.Zero));
			sizeKeyID = neededKeyID;
			byte[] bytesKeyID = new byte[sizeKeyID];
			GCHandle dataKeyID = GCHandle.Alloc(bytesKeyID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Consumer_GetKeyID (Handle, sizeKeyID, out neededKeyID, dataKeyID.AddrOfPinnedObject()));
			dataKeyID.Free();
			return Encoding.UTF8.GetString(bytesKeyID).TrimEnd(char.MinValue);
		}

		public String GetKeyValue ()
		{
			UInt32 sizeKeyValue = 0;
			UInt32 neededKeyValue = 0;
			CheckError(Internal.Lib3MFWrapper.Consumer_GetKeyValue (Handle, sizeKeyValue, out neededKeyValue, IntPtr.Zero));
			sizeKeyValue = neededKeyValue;
			byte[] bytesKeyValue = new byte[sizeKeyValue];
			GCHandle dataKeyValue = GCHandle.Alloc(bytesKeyValue, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Consumer_GetKeyValue (Handle, sizeKeyValue, out neededKeyValue, dataKeyValue.AddrOfPinnedObject()));
			dataKeyValue.Free();
			return Encoding.UTF8.GetString(bytesKeyValue).TrimEnd(char.MinValue);
		}

	}

	public class CAccessRight : CBase
	{
		public CAccessRight (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CConsumer GetConsumer ()
		{
			IntPtr newConsumer = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.AccessRight_GetConsumer (Handle, out newConsumer));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConsumer>(newConsumer);
		}

		public eWrappingAlgorithm GetWrappingAlgorithm ()
		{
			Int32 resultAlgorithm = 0;

			CheckError(Internal.Lib3MFWrapper.AccessRight_GetWrappingAlgorithm (Handle, out resultAlgorithm));
			return (eWrappingAlgorithm) (resultAlgorithm);
		}

		public eMgfAlgorithm GetMgfAlgorithm ()
		{
			Int32 resultAlgorithm = 0;

			CheckError(Internal.Lib3MFWrapper.AccessRight_GetMgfAlgorithm (Handle, out resultAlgorithm));
			return (eMgfAlgorithm) (resultAlgorithm);
		}

		public eDigestMethod GetDigestMethod ()
		{
			Int32 resultAlgorithm = 0;

			CheckError(Internal.Lib3MFWrapper.AccessRight_GetDigestMethod (Handle, out resultAlgorithm));
			return (eDigestMethod) (resultAlgorithm);
		}

	}

	public class CContentEncryptionParams : CBase
	{
		public CContentEncryptionParams (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public eEncryptionAlgorithm GetEncryptionAlgorithm ()
		{
			Int32 resultAlgorithm = 0;

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetEncryptionAlgorithm (Handle, out resultAlgorithm));
			return (eEncryptionAlgorithm) (resultAlgorithm);
		}

		public void GetKey (out Byte[] AByteData)
		{
			UInt64 sizeByteData = 0;
			UInt64 neededByteData = 0;
			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetKey (Handle, sizeByteData, out neededByteData, IntPtr.Zero));
			sizeByteData = neededByteData;
			AByteData = new Byte[sizeByteData];
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetKey (Handle, sizeByteData, out neededByteData, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free();
		}

		public void GetInitializationVector (out Byte[] AByteData)
		{
			UInt64 sizeByteData = 0;
			UInt64 neededByteData = 0;
			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetInitializationVector (Handle, sizeByteData, out neededByteData, IntPtr.Zero));
			sizeByteData = neededByteData;
			AByteData = new Byte[sizeByteData];
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetInitializationVector (Handle, sizeByteData, out neededByteData, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free();
		}

		public void GetAuthenticationTag (out Byte[] AByteData)
		{
			UInt64 sizeByteData = 0;
			UInt64 neededByteData = 0;
			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetAuthenticationTag (Handle, sizeByteData, out neededByteData, IntPtr.Zero));
			sizeByteData = neededByteData;
			AByteData = new Byte[sizeByteData];
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetAuthenticationTag (Handle, sizeByteData, out neededByteData, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free();
		}

		public void SetAuthenticationTag (Byte[] AByteData)
		{
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_SetAuthenticationTag (Handle, (UInt64) AByteData.Length, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free ();
		}

		public void GetAdditionalAuthenticationData (out Byte[] AByteData)
		{
			UInt64 sizeByteData = 0;
			UInt64 neededByteData = 0;
			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetAdditionalAuthenticationData (Handle, sizeByteData, out neededByteData, IntPtr.Zero));
			sizeByteData = neededByteData;
			AByteData = new Byte[sizeByteData];
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetAdditionalAuthenticationData (Handle, sizeByteData, out neededByteData, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free();
		}

		public UInt64 GetDescriptor ()
		{
			UInt64 resultDescriptor = 0;

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetDescriptor (Handle, out resultDescriptor));
			return resultDescriptor;
		}

		public String GetKeyUUID ()
		{
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetKeyUUID (Handle, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ContentEncryptionParams_GetKeyUUID (Handle, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

	}

	public class CResourceData : CBase
	{
		public CResourceData (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CPackagePart GetPath ()
		{
			IntPtr newPath = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceData_GetPath (Handle, out newPath));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPackagePart>(newPath);
		}

		public eEncryptionAlgorithm GetEncryptionAlgorithm ()
		{
			Int32 resultEncryptionAlgorithm = 0;

			CheckError(Internal.Lib3MFWrapper.ResourceData_GetEncryptionAlgorithm (Handle, out resultEncryptionAlgorithm));
			return (eEncryptionAlgorithm) (resultEncryptionAlgorithm);
		}

		public eCompression GetCompression ()
		{
			Int32 resultCompression = 0;

			CheckError(Internal.Lib3MFWrapper.ResourceData_GetCompression (Handle, out resultCompression));
			return (eCompression) (resultCompression);
		}

		public void GetAdditionalAuthenticationData (out Byte[] AByteData)
		{
			UInt64 sizeByteData = 0;
			UInt64 neededByteData = 0;
			CheckError(Internal.Lib3MFWrapper.ResourceData_GetAdditionalAuthenticationData (Handle, sizeByteData, out neededByteData, IntPtr.Zero));
			sizeByteData = neededByteData;
			AByteData = new Byte[sizeByteData];
			GCHandle dataByteData = GCHandle.Alloc(AByteData, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ResourceData_GetAdditionalAuthenticationData (Handle, sizeByteData, out neededByteData, dataByteData.AddrOfPinnedObject()));
			dataByteData.Free();
		}

	}

	public class CResourceDataGroup : CBase
	{
		public CResourceDataGroup (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public String GetKeyUUID ()
		{
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.ResourceDataGroup_GetKeyUUID (Handle, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.ResourceDataGroup_GetKeyUUID (Handle, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public CAccessRight AddAccessRight (CConsumer AConsumer, eWrappingAlgorithm AWrappingAlgorithm, eMgfAlgorithm AMgfAlgorithm, eDigestMethod ADigestMethod)
		{
			IntPtr AConsumerHandle = IntPtr.Zero;
			if (AConsumer != null)
				AConsumerHandle = AConsumer.GetHandle();
			Int32 enumWrappingAlgorithm = (Int32) AWrappingAlgorithm;
			Int32 enumMgfAlgorithm = (Int32) AMgfAlgorithm;
			Int32 enumDigestMethod = (Int32) ADigestMethod;
			IntPtr newTheAccessRight = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceDataGroup_AddAccessRight (Handle, AConsumerHandle, enumWrappingAlgorithm, enumMgfAlgorithm, enumDigestMethod, out newTheAccessRight));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAccessRight>(newTheAccessRight);
		}

		public CAccessRight FindAccessRightByConsumer (CConsumer AConsumer)
		{
			IntPtr AConsumerHandle = IntPtr.Zero;
			if (AConsumer != null)
				AConsumerHandle = AConsumer.GetHandle();
			IntPtr newTheAccessRight = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.ResourceDataGroup_FindAccessRightByConsumer (Handle, AConsumerHandle, out newTheAccessRight));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAccessRight>(newTheAccessRight);
		}

		public void RemoveAccessRight (CConsumer AConsumer)
		{
			IntPtr AConsumerHandle = IntPtr.Zero;
			if (AConsumer != null)
				AConsumerHandle = AConsumer.GetHandle();

			CheckError(Internal.Lib3MFWrapper.ResourceDataGroup_RemoveAccessRight (Handle, AConsumerHandle));
		}

	}

	public class CKeyStore : CBase
	{
		public CKeyStore (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CConsumer AddConsumer (String AConsumerID, String AKeyID, String AKeyValue)
		{
			byte[] byteConsumerID = Encoding.UTF8.GetBytes(AConsumerID + char.MinValue);
			byte[] byteKeyID = Encoding.UTF8.GetBytes(AKeyID + char.MinValue);
			byte[] byteKeyValue = Encoding.UTF8.GetBytes(AKeyValue + char.MinValue);
			IntPtr newConsumer = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_AddConsumer (Handle, byteConsumerID, byteKeyID, byteKeyValue, out newConsumer));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConsumer>(newConsumer);
		}

		public UInt64 GetConsumerCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetConsumerCount (Handle, out resultCount));
			return resultCount;
		}

		public CConsumer GetConsumer (UInt64 AConsumerIndex)
		{
			IntPtr newConsumer = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetConsumer (Handle, AConsumerIndex, out newConsumer));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConsumer>(newConsumer);
		}

		public void RemoveConsumer (CConsumer AConsumer)
		{
			IntPtr AConsumerHandle = IntPtr.Zero;
			if (AConsumer != null)
				AConsumerHandle = AConsumer.GetHandle();

			CheckError(Internal.Lib3MFWrapper.KeyStore_RemoveConsumer (Handle, AConsumerHandle));
		}

		public CConsumer FindConsumer (String AConsumerID)
		{
			byte[] byteConsumerID = Encoding.UTF8.GetBytes(AConsumerID + char.MinValue);
			IntPtr newConsumer = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_FindConsumer (Handle, byteConsumerID, out newConsumer));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CConsumer>(newConsumer);
		}

		public UInt64 GetResourceDataGroupCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetResourceDataGroupCount (Handle, out resultCount));
			return resultCount;
		}

		public CResourceDataGroup AddResourceDataGroup ()
		{
			IntPtr newResourceDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_AddResourceDataGroup (Handle, out newResourceDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceDataGroup>(newResourceDataGroup);
		}

		public CResourceDataGroup GetResourceDataGroup (UInt64 AResourceDataIndex)
		{
			IntPtr newResourceDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetResourceDataGroup (Handle, AResourceDataIndex, out newResourceDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceDataGroup>(newResourceDataGroup);
		}

		public void RemoveResourceDataGroup (CResourceDataGroup AResourceDataGroup)
		{
			IntPtr AResourceDataGroupHandle = IntPtr.Zero;
			if (AResourceDataGroup != null)
				AResourceDataGroupHandle = AResourceDataGroup.GetHandle();

			CheckError(Internal.Lib3MFWrapper.KeyStore_RemoveResourceDataGroup (Handle, AResourceDataGroupHandle));
		}

		public CResourceDataGroup FindResourceDataGroup (CPackagePart APartPath)
		{
			IntPtr APartPathHandle = IntPtr.Zero;
			if (APartPath != null)
				APartPathHandle = APartPath.GetHandle();
			IntPtr newResourceDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_FindResourceDataGroup (Handle, APartPathHandle, out newResourceDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceDataGroup>(newResourceDataGroup);
		}

		public CResourceData AddResourceData (CResourceDataGroup AResourceDataGroup, CPackagePart APartPath, eEncryptionAlgorithm AAlgorithm, eCompression ACompression, Byte[] AAdditionalAuthenticationData)
		{
			IntPtr AResourceDataGroupHandle = IntPtr.Zero;
			if (AResourceDataGroup != null)
				AResourceDataGroupHandle = AResourceDataGroup.GetHandle();
			IntPtr APartPathHandle = IntPtr.Zero;
			if (APartPath != null)
				APartPathHandle = APartPath.GetHandle();
			Int32 enumAlgorithm = (Int32) AAlgorithm;
			Int32 enumCompression = (Int32) ACompression;
			GCHandle dataAdditionalAuthenticationData = GCHandle.Alloc(AAdditionalAuthenticationData, GCHandleType.Pinned);
			IntPtr newResourceData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_AddResourceData (Handle, AResourceDataGroupHandle, APartPathHandle, enumAlgorithm, enumCompression, (UInt64) AAdditionalAuthenticationData.Length, dataAdditionalAuthenticationData.AddrOfPinnedObject(), out newResourceData));
			dataAdditionalAuthenticationData.Free ();
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceData>(newResourceData);
		}

		public void RemoveResourceData (CResourceData AResourceData)
		{
			IntPtr AResourceDataHandle = IntPtr.Zero;
			if (AResourceData != null)
				AResourceDataHandle = AResourceData.GetHandle();

			CheckError(Internal.Lib3MFWrapper.KeyStore_RemoveResourceData (Handle, AResourceDataHandle));
		}

		public CResourceData FindResourceData (CPackagePart AResourcePath)
		{
			IntPtr AResourcePathHandle = IntPtr.Zero;
			if (AResourcePath != null)
				AResourcePathHandle = AResourcePath.GetHandle();
			IntPtr newResourceData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_FindResourceData (Handle, AResourcePathHandle, out newResourceData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceData>(newResourceData);
		}

		public UInt64 GetResourceDataCount ()
		{
			UInt64 resultCount = 0;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetResourceDataCount (Handle, out resultCount));
			return resultCount;
		}

		public CResourceData GetResourceData (UInt64 AResourceDataIndex)
		{
			IntPtr newResourceData = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetResourceData (Handle, AResourceDataIndex, out newResourceData));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceData>(newResourceData);
		}

		public String GetUUID (out bool AHasUUID)
		{
			Byte resultHasUUID = 0;
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.KeyStore_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.KeyStore_GetUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			AHasUUID = (resultHasUUID != 0);
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public void SetUUID (String AUUID)
		{
			byte[] byteUUID = Encoding.UTF8.GetBytes(AUUID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.KeyStore_SetUUID (Handle, byteUUID));
		}

	}

	public class CModel : CBase
	{
		public CModel (IntPtr NewHandle) : base (NewHandle)
		{
		}

		public CPackagePart RootModelPart ()
		{
			IntPtr newRootModelPart = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_RootModelPart (Handle, out newRootModelPart));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPackagePart>(newRootModelPart);
		}

		public CPackagePart FindOrCreatePackagePart (String AAbsolutePath)
		{
			byte[] byteAbsolutePath = Encoding.UTF8.GetBytes(AAbsolutePath + char.MinValue);
			IntPtr newModelPart = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_FindOrCreatePackagePart (Handle, byteAbsolutePath, out newModelPart));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CPackagePart>(newModelPart);
		}

		public void SetUnit (eModelUnit AUnit)
		{
			Int32 enumUnit = (Int32) AUnit;

			CheckError(Internal.Lib3MFWrapper.Model_SetUnit (Handle, enumUnit));
		}

		public eModelUnit GetUnit ()
		{
			Int32 resultUnit = 0;

			CheckError(Internal.Lib3MFWrapper.Model_GetUnit (Handle, out resultUnit));
			return (eModelUnit) (resultUnit);
		}

		public String GetLanguage ()
		{
			UInt32 sizeLanguage = 0;
			UInt32 neededLanguage = 0;
			CheckError(Internal.Lib3MFWrapper.Model_GetLanguage (Handle, sizeLanguage, out neededLanguage, IntPtr.Zero));
			sizeLanguage = neededLanguage;
			byte[] bytesLanguage = new byte[sizeLanguage];
			GCHandle dataLanguage = GCHandle.Alloc(bytesLanguage, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Model_GetLanguage (Handle, sizeLanguage, out neededLanguage, dataLanguage.AddrOfPinnedObject()));
			dataLanguage.Free();
			return Encoding.UTF8.GetString(bytesLanguage).TrimEnd(char.MinValue);
		}

		public void SetLanguage (String ALanguage)
		{
			byte[] byteLanguage = Encoding.UTF8.GetBytes(ALanguage + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Model_SetLanguage (Handle, byteLanguage));
		}

		public CWriter QueryWriter (String AWriterClass)
		{
			byte[] byteWriterClass = Encoding.UTF8.GetBytes(AWriterClass + char.MinValue);
			IntPtr newWriterInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_QueryWriter (Handle, byteWriterClass, out newWriterInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CWriter>(newWriterInstance);
		}

		public CReader QueryReader (String AReaderClass)
		{
			byte[] byteReaderClass = Encoding.UTF8.GetBytes(AReaderClass + char.MinValue);
			IntPtr newReaderInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_QueryReader (Handle, byteReaderClass, out newReaderInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CReader>(newReaderInstance);
		}

		public CResource GetResourceByID (UInt32 AUniqueResourceID)
		{
			IntPtr newResource = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetResourceByID (Handle, AUniqueResourceID, out newResource));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResource>(newResource);
		}

		public CTexture2D GetTexture2DByID (UInt32 AUniqueResourceID)
		{
			IntPtr newTextureInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetTexture2DByID (Handle, AUniqueResourceID, out newTextureInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2D>(newTextureInstance);
		}

		public ePropertyType GetPropertyTypeByID (UInt32 AUniqueResourceID)
		{
			Int32 resultThePropertyType = 0;

			CheckError(Internal.Lib3MFWrapper.Model_GetPropertyTypeByID (Handle, AUniqueResourceID, out resultThePropertyType));
			return (ePropertyType) (resultThePropertyType);
		}

		public CBaseMaterialGroup GetBaseMaterialGroupByID (UInt32 AUniqueResourceID)
		{
			IntPtr newBaseMaterialGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetBaseMaterialGroupByID (Handle, AUniqueResourceID, out newBaseMaterialGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroup>(newBaseMaterialGroupInstance);
		}

		public CTexture2DGroup GetTexture2DGroupByID (UInt32 AUniqueResourceID)
		{
			IntPtr newTexture2DGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetTexture2DGroupByID (Handle, AUniqueResourceID, out newTexture2DGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2DGroup>(newTexture2DGroupInstance);
		}

		public CCompositeMaterials GetCompositeMaterialsByID (UInt32 AUniqueResourceID)
		{
			IntPtr newCompositeMaterialsInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetCompositeMaterialsByID (Handle, AUniqueResourceID, out newCompositeMaterialsInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCompositeMaterials>(newCompositeMaterialsInstance);
		}

		public CMultiPropertyGroup GetMultiPropertyGroupByID (UInt32 AUniqueResourceID)
		{
			IntPtr newMultiPropertyGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetMultiPropertyGroupByID (Handle, AUniqueResourceID, out newMultiPropertyGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMultiPropertyGroup>(newMultiPropertyGroupInstance);
		}

		public CMeshObject GetMeshObjectByID (UInt32 AUniqueResourceID)
		{
			IntPtr newMeshObjectInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetMeshObjectByID (Handle, AUniqueResourceID, out newMeshObjectInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshObject>(newMeshObjectInstance);
		}

		public CComponentsObject GetComponentsObjectByID (UInt32 AUniqueResourceID)
		{
			IntPtr newComponentsObjectInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetComponentsObjectByID (Handle, AUniqueResourceID, out newComponentsObjectInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponentsObject>(newComponentsObjectInstance);
		}

		public CColorGroup GetColorGroupByID (UInt32 AUniqueResourceID)
		{
			IntPtr newColorGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetColorGroupByID (Handle, AUniqueResourceID, out newColorGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CColorGroup>(newColorGroupInstance);
		}

		public CSliceStack GetSliceStackByID (UInt32 AUniqueResourceID)
		{
			IntPtr newSliceStacInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetSliceStackByID (Handle, AUniqueResourceID, out newSliceStacInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStack>(newSliceStacInstance);
		}

		public CLevelSet GetLevelSetByID (UInt32 AUniqueResourceID)
		{
			IntPtr newLevelSetObjectInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetLevelSetByID (Handle, AUniqueResourceID, out newLevelSetObjectInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLevelSet>(newLevelSetObjectInstance);
		}

		public String GetBuildUUID (out bool AHasUUID)
		{
			Byte resultHasUUID = 0;
			UInt32 sizeUUID = 0;
			UInt32 neededUUID = 0;
			CheckError(Internal.Lib3MFWrapper.Model_GetBuildUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, IntPtr.Zero));
			sizeUUID = neededUUID;
			byte[] bytesUUID = new byte[sizeUUID];
			GCHandle dataUUID = GCHandle.Alloc(bytesUUID, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.Model_GetBuildUUID (Handle, out resultHasUUID, sizeUUID, out neededUUID, dataUUID.AddrOfPinnedObject()));
			AHasUUID = (resultHasUUID != 0);
			dataUUID.Free();
			return Encoding.UTF8.GetString(bytesUUID).TrimEnd(char.MinValue);
		}

		public void SetBuildUUID (String AUUID)
		{
			byte[] byteUUID = Encoding.UTF8.GetBytes(AUUID + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Model_SetBuildUUID (Handle, byteUUID));
		}

		public CBuildItemIterator GetBuildItems ()
		{
			IntPtr newBuildItemIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetBuildItems (Handle, out newBuildItemIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBuildItemIterator>(newBuildItemIterator);
		}

		public sBox GetOutbox ()
		{
			Internal.InternalBox intresultOutbox;

			CheckError(Internal.Lib3MFWrapper.Model_GetOutbox (Handle, out intresultOutbox));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Box (intresultOutbox);
		}

		public CResourceIterator GetResources ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetResources (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CResourceIterator>(newResourceIterator);
		}

		public CObjectIterator GetObjects ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetObjects (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CObjectIterator>(newResourceIterator);
		}

		public CMeshObjectIterator GetMeshObjects ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetMeshObjects (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshObjectIterator>(newResourceIterator);
		}

		public CComponentsObjectIterator GetComponentsObjects ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetComponentsObjects (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponentsObjectIterator>(newResourceIterator);
		}

		public CTexture2DIterator GetTexture2Ds ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetTexture2Ds (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2DIterator>(newResourceIterator);
		}

		public CBaseMaterialGroupIterator GetBaseMaterialGroups ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetBaseMaterialGroups (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroupIterator>(newResourceIterator);
		}

		public CColorGroupIterator GetColorGroups ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetColorGroups (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CColorGroupIterator>(newResourceIterator);
		}

		public CTexture2DGroupIterator GetTexture2DGroups ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetTexture2DGroups (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2DGroupIterator>(newResourceIterator);
		}

		public CCompositeMaterialsIterator GetCompositeMaterials ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetCompositeMaterials (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCompositeMaterialsIterator>(newResourceIterator);
		}

		public CMultiPropertyGroupIterator GetMultiPropertyGroups ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetMultiPropertyGroups (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMultiPropertyGroupIterator>(newResourceIterator);
		}

		public CSliceStackIterator GetSliceStacks ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetSliceStacks (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStackIterator>(newResourceIterator);
		}

		public CImage3DIterator GetImage3Ds ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetImage3Ds (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImage3DIterator>(newResourceIterator);
		}

		public CModel MergeToModel ()
		{
			IntPtr newMergedModelInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_MergeToModel (Handle, out newMergedModelInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CModel>(newMergedModelInstance);
		}

		public void MergeFromModel (CModel AModelInstance)
		{
			IntPtr AModelInstanceHandle = IntPtr.Zero;
			if (AModelInstance != null)
				AModelInstanceHandle = AModelInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Model_MergeFromModel (Handle, AModelInstanceHandle));
		}

		public CMeshObject AddMeshObject ()
		{
			IntPtr newMeshObjectInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddMeshObject (Handle, out newMeshObjectInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMeshObject>(newMeshObjectInstance);
		}

		public CComponentsObject AddComponentsObject ()
		{
			IntPtr newComponentsObjectInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddComponentsObject (Handle, out newComponentsObjectInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CComponentsObject>(newComponentsObjectInstance);
		}

		public CSliceStack AddSliceStack (Double AZBottom)
		{
			IntPtr newSliceStackInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddSliceStack (Handle, AZBottom, out newSliceStackInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CSliceStack>(newSliceStackInstance);
		}

		public CTexture2D AddTexture2DFromAttachment (CAttachment ATextureAttachment)
		{
			IntPtr ATextureAttachmentHandle = IntPtr.Zero;
			if (ATextureAttachment != null)
				ATextureAttachmentHandle = ATextureAttachment.GetHandle();
			IntPtr newTexture2DInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddTexture2DFromAttachment (Handle, ATextureAttachmentHandle, out newTexture2DInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2D>(newTexture2DInstance);
		}

		public CBaseMaterialGroup AddBaseMaterialGroup ()
		{
			IntPtr newBaseMaterialGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddBaseMaterialGroup (Handle, out newBaseMaterialGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBaseMaterialGroup>(newBaseMaterialGroupInstance);
		}

		public CColorGroup AddColorGroup ()
		{
			IntPtr newColorGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddColorGroup (Handle, out newColorGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CColorGroup>(newColorGroupInstance);
		}

		public CTexture2DGroup AddTexture2DGroup (CTexture2D ATexture2DInstance)
		{
			IntPtr ATexture2DInstanceHandle = IntPtr.Zero;
			if (ATexture2DInstance != null)
				ATexture2DInstanceHandle = ATexture2DInstance.GetHandle();
			IntPtr newTexture2DGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddTexture2DGroup (Handle, ATexture2DInstanceHandle, out newTexture2DGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CTexture2DGroup>(newTexture2DGroupInstance);
		}

		public CCompositeMaterials AddCompositeMaterials (CBaseMaterialGroup ABaseMaterialGroupInstance)
		{
			IntPtr ABaseMaterialGroupInstanceHandle = IntPtr.Zero;
			if (ABaseMaterialGroupInstance != null)
				ABaseMaterialGroupInstanceHandle = ABaseMaterialGroupInstance.GetHandle();
			IntPtr newCompositeMaterialsInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddCompositeMaterials (Handle, ABaseMaterialGroupInstanceHandle, out newCompositeMaterialsInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CCompositeMaterials>(newCompositeMaterialsInstance);
		}

		public CMultiPropertyGroup AddMultiPropertyGroup ()
		{
			IntPtr newMultiPropertyGroupInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddMultiPropertyGroup (Handle, out newMultiPropertyGroupInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMultiPropertyGroup>(newMultiPropertyGroupInstance);
		}

		public CImageStack AddImageStack (UInt32 AColumnCount, UInt32 ARowCount, UInt32 ASheetCount)
		{
			IntPtr newInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddImageStack (Handle, AColumnCount, ARowCount, ASheetCount, out newInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImageStack>(newInstance);
		}

		public CImageStack GetImageStackByID (UInt32 AUniqueResourceID)
		{
			IntPtr newImageStackInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetImageStackByID (Handle, AUniqueResourceID, out newImageStackInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImageStack>(newImageStackInstance);
		}

		public CBuildItem AddBuildItem (CObject AObject, sTransform ATransform)
		{
			IntPtr AObjectHandle = IntPtr.Zero;
			if (AObject != null)
				AObjectHandle = AObject.GetHandle();
			Internal.InternalTransform intTransform = Internal.Lib3MFWrapper.convertStructToInternal_Transform (ATransform);
			IntPtr newBuildItemInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddBuildItem (Handle, AObjectHandle, ref intTransform, out newBuildItemInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CBuildItem>(newBuildItemInstance);
		}

		public void RemoveBuildItem (CBuildItem ABuildItemInstance)
		{
			IntPtr ABuildItemInstanceHandle = IntPtr.Zero;
			if (ABuildItemInstance != null)
				ABuildItemInstanceHandle = ABuildItemInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Model_RemoveBuildItem (Handle, ABuildItemInstanceHandle));
		}

		public CMetaDataGroup GetMetaDataGroup ()
		{
			IntPtr newTheMetaDataGroup = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetMetaDataGroup (Handle, out newTheMetaDataGroup));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CMetaDataGroup>(newTheMetaDataGroup);
		}

		public CAttachment AddAttachment (String AURI, String ARelationShipType)
		{
			byte[] byteURI = Encoding.UTF8.GetBytes(AURI + char.MinValue);
			byte[] byteRelationShipType = Encoding.UTF8.GetBytes(ARelationShipType + char.MinValue);
			IntPtr newAttachmentInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddAttachment (Handle, byteURI, byteRelationShipType, out newAttachmentInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachmentInstance);
		}

		public void RemoveAttachment (CAttachment AAttachmentInstance)
		{
			IntPtr AAttachmentInstanceHandle = IntPtr.Zero;
			if (AAttachmentInstance != null)
				AAttachmentInstanceHandle = AAttachmentInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Model_RemoveAttachment (Handle, AAttachmentInstanceHandle));
		}

		public CAttachment GetAttachment (UInt32 AIndex)
		{
			IntPtr newAttachmentInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetAttachment (Handle, AIndex, out newAttachmentInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachmentInstance);
		}

		public CAttachment FindAttachment (String AURI)
		{
			byte[] byteURI = Encoding.UTF8.GetBytes(AURI + char.MinValue);
			IntPtr newAttachmentInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_FindAttachment (Handle, byteURI, out newAttachmentInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachmentInstance);
		}

		public UInt32 GetAttachmentCount ()
		{
			UInt32 resultAttachmentCount = 0;

			CheckError(Internal.Lib3MFWrapper.Model_GetAttachmentCount (Handle, out resultAttachmentCount));
			return resultAttachmentCount;
		}

		public bool HasPackageThumbnailAttachment ()
		{
			Byte resultHasThumbnail = 0;

			CheckError(Internal.Lib3MFWrapper.Model_HasPackageThumbnailAttachment (Handle, out resultHasThumbnail));
			return (resultHasThumbnail != 0);
		}

		public CAttachment CreatePackageThumbnailAttachment ()
		{
			IntPtr newAttachment = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_CreatePackageThumbnailAttachment (Handle, out newAttachment));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachment);
		}

		public CAttachment GetPackageThumbnailAttachment ()
		{
			IntPtr newAttachment = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetPackageThumbnailAttachment (Handle, out newAttachment));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CAttachment>(newAttachment);
		}

		public void RemovePackageThumbnailAttachment ()
		{

			CheckError(Internal.Lib3MFWrapper.Model_RemovePackageThumbnailAttachment (Handle));
		}

		public void AddCustomContentType (String AExtension, String AContentType)
		{
			byte[] byteExtension = Encoding.UTF8.GetBytes(AExtension + char.MinValue);
			byte[] byteContentType = Encoding.UTF8.GetBytes(AContentType + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Model_AddCustomContentType (Handle, byteExtension, byteContentType));
		}

		public void RemoveCustomContentType (String AExtension)
		{
			byte[] byteExtension = Encoding.UTF8.GetBytes(AExtension + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.Model_RemoveCustomContentType (Handle, byteExtension));
		}

		public void SetRandomNumberCallback (IntPtr ATheCallback, UInt64 AUserData)
		{

			CheckError(Internal.Lib3MFWrapper.Model_SetRandomNumberCallback (Handle, ATheCallback, AUserData));
		}

		public CKeyStore GetKeyStore ()
		{
			IntPtr newKeyStore = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetKeyStore (Handle, out newKeyStore));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CKeyStore>(newKeyStore);
		}

		public CFunctionIterator GetFunctions ()
		{
			IntPtr newTheResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetFunctions (Handle, out newTheResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunctionIterator>(newTheResourceIterator);
		}

		public CImplicitFunction AddImplicitFunction ()
		{
			IntPtr newFunctionInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddImplicitFunction (Handle, out newFunctionInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CImplicitFunction>(newFunctionInstance);
		}

		public CFunctionFromImage3D AddFunctionFromImage3D (CImage3D AImage3DInstance)
		{
			IntPtr AImage3DInstanceHandle = IntPtr.Zero;
			if (AImage3DInstance != null)
				AImage3DInstanceHandle = AImage3DInstance.GetHandle();
			IntPtr newFunctionInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddFunctionFromImage3D (Handle, AImage3DInstanceHandle, out newFunctionInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CFunctionFromImage3D>(newFunctionInstance);
		}

		public CVolumeData AddVolumeData ()
		{
			IntPtr newVolumeDataInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddVolumeData (Handle, out newVolumeDataInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CVolumeData>(newVolumeDataInstance);
		}

		public CLevelSet AddLevelSet ()
		{
			IntPtr newLevelSetInstance = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_AddLevelSet (Handle, out newLevelSetInstance));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLevelSet>(newLevelSetInstance);
		}

		public CLevelSetIterator GetLevelSets ()
		{
			IntPtr newResourceIterator = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.Model_GetLevelSets (Handle, out newResourceIterator));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CLevelSetIterator>(newResourceIterator);
		}

		public void RemoveResource (CResource AResource)
		{
			IntPtr AResourceHandle = IntPtr.Zero;
			if (AResource != null)
				AResourceHandle = AResource.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Model_RemoveResource (Handle, AResourceHandle));
		}

	}

	public class Wrapper
	{
		private static void CheckError (Int32 errorCode)
		{
			if (errorCode != 0) {
				Internal.Lib3MFWrapper.ThrowError (IntPtr.Zero, errorCode);
			}
		}

		public static void GetLibraryVersion (out UInt32 AMajor, out UInt32 AMinor, out UInt32 AMicro)
		{

			CheckError(Internal.Lib3MFWrapper.GetLibraryVersion (out AMajor, out AMinor, out AMicro));
		}

		public static bool GetPrereleaseInformation (out String APrereleaseInfo)
		{
			Byte resultHasPrereleaseInfo = 0;
			UInt32 sizePrereleaseInfo = 0;
			UInt32 neededPrereleaseInfo = 0;
			CheckError(Internal.Lib3MFWrapper.GetPrereleaseInformation (out resultHasPrereleaseInfo, sizePrereleaseInfo, out neededPrereleaseInfo, IntPtr.Zero));
			sizePrereleaseInfo = neededPrereleaseInfo;
			byte[] bytesPrereleaseInfo = new byte[sizePrereleaseInfo];
			GCHandle dataPrereleaseInfo = GCHandle.Alloc(bytesPrereleaseInfo, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.GetPrereleaseInformation (out resultHasPrereleaseInfo, sizePrereleaseInfo, out neededPrereleaseInfo, dataPrereleaseInfo.AddrOfPinnedObject()));
			dataPrereleaseInfo.Free();
			APrereleaseInfo = Encoding.UTF8.GetString(bytesPrereleaseInfo).TrimEnd(char.MinValue);
			return (resultHasPrereleaseInfo != 0);
		}

		public static bool GetBuildInformation (out String ABuildInformation)
		{
			Byte resultHasBuildInfo = 0;
			UInt32 sizeBuildInformation = 0;
			UInt32 neededBuildInformation = 0;
			CheckError(Internal.Lib3MFWrapper.GetBuildInformation (out resultHasBuildInfo, sizeBuildInformation, out neededBuildInformation, IntPtr.Zero));
			sizeBuildInformation = neededBuildInformation;
			byte[] bytesBuildInformation = new byte[sizeBuildInformation];
			GCHandle dataBuildInformation = GCHandle.Alloc(bytesBuildInformation, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.GetBuildInformation (out resultHasBuildInfo, sizeBuildInformation, out neededBuildInformation, dataBuildInformation.AddrOfPinnedObject()));
			dataBuildInformation.Free();
			ABuildInformation = Encoding.UTF8.GetString(bytesBuildInformation).TrimEnd(char.MinValue);
			return (resultHasBuildInfo != 0);
		}

		public static void GetSpecificationVersion (String ASpecificationURL, out bool AIsSupported, out UInt32 AMajor, out UInt32 AMinor, out UInt32 AMicro)
		{
			byte[] byteSpecificationURL = Encoding.UTF8.GetBytes(ASpecificationURL + char.MinValue);
			Byte resultIsSupported = 0;

			CheckError(Internal.Lib3MFWrapper.GetSpecificationVersion (byteSpecificationURL, out resultIsSupported, out AMajor, out AMinor, out AMicro));
			AIsSupported = (resultIsSupported != 0);
		}

		public static CModel CreateModel ()
		{
			IntPtr newModel = IntPtr.Zero;

			CheckError(Internal.Lib3MFWrapper.CreateModel (out newModel));
			return Internal.Lib3MFWrapper.PolymorphicFactory<CModel>(newModel);
		}

		public static void Release (CBase AInstance)
		{
			IntPtr AInstanceHandle = IntPtr.Zero;
			if (AInstance != null)
				AInstanceHandle = AInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Release (AInstanceHandle));
		}

		public static void Acquire (CBase AInstance)
		{
			IntPtr AInstanceHandle = IntPtr.Zero;
			if (AInstance != null)
				AInstanceHandle = AInstance.GetHandle();

			CheckError(Internal.Lib3MFWrapper.Acquire (AInstanceHandle));
		}

		public static void SetJournal (String AJournalPath)
		{
			byte[] byteJournalPath = Encoding.UTF8.GetBytes(AJournalPath + char.MinValue);

			CheckError(Internal.Lib3MFWrapper.SetJournal (byteJournalPath));
		}

		public static bool GetLastError (CBase AInstance, out String ALastErrorString)
		{
			IntPtr AInstanceHandle = IntPtr.Zero;
			if (AInstance != null)
				AInstanceHandle = AInstance.GetHandle();
			Byte resultHasLastError = 0;
			UInt32 sizeLastErrorString = 0;
			UInt32 neededLastErrorString = 0;
			CheckError(Internal.Lib3MFWrapper.GetLastError (AInstanceHandle, sizeLastErrorString, out neededLastErrorString, IntPtr.Zero, out resultHasLastError));
			sizeLastErrorString = neededLastErrorString;
			byte[] bytesLastErrorString = new byte[sizeLastErrorString];
			GCHandle dataLastErrorString = GCHandle.Alloc(bytesLastErrorString, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.GetLastError (AInstanceHandle, sizeLastErrorString, out neededLastErrorString, dataLastErrorString.AddrOfPinnedObject(), out resultHasLastError));
			dataLastErrorString.Free();
			ALastErrorString = Encoding.UTF8.GetString(bytesLastErrorString).TrimEnd(char.MinValue);
			return (resultHasLastError != 0);
		}

		public static UInt64 GetSymbolLookupMethod ()
		{
			UInt64 resultSymbolLookupMethod = 0;

			CheckError(Internal.Lib3MFWrapper.GetSymbolLookupMethod (out resultSymbolLookupMethod));
			return resultSymbolLookupMethod;
		}

		public static void RetrieveProgressMessage (eProgressIdentifier ATheProgressIdentifier, out String AProgressMessage)
		{
			Int32 enumTheProgressIdentifier = (Int32) ATheProgressIdentifier;
			UInt32 sizeProgressMessage = 0;
			UInt32 neededProgressMessage = 0;
			CheckError(Internal.Lib3MFWrapper.RetrieveProgressMessage (enumTheProgressIdentifier, sizeProgressMessage, out neededProgressMessage, IntPtr.Zero));
			sizeProgressMessage = neededProgressMessage;
			byte[] bytesProgressMessage = new byte[sizeProgressMessage];
			GCHandle dataProgressMessage = GCHandle.Alloc(bytesProgressMessage, GCHandleType.Pinned);

			CheckError(Internal.Lib3MFWrapper.RetrieveProgressMessage (enumTheProgressIdentifier, sizeProgressMessage, out neededProgressMessage, dataProgressMessage.AddrOfPinnedObject()));
			dataProgressMessage.Free();
			AProgressMessage = Encoding.UTF8.GetString(bytesProgressMessage).TrimEnd(char.MinValue);
		}

		public static sColor RGBAToColor (Byte ARed, Byte AGreen, Byte ABlue, Byte AAlpha)
		{
			Internal.InternalColor intresultTheColor;

			CheckError(Internal.Lib3MFWrapper.RGBAToColor (ARed, AGreen, ABlue, AAlpha, out intresultTheColor));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Color (intresultTheColor);
		}

		public static sColor FloatRGBAToColor (Single ARed, Single AGreen, Single ABlue, Single AAlpha)
		{
			Internal.InternalColor intresultTheColor;

			CheckError(Internal.Lib3MFWrapper.FloatRGBAToColor (ARed, AGreen, ABlue, AAlpha, out intresultTheColor));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Color (intresultTheColor);
		}

		public static void ColorToRGBA (sColor ATheColor, out Byte ARed, out Byte AGreen, out Byte ABlue, out Byte AAlpha)
		{
			Internal.InternalColor intTheColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ATheColor);

			CheckError(Internal.Lib3MFWrapper.ColorToRGBA (ref intTheColor, out ARed, out AGreen, out ABlue, out AAlpha));
		}

		public static void ColorToFloatRGBA (sColor ATheColor, out Single ARed, out Single AGreen, out Single ABlue, out Single AAlpha)
		{
			Internal.InternalColor intTheColor = Internal.Lib3MFWrapper.convertStructToInternal_Color (ATheColor);

			CheckError(Internal.Lib3MFWrapper.ColorToFloatRGBA (ref intTheColor, out ARed, out AGreen, out ABlue, out AAlpha));
		}

		public static sTransform GetIdentityTransform ()
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.GetIdentityTransform (out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public static sTransform GetUniformScaleTransform (Single AFactor)
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.GetUniformScaleTransform (AFactor, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public static sTransform GetScaleTransform (Single AFactorX, Single AFactorY, Single AFactorZ)
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.GetScaleTransform (AFactorX, AFactorY, AFactorZ, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

		public static sTransform GetTranslationTransform (Single AVectorX, Single AVectorY, Single AVectorZ)
		{
			Internal.InternalTransform intresultTransform;

			CheckError(Internal.Lib3MFWrapper.GetTranslationTransform (AVectorX, AVectorY, AVectorZ, out intresultTransform));
			return Internal.Lib3MFWrapper.convertInternalToStruct_Transform (intresultTransform);
		}

	}

}
