/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Currency;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class CurrencyJavaType
extends AbstractClassJavaType<Currency> {
    public static final CurrencyJavaType INSTANCE = new CurrencyJavaType();

    public CurrencyJavaType() {
        super(Currency.class);
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Currency;
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Currency value) {
        return value.getCurrencyCode();
    }

    @Override
    public Currency fromString(CharSequence string) {
        return Currency.getInstance(string.toString());
    }

    @Override
    public <X> X unwrap(Currency value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Currency.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.getCurrencyCode();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Currency wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Currency) {
            Currency currency = (Currency)value;
            return currency;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Currency.getInstance(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 3L;
    }
}

