/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.format.JsonDocumentWriter;
import org.hibernate.type.format.StringJsonDocument;
import org.hibernate.type.format.StringJsonDocumentMarker;

public class StringJsonDocumentWriter
extends StringJsonDocument
implements JsonDocumentWriter {
    private final JsonAppender appender;

    public StringJsonDocumentWriter() {
        this(new StringBuilder());
    }

    public StringJsonDocumentWriter(StringBuilder sb) {
        this.processingStates.push(StringJsonDocument.JsonProcessingState.NONE);
        this.appender = new JsonAppender(sb);
    }

    @Override
    public JsonDocumentWriter startObject() {
        if (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.STARTING_ARRAY) {
            this.processingStates.push(StringJsonDocument.JsonProcessingState.ARRAY);
        } else if (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.ARRAY) {
            this.appender.append(StringJsonDocumentMarker.SEPARATOR.getMarkerCharacter());
        }
        this.appender.append(StringJsonDocumentMarker.OBJECT_START.getMarkerCharacter());
        this.processingStates.push(StringJsonDocument.JsonProcessingState.STARTING_OBJECT);
        return this;
    }

    @Override
    public JsonDocumentWriter endObject() {
        this.appender.append(StringJsonDocumentMarker.OBJECT_END.getMarkerCharacter());
        this.processingStates.push(StringJsonDocument.JsonProcessingState.ENDING_OBJECT);
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public JsonDocumentWriter startArray() {
        this.processingStates.push(StringJsonDocument.JsonProcessingState.STARTING_ARRAY);
        this.appender.append(StringJsonDocumentMarker.ARRAY_START.getMarkerCharacter());
        return this;
    }

    @Override
    public JsonDocumentWriter endArray() {
        this.appender.append(StringJsonDocumentMarker.ARRAY_END.getMarkerCharacter());
        this.processingStates.push(StringJsonDocument.JsonProcessingState.ENDING_ARRAY);
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public JsonDocumentWriter objectKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (StringJsonDocument.JsonProcessingState.OBJECT.equals(this.processingStates.getCurrent())) {
            this.appender.append(StringJsonDocumentMarker.SEPARATOR.getMarkerCharacter());
        }
        this.appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
        this.appender.append(key);
        this.appender.append("\":");
        this.moveProcessingStateMachine();
        return this;
    }

    private void addItemsSeparator() {
        if (((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())).equals((Object)StringJsonDocument.JsonProcessingState.ARRAY)) {
            this.appender.append(StringJsonDocumentMarker.SEPARATOR.getMarkerCharacter());
        }
    }

    private void moveProcessingStateMachine() {
        switch ((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())) {
            case STARTING_OBJECT: {
                this.processingStates.push(StringJsonDocument.JsonProcessingState.OBJECT);
                break;
            }
            case STARTING_ARRAY: {
                this.processingStates.push(StringJsonDocument.JsonProcessingState.ARRAY);
                break;
            }
            case ENDING_ARRAY: {
                this.processingStates.pop();
                if (((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())).equals((Object)StringJsonDocument.JsonProcessingState.ARRAY)) {
                    this.processingStates.pop();
                }
                StringJsonDocument.JsonProcessingState arrayStart = (StringJsonDocument.JsonProcessingState)((Object)this.processingStates.pop());
                assert (arrayStart.equals((Object)StringJsonDocument.JsonProcessingState.STARTING_ARRAY));
                break;
            }
            case ENDING_OBJECT: {
                this.processingStates.pop();
                if (((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())).equals((Object)StringJsonDocument.JsonProcessingState.OBJECT)) {
                    this.processingStates.pop();
                }
                StringJsonDocument.JsonProcessingState objectStart = (StringJsonDocument.JsonProcessingState)((Object)this.processingStates.pop());
                assert (objectStart.equals((Object)StringJsonDocument.JsonProcessingState.STARTING_OBJECT));
                break;
            }
        }
    }

    @Override
    public JsonDocumentWriter nullValue() {
        this.addItemsSeparator();
        this.appender.append("null");
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public JsonDocumentWriter numericValue(Number value) {
        this.addItemsSeparator();
        this.appender.append(value.toString());
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public JsonDocumentWriter booleanValue(boolean value) {
        this.addItemsSeparator();
        BooleanJavaType.INSTANCE.appendEncodedString(this.appender, value);
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public JsonDocumentWriter stringValue(String value) {
        this.addItemsSeparator();
        this.appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
        this.appender.startEscaping();
        this.appender.append(value);
        this.appender.endEscaping();
        this.appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
        this.moveProcessingStateMachine();
        return this;
    }

    @Override
    public <T> JsonDocumentWriter serializeJsonValue(Object value, JavaType<T> javaType, JdbcType jdbcType, WrapperOptions options) {
        this.addItemsSeparator();
        this.convertedBasicValueToString(value, options, this.appender, javaType, jdbcType);
        this.moveProcessingStateMachine();
        return this;
    }

    private <T> void convertedCastBasicValueToString(Object value, WrapperOptions options, JsonAppender appender, JavaType<T> javaType, JdbcType jdbcType) {
        assert (javaType.isInstance(value));
        this.convertedBasicValueToString(value, options, appender, javaType, jdbcType);
    }

    private <T> void convertedBasicValueToString(Object value, WrapperOptions options, JsonAppender appender, JavaType<T> javaType, JdbcType jdbcType) {
        assert (javaType.isInstance(value));
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (value instanceof Boolean) {
                    appender.append((Boolean)value != false ? (char)'1' : '0');
                    break;
                }
                if (value instanceof Enum) {
                    appender.appendSql(((Enum)value).ordinal());
                    break;
                }
            }
            case -7: 
            case -5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                javaType.appendEncodedString(appender, value);
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (value instanceof Boolean) {
                    appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                    appender.append((Boolean)value != false ? (char)'Y' : 'N');
                    appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                    break;
                }
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: 
            case 3005: 
            case 3006: 
            case 4001: 
            case 4002: 
            case 6000: 
            case 6001: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                appender.startEscaping();
                javaType.appendEncodedString(appender, value);
                appender.endEscaping();
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 91: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                JdbcDateJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Date.class, options));
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                JdbcTimeJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Time.class, options));
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 93: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                JdbcTimestampJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Timestamp.class, options));
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 2014: 
            case 3003: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(javaType.unwrap(value, OffsetDateTime.class, options), appender);
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 2: 
            case 3: 
            case 3000: 
            case 3015: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                javaType.appendEncodedString(appender, value);
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 3004: 
            case 4003: {
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                appender.write(javaType.unwrap(value, byte[].class, options));
                appender.append(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
                break;
            }
            case 2003: 
            case 3018: {
                throw new IllegalStateException("unexpected JSON array type");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in JSON: " + String.valueOf(jdbcType));
            }
        }
    }

    public String getJson() {
        return this.appender.toString();
    }

    public String toString() {
        return this.appender.toString();
    }

    private static class JsonAppender
    extends OutputStream
    implements SqlAppender {
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        private final StringBuilder sb;
        private boolean escape;

        public JsonAppender(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void appendSql(String fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(char fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(int value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(long value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(boolean value) {
            this.sb.append(value);
        }

        public String toString() {
            return this.sb.toString();
        }

        public void startEscaping() {
            assert (!this.escape);
            this.escape = true;
        }

        public void endEscaping() {
            assert (this.escape);
            this.escape = false;
        }

        @Override
        public JsonAppender append(char fragment) {
            if (this.escape) {
                this.appendEscaped(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public JsonAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public JsonAppender append(CharSequence csq, int start, int end) {
            if (this.escape) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendEscaped(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        @Override
        public void write(int v) {
            String hex = Integer.toHexString(v);
            this.sb.ensureCapacity(this.sb.length() + hex.length() + 1);
            if ((hex.length() & 1) == 1) {
                this.sb.append('0');
            }
            this.sb.append(hex);
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.sb.ensureCapacity(this.sb.length() + (len << 1));
            for (int i = 0; i < len; ++i) {
                int v = bytes[off + i] & 0xFF;
                this.sb.append(HEX_ARRAY[v >>> 4]);
                this.sb.append(HEX_ARRAY[v & 0xF]);
            }
        }

        private void appendEscaped(char fragment) {
            switch (fragment) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.sb.append("\\u").append(Integer.toHexString(fragment));
                    break;
                }
                case '\b': {
                    this.sb.append("\\b");
                    break;
                }
                case '\t': {
                    this.sb.append("\\t");
                    break;
                }
                case '\n': {
                    this.sb.append("\\n");
                    break;
                }
                case '\f': {
                    this.sb.append("\\f");
                    break;
                }
                case '\r': {
                    this.sb.append("\\r");
                    break;
                }
                case '\"': {
                    this.sb.append("\\\"");
                    break;
                }
                case '\\': {
                    this.sb.append("\\\\");
                    break;
                }
                default: {
                    this.sb.append(fragment);
                }
            }
        }
    }
}

