/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.ExpressionReplacementWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.results.internal.ResolvedSqlSelection;
import org.hibernate.type.BasicType;

public class AggregateWindowEmulationQueryTransformer
implements QueryTransformer {
    private final Over<Object> windowFunction;
    private final List<SortSpecification> withinGroup;
    private final List<SqlAstNode> arguments;

    public AggregateWindowEmulationQueryTransformer(Over<Object> windowFunction, List<SortSpecification> withinGroup, List<SqlAstNode> arguments) {
        this.windowFunction = windowFunction;
        this.withinGroup = withinGroup;
        this.arguments = arguments;
    }

    @Override
    public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
        SqlSelection selection;
        SqlSelectionExpression selectionExpression;
        QuerySpec outerQuerySpec = new QuerySpec(querySpec.isRoot());
        String identifierVariable = "hhh_";
        NavigablePath navigablePath = new NavigablePath("hhh_", "hhh_");
        final SelectClause selectClause = outerQuerySpec.getSelectClause();
        QuerySpec subQuerySpec = querySpec.asSubQuery();
        final SelectClause subSelectClause = subQuerySpec.getSelectClause();
        List<SqlSelection> subSelections = subSelectClause.getSqlSelections();
        final ArrayList<String> columnNames = new ArrayList<String>(subSelections.size());
        final HashMap<Expression, Integer> selectionMapping = new HashMap<Expression, Integer>(subSelections.size());
        for (int i = 0; i < subSelections.size(); ++i) {
            Expression finalExpression;
            BasicValuedMapping mapping = (BasicValuedMapping)subSelections.get(i).getExpressionType();
            String columnName = "col" + i;
            ColumnReference columnReference = new ColumnReference("hhh_", columnName, false, null, mapping.getJdbcMapping());
            Expression expression = subSelections.get(i).getExpression();
            if (expression == this.windowFunction) {
                finalExpression = new SelfRenderingAggregateFunctionSqlAstExpression("min", (sqlAppender, sqlAstArguments, returnType, walker1) -> {
                    sqlAppender.appendSql("min(");
                    ((SqlAstNode)sqlAstArguments.get(0)).accept(walker1);
                    sqlAppender.append(')');
                }, Collections.singletonList(columnReference), null, (ReturnableType)((Object)mapping.getMappedType()), expression.getExpressionType());
            } else {
                finalExpression = columnReference;
                selectionMapping.put(expression, i);
            }
            columnNames.add(columnName);
            selectClause.addSqlSelection(new ResolvedSqlSelection(i, finalExpression, (BasicType)mapping.getJdbcMapping()));
        }
        ArrayList<Expression> groupByExpressions = new ArrayList<Expression>(subQuerySpec.getGroupByClauseExpressions().size());
        for (Expression groupByClauseExpression : subQuerySpec.getGroupByClauseExpressions()) {
            Expression realExpression;
            Expression outerGroupByExpression;
            if (groupByClauseExpression instanceof SqlSelectionExpression) {
                selectionExpression = (SqlSelectionExpression)groupByClauseExpression;
                selection = selectionExpression.getSelection();
                outerGroupByExpression = new SqlSelectionExpression(selectClause.getSqlSelections().get(selection.getValuesArrayPosition()));
                realExpression = selection.getExpression();
            } else {
                if (groupByClauseExpression instanceof SqmPathInterpretation) {
                    SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)groupByClauseExpression;
                    realExpression = pathInterpretation.getSqlExpression();
                } else {
                    realExpression = groupByClauseExpression;
                }
                Integer position = (Integer)selectionMapping.get(realExpression);
                if (position == null) {
                    int valuesPosition = selectClause.getSqlSelections().size();
                    String columnName = "col" + valuesPosition;
                    JdbcMapping jdbcMapping = realExpression.getExpressionType().getSingleJdbcMapping();
                    ColumnReference columnReference = new ColumnReference("hhh_", columnName, false, null, jdbcMapping);
                    int subValuesPosition = subSelectClause.getSqlSelections().size();
                    ResolvedSqlSelection subSelection = new ResolvedSqlSelection(subValuesPosition, realExpression, (BasicType)jdbcMapping);
                    columnNames.add(columnName);
                    subSelectClause.addSqlSelection(subSelection);
                    outerGroupByExpression = columnReference;
                    selectionMapping.put(realExpression, subValuesPosition);
                } else {
                    outerGroupByExpression = new SqlSelectionExpression(selectClause.getSqlSelections().get(position));
                }
            }
            this.windowFunction.getPartitions().add(realExpression);
            groupByExpressions.add(outerGroupByExpression);
        }
        outerQuerySpec.setGroupByClauseExpressions(groupByExpressions);
        subQuerySpec.setGroupByClauseExpressions(null);
        if (subQuerySpec.getHavingClauseRestrictions() != null) {
            Predicate predicate = new ExpressionReplacementWalker(){

                @Override
                protected <X extends SqlAstNode> X replaceExpression(X expression) {
                    Expression outerExpression;
                    if (expression instanceof Literal || expression instanceof JdbcParameter) {
                        return expression;
                    }
                    if (expression instanceof SqlSelectionExpression) {
                        SqlSelectionExpression selectionExpression = (SqlSelectionExpression)expression;
                        SqlSelection selection = selectionExpression.getSelection();
                        outerExpression = selectClause.getSqlSelections().get(selection.getValuesArrayPosition()).getExpression();
                    } else {
                        Expression realExpression;
                        if (expression instanceof SqmPathInterpretation) {
                            SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)expression;
                            realExpression = pathInterpretation.getSqlExpression();
                        } else {
                            realExpression = (Expression)expression;
                        }
                        Integer position = (Integer)selectionMapping.get(realExpression);
                        if (position == null) {
                            int valuesPosition = selectClause.getSqlSelections().size();
                            String columnName = "col" + valuesPosition;
                            JdbcMapping jdbcMapping = realExpression.getExpressionType().getSingleJdbcMapping();
                            ColumnReference columnReference = new ColumnReference("hhh_", columnName, false, null, jdbcMapping);
                            int subValuesPosition = subSelectClause.getSqlSelections().size();
                            ResolvedSqlSelection subSelection = new ResolvedSqlSelection(subValuesPosition, realExpression, (BasicType)jdbcMapping);
                            columnNames.add(columnName);
                            subSelectClause.addSqlSelection(subSelection);
                            outerExpression = columnReference;
                            selectionMapping.put(realExpression, subValuesPosition);
                        } else {
                            outerExpression = selectClause.getSqlSelections().get(position).getExpression();
                        }
                    }
                    return (X)outerExpression;
                }
            }.replaceExpressions(subQuerySpec.getHavingClauseRestrictions());
            outerQuerySpec.setHavingClauseRestrictions(predicate);
            subQuerySpec.setHavingClauseRestrictions(null);
        }
        if (subQuerySpec.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : subQuerySpec.getSortSpecifications()) {
                Expression outerSortExpression;
                Expression sortExpression = sortSpecification.getSortExpression();
                if (sortExpression instanceof SqlSelectionExpression) {
                    selectionExpression = (SqlSelectionExpression)sortExpression;
                    selection = selectionExpression.getSelection();
                    outerSortExpression = new SqlSelectionExpression(selectClause.getSqlSelections().get(selection.getValuesArrayPosition()));
                } else {
                    Expression realExpression;
                    if (sortExpression instanceof SqmPathInterpretation) {
                        SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)sortExpression;
                        realExpression = pathInterpretation.getSqlExpression();
                    } else {
                        realExpression = sortExpression;
                    }
                    Integer position = (Integer)selectionMapping.get(realExpression);
                    if (position == null) {
                        int valuesPosition = selectClause.getSqlSelections().size();
                        String columnName = "col" + valuesPosition;
                        JdbcMapping jdbcMapping = realExpression.getExpressionType().getSingleJdbcMapping();
                        ColumnReference columnReference = new ColumnReference("hhh_", columnName, false, null, jdbcMapping);
                        int subValuesPosition = subSelectClause.getSqlSelections().size();
                        ResolvedSqlSelection subSelection = new ResolvedSqlSelection(subValuesPosition, realExpression, (BasicType)jdbcMapping);
                        columnNames.add(columnName);
                        subSelectClause.addSqlSelection(subSelection);
                        outerSortExpression = columnReference;
                        selectionMapping.put(realExpression, subValuesPosition);
                    } else {
                        outerSortExpression = new SqlSelectionExpression(selectClause.getSqlSelections().get(position));
                    }
                }
                outerQuerySpec.addSortSpecification(new SortSpecification(outerSortExpression, sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence()));
            }
            subQuerySpec.getSortSpecifications().clear();
        }
        int selectionOffset = columnNames.size();
        ArrayList<ColumnReference> sortingColumns = new ArrayList<ColumnReference>(this.withinGroup.size());
        for (int i = 0; i < this.withinGroup.size(); ++i) {
            int valueIndex = selectionOffset + i;
            Expression sortExpression = this.withinGroup.get(i).getSortExpression();
            BasicValuedMapping mapping = (BasicValuedMapping)sortExpression.getExpressionType();
            String columnName = "col" + valueIndex;
            int oldValueIndex = subSelectClause.getSqlSelections().size();
            columnNames.add(columnName);
            subSelectClause.addSqlSelection(new ResolvedSqlSelection(oldValueIndex, sortExpression, (BasicType)mapping.getJdbcMapping()));
            sortingColumns.add(new ColumnReference("hhh_", columnName, false, null, mapping.getJdbcMapping()));
        }
        if (this.arguments != null) {
            switch (this.arguments.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    outerQuerySpec.applyPredicate(new ComparisonPredicate((Expression)sortingColumns.get(0), ComparisonOperator.EQUAL, (Expression)this.arguments.get(0)));
                    break;
                }
                default: {
                    outerQuerySpec.applyPredicate(new ComparisonPredicate(new SqlTuple(sortingColumns, null), ComparisonOperator.EQUAL, new SqlTuple(this.arguments, null)));
                }
            }
        }
        QueryPartTableGroup queryPartTableGroup = new QueryPartTableGroup(navigablePath, null, new SelectStatement(subQuerySpec), "hhh_", columnNames, false, true, converter.getCreationContext().getSessionFactory());
        outerQuerySpec.getFromClause().addRoot(queryPartTableGroup);
        outerQuerySpec.setOffsetClauseExpression(subQuerySpec.getOffsetClauseExpression());
        outerQuerySpec.setFetchClauseExpression(subQuerySpec.getFetchClauseExpression(), subQuerySpec.getFetchClauseType());
        subQuerySpec.setOffsetClauseExpression(null);
        subQuerySpec.setFetchClauseExpression(null, null);
        return outerQuerySpec;
    }
}

