/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.undertow.httpcore.BlockingHttpExchange;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.UndertowInputStream;
import io.undertow.httpcore.UndertowOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultBlockingHttpExchange
implements BlockingHttpExchange {
    private InputStream inputStream;
    private OutputStream outputStream;
    final HttpExchange exchange;

    public DefaultBlockingHttpExchange(HttpExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new UndertowInputStream(this.exchange);
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new UndertowOutputStream(this.exchange);
        }
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

