/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class IncrFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Double> {
    public static final AdvancedExternalizer<IncrFunction> EXTERNALIZER = new Externalizer();
    private final Double score;
    private final V member;
    private final boolean addOnly;
    private final boolean updateOnly;
    private final boolean updateLessScoresOnly;
    private final boolean updateGreaterScoresOnly;

    public IncrFunction(double score, V member, SortedSetAddArgs args) {
        this.score = score;
        this.member = member;
        this.addOnly = args.addOnly;
        this.updateOnly = args.updateOnly;
        this.updateLessScoresOnly = args.updateLessScoresOnly;
        this.updateGreaterScoresOnly = args.updateGreaterScoresOnly;
    }

    public IncrFunction(double score, V value, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly) {
        this.score = score;
        this.member = value;
        this.addOnly = addOnly;
        this.updateOnly = updateOnly;
        this.updateLessScoresOnly = updateLessScoresOnly;
        this.updateGreaterScoresOnly = updateGreaterScoresOnly;
    }

    public Double apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        SortedSetBucket.SortedSetResult res;
        Optional existing = entryView.peek();
        SortedSetBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (SortedSetBucket<V>)existing.get();
        } else if (!this.updateOnly) {
            bucket = new SortedSetBucket<V>();
        }
        Double result = null;
        if (bucket != null && (res = bucket.incrScore(this.score, this.member, this.addOnly, this.updateOnly, this.updateLessScoresOnly, this.updateGreaterScoresOnly)) != null) {
            result = res.result();
            entryView.set(res.bucket(), new MetaParam.Writable[0]);
        }
        return result;
    }

    private static class Externalizer
    implements AdvancedExternalizer<IncrFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends IncrFunction>> getTypeClasses() {
            return Collections.singleton(IncrFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_INCR_SCORE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, IncrFunction object) throws IOException {
            output.writeDouble(object.score);
            output.writeObject(object.member);
            output.writeBoolean(object.addOnly);
            output.writeBoolean(object.updateOnly);
            output.writeBoolean(object.updateLessScoresOnly);
            output.writeBoolean(object.updateGreaterScoresOnly);
        }

        public IncrFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IncrFunction(input.readDouble(), input.readObject(), input.readBoolean(), input.readBoolean(), input.readBoolean(), input.readBoolean());
        }
    }
}

