/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.StopPartition;
import org.apache.kafka.server.log.remote.storage.RemoteLogManager;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u0006\r\u0001EA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005-\u0001\t\u0015\r\u0011\"\u0001.\u0011!a\u0004A!A!\u0002\u0013q\u0003\"B\u001f\u0001\t\u0003q\u0004\"B\"\u0001\t\u0013!\u0005B\u0002/\u0001\t\u0003aQ\fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\u0003%Q{\u0007/[2D_:4\u0017n\u001a%b]\u0012dWM\u001d\u0006\u0003\u001b9\taa]3sm\u0016\u0014(\"A\b\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0005\r\u001d!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0019%\u00111\u0004\u0004\u0002\u000e\u0007>tg-[4IC:$G.\u001a:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}q\u0011!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001%!\tIR%\u0003\u0002'\u0019\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0017-\fgm[1D_:4\u0017n\u001a\t\u00033)J!a\u000b\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0007cV|G/Y:\u0016\u00039\u0002\"aL\u001d\u000f\u0005A:dBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!\u0004#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003q1\tA\"U;pi\u00064\u0015m\u0019;pefL!AO\u001e\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\tAD\"A\u0004rk>$\u0018m\u001d\u0011\u0002\rqJg.\u001b;?)\u0011y\u0004)\u0011\"\u0011\u0005e\u0001\u0001\"\u0002\u0012\u0007\u0001\u0004!\u0003\"\u0002\u0015\u0007\u0001\u0004I\u0003\"\u0002\u0017\u0007\u0001\u0004q\u0013aD;qI\u0006$X\rT8h\u0007>tg-[4\u0015\u0007\u0015C%\u000b\u0005\u0002\u0014\r&\u0011q\t\u0006\u0002\u0005+:LG\u000fC\u0003J\u000f\u0001\u0007!*A\u0003u_BL7\r\u0005\u0002L\u001f:\u0011A*\u0014\t\u0003eQI!A\u0014\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dRAQaU\u0004A\u0002Q\u000b1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0005kRLGNC\u0001Z\u0003\u0011Q\u0017M^1\n\u0005m3&A\u0003)s_B,'\u000f^5fg\u0006qR.Y=cKV\u0003H-\u0019;f%\u0016lw\u000e^3M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u000b\u0006\u000bz{fo\u001f\u0005\u0006\u0013\"\u0001\rA\u0013\u0005\u0006A\"\u0001\r!Y\u0001\u0005Y><7\u000fE\u0002cK\u001el\u0011a\u0019\u0006\u0003IR\t!bY8mY\u0016\u001cG/[8o\u0013\t17MA\u0002TKF\u0004\"\u0001\u001b;\u000e\u0003%T!A[6\u0002\u00071|wM\u0003\u0002m[\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003]>\fqa\u001d;pe\u0006<WM\u0003\u0002\u0010a*\u0011\u0011O]\u0001\u0007CB\f7\r[3\u000b\u0003M\f1a\u001c:h\u0013\t)\u0018N\u0001\u0006V]&4\u0017.\u001a3M_\u001eDQa\u001e\u0005A\u0002a\f1c^1t%\u0016lw\u000e^3M_\u001e,e.\u00192mK\u0012\u0004\"aE=\n\u0005i$\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006y\"\u0001\r\u0001_\u0001\u0010o\u0006\u001c8i\u001c9z\t&\u001c\u0018M\u00197fI\u0006!\u0002O]8dKN\u001c8i\u001c8gS\u001e\u001c\u0005.\u00198hKN$B!R@\u0002\u0002!)\u0011*\u0003a\u0001\u0015\")1+\u0003a\u0001)\u0006A\u0002/\u0019:tKRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0011\u0005\u001d\u0011qBA\t\u0003+\u0001BAY3\u0002\nA\u00191#a\u0003\n\u0007\u00055ACA\u0002J]RDQa\u0015\u0006A\u0002QCq!a\u0005\u000b\u0001\u0004\tI!\u0001\u0005ce>\\WM]%e\u0011\u0019\t9B\u0003a\u0001\u0015\u0006!\u0001O]8q\u0001")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig) {
        LogManager logManager = this.replicaManager().logManager();
        Seq<UnifiedLog> logs = logManager.logsByTopic(topic);
        boolean wasRemoteLogEnabled = logs.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.remoteLogEnabled()));
        boolean wasCopyDisabled = logs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$2.config().remoteLogCopyDisable())));
        logManager.updateTopicConfig(topic, topicConfig, this.kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), wasRemoteLogEnabled);
        this.maybeUpdateRemoteLogComponents(topic, logs, wasRemoteLogEnabled, wasCopyDisabled);
    }

    /*
     * WARNING - void declaration
     */
    public void maybeUpdateRemoteLogComponents(String topic, Seq<UnifiedLog> logs, boolean wasRemoteLogEnabled, boolean wasCopyDisabled) {
        void var10_10;
        void var9_9;
        boolean isRemoteLogEnabled = logs.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.remoteLogEnabled()));
        boolean isCopyDisabled = logs.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$4.config().remoteLogCopyDisable())));
        boolean isDeleteOnDisable = logs.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$5.config().remoteLogDeleteOnDisable())));
        Tuple2 tuple2 = ((IterableOps)logs.flatMap((Function1 & Serializable)log -> this.replicaManager().onlinePartition(log.topicPartition()))).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeader()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq leaderPartitions = (Seq)tuple2._1();
        Seq followerPartitions = (Seq)tuple2._2();
        if (isRemoteLogEnabled && (!wasRemoteLogEnabled || wasCopyDisabled && !isCopyDisabled)) {
            Map<String, Uuid> topicIds = Collections.singletonMap(topic, this.replicaManager().metadataCache().getTopicId(topic));
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$6$adapted((Seq)var9_9, (Seq)var10_10, topicIds, arg_0));
        }
        if (isRemoteLogEnabled && !wasCopyDisabled && isCopyDisabled) {
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$7$adapted((Seq)var9_9, arg_0));
        }
        if (wasRemoteLogEnabled && !isRemoteLogEnabled && isDeleteOnDisable) {
            HashSet stopPartitions = new HashSet();
            var9_9.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, true, true))));
            var10_10.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, false, true))));
            ((IterableOnceOps)logs.filter(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$10$adapted((Seq)var9_9, arg_0))).foreach((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)log.maybeIncrementLogStartOffset(log.localLogStartOffset(), LogStartOffsetIncrementReason.SegmentDeletion)));
            this.replicaManager().remoteLogManager().foreach((Function1 & Serializable)rlm -> {
                rlm.stopPartitions((java.util.Set)stopPartitions, (x$8, x$9) -> {});
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        this.updateLogConfig(topic, topicConfig);
        this.updateThrottledList$1("leader.replication.throttled.replicas", this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1("follower.replication.throttled.replicas", this.quotas().follower(), topicConfig, topic);
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator.ensureValidString((String)prop, (String)configValue);
        switch (configValue == null ? 0 : configValue.hashCode()) {
            case 0: {
                if (!"".equals(configValue)) break;
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(configValue)) break;
                return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ReplicationQuotaManager.ALL_REPLICAS).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$10)))).toSeq();
            }
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$11 -> x$11.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(brokerId, x$12)))), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$13[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateRemoteLogComponents$11(UnifiedLog log$1, Partition p) {
        return p.topicPartition().equals((Object)log$1.topicPartition());
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Setting " + prop + " on broker " + $this.kafkaConfig.brokerId() + " for topic: " + topic$1 + " and partitions " + partitions);
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Removing " + prop + " from broker " + $this.kafkaConfig.brokerId() + " for topic " + topic$1);
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$3(int brokerId$1, String[] x$12) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$6$adapted(Seq leaderPartitions$1, Seq followerPartitions$1, Map topicIds$1, RemoteLogManager rlm) {
        rlm.onLeadershipChange(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)followerPartitions$1.toSet()).asJava(), topicIds$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$7$adapted(Seq leaderPartitions$1, RemoteLogManager rlm) {
        rlm.stopLeaderCopyRLMTasks(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$10$adapted(Seq leaderPartitions$1, UnifiedLog log) {
        return BoxesRunTime.boxToBoolean((boolean)leaderPartitions$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$11(log, p))));
    }
}

