/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import jdk.jfr.EventType;
import jdk.jfr.internal.MetadataReader;
import jdk.jfr.internal.MetadataWriter;
import jdk.jfr.internal.Type;

public final class MetadataDescriptor {
    static final String ATTRIBUTE_ID = "id";
    static final String ATTRIBUTE_SIMPLE_TYPE = "simpleType";
    static final String ATTRIBUTE_GMT_OFFSET = "gmtOffset";
    static final String ATTRIBUTE_LOCALE = "locale";
    static final String ELEMENT_TYPE = "class";
    static final String ELEMENT_SETTING = "setting";
    static final String ELEMENT_ANNOTATION = "annotation";
    static final String ELEMENT_FIELD = "field";
    static final String ATTRIBUTE_SUPER_TYPE = "superType";
    static final String ATTRIBUTE_TYPE_ID = "class";
    static final String ATTRIBUTE_DIMENSION = "dimension";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_CONSTANT_POOL = "constantPool";
    static final String ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
    final List<EventType> eventTypes = new ArrayList<EventType>();
    final Collection<Type> types = new ArrayList<Type>();
    long gmtOffset;
    String locale;
    Element root;

    MetadataDescriptor() {
    }

    private static void prettyPrintXML(Appendable appendable, String string, Element element) throws IOException {
        appendable.append(string + "<" + element.name);
        for (Attribute object : element.attributes) {
            appendable.append(" ").append(object.name).append("=\"").append(object.value).append("\"");
        }
        if (element.elements.size() == 0) {
            appendable.append("/");
        }
        appendable.append(">\n");
        for (Element element2 : element.elements) {
            MetadataDescriptor.prettyPrintXML(appendable, string + "  ", element2);
        }
        if (element.elements.size() != 0) {
            appendable.append(string).append("</").append(element.name).append(">\n");
        }
    }

    public Collection<Type> getTypes() {
        return this.types;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public int getGMTOffset() {
        return (int)this.gmtOffset;
    }

    public String getLocale() {
        return this.locale;
    }

    public static MetadataDescriptor read(DataInput dataInput) throws IOException {
        MetadataReader metadataReader = new MetadataReader(dataInput);
        return metadataReader.getDescriptor();
    }

    static void write(List<Type> list, DataOutput dataOutput) throws IOException {
        MetadataDescriptor metadataDescriptor = new MetadataDescriptor();
        metadataDescriptor.locale = Locale.getDefault().toString();
        metadataDescriptor.gmtOffset = TimeZone.getDefault().getRawOffset();
        metadataDescriptor.types.addAll(list);
        MetadataWriter metadataWriter = new MetadataWriter(metadataDescriptor);
        metadataWriter.writeBinary(dataOutput);
    }

    public String toString() {
        return this.root.toString();
    }

    static final class Element {
        final String name;
        final List<Element> elements = new ArrayList<Element>();
        final List<Attribute> attributes = new ArrayList<Attribute>();

        Element(String string) {
            this.name = string;
        }

        long longValue(String string) {
            String string2 = this.attribute(string);
            if (string2 != null) {
                return Long.parseLong(string2);
            }
            throw new IllegalArgumentException(string);
        }

        String attribute(String string) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equals(string)) continue;
                return attribute.value;
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                MetadataDescriptor.prettyPrintXML(stringBuilder, "", this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringBuilder.toString();
        }

        long attribute(String string, long l) {
            String string2 = this.attribute(string);
            if (string2 == null) {
                return l;
            }
            return Long.parseLong(string2);
        }

        String attribute(String string, String string2) {
            String string3 = this.attribute(string);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }

        List<Element> elements(String ... stringArray) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (String string : stringArray) {
                for (Element element : this.elements) {
                    if (!element.name.equals(string)) continue;
                    arrayList.add(element);
                }
            }
            return arrayList;
        }

        void add(Element element) {
            this.elements.add(element);
        }

        void addAttribute(String string, Object object) {
            this.attributes.add(new Attribute(string, String.valueOf(object)));
        }

        Element newChild(String string) {
            Element element = new Element(string);
            this.elements.add(element);
            return element;
        }

        public void addArrayAttribute(Element element, String string, Object object) {
            String string2;
            switch (string2 = object.getClass().getComponentType().getName()) {
                case "int": {
                    int[] nArray = (int[])object;
                    for (int i = 0; i < nArray.length; ++i) {
                        this.addAttribute(string + "-" + i, nArray[i]);
                    }
                    break;
                }
                case "long": {
                    long[] lArray = (long[])object;
                    for (int i = 0; i < lArray.length; ++i) {
                        this.addAttribute(string + "-" + i, lArray[i]);
                    }
                    break;
                }
                case "float": {
                    float[] fArray = (float[])object;
                    for (int i = 0; i < fArray.length; ++i) {
                        this.addAttribute(string + "-" + i, Float.valueOf(fArray[i]));
                    }
                    break;
                }
                case "double": {
                    double[] dArray = (double[])object;
                    for (int i = 0; i < dArray.length; ++i) {
                        this.addAttribute(string + "-" + i, dArray[i]);
                    }
                    break;
                }
                case "short": {
                    short[] sArray = (short[])object;
                    for (int i = 0; i < sArray.length; ++i) {
                        this.addAttribute(string + "-" + i, sArray[i]);
                    }
                    break;
                }
                case "char": {
                    char[] cArray = (char[])object;
                    for (int i = 0; i < cArray.length; ++i) {
                        this.addAttribute(string + "-" + i, Character.valueOf(cArray[i]));
                    }
                    break;
                }
                case "byte": {
                    byte[] byArray = (byte[])object;
                    for (int i = 0; i < byArray.length; ++i) {
                        this.addAttribute(string + "-" + i, byArray[i]);
                    }
                    break;
                }
                case "boolean": {
                    boolean[] blArray = (boolean[])object;
                    for (int i = 0; i < blArray.length; ++i) {
                        this.addAttribute(string + "-" + i, blArray[i]);
                    }
                    break;
                }
                case "java.lang.String": {
                    String[] stringArray = (String[])object;
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addAttribute(string + "-" + i, stringArray[i]);
                    }
                    break;
                }
                default: {
                    throw new InternalError("Array type of " + string2 + " is not supported");
                }
            }
        }
    }

    static final class Attribute {
        final String name;
        final String value;

        private Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

