/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CMSBitMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CMSCollector
extends VMObject {
    private static long markBitMapFieldOffset;

    public CMSCollector(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CMSCollector");
        markBitMapFieldOffset = type.getField("_markBitMap").getOffset();
    }

    public CMSBitMap markBitMap() {
        return (CMSBitMap)VMObjectFactory.newObject(CMSBitMap.class, this.addr.addOffsetTo(markBitMapFieldOffset));
    }

    public long blockSizeUsingPrintezisBits(Address addr) {
        CMSBitMap markBitMap = this.markBitMap();
        long addressSize = VM.getVM().getAddressSize();
        if (markBitMap.isMarked(addr) && markBitMap.isMarked(addr.addOffsetTo(1L * addressSize))) {
            Address nextOneAddr = markBitMap.getNextMarkedWordAddress(addr.addOffsetTo(2L * addressSize));
            long size = nextOneAddr.addOffsetTo(1L * addressSize).minus(addr);
            return size;
        }
        return -1L;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CMSCollector.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

