/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;

abstract class AbstractWyhashFinal
implements AbstractHasher64 {
    protected final long seed;
    protected final long secret1;
    protected final long secret2;
    protected final long secret3;
    protected static final long[] DEFAULT_SECRET = new long[]{-6884282663029611473L, -1800455987208640293L, -8161530843051276573L, 6384245875588680899L};

    protected AbstractWyhashFinal(long seed, long secret1, long secret2, long secret3) {
        this.seed = seed;
        this.secret1 = secret1;
        this.secret2 = secret2;
        this.secret3 = secret3;
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        int i;
        if (len <= 16) {
            if (len >= 4) {
                long a = (long)ByteArrayUtil.getInt(input, off) << 32 | (long)ByteArrayUtil.getInt(input, off + (len >>> 3 << 2)) & 0xFFFFFFFFL;
                long b = (long)ByteArrayUtil.getInt(input, off + len - 4) << 32 | (long)ByteArrayUtil.getInt(input, off + len - 4 - (len >>> 3 << 2)) & 0xFFFFFFFFL;
                return this.finish(a, b, this.seed, len);
            }
            if (len > 0) {
                int a = AbstractWyhashFinal.wyr3(input, off, len);
                return this.finish(a, 0L, this.seed, len);
            }
            return this.finish(0L, 0L, this.seed, 0L);
        }
        int p = off;
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        for (i = len; i > 48; i -= 48) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, p) ^ this.secret1, ByteArrayUtil.getLong(input, p + 8) ^ see0);
            see1 = HashUtil.mix(ByteArrayUtil.getLong(input, p + 16) ^ this.secret2, ByteArrayUtil.getLong(input, p + 24) ^ see1);
            see2 = HashUtil.mix(ByteArrayUtil.getLong(input, p + 32) ^ this.secret3, ByteArrayUtil.getLong(input, p + 40) ^ see2);
            p += 48;
        }
        see0 ^= see1 ^ see2;
        while (i > 16) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, p) ^ this.secret1, ByteArrayUtil.getLong(input, p + 8) ^ see0);
            i -= 16;
            p += 16;
        }
        long a = ByteArrayUtil.getLong(input, p + i - 16);
        long b = ByteArrayUtil.getLong(input, p + i - 8);
        return this.finish(a, b, see0, len);
    }

    @Override
    public <T> long hashBytesToLong(T input, long off, long len, ByteAccess<T> access) {
        long i;
        if (len <= 16L) {
            if (len >= 4L) {
                long a = access.getIntAsUnsignedLong(input, off) << 32 | access.getIntAsUnsignedLong(input, off + (len >>> 3 << 2));
                long b = access.getIntAsUnsignedLong(input, off + len - 4L) << 32 | access.getIntAsUnsignedLong(input, off + len - 4L - (len >>> 3 << 2));
                return this.finish(a, b, this.seed, len);
            }
            if (len > 0L) {
                int a = AbstractWyhashFinal.wyr3(input, off, len, access);
                return this.finish(a, 0L, this.seed, len);
            }
            return this.finish(0L, 0L, this.seed, len);
        }
        long p = off;
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        for (i = len; i > 48L; i -= 48L) {
            see0 = HashUtil.mix(access.getLong(input, p) ^ this.secret1, access.getLong(input, p + 8L) ^ see0);
            see1 = HashUtil.mix(access.getLong(input, p + 16L) ^ this.secret2, access.getLong(input, p + 24L) ^ see1);
            see2 = HashUtil.mix(access.getLong(input, p + 32L) ^ this.secret3, access.getLong(input, p + 40L) ^ see2);
            p += 48L;
        }
        see0 ^= see1 ^ see2;
        while (i > 16L) {
            see0 = HashUtil.mix(access.getLong(input, p) ^ this.secret1, access.getLong(input, p + 8L) ^ see0);
            i -= 16L;
            p += 16L;
        }
        long a = access.getLong(input, p + i - 16L);
        long b = access.getLong(input, p + i - 8L);
        return this.finish(a, b, see0, len);
    }

    protected abstract long finish(long var1, long var3, long var5, long var7);

    @Override
    public long hashCharsToLong(CharSequence input) {
        int i;
        int len = input.length();
        if (len <= 8) {
            if (len >= 2) {
                long a = (long)ByteArrayUtil.getInt(input, 0) << 32 | (long)ByteArrayUtil.getInt(input, len >>> 2 << 1) & 0xFFFFFFFFL;
                long b = (long)ByteArrayUtil.getInt(input, len - 2) << 32 | (long)ByteArrayUtil.getInt(input, len - 2 - (len >>> 2 << 1)) & 0xFFFFFFFFL;
                return this.finish(a, b, this.seed, len << 1);
            }
            if (len > 0) {
                char ch = input.charAt(0);
                int c0 = ch & 0xFF;
                int c1 = ch >>> 8;
                int a = c0 << 16 | c1 << 8 | c1;
                return this.finish(a, 0L, this.seed, len << 1);
            }
            return this.finish(0L, 0L, this.seed, 0L);
        }
        int p = 0;
        long see0 = this.seed;
        long see1 = this.seed;
        long see2 = this.seed;
        for (i = len; i > 24; i -= 24) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, p) ^ this.secret1, ByteArrayUtil.getLong(input, p + 4) ^ see0);
            see1 = HashUtil.mix(ByteArrayUtil.getLong(input, p + 8) ^ this.secret2, ByteArrayUtil.getLong(input, p + 12) ^ see1);
            see2 = HashUtil.mix(ByteArrayUtil.getLong(input, p + 16) ^ this.secret3, ByteArrayUtil.getLong(input, p + 20) ^ see2);
            p += 24;
        }
        see0 ^= see1 ^ see2;
        while (i > 8) {
            see0 = HashUtil.mix(ByteArrayUtil.getLong(input, p) ^ this.secret1, ByteArrayUtil.getLong(input, p + 4) ^ see0);
            i -= 8;
            p += 8;
        }
        long a = ByteArrayUtil.getLong(input, len - 8);
        long b = ByteArrayUtil.getLong(input, len - 4);
        return this.finish(a, b, see0, (long)len << 1);
    }

    private static int wyr3(byte[] data, int off, int k) {
        return (data[off] & 0xFF) << 16 | (data[off + (k >>> 1)] & 0xFF) << 8 | data[off + k - 1] & 0xFF;
    }

    private static <T> int wyr3(T data, long off, long k, ByteAccess<T> access) {
        return access.getByteAsUnsignedInt(data, off) << 16 | access.getByteAsUnsignedInt(data, off + (k >>> 1)) << 8 | access.getByteAsUnsignedInt(data, off + k - 1L);
    }

    protected static long[] makeSecret(long seed) {
        long[] secret = new long[4];
        byte[] c = new byte[]{15, 23, 27, 29, 30, 39, 43, 45, 46, 51, 53, 54, 57, 58, 60, 71, 75, 77, 78, 83, 85, 86, 89, 90, 92, 99, 101, 102, 105, 106, 108, 113, 114, 116, 120, -121, -117, -115, -114, -109, -107, -106, -103, -102, -100, -93, -91, -90, -87, -86, -84, -79, -78, -76, -72, -61, -59, -58, -55, -54, -52, -47, -46, -44, -40, -31, -30, -28, -24, -16};
        for (int i = 0; i < 4; ++i) {
            boolean ok;
            block1: do {
                int j;
                ok = true;
                secret[i] = (long)c[(int)Long.remainderUnsigned(HashUtil.mix(seed += -6884282663029611473L, seed ^ 0xE7037ED1A0B428DBL), c.length)] & 0xFFL;
                if ((secret[i] & 1L) == 0L) {
                    seed += 7150253579921374537L;
                    ok = false;
                    continue;
                }
                for (j = 8; j < 64; j += 8) {
                    int n = i;
                    secret[n] = secret[n] | ((long)c[(int)Long.remainderUnsigned(HashUtil.mix(seed += -6884282663029611473L, seed ^ 0xE7037ED1A0B428DBL), c.length)] & 0xFFL) << j;
                }
                for (j = 0; j < i; ++j) {
                    if (Long.bitCount(secret[j] ^ secret[i]) == 32) continue;
                    ok = false;
                    continue block1;
                }
            } while (!ok);
        }
        return secret;
    }

    @Override
    public long hashIntToLong(int v) {
        long a = (long)v << 32 | (long)v & 0xFFFFFFFFL;
        return this.finish(a, a, this.seed, 4L);
    }

    @Override
    public long hashIntIntToLong(int v1, int v2) {
        return this.finish((long)v1 << 32 | (long)v2 & 0xFFFFFFFFL, (long)v2 << 32 | (long)v1 & 0xFFFFFFFFL, this.seed, 8L);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        long x = (long)v2 & 0xFFFFFFFFL;
        return this.finish((long)v1 << 32 | x, (long)v3 << 32 | x, this.seed, 12L);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish((long)v1 << 32 | v2 & 0xFFFFFFFFL, v2, this.seed, 12L);
    }

    @Override
    public long hashLongToLong(long v) {
        return this.finish(v << 32 | v >>> 32, v, this.seed, 8L);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        return this.finish(v1 << 32 | v2 & 0xFFFFFFFFL, v2 & 0xFFFFFFFF00000000L | v1 >>> 32, this.seed, 16L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        return this.finish(v2, v3, HashUtil.mix(v1 ^ this.secret1, v2 ^ this.seed), 24L);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        long x = v1 >>> 32;
        return this.finish(v1 << 32 | x, (long)v2 << 32 | x, this.seed, 12L);
    }

    private class HashStreamImpl
    implements AbstractHashStream64 {
        private final byte[] buffer = new byte[56];
        private long byteCount = 0L;
        private int offset = 0;
        private long see0;
        private long see1;
        private long see2;
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
            this.see0 = AbstractWyhashFinal.this.seed;
            this.see1 = AbstractWyhashFinal.this.seed;
            this.see2 = AbstractWyhashFinal.this.seed;
        }

        public int hashCode() {
            return this.getAsInt();
        }

        public boolean equals(Object obj) {
            return HashUtil.equalsHelper(this, obj);
        }

        @Override
        public HashStream64 reset() {
            this.byteCount = 0L;
            this.offset = 0;
            this.see0 = AbstractWyhashFinal.this.seed;
            this.see1 = AbstractWyhashFinal.this.seed;
            this.see2 = AbstractWyhashFinal.this.seed;
            return this;
        }

        @Override
        public Hasher64 getHasher() {
            return AbstractWyhashFinal.this;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L) ? 16 : this.offset;
            byte[] state = new byte[9 + (this.byteCount > 48L || this.byteCount < 0L ? 24 : 0) + numBufferBytes];
            int off = 0;
            state[off++] = 0;
            ByteArrayUtil.setLong(state, off, this.byteCount);
            off += 8;
            if (this.byteCount > 48L || this.byteCount < 0L) {
                ByteArrayUtil.setLong(state, off, this.see0);
                ByteArrayUtil.setLong(state, off += 8, this.see1);
                ByteArrayUtil.setLong(state, off += 8, this.see2);
                off += 8;
            }
            if (this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L)) {
                System.arraycopy(this.buffer, 32 + this.offset, state, off, 16 - this.offset);
                off += 16 - this.offset;
            }
            System.arraycopy(this.buffer, 0, state, off, this.offset);
            return state;
        }

        @Override
        public HashStream64 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 9);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            this.byteCount = ByteArrayUtil.getLong(state, off);
            off += 8;
            this.offset = this.byteCount == 0L ? 0 : (int)Long.remainderUnsigned(this.byteCount - 1L, 48L) + 1;
            int numBufferBytes = this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L) ? 16 : this.offset;
            Preconditions.checkArgument(state.length == 9 + (this.byteCount > 48L || this.byteCount < 0L ? 24 : 0) + numBufferBytes);
            if (this.byteCount > 48L || this.byteCount < 0L) {
                this.see0 = ByteArrayUtil.getLong(state, off);
                this.see1 = ByteArrayUtil.getLong(state, off += 8);
                this.see2 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.see0 = AbstractWyhashFinal.this.seed;
                this.see1 = AbstractWyhashFinal.this.seed;
                this.see2 = AbstractWyhashFinal.this.seed;
            }
            if (this.offset < 16 && (this.byteCount >= 16L || this.byteCount < 0L)) {
                System.arraycopy(state, off, this.buffer, 32 + this.offset, 16 - this.offset);
                off += 16 - this.offset;
            }
            System.arraycopy(state, off, this.buffer, 0, this.offset);
            return this;
        }

        @Override
        public HashStream64 putByte(byte v) {
            if (this.offset >= 48) {
                this.offset -= 48;
                this.processBuffer();
            }
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            ByteArrayUtil.setShort(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                ByteArrayUtil.setShort(this.buffer, 0, (short)(v << (this.offset << 3) >>> 16));
            }
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            ByteArrayUtil.setChar(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                ByteArrayUtil.setChar(this.buffer, 0, (char)(v << (this.offset << 3) >>> 16));
            }
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            ByteArrayUtil.setInt(this.buffer, this.offset, v);
            this.offset += 4;
            this.byteCount += 4L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                ByteArrayUtil.setInt(this.buffer, 0, v >>> -(this.offset << 3));
            }
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            ByteArrayUtil.setLong(this.buffer, this.offset, v);
            this.offset += 8;
            this.byteCount += 8L;
            if (this.offset > 48) {
                this.offset -= 48;
                this.processBuffer();
                ByteArrayUtil.setLong(this.buffer, 0, v >>> -(this.offset << 3));
            }
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.byteCount += (long)len;
            int x = 48 - this.offset;
            if (len > x) {
                System.arraycopy(b, off, this.buffer, this.offset, x);
                this.processBuffer();
                off += x;
                if ((len -= x) > 48) {
                    do {
                        long b0 = ByteArrayUtil.getLong(b, off);
                        long b1 = ByteArrayUtil.getLong(b, off + 8);
                        long b2 = ByteArrayUtil.getLong(b, off + 16);
                        long b3 = ByteArrayUtil.getLong(b, off + 24);
                        long b4 = ByteArrayUtil.getLong(b, off + 32);
                        long b5 = ByteArrayUtil.getLong(b, off + 40);
                        this.processBuffer(b0, b1, b2, b3, b4, b5);
                        off += 48;
                    } while ((len -= 48) > 48);
                    if (len < 16) {
                        int y = 16 - len;
                        System.arraycopy(b, off - y, this.buffer, 32 + len, y);
                    }
                }
                this.offset = 0;
            }
            System.arraycopy(b, off, this.buffer, this.offset, len);
            this.offset += len;
            return this;
        }

        @Override
        public <T> HashStream64 putBytes(T b, long off, long len, ByteAccess<T> access) {
            this.byteCount += len;
            int x = 48 - this.offset;
            if (len > (long)x) {
                access.copyToByteArray(b, off, this.buffer, this.offset, x);
                this.processBuffer();
                off += (long)x;
                if ((len -= (long)x) > 48L) {
                    do {
                        long b0 = access.getLong(b, off);
                        long b1 = access.getLong(b, off + 8L);
                        long b2 = access.getLong(b, off + 16L);
                        long b3 = access.getLong(b, off + 24L);
                        long b4 = access.getLong(b, off + 32L);
                        long b5 = access.getLong(b, off + 40L);
                        this.processBuffer(b0, b1, b2, b3, b4, b5);
                        off += 48L;
                    } while ((len -= 48L) > 48L);
                    if (len < 16L) {
                        int y = 16 - (int)len;
                        access.copyToByteArray(b, off - (long)y, this.buffer, 32 + (int)len, y);
                    }
                }
                this.offset = 0;
            }
            access.copyToByteArray(b, off, this.buffer, this.offset, (int)len);
            this.offset += (int)len;
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence s) {
            int remainingChars = s.length();
            this.byteCount += (long)remainingChars << 1;
            int off = 0;
            if (remainingChars > 48 - this.offset >>> 1) {
                if (this.offset > 1) {
                    off = 49 - this.offset >>> 1;
                    ByteArrayUtil.copyCharsToByteArray(s, 0, this.buffer, this.offset, off);
                    remainingChars -= off;
                    this.processBuffer();
                    this.offset &= 1;
                }
                if (this.offset == 0) {
                    if (remainingChars > 24) {
                        long b5;
                        long b4;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            b4 = ByteArrayUtil.getLong(s, off + 16);
                            b5 = ByteArrayUtil.getLong(s, off + 20);
                            this.processBuffer(b0, b1, b2, b3, b4, b5);
                            off += 24;
                        } while ((remainingChars -= 24) > 24);
                        ByteArrayUtil.setLong(this.buffer, 32, b4);
                        ByteArrayUtil.setLong(this.buffer, 40, b5);
                    }
                } else {
                    long z = (long)this.buffer[off == 0 ? 0 : 48] & 0xFFL;
                    if (remainingChars >= 24) {
                        long b5;
                        long b4;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            b4 = ByteArrayUtil.getLong(s, off + 16);
                            b5 = ByteArrayUtil.getLong(s, off + 20);
                            long y = b5 >>> 56;
                            b5 = b4 >>> 56 | b5 << 8;
                            b4 = b3 >>> 56 | b4 << 8;
                            b3 = b2 >>> 56 | b3 << 8;
                            b2 = b1 >>> 56 | b2 << 8;
                            b1 = b0 >>> 56 | b1 << 8;
                            b0 = z | b0 << 8;
                            z = y;
                            this.processBuffer(b0, b1, b2, b3, b4, b5);
                            off += 24;
                        } while ((remainingChars -= 24) >= 24);
                        ByteArrayUtil.setLong(this.buffer, 32, b4);
                        ByteArrayUtil.setLong(this.buffer, 40, b5);
                    }
                    this.buffer[0] = (byte)z;
                }
            }
            ByteArrayUtil.copyCharsToByteArray(s, off, this.buffer, this.offset, remainingChars);
            this.offset += remainingChars << 1;
            return this;
        }

        private void processBuffer() {
            long b0 = ByteArrayUtil.getLong(this.buffer, 0);
            long b1 = ByteArrayUtil.getLong(this.buffer, 8);
            long b2 = ByteArrayUtil.getLong(this.buffer, 16);
            long b3 = ByteArrayUtil.getLong(this.buffer, 24);
            long b4 = ByteArrayUtil.getLong(this.buffer, 32);
            long b5 = ByteArrayUtil.getLong(this.buffer, 40);
            this.processBuffer(b0, b1, b2, b3, b4, b5);
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5) {
            this.see0 = HashUtil.mix(b0 ^ AbstractWyhashFinal.this.secret1, b1 ^ this.see0);
            this.see1 = HashUtil.mix(b2 ^ AbstractWyhashFinal.this.secret2, b3 ^ this.see1);
            this.see2 = HashUtil.mix(b4 ^ AbstractWyhashFinal.this.secret3, b5 ^ this.see2);
        }

        @Override
        public long getAsLong() {
            long b;
            long a;
            long s = this.see0;
            if (this.byteCount <= 16L) {
                if (this.byteCount >= 4L) {
                    a = (long)ByteArrayUtil.getInt(this.buffer, 0) << 32 | (long)ByteArrayUtil.getInt(this.buffer, this.offset >>> 3 << 2) & 0xFFFFFFFFL;
                    b = (long)ByteArrayUtil.getInt(this.buffer, this.offset - 4) << 32 | (long)ByteArrayUtil.getInt(this.buffer, this.offset - 4 - (this.offset >>> 3 << 2)) & 0xFFFFFFFFL;
                } else if (this.byteCount > 0L) {
                    a = AbstractWyhashFinal.wyr3(this.buffer, 0, this.offset);
                    b = 0L;
                } else {
                    a = 0L;
                    b = 0L;
                }
            } else {
                s ^= this.see1 ^ this.see2;
                int i = this.offset;
                int p = 0;
                while (i > 16) {
                    s = HashUtil.mix(ByteArrayUtil.getLong(this.buffer, p) ^ AbstractWyhashFinal.this.secret1, ByteArrayUtil.getLong(this.buffer, p + 8) ^ s);
                    i -= 16;
                    p += 16;
                }
                if (this.offset >= 16) {
                    a = ByteArrayUtil.getLong(this.buffer, this.offset - 16);
                    b = ByteArrayUtil.getLong(this.buffer, this.offset - 8);
                } else {
                    b = ByteArrayUtil.getLong(this.buffer, 0);
                    a = ByteArrayUtil.getLong(this.buffer, 40);
                    int shift = this.offset << 3;
                    if (this.offset > 8) {
                        a = a >>> shift | b << -shift;
                        b = ByteArrayUtil.getLong(this.buffer, this.offset - 8);
                    } else if (this.offset < 8) {
                        b = a >>> shift | b << -shift;
                        a = ByteArrayUtil.getLong(this.buffer, this.offset + 32);
                    }
                }
            }
            return AbstractWyhashFinal.this.finish(a, b, s, this.byteCount);
        }
    }
}

