/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.StorageOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl;", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "Lorg/jetbrains/jps/incremental/storage/StorageOwner;", "storePath", "Ljava/nio/file/Path;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "<init>", "(Ljava/nio/file/Path;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;)V", "mapping", "Lorg/jetbrains/jps/incremental/storage/OneToManyPathsMapping;", "setOutputs", "", "sourceFile", "outputs", "", "appendOutput", "sourcePath", "", "outputPath", "remove", "removeOutput", "srcPath", "getOutputs", "", "getSourcesIterator", "", "getSourceFileIterator", "cursor", "Lorg/jetbrains/jps/incremental/storage/SourceToOutputMappingCursor;", "flush", "memoryCachesOnly", "", "close", "clean", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class SourceToOutputMappingImpl
implements SourceToOutputMapping,
StorageOwner {
    @NotNull
    private final OneToManyPathsMapping mapping;

    public SourceToOutputMappingImpl(@NotNull Path storePath, @NotNull PathRelativizerService relativizer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)storePath, (String)"storePath");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        this.mapping = new OneToManyPathsMapping(storePath, relativizer);
    }

    public void setOutputs(@NotNull Path sourceFile, @NotNull List<? extends Path> outputs2) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter(outputs2, (String)"outputs");
        this.mapping.setOutputs(sourceFile, outputs2);
    }

    @Override
    public void appendOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.mapping.appendData(sourcePath, outputPath);
    }

    @Override
    public void remove(@NotNull Path sourceFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.mapping.remove(sourceFile);
    }

    @Override
    public void removeOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.mapping.removeData(srcPath, outputPath);
    }

    @Nullable
    public List<String> getOutputs(@NotNull String srcPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
        return this.mapping.getOutputs(srcPath);
    }

    @Override
    @Nullable
    public Collection<Path> getOutputs(@NotNull Path sourceFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.mapping.getOutputs(sourceFile);
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() throws IOException {
        Iterator<String> iterator = this.mapping.getKeysIterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"getKeysIterator(...)");
        return iterator;
    }

    @Override
    @NotNull
    public Iterator<Path> getSourceFileIterator() throws IOException {
        Iterator<String> iterator = this.mapping.getKeysIterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"getKeysIterator(...)");
        return SequencesKt.map((Sequence)SequencesKt.asSequence(iterator), SourceToOutputMappingImpl::getSourceFileIterator$lambda$0).iterator();
    }

    @Override
    @NotNull
    public SourceToOutputMappingCursor cursor() throws IOException {
        SourceToOutputMappingCursor sourceToOutputMappingCursor = this.mapping.cursor();
        Intrinsics.checkNotNullExpressionValue((Object)sourceToOutputMappingCursor, (String)"cursor(...)");
        return sourceToOutputMappingCursor;
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        this.mapping.flush(memoryCachesOnly);
    }

    @Override
    public void close() {
        this.mapping.close();
    }

    @Override
    public void clean() {
        this.mapping.clean();
    }

    private static final Path getSourceFileIterator$lambda$0(String it) {
        return Path.of(it, new String[0]);
    }
}

