/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import java.util.Comparator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;

public final class NaturalComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new NaturalComparator();

    @Override
    public int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return NaturalComparator.naturalCompare(s1, s2, s1.length(), s2.length(), true, false);
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    public static int naturalCompare(@NotNull String s1, @NotNull String s2, int length1, int length2, boolean ignoreCase, boolean likeFileNames) {
        int j2;
        if (s1 == null) {
            NaturalComparator.$$$reportNull$$$0(0);
        }
        if (s2 == null) {
            NaturalComparator.$$$reportNull$$$0(1);
        }
        int i2 = 0;
        for (j2 = 0; i2 < length1 && j2 < length2; ++i2, ++j2) {
            int diff;
            char ch1 = s1.charAt(i2);
            char ch2 = s2.charAt(j2);
            if ((Strings.isDecimalDigit(ch1) || ch1 == ' ') && (Strings.isDecimalDigit(ch2) || ch2 == ' ')) {
                int end2;
                int start1 = NaturalComparator.skipChar(s1, NaturalComparator.skipChar(s1, i2, length1, ' '), length1, '0');
                int start2 = NaturalComparator.skipChar(s2, NaturalComparator.skipChar(s2, j2, length2, ' '), length2, '0');
                int end1 = NaturalComparator.skipDigits(s1, start1, length1);
                int lengthDiff = end1 - start1 - ((end2 = NaturalComparator.skipDigits(s2, start2, length2)) - start2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                int numberDiff = NaturalComparator.compareCharRange(s1, s2, start1, start2, end1);
                if (numberDiff != 0) {
                    return numberDiff;
                }
                int fullLengthDiff = end1 - i2 - (end2 - j2);
                if (fullLengthDiff != 0) {
                    return fullLengthDiff;
                }
                int leadingDiff = NaturalComparator.compareCharRange(s1, s2, i2, j2, start1);
                if (leadingDiff != 0) {
                    return leadingDiff;
                }
                i2 = end1 - 1;
                j2 = end2 - 1;
                continue;
            }
            if (!(likeFileNames ? ch1 != ch2 && (diff = ch1 == '-' && ch2 != '_' ? NaturalComparator.compareChars('_', ch2, ignoreCase) : (ch2 == '-' && ch1 != '_' ? NaturalComparator.compareChars(ch1, '_', ignoreCase) : NaturalComparator.compareChars(ch1, ch2, ignoreCase))) != 0 : (diff = NaturalComparator.compareChars(ch1, ch2, ignoreCase)) != 0)) continue;
            return diff;
        }
        if (i2 < length1) {
            return 1;
        }
        if (j2 < length2) {
            return -1;
        }
        if (length1 != length2) {
            return length1 - length2;
        }
        return ignoreCase ? NaturalComparator.naturalCompare(s1, s2, length1, length2, false, likeFileNames) : 0;
    }

    private static int compareCharRange(@NotNull String s1, @NotNull String s2, int offset1, int offset2, int end1) {
        if (s1 == null) {
            NaturalComparator.$$$reportNull$$$0(2);
        }
        if (s2 == null) {
            NaturalComparator.$$$reportNull$$$0(3);
        }
        int i2 = offset1;
        int j2 = offset2;
        while (i2 < end1) {
            int diff = s1.charAt(i2) - s2.charAt(j2);
            if (diff != 0) {
                return diff;
            }
            ++i2;
            ++j2;
        }
        return 0;
    }

    private static int compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ch1 == ' ' && ch2 > ' ' && ch2 < '0') {
            return 1;
        }
        if (ch2 == ' ' && ch1 > ' ' && ch1 < '0') {
            return -1;
        }
        return Strings.compare(ch1, ch2, ignoreCase);
    }

    private static int skipDigits(String s2, int start, int end) {
        while (start < end && Strings.isDecimalDigit(s2.charAt(start))) {
            ++start;
        }
        return start;
    }

    private static int skipChar(String s2, int start, int end, char c2) {
        while (start < end && s2.charAt(start) == c2) {
            ++start;
        }
        return start;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/NaturalComparator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "naturalCompare";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareCharRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

