---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストをフォークすると、アップストリームリポジトリのメンバーがフォークにコントリビュートできるかどうかを設定できます。
title: フォークを越えてマージリクエストでコラボレーションする
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[フォーク](../repository/forking_workflow.md)からマージリクエストを開くと、アップストリームのメンバーがブランチで共同作業できるようにすることができます。このオプションを有効にすると、ターゲットブランチへのマージ権限を持つメンバーは、マージリクエストのソースブランチへの書き込み権限を取得します。

これにより、アップストリームプロジェクトのメンバーは、マージする前に小さな修正を行ったり、リベースブランチを作成したりできます。

この機能は、フォークされたプロジェクト間で[公開されている](../../public_access.md)マージリクエストで使用できます。

## アップストリームメンバーからのコミットを許可する {#allow-commits-from-upstream-members}

マージリクエストの作成者は、コントリビュート先のプロジェクトのアップストリームメンバーからのコミット編集を許可できます:

1. マージリクエストの作成または編集中に、**コントリビュート**までスクロールし、**Allow commits from members who can merge to the target branch**（ターゲットブランチにマージできるメンバーからのコミットを許可する）チェックボックスを選択します。
1. マージリクエストの作成を完了します。

マージリクエストを作成すると、マージリクエストウィジェットに**Members who can merge are allowed to add commits**（メンバーはマージできるコミットの追加を許可されています）というメッセージが表示されます。アップストリームメンバーは次のことができます:

- ブランチに直接コミットします。
- マージリクエストのパイプラインとジョブを再試行します。

## アップストリームメンバーからのコミットを禁止する {#prevent-commits-from-upstream-members}

マージリクエストの作成者は、コントリビュート先のプロジェクトのアップストリームメンバーからのコミット編集を禁止できます:

1. マージリクエストの作成または編集中に、**コントリビュート**までスクロールし、**Allow commits from members who can merge to the target branch**（ターゲットブランチにマージできるメンバーからのコミットを許可する）チェックボックスをオフにします。
1. マージリクエストの作成を完了します。

## アップストリームメンバーとしてフォークにプッシュする {#push-to-the-fork-as-the-upstream-member}

次の条件に該当する場合、フォークされたリポジトリのブランチに直接プッシュできます:

- マージリクエストの作成者が、アップストリームメンバーからのコントリビュートを有効にしている。
- アップストリームプロジェクトのデベロッパーロール以上を持っている。

フォークのブランチに変更をプッシュしたり、コミットを追加したりするには、コマンドラインGitを使用できます。詳しくは、[アップストリームメンバーとしてフォークにプッシュするためにGitを使用](../../../topics/git/forks.md#push-to-a-fork-as-an-upstream-member)を参照してください。

## トラブルシューティング {#troubleshooting}

### フォークされたプロジェクトのMRページからパイプラインステータスを利用できません {#pipeline-status-unavailable-from-mr-page-of-forked-project}

ユーザーがプロジェクトをフォークすると、フォークされたコピーの権限は元のプロジェクトからコピーされません。アップストリームプロジェクトのメンバーがマージリクエストの変更を表示またはマージするには、フォークの作成者がフォークされたコピーに権限を付与する必要があります。

元のプロジェクトに戻るフォークされたプロジェクトのマージリクエストページからパイプラインステータスを表示するには:

1. すべてのアップストリームメンバーを含む[グループを作成](../../group/_index.md#create-a-group)します。
1. 左側のサイドバーで、**検索または移動先**を選択し、フォークしたプロジェクトを見つけます。
1. フォークされたプロジェクトの**管理** > **メンバー**ページに移動し、新しく作成したグループをフォークされたプロジェクトに招待します。
