---
stage: Create
group: Import
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 移行後のコントリビュートおよびメンバーシップのマッピング
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.4で、`importer_user_mapping`および`bulk_import_importer_user_mapping`という名前の[機能フラグ](../../administration/feature_flags/_index.md)付きの直接転送[で導入](https://gitlab.com/gitlab-org/gitlab/-/issues/443557)されました。デフォルトでは無効になっています。
- `importer_user_mapping`および`gitea_user_mapping`という名前の[機能フラグ](../../administration/feature_flags/_index.md)付きでGiteaに、`importer_user_mapping`および`github_user_mapping`という名前の機能フラグ付きで[GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/466355)にGitLab 17.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/467084)されました。デフォルトでは無効になっています。
- GitLab 17.7で、`importer_user_mapping`および`bitbucket_server_user_mapping`という名前の[機能フラグ](../../administration/feature_flags/_index.md)付きでBitbucket Serverに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/466356)されました。デフォルトでは無効になっています。
- GitLab 17.7の[GitLab.comおよびGitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/472735)（直接転送の場合）。
- GitLab 17.7のGitLab.comで[Bitbucket Server](https://gitlab.com/gitlab-org/gitlab/-/issues/509897)、[Gitea](https://gitlab.com/gitlab-org/gitlab/-/issues/498390)、および[GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/499993)で有効になりました。
- GitLab 17.8のGitLab Self-Managedで[Bitbucket Server](https://gitlab.com/gitlab-org/gitlab/-/issues/509897)、[Gitea](https://gitlab.com/gitlab-org/gitlab/-/issues/498390)、および[GitHub](https://gitlab.com/gitlab-org/gitlab/-/issues/499993)で有効になりました。
- パーソナルネームスペースへのインポート時に、個人のネームスペースオーナーにコントリビュートを再割り当てすることがGitLab 18.3で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/525342)されました。`user_mapping_to_personal_namespace_owner`[という名前の機能フラグ付き](../../administration/feature_flags/_index.md)。デフォルトでは無効になっています。
- ダイレクトトランスファーの[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/508945)はGitLab 18.4で行われました。機能フラグ`bulk_import_importer_user_mapping`は削除されました。
- サービスアカウント、プロジェクトボット、およびグループボットへのコントリビュートの再割り当ては、`user_mapping_service_account_and_bots`[という名前の機能フラグ付き](../../administration/feature_flags/_index.md)でGitLab 18.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/573124)されました。デフォルトでは有効になっています。
- Giteaの[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/512211)はGitLab 18.6で行われました。機能フラグ`gitea_user_mapping`は削除されました。
- パーソナルネームスペースへのインポート時に、個人のネームスペースオーナーにコントリビュートを再割り当てすることがGitLab 18.6で[一般公開](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211626)されました。機能フラグ`user_mapping_to_personal_namespace_owner`は削除されました。
- `github_user_mapping`機能フラグは、GitLab 18.8で[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216778)されました。

{{< /history >}}

移行後のマッピングにより、ソースインスタンスからのユーザーコントリビュートとメンバーシップは、宛先インスタンス上の実際のユーザーではなく、最初にプレースホルダユーザーに割り当てられます。

実際のユーザーへの割り当てを延期できるため、インポートをレビューし、正しいユーザーにコントリビュートを再割り当てする時間を確保できます。このプロセスにより、マッピングプロセスを制御しながら、正確な属性を保証できます。

移行後のユーザーコントリビュートとメンバーシップのマッピングは、次からの移行でデフォルトで利用できます:

- [ダイレクトトランスファーを使用する場合のGitLab](../group/import/_index.md)
- [GitHub](../project/import/github.md)
- [Bitbucket Server](bitbucket_server.md)
- [Gitea](gitea.md)

プロジェクトを[パーソナルネームスペース](../namespace/_index.md#types-of-namespaces)にインポートする場合、ユーザーコントリビュートマッピングとメンバーシップマッピングはサポートされず、すべてのコントリビュートはパーソナルネームスペースオーナーに割り当てられます。これらのコントリビュートは再割り当てできません。

## 前提条件 {#prerequisites}

- [ユーザー制限](#placeholder-user-limits)に従って、ユーザー数を計画します。
- GitLab.comにインポートする場合は、有料ネームスペースを設定します。
- GitLab.comにインポートし、[GitLab.comグループのSAML SSO](../group/saml_sso/_index.md)を使用する場合は、すべてのユーザーがSAML IDをGitLab.comアカウントにリンクしていることを確認します。

## 移行後のマッピングワークフロー {#post-migration-mapping-workflow}

移行後のマッピングを使用する場合、GitLabはインポートするすべてのメンバーシップとコントリビュートを[プレースホルダユーザー](#placeholder-users)にマップします。プレースホルダユーザーは、ソースインスタンスに同じメールアドレスを持つユーザーが存在する場合でも、宛先インスタンスに作成されます。宛先インスタンスでコントリビュートを再割り当てするまで、すべてのコントリビュートはプレースホルダユーザーに関連付けられます。

インポートが完了し、結果をレビューしたら、次のようにマッピングを更新できます:

- 宛先インスタンス上の既存のユーザーにメンバーシップとコントリビュートを再割り当てします。移行元インスタンスと移行先インスタンスで異なるメールアドレスを持つユーザーのメンバーシップとコントリビュートをマッピングできます。
- 宛先インスタンスに新しいユーザーを作成し、それらにメンバーシップとコントリビュートを再割り当てします。

特定のコントリビュートをプレースホルダユーザーに割り当てたままにして、履歴コンテキストを保持することもできます。

宛先インスタンス上のユーザーにコントリビュートを再割り当てすると、ユーザーは次のいずれかを選択できます:

- 再割り当てを受け入れる。再割り当てプロセスには数分かかる場合があります。その後、同じソースインスタンスから、宛先インスタンス上の同じトップレベルグループまたはサブグループにインポートすると、コントリビュートはユーザーに自動的にマッピングされます。
- 再割り当てを拒否する。

### エンタープライズユーザー {#enterprise-users}

{{< history >}}

- GitLab 18.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/510673)されました。

{{< /history >}}

トップレベルグループに少なくとも1人の[エンタープライズユーザー](../enterprise_user/_index.md)がいる場合、組織内のエンタープライズユーザーにのみコントリビュートを再割り当てすることができます。

つまり、組織外のユーザーに誤って再割り当てしてしまうことはありません。

### 削除されたユーザー {#deleted-users}

ソースインスタンスで、現在削除されているユーザーによって行われたコントリビュートは、次の場合を除き、宛先インスタンス上の[Ghostユーザー](../../administration/internal_users.md)にマップされます:

- コントリビュートがソースインスタンス上の削除されたユーザーから適切に切り離されなかった。
- Bitbucket Serverから移行する場合。

### プレースホルダーユーザー {#placeholder-users}

コントリビュートとメンバーシップのマッピングでは、コントリビュートとメンバーシップを宛先インスタンス上のユーザーにすぐに割り当てることはありません。代わりに、インポートされたコントリビュートまたはメンバーシップを持つアクティブ、非アクティブ、またはボットユーザーに対してプレースホルダユーザーが作成されます。

コントリビュートとメンバーシップはどちらも、最初にこれらのプレースホルダユーザーに割り当てられ、インポート後に宛先インスタンス上の既存のユーザーに再割り当てすることができます。

再割り当てられるまで、コントリビュートはプレースホルダーに関連付けられています。プレースホルダーのメンバーシップは、メンバーリストには表示されません。

プレースホルダーユーザーは、ライセンス制限にはカウントされません。

#### 例外 {#exceptions}

プレースホルダユーザーは、次のシナリオでは作成されません:

- 削除されたユーザーからのコントリビュートがある[Gitea](gitea.md)からプロジェクトをインポートしています。これらのユーザーからのコントリビュートは、プロジェクトをインポートしたユーザーにマップされます。
- [プレースホルダーユーザー制限](#placeholder-user-limits)を超過しました。新しいユーザーからのコントリビュートは、インポートユーザーにマップされます。

#### プレースホルダーユーザー属性 {#placeholder-user-attributes}

プレースホルダーユーザーは通常のユーザーとは異なり、次のことはできません。

- サインイン。
- アクションを実行する。たとえば、パイプラインの実行などです。
- イシューおよびマージリクエストの担当者またはレビュアーとして候補に表示されます。
- プロジェクトおよびグループのメンバーになる。

ソースインスタンス上のユーザーとの接続を維持するために、プレースホルダーユーザーには次のものがあります。

- 新しいプレースホルダーユーザーが必要かどうかをインポートプロセスが判断するために使用する固有識別子（`source_user_id`）。
- ソースホスト名またはドメイン（`source_hostname`）。
- コントリビュートの再割り当てを支援するためのソースユーザーの名前（`source_name`）。
- コントリビュートの再アサイン中にグループオーナーを支援するためのソースユーザーのユーザー名（`source_username`）。
- どのインポーターがプレースホルダーを作成したかを区別するインポートタイプ（`import_type`）。
- 移行追跡のために移行元ユーザーが作成されたときのタイムスタンプ（`created_at`）（ローカル時刻）（GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/507297)）。

履歴コンテキストを保持するために、プレースホルダーユーザー名とユーザー名は、移行元ユーザー名とユーザー名から派生します。

- プレースホルダーユーザーの名前は`Placeholder <source user name>`です。
- プレースホルダーユーザーのユーザー名は`%{source_username}_placeholder_user_%{incremental_number}`です。

#### プレースホルダーユーザーを表示する {#view-placeholder-users}

前提条件: 

- グループのオーナーのロールを持っている必要があります。

トップレベルグループとそのサブグループへのインポート中に、プレースホルダーユーザーが移行先インスタンスに作成されます。トップレベルグループとそのサブグループへのインポート中に作成されたプレースホルダーユーザーを表示するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。

#### プレースホルダーユーザーをフィルタリングする {#filter-for-placeholder-users}

{{< details >}}

- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/521974)されました。

{{< /history >}}

前提条件: 

- インスタンスへの管理者アクセス権が必要です。

トップレベルグループとそのサブグループへのインポート中に、プレースホルダーユーザーが移行先インスタンスに作成されます。インスタンス全体のインポート中に作成されたプレースホルダーユーザーをフィルタリングするには:

1. 右上隅で、**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. 検索ボックスで、**タイプ**でユーザーをフィルタリングします。

#### プレースホルダーユーザーを作成する {#creating-placeholder-users}

プレースホルダユーザーは、インポート元ごと、およびトップレベルグループごとに作成されます:

- 同じプロジェクトを移行先インスタンスの同じトップレベルグループに2回インポートする場合、2回目のインポートでは最初のインポートと同じプレースホルダーユーザーが使用されます。
- 同じプロジェクトを2回インポートしても、移行先インスタンスの異なるトップレベルグループにインポートする場合、2回目のインポートではそのトップレベルグループの下に新しいプレースホルダーユーザーが作成されます。

{{< alert type="note" >}}

プレースホルダーユーザーは、トップレベルグループにのみ関連付けられています。サブグループまたはプロジェクトを削除すると、プレースホルダーユーザーはトップレベルグループ内のコントリビュートを参照しなくなります。テストには、指定されたトップレベルグループを使用する必要があります。プレースホルダーユーザーの削除は、[イシュー519391](https://gitlab.com/gitlab-org/gitlab/-/issues/519391)および[イシュー537340](https://gitlab.com/gitlab-org/gitlab/-/issues/537340)で提案されています。

{{< /alert >}}

ユーザーが[再アサインを承認](#accept-contribution-reassignment)すると、同じソースインスタンスから、宛先インスタンス上の同じトップレベルグループまたはサブグループにインポートしても、プレースホルダーユーザーは作成されません。代わりに、コントリビュートはユーザーに自動的にマッピングされます。

#### プレースホルダーユーザーの削除 {#placeholder-user-deletion}

{{< history >}}

- GitLab 18.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/473256)されました。

{{< /history >}}

プレースホルダユーザーを含むトップレベルグループを削除すると、これらのユーザーは自動的に削除のスケジュールが設定されます。このプロセスが完了するまでに時間がかかる場合があります。ただし、プレースホルダユーザーが他のプロジェクトまたはグループにも関連付けられている場合、システムに残ります。

> [!note]プレースホルダユーザーを削除する他の方法は存在しませんが、[イシュー519391](https://gitlab.com/gitlab-org/gitlab/-/issues/519391)および[イシュー537340](https://gitlab.com/gitlab-org/gitlab/-/issues/537340)で改善のサポートが提案されています。

#### プレースホルダーユーザー制限 {#placeholder-user-limits}

GitLab.comにインポートする場合、プレースホルダーユーザーは、移行先インスタンスのトップレベルグループごとに制限されます。制限は、プランとシート数によって異なります。プレースホルダーユーザーは、ライセンス制限にはカウントされません。

| GitLab.comのプラン          | シート数 | トップレベルグループのプレースホルダーユーザー制限 |
|:-------------------------|:----------------|:------------------------------------------|
| Freeおよびすべてのトライアル       | 任意の量      | 200                                       |
| Premium                  | < 100           | 500                                       |
| Premium                  | 101〜500         | 2000                                      |
| Premium                  | 501～1000      | 4000                                      |
| Premium                  | > 1000          | 6000                                      |
| Ultimateおよびオープンソース | < 100           | 1000                                      |
| Ultimateおよびオープンソース | 101〜500         | 4000                                      |
| Ultimateおよびオープンソース | 501～1000      | 6000                                      |
| Ultimateおよびオープンソース | > 1000          | 8000                                      |

GitLab Self-ManagedおよびGitLab Dedicatedの場合、デフォルトではプレースホルダー制限は適用されません。GitLab管理者は、インスタンスの[プレースホルダー制限を設定](../../administration/instance_limits.md#import-placeholder-user-limits)できます。

現在のプレースホルダーユーザーの使用量と制限を表示するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定** > **使用量クォータ**を選択します。
1. **インポート**タブを選択します。

事前に必要なプレースホルダーユーザーの数を判断することはできません。

プレースホルダーユーザー制限に達すると、すべてのコントリビュートが`Import User`という単一の非機能ユーザーに割り当てられます。`Import User`に割り当てられたコントリビュートは重複排除される可能性があり、インポート中に一部のコントリビュートが作成されない可能性があります。たとえば、マージリクエストの承認者からの複数の承認が`Import User`に割り当てられている場合、最初の承認のみが作成され、その他は無視されます。重複排除される可能性のあるコントリビュートは次のとおりです。

- 承認ルール
- 絵文字リアクション
- イシューの担当者
- メンバーシップ
- マージリクエストの承認、担当者、レビュアー
- プッシュ、マージリクエスト、およびデプロイのアクセスレベル

すべての変更によってシステムノートが作成されます。これは、プレースホルダーユーザー制限の影響を受けません。

## コントリビュートとメンバーシップの再アサイン {#reassign-contributions-and-memberships}

トップレベルグループのオーナーロールを持つユーザーは、プレースホルダユーザーから既存のアクティブな非ボットユーザーにコントリビュートとメンバーシップを再割り当てすることができます。移行先インスタンスでは、トップレベルグループのオーナーロールを持つユーザーは、次のことができます。

- [UI](#request-reassignment-in-ui)で、または[CSVファイル](#request-reassignment-by-using-a-csv-file)を介して、ユーザーにコントリビュートとメンバーシップの再アサインをレビューするようリクエストします。多数のプレースホルダーユーザーがいる場合は、CSVファイルを使用する必要があります。どちらの場合も、ユーザーは再アサインを受け入れるか拒否するためのリクエストをメールで受信します。選択したユーザーが[再割り当てリクエストを承認](#accept-contribution-reassignment)した後にのみ、再割り当てが開始されます。
- コントリビュートとメンバーシップを再アサインしないことを選択し、[プレースホルダーユーザーに割り当てられたまま](#keep-as-placeholder)にします。

GitLab Self-ManagedおよびGitLab Dedicatedでは、管理者はコントリビュートとメンバーシップを、確認なしにアクティブおよび非アクティブの非ボットユーザーにすぐに再割り当てすることができます。詳細については、[管理者がプレースホルダーユーザーを再アサインするときに承認をスキップする](../../administration/settings/import_and_export_settings.md#skip-confirmation-when-administrators-reassign-placeholder-users)を参照してください。コントリビュートとメンバーシップを管理者に再割り当てするには、[コントリビュートマッピングを管理者に許可する](../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)を参照してください。

## プレースホルダユーザーを再割り当てするときの確認をバイパスする {#bypass-confirmation-when-reassigning-placeholder-users}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

{{< history >}}

- `group_owner_placeholder_confirmation_bypass`という機能フラグ付きで、GitLab 18.1の[GitLab.comで導入](https://gitlab.com/gitlab-org/gitlab/-/issues/544024)されました。デフォルトでは無効になっています。
- GitLab 18.4の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/548946)になりました。
- GitLab 18.7の[GitLab.comで一般公開](https://gitlab.com/gitlab-org/gitlab/-/issues/569771)されました。機能フラグ`group_owner_placeholder_confirmation_bypass`は削除されました。

{{< /history >}}

前提条件: 

- グループのオーナーのロールを持っている必要があります。

プレースホルダーを再割り当てするときに、[エンタープライズユーザー](../enterprise_user/_index.md)の確認をバイパスするには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定** > **一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **プレースホルダーユーザーの確認**で、**プレースホルダーをユーザー認証なしにエンタープライズユーザーに再割り当て**チェックボックスを選択します。
1. **ユーザーの確認の復元するタイミング**で、ユーザーの確認をバイパスする終了日を選択します。デフォルト値は1日です。
1. **変更を保存**を選択します。

### 複数のプレースホルダーユーザーからのコントリビュートの再割り当て {#reassigning-contributions-from-multiple-placeholder-users}

最初に単一のプレースホルダユーザーに割り当てられたすべてのコントリビュートを、宛先インスタンス上の単一のアクティブな通常のユーザー、サービスアカウント、プロジェクトボット、およびグループボットに再割り当てすることができます。単一のプレースホルダユーザーに割り当てられたコントリビュートを複数のユーザーに分割することはできません。

プレースホルダーユーザーが以下からのユーザーである場合、複数のプレースホルダーユーザーからのコントリビュートを宛先インスタンス上の同じユーザーに再アサインできます。

- 異なるソースインスタンス
- 同じソースインスタンス（宛先インスタンス上の異なるトップレベルグループにインポートされる）

割り当てられたユーザーが再アサインリクエストを承認する前に無効になった場合、保留中の再アサインは、ユーザーが承認するまでユーザーにリンクされたままになります。

再割り当てリクエストを受信するユーザーは、次のことができます:

- [リクエストを承認する](#accept-contribution-reassignment)。以前にプレースホルダーユーザーに起因していたすべてのコントリビュートとメンバーシップは、承認ユーザーに再アサインされます。このプロセスには、コントリビュートの数に応じて数分かかる場合があります。
- [リクエストを拒否](#reject-contribution-reassignment)するか、スパムとして報告します。このオプションは、再割り当てリクエストメールで利用できます。

サービスアカウント、プロジェクトボット、およびグループボットにコントリビュートを再割り当てすると、再割り当てリクエストが自動的に承認されます。

同じトップレベルグループへの以降のインポートでは、同じソースユーザーに属するコントリビュートとメンバーシップは、そのソースユーザーの再アサインを以前に承認したユーザーに自動的にマッピングされます。

GitLab Self-ManagedおよびGitLab Dedicatedでは、管理者はコントリビュートとメンバーシップを、確認なしにアクティブおよび非アクティブの非ボットユーザーにすぐに再割り当てすることができます。詳細については、[管理者がプレースホルダーユーザーを再アサインするときに承認をスキップする](../../administration/settings/import_and_export_settings.md#skip-confirmation-when-administrators-reassign-placeholder-users)を参照してください。コントリビュートとメンバーシップを管理者に再割り当てするには、[コントリビュートマッピングを管理者に許可する](../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)を参照してください。

### 再アサインの完了 {#completing-the-reassignment}

再アサインプロセスは、次の操作を行う前に完全に完了する必要があります:

- [同じGitLabインスタンス内でインポートされたグループを移動する](../group/manage.md#transfer-a-group)。
- [インポートされたプロジェクトを別のグループに移動する](../project/working_with_projects.md#transfer-a-project)。
- インポートされたイシューを複製します。
- インポートされたイシューをエピックにプロモートします。

プロセスが完了していない場合、プレースホルダーユーザーに割り当てられたままのコントリビュートは、実際のユーザーに再アサインできず、プレースホルダーユーザーに関連付けられたままになります。

### セキュリティに関する考慮事項 {#security-considerations}

コントリビュートとメンバーシップの再アサインは元に戻すことができないため、開始する前にすべてを注意深く確認してください。

コントリビュートとメンバーシップを誤ったユーザーに再アサインすると、そのユーザーがグループのメンバーになるため、セキュリティ上の脅威となります。そのため、閲覧を許可されていない情報を閲覧できるようになります。

管理者アクセス権を持つユーザーへのコントリビュートの再アサインはデフォルトで無効になっていますが、[有効に](../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)することができます。

#### メンバーシップのセキュリティに関する考慮事項 {#membership-security-considerations}

GitLabの権限モデルにより、グループまたはプロジェクトが既存の親グループにインポートされると、親グループのメンバーには、インポートされたグループまたはプロジェクトの[継承されたメンバーシップ](../project/members/_index.md#membership-types)が付与されます。

インポートされたグループまたはプロジェクトの既存の継承されたメンバーシップをすでに持っているユーザーをコントリビュートとメンバーシップの再アサインに選択すると、メンバーシップがそのユーザーにどのように再アサインされるかに影響を与える可能性があります。

GitLabでは、子プロジェクトまたはグループのメンバーシップが、継承されたメンバーシップよりも低いロールを持つことは許可されていません。割り当てられたユーザーのインポートされたメンバーシップが、既存の継承されたメンバーシップよりも低いロールを持っている場合、インポートされたメンバーシップはユーザーに再アサインされません。

その結果、インポートされたグループまたはプロジェクトのメンバーシップが、移行元よりも高い状態になります。

### UIで再割り当てをリクエストする {#request-reassignment-in-ui}

前提条件: 

- グループのオーナーのロールを持っている必要があります。

トップレベルグループでコントリビュートとメンバーシップを再割り当てできます。コントリビュートとメンバーシップの再割り当てをリクエストするには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 各プレースホルダーについて、テーブルの列**プレースホルダーユーザー**と**ソース**の情報をレビューします。
1. **プレースホルダーの再割り当て先**列で、ドロップダウンリストからユーザーを選択します。
1. **再アサイン**を選択します。

1つのプレースホルダーユーザーのコントリビュートのみを、移行先インスタンスのアクティブな非ボットユーザーに再アサインできます。

ユーザーが再アサインを承認する前に、[リクエストをキャンセル](#cancel-reassignment-request)できます。

GitLab Self-ManagedおよびGitLab Dedicatedでは、管理者はコントリビュートとメンバーシップを、確認なしにアクティブおよび非アクティブの非ボットユーザーにすぐに再割り当てすることができます。詳細については、[管理者がプレースホルダーユーザーを再アサインするときに承認をスキップする](../../administration/settings/import_and_export_settings.md#skip-confirmation-when-administrators-reassign-placeholder-users)を参照してください。コントリビュートとメンバーシップを管理者に再割り当てするには、[コントリビュートマッピングを管理者に許可する](../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)を参照してください。

### CSVファイルを使用して再アサインをリクエストする {#request-reassignment-by-using-a-csv-file}

{{< history >}}

- GitLab 17.10で`importer_user_mapping_reassignment_csv`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/455901)されました。デフォルトでは有効になっています。
- GitLab 18.0[で一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/478022)になりました。機能フラグ`importer_user_mapping_reassignment_csv`は削除されました。

{{< /history >}}

前提条件: 

- グループのオーナーのロールを持っている必要があります。

多数のプレースホルダーユーザーの場合、CSVファイルを使用してコントリビュートとメンバーシップを再アサインすることができます。次の情報を含む、事前入力されたCSVテンプレートをダウンロードできます。例: 

| ソースホスト          | インポートタイプ | ソースユーザー識別子 | ソースユーザーの氏名 | ソースユーザー名 |
|----------------------|-------------|------------------------|------------------|-----------------|
| `gitlab.example.com` | `gitlab`    | `alice`                | `Alice Coder`    | `a.coer`        |

**ソースホスト**、**インポートタイプ**、または**ソースユーザー識別子**を更新しないでください。この情報は、完成したCSVファイルをアップロードした後で、対応するデータベースレコードを見つけるために使用されます。**ソースユーザーの氏名**と**ソースユーザー名**は、ソースユーザーを識別するものであり、CSVファイルをアップロードした後は使用されません。

CSVファイルのすべての行を更新する必要はありません。**GitLabユーザー名**または**GitLabパブリックメール**を含む行のみが処理されます。他のすべての行はスキップされます。

CSVファイルを使用してコントリビュートとメンバーシップの再アサインをリクエストするには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **CSVで再アサイン**を選択します。
1. 事前入力されたCSVテンプレートをダウンロードします。
1. **GitLabユーザー名**または**GitLabパブリックメール**に、移行先インスタンスのGitLabユーザーのユーザー名またはパブリックメールアドレスを入力します。インスタンス管理者は、確認済みのメールアドレスを持つユーザーを再割り当てできます。
1. 完成したCSVファイルをアップロードします。
1. **再アサイン**を選択します。

単一のプレースホルダーユーザーからのコントリビュートのみを、移行先インスタンスの各アクティブな非ボットユーザーに割り当てることができます。ユーザーは、自分に再アサインされた[コントリビュートをレビューして承認する](#accept-contribution-reassignment)ためのメールを受信します。ユーザーがレビューする前に、[再アサインリクエストをキャンセル](#cancel-reassignment-request)できます。

GitLab Self-ManagedおよびGitLab Dedicatedでは、管理者はコントリビュートとメンバーシップを、確認なしにアクティブおよび非アクティブの非ボットユーザーにすぐに再割り当てすることができます。詳細については、[管理者がプレースホルダーユーザーを再アサインするときに承認をスキップする](../../administration/settings/import_and_export_settings.md#skip-confirmation-when-administrators-reassign-placeholder-users)を参照してください。コントリビュートとメンバーシップを管理者に再割り当てするには、[コントリビュートマッピングを管理者に許可する](../../administration/settings/import_and_export_settings.md#allow-contribution-mapping-to-administrators)を参照してください。

コントリビュートを再アサインすると、GitLabから次の数が記載されたメールが送信されます。

- 正常に処理された行
- 正常に処理されなかった行
- スキップされた行

正常に処理されなかった行がある場合、メールには、より詳細な結果が記載されたCSVファイルが添付されます。

UIを使用せずにプレースホルダーユーザーを一括で再割り当てするには、[グループプレースホルダー再割り当てAPI](../../api/group_placeholder_reassignments.md)を参照してください。

### プレースホルダーとして保持する {#keep-as-placeholder}

{{< history >}}

- GitLab 18.5で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/535431)されました。操作は復元できます。

{{< /history >}}

コントリビュートとメンバーシップを移行先インスタンスのユーザーに再アサインしたくない場合があります。たとえば、移行元インスタンスでコントリビュートした元従業員がいて、移行先インスタンスにユーザーとして存在しない場合があります。

このような場合は、コントリビュートをプレースホルダーユーザーに割り当てたままにすることができます。プレースホルダーユーザーは、[プロジェクトまたはグループのメンバーになることができない](#placeholder-user-attributes)ため、メンバーシップ情報を保持しません。

プレースホルダーユーザーの名前とユーザー名は、移行元ユーザーの名前とユーザー名に似ているため、多くの履歴コンテキストを保持できます。

コントリビュートをプレースホルダーユーザーに割り当てたままにすることは、一度に1つずつ行うか、一括で行うことができます。コントリビュートを一括で再アサインすると、ネームスペース全体と、次の[再アサインステータス](#view-and-filter-by-reassignment-status)を持つユーザーが影響を受けます。

- `Not started`
- `Rejected`

プレースホルダーユーザーを一度に1つずつ保持するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. **プレースホルダーユーザー**および**ソース**列をレビューして、保持するプレースホルダーユーザーを見つけます。
1. **再割り当て先のプレースホルダー**列で、**再割り当てしない**を選択します。
1. **確認**を選択します。

プレースホルダーユーザーを一括で保持するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. リストの上にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）> **すべてをプレースホルダーとして保持**を選択します。
1. 確認ダイアログで、**確認**を選択します。

操作を復元するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て済**サブタブに移動します。ここにプレースホルダーが表でリスト表示されます。
1. 正しい行の**元に戻す**を選択します。

### 再割り当てのリクエストをキャンセルする {#cancel-reassignment-request}

ユーザーが再割り当てリクエストを承認する前に、リクエストをキャンセルできます。

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 正しい行で**キャンセル**を選択します。

### 保留中の再割り当てリクエストについて、再度ユーザーに通知する {#notify-user-again-about-pending-reassignment-requests}

ユーザーが再アサインリクエストに対応していない場合は、別のメールを送信して再度プロンプトを表示できます。

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. 正しい行で**通知**を選択します。

### 再アサインステータスで表示およびフィルタリングする {#view-and-filter-by-reassignment-status}

すべてのプレースホルダーユーザーの再アサインステータスを表示するには:

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **管理** > **メンバー**を選択します。
1. **プレースホルダー**タブを選択します。
1. **再割り当て待ち**サブタブに移動します。プレースホルダーがテーブルにリストされています。
1. **再割り当てのステータス**列で、各プレースホルダーユーザーの状態を確認します。

**再割り当て待ち**タブで使用可能なステータスは次のとおりです。

- `Not started` - 再アサインは開始されていません。
- `Pending approval` - 再アサインは、ユーザーの承認を待機しています。
- `Reassigning` - 再アサインが進行中です。
- `Rejected` - 再アサインはユーザーによって拒否されました。
- `Failed` - 再アサインに失敗しました。

**再割り当て済**タブで使用可能なステータスは次のとおりです。

- `Success` - 再アサインに成功しました。
- `Kept as placeholder` - プレースホルダーユーザーが永続化されました。

デフォルトでは、テーブルはプレースホルダーユーザー名でアルファベット順に並べ替えられています。再アサイン状態でテーブルを並べ替えることもできます。

## コントリビュートの再割り当てを確認する {#confirm-contribution-reassignment}

[**管理者がプレースホルダーユーザーを再割り当てするときに承認をスキップする**](../../administration/settings/import_and_export_settings.md#skip-confirmation-when-administrators-reassign-placeholder-users)が有効になっている場合:

- 管理者はユーザーの承認なしに、コントリビュートをすぐに再アサインできます。
- 管理者は、コントリビュートをアクティブおよび非アクティブの非ボットユーザーに再割り当てすることができます。
- コントリビュートが再割り当てされたことを通知するメールが届きます。

この設定が有効になっていない場合、再アサインを[承認](#accept-contribution-reassignment)または[却下](#reject-contribution-reassignment)できます。

### コントリビュートの再割り当てを承認する {#accept-contribution-reassignment}

インポート処理が行われたことを知らせるメールが届き、コントリビュートを自分自身に再アサインすることを確認するように求められる場合があります。

このインポート処理について知らされた場合でも、再アサインの詳細を非常に注意深くレビューする必要があります。メールに記載されている詳細は次のとおりです。

- **インポート元** \- インポートされたコンテンツの送信元プラットフォーム。たとえば、GitLab、GitHub、またはBitbucketの別のインスタンス。
- **元のユーザー** \- ソースプラットフォーム上のユーザーの氏名とユーザー名。これは、そのプラットフォームでのあなたの氏名とユーザー名である可能性があります。
- **インポート先** \- 新しいプラットフォームの名前。GitLabインスタンスのみです。
- **再アサイン先** \- GitLabインスタンスでのあなたの氏名とユーザー名。
- **再アサイン者** \- インポートを実行した同僚または上司の氏名とユーザー名。

### コントリビュートの再割り当てを拒否する {#reject-contribution-reassignment}

コントリビュートの自分自身への再アサインを確認するように求めるメールを受信し、この情報を認識しない場合、または誤りに気付いた場合は、次のようにします:

1. まったく続行しないでください。または、コントリビュートの再アサインを拒否してください。
1. 信頼できる同僚または上司に相談してください。

### セキュリティに関する考慮事項 {#security-considerations-1}

再割り当てリクエストの再アサインの詳細を非常に注意深くレビューする必要があります。信頼できる同僚または上司からこのプロセスについて事前に知らされていない場合は、特に注意してください。

疑わしい再割り当てを承認するのではなく、次のようにします:

1. メールに対応しないでください。
1. 信頼できる同僚または上司に相談してください。

知っていて信頼できるユーザーからの再アサインのみを承認してください。コントリビュートの再アサインは永続的であり、元に戻すことはできません。再割り当てを承認すると、コントリビュートが誤ってあなたに起因する可能性があります。

コントリビュートの再アサインプロセスは、GitLabで**再アサインを承認**を選択して再アサインリクエストを承認した後にのみ開始されます。プロセスは、メール内のリンクを選択しても開始されません。

## 代替マッピング方法 {#alternative-mapping-method}

移行後のマッピングの代替手段は、移行中にマップする方法です。この方法はお勧めしません。見つかった問題が修正される可能性は低いです。

代替のマッピング方法:

- 移行前に、機能フラグを無効にするなど、いくつかの準備が必要です。
- 次のものからの移行に利用できます:
  - GitHub。
  - Bitbucket Server。
  - Gitea（GitLab 18.5以前）。
- GitLab Self-ManagedおよびGitLab Dedicatedへの移行に利用できます。

詳細については、各インポーターのマッピングドキュメントの代替方法を参照してください。
