---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 基本エージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

この機能は[GitLabクレジット](../../../../subscriptions/gitlab_credits.md)を使用します。

{{< /details >}}

{{< history >}}

- GitLab 18.6でベータ版として[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/576618)されました。
- GitLab 18.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/work_items/585273)になりました。

{{< /history >}}

基本エージェントは、ドメイン固有の専門知識とコンテキスト認識を備え、GitLab Duo Chatの機能を拡張する特化型AIアシスタントです。

汎用的なGitLab Duo Agentとは異なり、基本エージェントは、それぞれの専門ドメインに固有のワークフロー、フレームワーク、ベストプラクティスを理解しています。各エージェントは、GitLab機能に関する深い知識と役割に応じた推論を組み合わせることで、実際の業務に即した形で役立つ、的確な支援を提供します。

基本エージェントは、GitLabによって構築および管理されており、GitLab管理バッジ（{{< icon name="tanuki-verified" >}}）が表示されます。

## 利用可能な基本エージェント {#available-foundational-agents}

次の基本エージェントを利用できます:

- [プランナー](planner.md)。プロダクト管理および計画ワークフローに対応。
- [セキュリティ分析](security_analyst_agent.md)。セキュリティ分析および脆弱性管理に対応。
- [データ分析](data_analyst.md)。プラットフォームデータの分析および可視化に対応。

## エージェントを複製する {#duplicate-an-agent}

基本エージェントに変更を加えるには、そのコピーを作成します。

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。

エージェントを複製するには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**エージェント**タブを選択します。
1. 複製するエージェントを選択します。
1. 右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）> **重複**を選択します。
1. **表示レベルとアクセス**で、次の操作を行います:
   1. **管理元**ドロップダウンリストから、エージェントのプロジェクトを選択します。
   1. **表示レベル**で、**非公開**または**公開**を選択します。
1. オプション。変更するフィールドを編集します。
1. **エージェントを作成**を選択します。

カスタムエージェントが作成されます。これを使用するには、[有効にする](../custom.md#enable-an-agent)必要があります。

## 基本エージェントのオン/オフを切り替える {#turn-foundational-agents-on-or-off}

デフォルトでは、基本エージェントはオンになっています。トップレベルグループ（ネームスペース）またはインスタンスに対して、基本エージェントをオンまたはオフにできます。

基本エージェントをデフォルトでオフにした場合:

- 新しくリリースされたエージェントを含め、デフォルト設定を使用する基本エージェントはオフになります。
- デフォルトのGitLab Duo Agentは引き続き使用できます。

{{< tabs >}}

{{< tab title="GitLab.comの場合" >}}

前提条件: 

- グループのオーナーロールが必要です。

1. 上部のバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **GitLab Duo**を選択します。
1. **設定の変更**を選択します。
1. **基本エージェント**の**デフォルトの可用性**で、次のいずれかを選択します:
   - **オン**
   - **オフ**
1. **可用性の設定**で、各エージェントに対して次のいずれかを選択します:
   - **オン**
   - **オフ**
   - **デフォルト（有効）を使用**または**デフォルト（無効）を使用**
1. **変更を保存**を選択します。

これらの設定は、次のユーザーに適用されます:

- トップレベルグループを[デフォルトのGitLab Duoのネームスペース](../../../../user/profile/preferences.md#set-a-default-gitlab-duo-namespace)として設定しているユーザー。
- デフォルトのネームスペースを設定しておらず、トップレベルグループに属するネームスペースにアクセスするユーザー。

トップレベルグループで基本エージェントをオフにすると、そのグループをデフォルトのGitLab Duoネームスペースとして使用しているユーザーは、どのネームスペースでも基本エージェントにアクセスできなくなります。

{{< /tab >}}

{{< tab title="インスタンスの場合" >}}

前提条件: 

- 管理者である必要があります。

1. 右上隅で、**管理者**を選択します。
1. 左側のサイドバーで、**GitLab Duo**を選択します。
1. **設定の変更**を選択します。
1. **基本エージェント**の**デフォルトの可用性**で、次のいずれかを選択します:
   - **オン**
   - **オフ**
1. **可用性の設定**で、各エージェントに対して次のいずれかを選択します:
   - **オン**
   - **オフ**
   - **デフォルト（有効）を使用**または**デフォルト（無効）を使用**
1. **変更を保存**を選択します。

{{< /tab >}}

{{< /tabs >}}
