---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Slack app level token'
---

## Description

The response body contains content that matches the pattern of a Slack app level token was identified. App level tokens are for use with Slack apps but only with specific APIs, which are related to the app across all organizations where the app is installed.

Three scope levels can be assigned:

- `connections:write:` Route your app's interactions and event payloads over WebSockets
- `authorizations:read:` View information about your app's authorizations on installed teams
- `app_configurations:write:` Configure your application

A malicious actor with access to this token is granted one or more of the above permissions to access the API with for a specific application.

Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a Slack app level token:

- Sign in to Slack and access <https://api.slack.com/apps>
- Find the application with the identified token and select the name
- In the left-hand menu, select "Basic Information"
- Scroll down to the "App-Level Tokens" section and select the token name of the identified token
- In the token dialog, select "Revoke"
- When prompted, select "Yes, I'm sure" in the "Are you sure?" dialog

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.172 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
