---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: yes
title: タスク
description: タスクラベル、機密タスク、リンクされたアイテム、タスクウェイト。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 14.5で`work_items`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/334812)されました。デフォルトでは無効になっています。
- GitLab 15.0で、タスクの作成、編集、削除が[導入](https://gitlab.com/groups/gitlab-org/-/epics/7169)されました。
- GitLab 15.3の[GitLab.comおよびGitLab Self-Managedで有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/334812)されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

GitLabにおけるタスクとは、イシューで作成できる計画アイテムです。タスクを使用すると、[イシュー](project/issues/_index.md)でキャプチャされたユーザーストーリーを追跡可能なより小さなアイテムに分割できます。

イシューを計画する際には、その完了に必要な技術的な要件や手順をキャプチャし、分割する方法が必要です。関連タスクを含むイシューはより明確に定義されるため、より正確なイシューのウェイトと完了基準を提供できます。

最新の更新については、[タスクロードマップ](https://gitlab.com/groups/gitlab-org/-/epics/7103)を確認してください。

タスクは作業アイテムの一種であり、GitLabの[デフォルトのイシュータイプ](https://gitlab.com/gitlab-org/gitlab/-/issues/323404)へ向けたステップです。イシューと[エピック](group/epics/_index.md)を作業アイテムに移行し、カスタム作業アイテムタイプを追加するロードマップについては、[エピック6033](https://gitlab.com/groups/gitlab-org/-/epics/6033)または[計画の方向性](https://about.gitlab.com/direction/plan/)のページを参照してください。

## タスクを表示する {#view-tasks}

イシューのタスクは、**子アイテム**セクションで表示できます。

`Type = task`で[イシューのリストをフィルターリング](project/issues/managing_issues.md#filter-the-list-of-issues)することもできます。

イシューからタスクを選択すると、ダイアログウィンドウで開きます。新しいブラウザタブで開くタスクを選択するか、タスクをイシューリストから選択すると、タスクがフルページビューで開きます。

## タスクを作成する {#create-a-task}

{{< history >}}

- GitLab 17.1で、タスクを作成するプロジェクトを選択するオプションが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/436255)されました。

{{< /history >}}

前提要件:

- プロジェクトのゲストロール以上であるか、プロジェクトが公開である必要があります。

タスクを作成するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、**追加**を選択します。
1. **新規タスク**を選択します。
1. タスクのタイトルを入力します。
1. 新しいタスクを作成する[プロジェクト](project/organize_work_with_projects.md)を選択します。
1. **Create task**（タスクを作成）を選択します。

### タスクリスト項目から {#from-a-task-list-item}

{{< history >}}

- GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/377307)されました。

{{< /history >}}

前提要件:

- プロジェクトのゲストロール以上が必要です。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明で、タスクリスト項目にカーソルを合わせ、オプションメニュー（{{< icon name="ellipsis_v" >}}）を選択します。
1. **Convert to task**（タスクに変換）を選択します。

タスクリスト項目がイシューの説明から削除され、その内容に基づいてタスクウィジェットにタスクが作成されます。ネストされたタスクリスト項目は、1つ上のネストレベルに移動します。

## 既存のタスクをイシューに追加する {#add-existing-tasks-to-an-issue}

{{< history >}}

- GitLab 15.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/381868)されました。

{{< /history >}}

前提要件:

- プロジェクトのゲストロール以上であるか、プロジェクトが公開である必要があります。

タスクを追加するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、**追加**を選択します。
1. **既存のタスク**を選択します。
1. タイトルでタスクを検索します。
1. イシューに追加するタスクを1つ以上選択します。
1. **Add task**（タスクを追加）を選択します。

## タスクを編集する {#edit-a-task}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクを編集するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクを選択します。タスクウィンドウが開きます。
1. オプション。タイトルを編集するには、タイトルを選択して変更します。
1. オプション。説明を編集するには、編集アイコン（{{< icon name="pencil" >}}）を選択して変更し、**保存**を選択します。
1. 閉じるアイコン（{{< icon name="close" >}}）を選択します。

### リッチテキストエディタを使用する {#using-the-rich-text-editor}

{{< history >}}

- ダイアログビューでのリッチテキスト編集は、GitLab 15.6で`work_items_mvc`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/363007)されました。デフォルトでは無効になっています。
- GitLab 15.7で、フルページビューでのリッチテキスト編集が[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104533)されました。
- GitLab 16.2で[一般提供](https://gitlab.com/groups/gitlab-org/-/epics/10378)になりました。機能フラグ`work_items_mvc`は削除されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

リッチテキストエディタを使用して、タスクの説明を編集します。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクの説明を編集するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **説明**の横にある編集アイコン（{{< icon name="pencil" >}}）を選択します。説明テキストボックスが表示されます。
1. テキストボックスの上で、**Rich text**（リッチテキスト）を選択します。
1. 変更を加えて、**保存**を選択します。

## タスクをイシューにプロモートする {#promote-a-task-to-an-issue}

{{< history >}}

- GitLab 16.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/412534)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクをイシューにプロモートするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクを選択します。タスクウィンドウが開きます。
1. 親イシューのリンクを解除し、タスクをプロモートします: タスクウィンドウで、次の2つの[クイックアクション](project/quick_actions.md)を別々のコメントで使用します:

   ```plaintext
   /remove_parent
   ```

   ```plaintext
   /promote_to issue
   ```

タスクはイシューに変換され、`/issues/`を含む新しいURLが割り当てられます。`/work_items/`を含む以前のURLは引き続き使用できます。

## タスクを別のアイテムタイプに変換する {#convert-a-task-into-another-item-type}

{{< history >}}

- GitLab 17.8で`work_items_beta`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385131)されました。デフォルトでは無効になっています。
- `okrs_mvc`という[フラグ](../administration/feature_flags/_index.md)に[移動しました](https://gitlab.com/gitlab-org/gitlab/-/issues/385131)。現在のフラグの状態については、このページの上部を参照してください。

{{< /history >}}

タスクを次のような別のアイテムタイプに変換します:

- イシュー
- 目標
- 主な成果

{{< alert type="warning" >}}

ターゲットのタイプが元のタイプのすべてのフィールドをサポートしていない場合、タイプを変更するとデータが失われる可能性があります。

{{< /alert >}}

前提要件:

- 変換するタスクには、親アイテムが割り当てられていない必要があります。

タスクを別のアイテムタイプに変換するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択します。
1. イシューリストで、タスクを見つけます。
1. オプション。タスクに親イシューが割り当てられている場合は、親イシューを削除します。`/remove_parent`クイックアクションを使用して、タスクにコメントを追加します。
1. 右上隅で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**種類の変更**を選択します。
1. 目的のアイテムタイプを選択します。
1. すべての条件が満たされたら、**種類の変更**を選択します。

または、`/type`[クイックアクション](project/quick_actions.md#work-items)を使用し、コメントで`issue`、`objective`、または`key result`を追加することもできます。

## イシューからタスクを削除する {#remove-a-task-from-an-issue}

{{< history >}}

- GitLab 17.0で、必要な最小ロールがレポーターからゲストに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/404799)されました。

{{< /history >}}

前提要件:

- プロジェクトのゲストロール以上が必要です。

イシューからタスクを削除できます。タスクは削除されませんが、この2つは関連付けられなくなります。再度関連付けることはできません。

イシューからタスクを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、削除するタスクの横にあるオプションメニュー（{{< icon name="ellipsis_v" >}}）を選択します。
1. **Remove task**（タスクを削除）を選択します。

## タスクを削除する {#delete-a-task}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがオーナーからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- 次のいずれかの条件を満たす必要があります:
  - タスクの作成者であり、プロジェクトのゲストロール以上を持っている。
  - プロジェクトのプランナーまたはオーナーのロールを持っている。

タスクを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクを選択します。
1. タスクウィンドウで、オプションメニュー（{{< icon name="ellipsis_v" >}}）の**Delete task**（タスクを削除）を選択します。
1. **OK**を選択します。

## タスクを並べ替える {#reorder-tasks}

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385887)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

デフォルトでは、タスクは作成日の順で表示されています。並べ替えるには、ドラッグして移動します。

## ステータスを変更する {#change-status}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.2で`work_item_status_feature_flag`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/543862)されました。デフォルトでは有効になっています。
- GitLab 18.4で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/521286)になりました。機能フラグ`work_item_status_feature_flag`は削除されました。

{{< /history >}}

<!-- Turn off the future tense test because of "won't do". -->
<!-- vale gitlab_base.FutureTense = NO -->

タスクにステータスを割り当てると、ワークフローの進行状況を追跡できます。ステータスは、基本的なオープン/クローズステータスよりもきめ細かい追跡を提供し、**進行中**、**完了**、または**Won't do**（実施しない）のような特定のステージを使用できます。
<!-- vale gitlab_base.FutureTense = YES -->

カスタムステータスの構成方法など、ステータスの詳細については、[ステータス](work_items/status.md)を参照してください。

前提要件:

- プロジェクトのプランナーロール以上であるか、タスクの作成者であるか、タスクの担当者である必要があります。

タスクのステータスを変更するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. 左側のサイドバーで、**Plan** > **イシュー**を選択し、表示するタスクを選択します。
1. 右側のサイドバーの**ステータス**セクションで、**編集**を選択します。
1. ドロップダウンリストからステータスを選択します。

タスクのステータスがすぐに更新されます。

`/status` [クイックアクション](project/quick_actions.md#issues-merge-requests-and-epics)を使用することで、ステータスを設定することもできます。

## タスクにユーザーを割り当てる {#assign-users-to-a-task}

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

タスクの担当者を表示するには、タスクにユーザーを割り当てます。

GitLab Freeのユーザーは、1つのタスクに1人のユーザーを割り当てることができます。GitLab PremiumおよびUltimateのユーザーは、1つのタスクに複数のユーザーを割り当てることができます。[イシューの複数の担当者](project/issues/multiple_assignees_for_issues.md)も参照してください。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクの担当者を変更するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **担当者**の横にある**Add assignees**（担当者を追加）を選択します。
1. ドロップダウンリストから、担当者として追加するユーザーを選択します。
1. ドロップダウンリストの外側の領域を選択します。

## タスクにラベルを割り当てる {#assign-labels-to-a-task}

{{< history >}}

- GitLab 15.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/339756)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクに[ラベル](project/labels.md)を追加するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **ラベル**の横にある**ラベルを追加**を選択します。
1. ドロップダウンリストから、追加するラベルを選択します。
1. ドロップダウンリストの外側の領域を選択します。

## 開始日と期限を設定する {#set-a-start-and-due-date}

{{< history >}}

- GitLab 15.4で`work_items_mvc_2`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/365399)されました。デフォルトでは無効になっています。
- GitLab 15.5で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/365399)になりました。機能フラグ`work_items_mvc_2`は削除されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

タスクに[開始日と期限](project/issues/due_dates.md)を設定できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクに開始日と期限を設定することで、作業を開始および終了する時期を示すことができます。

期限を設定するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. タスクの**期限**の横にすでに期限が設定されている場合は、それを選択します。設定されていない場合は、**Add due date**（期限を追加）を選択します。
1. 日付ピッカーで、目的の期限を選択します。

開始日を設定するには、次の手順に従います:

1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. タスクの**開始日**の横に開始日がすでに設定されている場合は、その日付を選択します。設定されていない場合は、**Add start date**（開始日を追加）を選択します。
1. 日付ピッカーで、目的の期限を選択します。

   期限は、開始日以降の日付である必要があります。開始日を期限より後の日付に設定すると、期限が開始日と同じ日に変更されます。

## タスクをマイルストーンに追加する {#add-a-task-to-a-milestone}

{{< history >}}

- GitLab 15.5で`work_items_mvc_2`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367463)されました。デフォルトでは無効になっています。
- GitLab 15.7で、`work_items_mvc`という名前の機能フラグに[移行](https://gitlab.com/gitlab-org/gitlab/-/issues/367463)しました。デフォルトでは無効になっています。
- GitLab 15.7で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/367463)になりました。機能フラグ`work_items_mvc`は削除されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

タスクを[マイルストーン](project/milestones/_index.md)に追加できます。タスクを表示すると、マイルストーンのタイトルを確認できます。すでにマイルストーンに属しているイシューに対してタスクを作成すると、新しいタスクはそのマイルストーンを継承します。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

タスクをマイルストーンに追加するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **マイルストーン**の横にある**Add to milestone**（マイルストーンに追加）を選択します。タスクがすでにマイルストーンに属している場合、ドロップダウンリストに現在のマイルストーンが表示されます。
1. ドロップダウンリストから、タスクに関連付けるマイルストーンを選択します。

## タスクのウェイトを設定する {#set-task-weight}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.3で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/362550)されました。
- GitLab 16.7で編集ボタンが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/429137)されました。

{{< /history >}}

前提要件:

- プロジェクトのレポーターロール以上が必要です。

各タスクにウェイトを設定することで、各タスクに必要な作業量を示すことができます。この値は、タスクを表示するときにのみ表示されます。

タスクのイシューのウェイトを設定するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **ウェイト**の横にある**編集**を選択します。
1. 正の整数を入力します。
1. **適用**を選択するか、<kbd>Enter</kbd>キーを押します。

### 親イシュー内のタスクのカウントとウェイトを表示する {#view-count-and-weight-of-tasks-in-the-parent-issue}

{{< history >}}

- GitLab 18.3で`use_cached_rolled_up_weights`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)されました。デフォルトでは無効になっています。
- GitLab 18.4の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)になりました。
- GitLab 18.6で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)になりました。機能フラグ`use_cached_rolled_up_weights`は削除されました。

{{< /history >}}

子孫タスクの数とそれらの合計ウェイトが、イシューの説明の**子アイテム**セクションヘッダーに表示されます。

オープンタスクと完了タスクの数を確認するには、次の手順に従います:

- セクションヘッダーで、合計数にカーソルを合わせます。

これらの数値は、表示する権限がないイシューも含め、イシューに関連付けられているすべての子タスクを反映しています。

### 親イシューの進行状況を表示する {#view-progress-of-the-parent-issue}

{{< history >}}

- GitLab 18.3で`use_cached_rolled_up_weights`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)されました。デフォルトでは無効になっています。
- GitLab 18.4の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)になりました。
- GitLab 18.6で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/520886)になりました。機能フラグ`use_cached_rolled_up_weights`は削除されました。

{{< /history >}}

イシューの進捗率は、イシューの説明の**子アイテム**セクションヘッダーに表示されます。

子タスクの完了したウェイトと合計ウェイトを確認するには、次の手順に従います:

- セクションヘッダーで、パーセンテージにカーソルを合わせます。

ウェイトと進捗率は、表示する権限がないイシューも含め、イシューに関連付けられているすべてのタスクを反映しています。

## タスクをイテレーションに追加する {#add-a-task-to-an-iteration}

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

{{< history >}}

- GitLab 15.5で`work_items_mvc_2`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367456)されました。デフォルトでは無効になっています。
- GitLab 15.7で、`work_items_mvc`という名前の機能フラグに[移行](https://gitlab.com/gitlab-org/gitlab/-/issues/367456)しました。デフォルトでは無効になっています。
- GitLab 15.7で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/367456)になりました。機能フラグ`work_items_mvc`は削除されました。

{{< /history >}}

タスクを[イテレーション](group/iterations/_index.md)に追加できます。イテレーションのタイトルと期間は、タスクを表示したときにのみ確認できます。

前提要件:

- プロジェクトのレポーターロール以上が必要です。

タスクをイテレーションに追加するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **イテレーション**の横にある**Add to iteration**（イテレーションに追加）を選択します。
1. ドロップダウンリストから、タスクに関連付けるイテレーションを選択します。

## 費やされる時間を見積もり、追跡する {#estimate-and-track-spent-time}

{{< history >}}

- GitLab 17.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/438577)されました。

{{< /history >}}

タスクに費やされる時間を見積もり、追跡できます。

詳細については、[タイムトラッキング](project/time_tracking.md)を参照してください。

## 「**続きを読む**」で説明が省略されるのを防ぎます。 {#prevent-truncating-descriptions-with-read-more}

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

タスクの説明が長い場合、GitLabはその一部のみを表示します。説明全体を表示するには、**続きを読む**を選択する必要があります。この切り詰める機能により、長文をスクロールせずに、ページ上の他の要素を簡単に見つけることができます。

説明を折りたたむかどうかを変更するには、次の手順に従います:

1. タスクの右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. 好みに応じて**説明を折りたたむ**を切り替えます。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

## 右側のサイドバーを非表示にする {#hide-the-right-sidebar}

{{< history >}}

- GitLab 17.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184)されました。

{{< /history >}}

スペースがある場合、タスクの属性は説明の右側のサイドバーに表示されます。サイドバーを非表示にして、説明のスペースを増やすには、次の手順に従います:

1. タスクの右上隅にある**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **サイドバーを非表示にする**を選択します。

この設定は記憶され、すべてのイシュー、タスク、エピック、目標、および主な成果に影響します。

サイドバーを再度表示するには: 

- 上記の手順を繰り返し、**サイドバーを表示する**を選択します。

## タスクのシステムノートを表示する {#view-task-system-notes}

{{< history >}}

- GitLab 15.7で`work_items_mvc_2`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/378949)されました。デフォルトでは無効になっています。
- GitLab 15.8で、`work_items_mvc`という機能フラグに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/378949)しました。デフォルトでは無効になっています。
- GitLab 15.8で、アクティビティーのソート順の変更が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/378949)されました。
- GitLab 15.10で、アクティビティーのフィルタリングが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/389971)されました。
- GitLab 15.10で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/334812)になりました。機能フラグ`work_items_mvc`は削除されました。

{{< /history >}}

タスクに関連するすべてのシステムノートを表示できます。デフォルトでは、**古い順**にソートされます。ソート順はいつでも**新しい順**に変更でき、この設定はセッション間で保持されます。デフォルトの**すべてのアクティビティー**に加えて、**コメントのみ**と**履歴のみ**でアクティビティーをフィルタリングすることもできます。この設定はセッション間で保持されます。

## コメントとスレッド {#comments-and-threads}

タスクに[コメント](discussions/_index.md)を追加したり、スレッドに返信したりできます。

## タスク参照をコピーする {#copy-task-reference}

{{< history >}}

- GitLab 16.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/396553)されました。

{{< /history >}}

GitLabの別の場所でタスクを参照するには、完全なURLまたは短い参照（`namespace/project-name#123`のようなもの。`namespace`はグループまたはユーザー名のいずれか）を使用できます。

タスク参照をクリップボードにコピーするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、タスクを選択します。
1. 右上隅にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**Copy Reference**（参照をコピー）を選択します。

これで、この参照を別の説明またはコメントに貼り付けることができます。

タスク参照の詳細については、[GitLab-Flavored Markdown](markdown.md#gitlab-specific-references)を参照してください。

## タスクのメールアドレスをコピーする {#copy-task-email-address}

{{< history >}}

- GitLab 16.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/396553)されました。

{{< /history >}}

メールを送信して、タスクにコメントを作成できます。このアドレスにメールを送信すると、メール本文を含むコメントが作成されます。

メールの送信によるコメントの作成、および必要な設定の詳細については、[メールを送信してコメントに返信する](discussions/_index.md#reply-to-a-comment-by-sending-email)を参照してください。

タスクのメールアドレスをコピーするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. 右上隅にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**Copy task email address**（タスクのメールアドレスをコピー）を選択します。

## イシューを親として設定する {#set-an-issue-as-a-parent}

{{< history >}}

- GitLab 16.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/11198)されました。

{{< /history >}}

前提要件:

- プロジェクトのゲストロール以上が必要です。
- イシューとタスクは、同じプロジェクトに属している必要があります。

タスクの親としてイシューを設定するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、編集するタスクのタイトルを選択します。タスクウィンドウが開きます。
1. **親**の横にあるドロップダウンから、追加する親を選択します。
1. ドロップダウンリストの外側の領域を選択します。

タスクの親アイテムを削除するには、**親**の横にあるドロップダウンリストを選択し、**アサイン解除**を選択します。

## 非公開タスク {#confidential-tasks}

{{< history >}}

- GitLab 15.3で[導入](https://gitlab.com/groups/gitlab-org/-/epics/8410)されました。

{{< /history >}}

非公開タスクは、[十分な権限](#who-can-see-confidential-tasks)を持つプロジェクトのメンバーのみが表示できるタスクです。非公開タスクを使用すると、セキュリティの脆弱性を非公開に設定することや、予期せぬ情報漏洩を防ぐことができます。

### タスクを非公開に設定する {#make-a-task-confidential}

デフォルトでは、タスクは公開されています。タスクの作成時または編集時に、タスクを非公開に設定することができます。

前提要件:

- プロジェクトのレポーターロール以上が必要です。
- タスクに非公開でない親イシューがあり、そのイシューを非公開に設定する場合は、まずすべての子タスクを非公開に設定する必要があります。[非公開イシュー](project/issues/confidential_issues.md)には、非公開の子しか含めることができません。

#### 新しいタスクの場合 {#in-a-new-task}

新しいタスクを作成する際、テキストエリアのすぐ下に、タスクを非公開としてマークするためのチェックボックスが表示されます。

そのチェックボックスをオンにして、**Create task**（タスクを作成）を選択します。

#### 既存のタスクの場合 {#in-an-existing-task}

既存のタスクの公開設定を変更するには、次の手順に従います:

1. [タスクを開きます](#view-tasks)。
1. 右上隅にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択します。
1. **非公開に設定**を選択します。

### 非公開タスクを表示できるユーザー {#who-can-see-confidential-tasks}

タスクが非公開に設定されている場合、プロジェクトのレポーターロール以上を持っているユーザーのみがタスクにアクセスできます。ゲストロールまたは[最小](permissions.md#users-with-minimal-access)ロールを持つユーザーは、変更前に積極的に参加していたとしても、タスクにアクセスできません。

ただし、**Guest role**（ゲストロール）を持つユーザーは非公開タスクを作成できますが、自分で作成したタスクのみを表示できます。

ゲストロールを持つユーザーまたは非メンバーは、タスクに割り当てられている場合、非公開タスクを表示できます。ゲストユーザーまたは非メンバーが非公開タスクから割り当てを解除されると、そのタスクを表示できなくなります。

必要な権限を持たないユーザーの検索結果には、非公開タスクは表示されません。

### 非公開タスクのインジケーター {#confidential-task-indicators}

非公開タスクは、標準タスクとは視覚的にいくつかの点で異なります。タスクの一覧表示では、非公開として設定されているタスクの横に非公開（{{< icon name="eye-slash" >}}）アイコンが表示されます。

[十分な権限](#who-can-see-confidential-tasks)がない場合、非公開タスクは一切表示できません。

同様に、タスク内では、パンくずリストのすぐ横に非公開（{{< icon name="eye-slash" >}}）アイコンが表示されます。

標準から非公開へ、またはその逆へのすべての変更は、タスクのコメントのシステムノートに表示されます。例:

- {{< icon name="eye-slash" >}} Jo Garciaが5分前にイシューを非公開にしました
- {{< icon name="eye" >}} Jo Garciaがたった今、イシューを全員に公開しました

## ディスカッションをロックする {#lock-discussion}

{{< history >}}

- GitLab 16.9で`work_items_beta`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/398649)されました。デフォルトでは無効になっています。
- 機能フラグ`work_items_beta`は、GitLab 18.6で[削除](https://gitlab.com/gitlab-com/gl-infra/production/-/issues/17549)されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

タスクでの公開コメントを禁止できます。その場合、プロジェクトメンバーのみがコメントを追加および編集できます。

前提要件:

- レポーターロール以上が必要です。

タスクをロックするには、次の手順に従います:

1. 右上隅にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択します。
1. **ディスカッションのロック**を選択します。

システムノートがページの詳細に追加されます。

ディスカッションがロックされた状態でタスクが完了した場合、ディスカッションがロック解除されるまで再オープンすることはできません。

## 2列レイアウト {#two-column-layout}

{{< history >}}

- GitLab 16.2で`work_items_mvc_2`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/415077)されました。デフォルトでは無効になっています。この機能は[ベータ版](../policy/development_stages_support.md)です。
- GitLab 16.10で`work_items_beta`という機能フラグに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/446064)しました。デフォルトでは無効になっています。
- [移動](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147020)機能フラグ`work_items_beta` GitLab 17.0。

{{< /history >}}

タスクは、イシューと同様の2列レイアウトを使用します。左側には説明とスレッド、右側にはラベルや担当者などの属性が表示されます。

この機能は[ベータ版](../policy/development_stages_support.md)です。バグを見つけた場合は、[フィードバックイシューにコメントしてください](https://gitlab.com/gitlab-org/gitlab/-/issues/442090)。

![タスクの2列ビュー](img/task_two_column_view_v16_10.png)

## タスク内のリンクされたアイテム {#linked-items-in-tasks}

{{< history >}}

- GitLab 16.5で`linked_work_items`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/416558)されました。デフォルトでは無効になっています。
- GitLab 16.7の[GitLab.comおよびGitLab Self-Managedで有効化](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139394)されました。
- GitLab 16.8で、URLとIDを入力して関連アイテムを追加する機能が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/427594)されました。
- GitLab 17.0で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150148)になりました。機能フラグ`linked_work_items`は削除されました。
- GitLab 17.0で、必要な最小ロールがレポーター（trueの場合）からゲストに[変更](https://gitlab.com/groups/gitlab-org/-/epics/10267)されました。

{{< /history >}}

リンクされたアイテムは双方向の関係であり、絵文字リアクションセクションの下のブロックに表示されます。同じプロジェクト内の目標、主な成果、またはタスクを相互にリンクできます。

この関係は、ユーザーが両方のアイテムを表示できる場合にのみUIに表示されます。

### リンクされたアイテムを追加する {#add-a-linked-item}

前提要件:

- プロジェクトのゲストロール以上が必要です。

タスクにアイテムをリンクするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、タスクを選択します。
1. タスクの**リンクされたアイテム**セクションで、**追加**を選択します。
1. 2つのアイテム間の関係を次のいずれかから選択します:
   - **次のアイテムに関連している**
   - **次のアイテムをブロックしている**
   - **次のアイテムにブロックされている**
1. アイテムの検索テキスト、URL、または参照IDを入力します。
1. リンクするアイテムをすべて追加したら、検索ボックスの下にある**追加**を選択します。

リンクされたすべてのアイテムの追加が完了すると、それらの関係が視覚的にわかりやすく分類されて表示されます。

![リンクされたアイテムブロック](img/linked_items_list_v16_5.png)

### リンクされたアイテムを削除する {#remove-a-linked-item}

前提要件:

- プロジェクトのゲストロール以上が必要です。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Plan** > **イシュー**を選択し、イシューを選択して表示します。
1. イシューの説明の**子アイテム**セクションで、タスクを選択します。
1. タスクの**リンクされたアイテム**セクションで、各アイテムの横にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**削除**を選択します。

双方向の関係性により、いずれのアイテムにも関係が表示されなくなります。

### マージリクエストを追加してタスクを自動的にクローズする {#add-a-merge-request-and-automatically-close-tasks}

{{< history >}}

- GitLab 17.3で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/440851)されました。

{{< /history >}}

マージリクエストがマージされたときにタスクをクローズするように設定できます。

前提要件:

- マージリクエストを含むプロジェクトのデベロッパーロール以上が必要です。
- タスクを含むプロジェクトのレポーターロール以上が必要です。

1. マージリクエストを編集します。
1. **説明**ボックスで、タスクを見つけて追加します。
   - イシューにマージリクエストを追加する場合と同じ[クローズパターン](project/issues/managing_issues.md#closing-issues-automatically)を使用します。
   - タスクがマージリクエストと同じプロジェクトにある場合、<kbd>#</kbd>を入力し、その後にタスクのIDまたはタイトルを入力して、タスクを検索できます。
   - タスクが別のプロジェクトにある場合、タスクを開いた状態で、ブラウザからURLをコピーするか、右上隅にある縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**Copy Reference**（参照をコピー）を選択して、タスクの参照をコピーします。

マージリクエストが本文の**開発**セクションに表示されるようになりました。

タスクにマージリクエストを追加するには、正確なクローズパターンを使用する必要があります。他のテキストでは機能しません。

プロジェクトの設定で[イシューの自動クローズ](project/issues/managing_issues.md#disable-automatic-issue-closing)が有効になっている場合、次のいずれかの条件が満たされると、タスクは自動的にクローズします:

- 追加されたマージリクエストがマージされる。
- クローズパターンを持つタスクを参照するコミットが、プロジェクトのデフォルトブランチにコミットされる。

## 関連トピック {#related-topics}

- [タスクからマージリクエストを作成する](project/merge_requests/creating_merge_requests.md#from-a-task)
