---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: カスタムフロー
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise。
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: 実験的機能

{{< /details >}}

{{< collapsible title="モデル情報" >}}

- LLM: Anthropic [Claude Sonnet 4](https://www.anthropic.com/claude/sonnet)

{{< /collapsible >}}

{{< history >}}

- `ai_catalog_flows`という名前の[フラグ](../../../administration/feature_flags/_index.md)とともに、GitLab 18.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/578228)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

カスタムフローは、AIを利用したワークフローであり、GitLabプロジェクト全体で複雑な複数ステップのタスクを自動化するために、ユーザーが作成および設定します。

## Flowの表示レベル {#flow-visibility}

カスタムフローを作成する際に、それを管理するGitLabプロジェクトを選択し、flowを公開にするかプライベートにするかを選択します。

公開フロー:

- インスタンス上の誰でも表示でき、前提条件を満たすすべてのGitLabプロジェクトで有効にできます。

プライベートフロー:

- 管理GitLabプロジェクトのメンバーで、少なくともデベロッパーロールを持つユーザー、およびトップレベルグループのオーナーロールを持つユーザーのみが表示できます。
- 管理GitLabプロジェクト以外のGitLabプロジェクト、またはトップレベルグループ以外のグループでは、有効にできません。

flowが現在有効になっている場合、プライベートflowを公開に変更することはできません。

## GitLabプロジェクトのフローを表示 {#view-the-flows-for-your-project}

前提要件:

- プロジェクトのデベロッパーロール以上を持っている必要があります。

GitLabプロジェクトで有効になっているフローのリストを表示するには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **フロー**を選択します。

Flowを選択して詳細を表示します。

## Flowを作成 {#create-a-flow}

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

Flowを作成するには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **フロー**を選択します。
1. **新しいフロー**を選択します。
1. **基本情報**の下:
   1. **表示名**に名前を入力します。
   1. **説明**に説明を入力します。
1. **表示レベルとアクセス**の**表示レベル**で、**プライベート**または**公開**を選択します。
1. **設定**の下:
   1. **flow**を選択します。
   1. エディタで、flowの設定を入力します。カスタムフローYAMLの記述方法については、[flow registry framework documentation](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist/-/blob/main/docs/flow_registry/v1.md)を参照してください。
1. **フローを作成**を選択します。

FlowはAIカタログに表示されます。

## Flowを有効にする {#enable-a-flow}

Flowを有効にすると、イシュー、マージリクエスト、またはディスカッションからトリガーできます。Flowを有効にするには、以下を実行する必要があります:

1. トップレベルグループで有効にします。
1. 使用するGitLabプロジェクトで有効にします。

### トップレベルグループで有効にする {#enable-in-a-top-level-group}

前提要件:

- グループのオーナーロールを持っている必要があります。

トップレベルグループでflowを有効にするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 有効にするflowを選択します。
1. 右上隅で、**グループで有効にする**を選択します。
1. ドロップダウンリストから、flowを有効にするグループを選択します。
1. **有効**を選択します。

Flowは、グループの**自動化** > **フロー**ページに表示されます。

### GitLabプロジェクトで有効にする {#enable-in-a-project}

前提要件:

- プロジェクトのメンテナーロール以上が必要です。
- Flowは、GitLabプロジェクトのトップレベルグループで有効にする必要があります。

GitLabプロジェクトでflowを有効にするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **フロー**を選択します。
1. 右上隅で、**グループからのflowを有効にする**を選択します。
1. ドロップダウンリストから、有効にするflowを選択します。
1. **トリガーを追加**で、flowをトリガーするイベントを選択します:
   - **メンション**: イシューまたはマージリクエストのコメントでサービスアカウントユーザーがメンションされた場合。
   - **アサイン**: サービスアカウントユーザーがイシューまたはマージリクエストにアサインされた場合。
   - **レビュアーをアサインする**: サービスアカウントユーザーがマージリクエストのレビュアーとしてアサインされた場合。
1. **有効**を選択します。

Flowは、GitLabプロジェクトの**自動化** > **フロー**リストに表示されます。

### Flowを無効にする {#disable-a-flow}

前提要件:

- グループの場合、オーナーロールが必要です。
- プロジェクトでは、少なくともメンテナーロールが必要です。

Flowを無効にするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループまたはプロジェクトを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **自動化** > **フロー**を選択します。
1. 削除するflowを見つけて、**アクション** ({{< icon name="ellipsis_v" >}}) > **無効**を選択します。
1. 確認ダイアログで、**無効化**を選択します。

Flowは、GitLabプロジェクトまたはグループに表示されなくなり、実行できなくなります。Flowに関連付けられているサービスアカウントまたはトリガーもすべて削除されます。

## トリガーを作成する {#create-a-trigger}

次に、[トリガーを作成](../triggers/_index.md)する必要があります。これにより、flowがいつ実行されるかが決定されます。

たとえば、ディスカッションでflowサービスアカウントユーザーをメンションした場合、またはレビュアーとしてサービスアカウントをアサインした場合に、トリガーされるようにflowを指定できます。

GitLabプロジェクトでflowを有効にすると、トリガーも作成されます。

## Flowを使用する {#use-a-flow}

前提要件:

- プロジェクトのデベロッパーロール以上を持っている必要があります。
- Flowは、GitLabプロジェクトで有効にする必要があります。

Flowを使用するには、次のようにします:

1. プロジェクトで、イシュー、マージリクエスト、またはエピックを開きます。
1. Flowをトリガーするには、flowサービスアカウントユーザーをメンション、アサイン、またはレビューをリクエストします。デフォルトでは、ユーザーの名前は`ai-<flow>-<group>`です。

   たとえば、`Code review flow`という名前のflowを`GitLab Duo`グループで有効にした場合、サービスアカウントユーザーは`ai-code-review-flow-gitlab-duo`です。
1. Flowがタスクを完了すると、確認が表示され、すぐにマージできる変更またはインラインコメントが表示されます。

## Flowを複製する {#duplicate-a-flow}

元のエージェントを上書きせずにflowを変更するには、既存のエージェントのコピーを作成します。

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

Flowを複製するには、次のようにします:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 複製するflowを選択します。
1. 右上隅で、**アクション** ({{< icon name="ellipsis_v" >}}) > **複製**を選択します。
1. オプション。変更するフィールドを編集します。
1. **フローを作成**を選択します。

## フローを管理 {#manage-flows}

Flowを編集して設定を変更するか、削除してAIカタログから削除します。

前提要件:

- 管理対象のGitLabプロジェクトのメンバーであり、メンテナーロール以上を持っている必要があります。

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 管理するflowを選択します。
   - Flowを編集するには、次のようにします:
     1. 右上隅で、**編集**を選択します。
     1. 変更するフィールドを編集し、**変更を保存**を選択します。
   - Flowを削除するには、次のようにします:
     1. 右上隅にある**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
     1. 確認ダイアログで、**削除**を選択します。

## Flowをレポート {#report-a-flow}

潜在的に不快な内容が含まれている場合、または組織にリスクをもたらす可能性があるflowをレポートできます。

Flowをレポートするには、次のようにします:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. レポートするflowを選択します。
1. 右上隅で、**アクション** ({{< icon name="ellipsis_v" >}}) > **Report to admin**（管理者に報告）を選択します。
1. 不正行為のレポートに入力し、**送信**を選択します。

管理者に通知が送信され、flowを非表示または削除できます。
