/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class GlobalUIPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.global";
    public static final String PROP_HAS_PERMISSION = "hasPermission";
    public static final String PROP_CAN_CREATE_CONNECTION = "canCreateConnection";
    public static final String PROP_HAS_ACTIVE_PROJECT = "hasActiveProject";
    public static final String PROP_HAS_MULTI_PROJECTS = "hasMultipleProjects";
    public static final String PROP_CAN_CREATE_PROJECT = "canCreateProject";
    public static final String PROP_CAN_EDIT_RESOURCE = "canEditResource";
    public static final String PROP_CURRENT_PROJECT_RESOURCE_EDITABLE = "currentProjectResourceEditable";
    public static final String PROP_CURRENT_PROJECT_RESOURCE_VIEWABLE = "currentProjectResourceViewable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return switch (property) {
            case PROP_HAS_PERMISSION -> DBWorkbench.getPlatform().getWorkspace().hasRealmPermission(CommonUtils.toString((Object)expectedValue));
            case PROP_HAS_MULTI_PROJECTS -> {
                if (DBWorkbench.getPlatform().getWorkspace().getProjects().size() > 1) {
                    yield true;
                }
                yield false;
            }
            case PROP_HAS_ACTIVE_PROJECT -> {
                if (DBWorkbench.getPlatform().getWorkspace().getActiveProject() != null) {
                    yield true;
                }
                yield false;
            }
            case PROP_CAN_CREATE_PROJECT -> GlobalUIPropertyTester.canManageProjects();
            case PROP_CAN_CREATE_CONNECTION -> {
                for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
                    if (!project.hasRealmPermission("project-datasource-edit")) continue;
                    yield true;
                }
                yield false;
            }
            case PROP_CAN_EDIT_RESOURCE -> {
                DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
                if (project != null && project.hasRealmPermission("project-resource-edit")) {
                    yield true;
                }
                yield false;
            }
            case PROP_CURRENT_PROJECT_RESOURCE_EDITABLE -> {
                DBPProject project = NavigatorUtils.getSelectedProject();
                if (project != null && project.hasRealmPermission("project-resource-edit")) {
                    yield true;
                }
                yield false;
            }
            case PROP_CURRENT_PROJECT_RESOURCE_VIEWABLE -> {
                DBPProject project = NavigatorUtils.getSelectedProject();
                if (project != null && project.hasRealmPermission("project-resource-view")) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean canManageProjects() {
        return DBWorkbench.getPlatform().getWorkspace().canManageProjects();
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.global." + propName));
    }

    public static class ResourceListener
    implements IPluginService,
    IResourceChangeListener {
        public void activateService() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public void deactivateService() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    if (childDelta.getResource() instanceof IProject && (childDelta.getKind() == 1 || childDelta.getKind() == 2)) {
                        GlobalUIPropertyTester.firePropertyChange(GlobalUIPropertyTester.PROP_HAS_MULTI_PROJECTS);
                    }
                    ++n2;
                }
            }
        }
    }
}

