/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardUpdater;

public class DashboardUpdateJob
extends AbstractJob {
    private static final Log log = Log.getLog(DashboardUpdateJob.class);
    private static final int JOB_DELAY = 1000;
    private static DashboardUpdateJob updateJob;
    private final AtomicBoolean isSchedule = new AtomicBoolean(true);

    private DashboardUpdateJob() {
        super("Dashboard update");
    }

    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        try {
            if (new DashboardUpdater().updateDashboards(monitor)) {
                this.pauseDashboardUpdate();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error running dashboard updater", (Throwable)e);
        }
        if (this.isSchedule.get() && !DBWorkbench.getPlatform().isShuttingDown()) {
            this.schedule(1000L);
        }
        return Status.OK_STATUS;
    }

    public static void startUpdating() {
        updateJob = new DashboardUpdateJob();
        updateJob.schedule(1000L);
    }

    public static DashboardUpdateJob getDefault() {
        return updateJob;
    }

    public void resumeDashboardUpdate() {
        if (this.isSchedule.compareAndSet(false, true)) {
            this.schedule(1000L);
        }
    }

    public void pauseDashboardUpdate() {
        this.isSchedule.set(false);
    }
}

