/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

@Component(role=LifecycleTaskSegmentCalculator.class)
public class DefaultLifecycleTaskSegmentCalculator
implements LifecycleTaskSegmentCalculator {
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session2) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException {
        MavenProject rootProject = session2.getTopLevelProject();
        List<String> tasks = session2.getGoals();
        if ((tasks == null || tasks.isEmpty()) && !StringUtils.isEmpty(rootProject.getDefaultGoal())) {
            tasks = Arrays.asList(StringUtils.split(rootProject.getDefaultGoal()));
        }
        return this.calculateTaskSegments(session2, tasks);
    }

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session2, List<String> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        ArrayList<TaskSegment> taskSegments = new ArrayList<TaskSegment>(tasks.size());
        TaskSegment currentSegment = null;
        for (String task : tasks) {
            if (this.isGoalSpecification(task)) {
                boolean aggregating;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session2.getTopLevelProject(), session2);
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(task, session2, session2.getTopLevelProject());
                boolean bl = aggregating = mojoDescriptor.isAggregator() || !mojoDescriptor.isProjectRequired();
                if (currentSegment == null || currentSegment.isAggregating() != aggregating) {
                    currentSegment = new TaskSegment(aggregating);
                    taskSegments.add(currentSegment);
                }
                currentSegment.getTasks().add(new GoalTask(task));
                continue;
            }
            if (currentSegment == null || currentSegment.isAggregating()) {
                currentSegment = new TaskSegment(false);
                taskSegments.add(currentSegment);
            }
            currentSegment.getTasks().add(new LifecycleTask(task));
        }
        return taskSegments;
    }

    @Override
    public boolean requiresProject(MavenSession session2) {
        List<String> goals = session2.getGoals();
        if (goals != null) {
            for (String goal : goals) {
                if (this.isGoalSpecification(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGoalSpecification(String task) {
        return task.indexOf(58) >= 0;
    }
}

