﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/StepParameterChunks.h>
#include <aws/deadline/model/StepParameterType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>The details of a step parameter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StepParameter">AWS
 * API Reference</a></p>
 */
class StepParameter {
 public:
  AWS_DEADLINE_API StepParameter() = default;
  AWS_DEADLINE_API StepParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API StepParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the parameter.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  StepParameter& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data type of the parameter.</p>
   */
  inline StepParameterType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(StepParameterType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline StepParameter& WithType(StepParameterType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration for task chunking.</p>
   */
  inline const StepParameterChunks& GetChunks() const { return m_chunks; }
  inline bool ChunksHasBeenSet() const { return m_chunksHasBeenSet; }
  template <typename ChunksT = StepParameterChunks>
  void SetChunks(ChunksT&& value) {
    m_chunksHasBeenSet = true;
    m_chunks = std::forward<ChunksT>(value);
  }
  template <typename ChunksT = StepParameterChunks>
  StepParameter& WithChunks(ChunksT&& value) {
    SetChunks(std::forward<ChunksT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  StepParameterType m_type{StepParameterType::NOT_SET};

  StepParameterChunks m_chunks;
  bool m_nameHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_chunksHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
