/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ShowInFinder
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(ShowInFinder.class.getName());
    private final DataObject context;
    private static final RequestProcessor RP = new RequestProcessor("ShowInFinder", 1);

    public ShowInFinder(DataObject dataObject) {
        this.context = dataObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RP.execute(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject = ShowInFinder.this.context.getPrimaryFile();
                if (fileObject == null) {
                    return;
                }
                LOG.log(Level.FINE, "Selected file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
                if (FileUtil.getArchiveFile((FileObject)fileObject) != null) {
                    fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
                }
                LOG.log(Level.FINE, "File to select in Finder: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    LOG.log(Level.INFO, "Ignoring non local file: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowInFinder.class, (String)"TXT_NoLocalFile"));
                    return;
                }
                try {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getDeclaredMethod("revealInFinder", File.class);
                    method.invoke(null, file);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.log(Level.FINE, "Cannot load com.apple.eio.FileManager class.");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOG.log(Level.FINE, "No method revealInFinder(java.io.File) in the com.apple.eio.FileManager class.");
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOG.log(Level.FINE, "Cannot invoke method com.apple.eio.FileManager.revealInFinder(java.io.File).");
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.log(Level.FINE, "The method com.apple.eio.FileManager.revealInFinder(java.io.File) is not accessible");
                }
            }
        });
    }
}

