/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.ByteBuffer;
import org.apache.tomcat.util.buf.ByteBufferUtilsUnsafe;

public class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static ByteBuffer expand(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2;
        if (byteBuffer.capacity() >= n) {
            return byteBuffer;
        }
        boolean bl = false;
        if (byteBuffer.isDirect()) {
            byteBuffer2 = ByteBuffer.allocateDirect(n);
            bl = true;
        } else {
            byteBuffer2 = ByteBuffer.allocate(n);
        }
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        if (bl) {
            ByteBufferUtils.cleanDirectBuffer(byteBuffer);
        }
        return byteBuffer2;
    }

    public static void cleanDirectBuffer(ByteBuffer byteBuffer) {
        ByteBufferUtilsUnsafe.cleanDirectBuffer(byteBuffer);
    }
}

