/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.AbstractPen;

public class ExtLogPen
extends AbstractPen {
    private int penStyle;
    private int width;
    private int brushStyle;
    private Color color;
    private int hatch;
    private int[] style;

    public ExtLogPen(int penStyle, int width, int brushStyle, Color color, int hatch, int[] style) {
        this.penStyle = penStyle;
        this.width = width;
        this.brushStyle = brushStyle;
        this.color = color;
        this.hatch = hatch;
        this.style = style;
    }

    public ExtLogPen(EMFInputStream emf) throws IOException {
        this.penStyle = emf.readDWORD();
        this.width = emf.readDWORD();
        this.brushStyle = emf.readUINT();
        this.color = emf.readCOLORREF();
        this.hatch = emf.readULONG();
        int nStyle = emf.readDWORD();
        if (nStyle == 0) {
            emf.readDWORD();
        }
        this.style = emf.readDWORD(nStyle);
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.penStyle);
        emf.writeDWORD(this.width);
        emf.writeUINT(this.brushStyle);
        emf.writeCOLORREF(this.color);
        emf.writeULONG(this.hatch);
        emf.writeDWORD(this.style.length);
        if (this.style.length == 0) {
            emf.writeDWORD(0);
        }
        emf.writeDWORD(this.style);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  ExtLogPen\n");
        s.append("    penStyle: ");
        s.append(Integer.toHexString(this.penStyle));
        s.append("\n");
        s.append("    width: ");
        s.append(this.width);
        s.append("\n");
        s.append("    brushStyle: ");
        s.append(this.brushStyle);
        s.append("\n");
        s.append("    color: ");
        s.append(this.color);
        s.append("\n");
        s.append("    hatch: ");
        s.append(this.hatch);
        s.append("\n");
        for (int i = 0; i < this.style.length; ++i) {
            s.append("      style[");
            s.append(i);
            s.append("]: ");
            s.append(this.style[i]);
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.setUseCreatePen(false);
        renderer.setPenPaint(this.color);
        renderer.setPenStroke(this.createStroke(renderer, this.penStyle, this.style, this.width));
    }
}

