/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class DnNormalizer
extends Normalizer {
    private transient SchemaManager schemaManager;

    public DnNormalizer() {
        super("2.5.13.1");
    }

    @Override
    public String normalize(String value) throws LdapException {
        Dn dn = new Dn(this.schemaManager, value);
        return dn.getNormName();
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        Dn dn = new Dn(this.schemaManager, value);
        return dn.getNormName();
    }

    public String normalize(Dn value) throws LdapException {
        Dn dn = value;
        if (!value.isSchemaAware()) {
            dn = new Dn(this.schemaManager, value);
        }
        return dn.getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

