/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MutableMatch
extends MutableSingleRel {
    public final RexNode pattern;
    public final boolean strictStart;
    public final boolean strictEnd;
    public final Map<String, RexNode> patternDefinitions;
    public final Map<String, RexNode> measures;
    public final RexNode after;
    public final Map<String, ? extends SortedSet<String>> subsets;
    public final boolean allRows;
    public final ImmutableBitSet partitionKeys;
    public final RelCollation orderKeys;
    public final @Nullable RexNode interval;

    private MutableMatch(RelDataType rowType, MutableRel input, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, @Nullable RexNode interval) {
        super(MutableRelType.MATCH, rowType, input);
        this.pattern = pattern;
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefinitions = patternDefinitions;
        this.measures = measures;
        this.after = after;
        this.subsets = subsets;
        this.allRows = allRows;
        this.partitionKeys = partitionKeys;
        this.orderKeys = orderKeys;
        this.interval = interval;
    }

    public static MutableMatch of(RelDataType rowType, MutableRel input, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, @Nullable RexNode interval) {
        return new MutableMatch(rowType, input, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof MutableMatch && this.pattern.equals(((MutableMatch)obj).pattern) && this.strictStart == ((MutableMatch)obj).strictStart && this.strictEnd == ((MutableMatch)obj).strictEnd && this.allRows == ((MutableMatch)obj).allRows && this.patternDefinitions.equals(((MutableMatch)obj).patternDefinitions) && this.measures.equals(((MutableMatch)obj).measures) && this.after.equals(((MutableMatch)obj).after) && this.subsets.equals(((MutableMatch)obj).subsets) && this.partitionKeys.equals(((MutableMatch)obj).partitionKeys) && this.orderKeys.equals(((MutableMatch)obj).orderKeys) && Objects.equals(this.interval, ((MutableMatch)obj).interval) && this.input.equals(((MutableMatch)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.measures, this.after, this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Match(pattern: ").append(this.pattern).append(", strictStart: ").append(this.strictStart).append(", strictEnd: ").append(this.strictEnd).append(", patternDefinitions: ").append(this.patternDefinitions).append(", measures: ").append(this.measures).append(", after: ").append(this.after).append(", subsets: ").append(this.subsets).append(", allRows: ").append(this.allRows).append(", partitionKeys: ").append(this.partitionKeys).append(", orderKeys: ").append(this.orderKeys).append(", interval: ").append(this.interval).append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableMatch.of(this.rowType, this.input.clone(), this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.measures, this.after, this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }
}

