/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.CrtAsyncRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestAdapter;
import software.amazon.awssdk.http.crt.internal.response.CrtResponseAdapter;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class CrtAsyncRequestExecutor {
    private static final Logger log = Logger.loggerFor(CrtAsyncRequestExecutor.class);

    public CompletableFuture<Void> execute(CrtAsyncRequestContext executionContext) {
        MetricCollector metricCollector = executionContext.metricCollector();
        boolean shouldPublishMetrics = metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
        long acquireStartTime = 0L;
        if (shouldPublishMetrics) {
            acquireStartTime = System.nanoTime();
        }
        CompletableFuture<Void> requestFuture = this.createAsyncExecutionFuture(executionContext.sdkRequest());
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        long finalAcquireStartTime = acquireStartTime;
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            AsyncExecuteRequest asyncRequest = executionContext.sdkRequest();
            if (shouldPublishMetrics) {
                CrtUtils.reportMetrics(executionContext.crtConnPool(), metricCollector, finalAcquireStartTime);
            }
            if (throwable != null) {
                Throwable toThrow = CrtUtils.wrapConnectionFailureException(throwable);
                this.reportAsyncFailure((HttpClientConnection)crtConn, toThrow, requestFuture, asyncRequest.responseHandler());
                return;
            }
            this.executeRequest(executionContext, requestFuture, (HttpClientConnection)crtConn, asyncRequest);
        });
        return requestFuture;
    }

    private void executeRequest(CrtAsyncRequestContext executionContext, CompletableFuture<Void> requestFuture, HttpClientConnection crtConn, AsyncExecuteRequest asyncRequest) {
        try {
            HttpRequest crtRequest = CrtRequestAdapter.toAsyncCrtRequest(executionContext);
            HttpStreamResponseHandler crtResponseHandler = CrtResponseAdapter.toCrtResponseHandler(crtConn, requestFuture, asyncRequest.responseHandler());
            crtConn.makeRequest(crtRequest, crtResponseHandler).activate();
        }
        catch (HttpException e) {
            Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(e);
            this.reportAsyncFailure(crtConn, toThrow, requestFuture, asyncRequest.responseHandler());
        }
        catch (IllegalStateException | CrtRuntimeException e) {
            this.reportAsyncFailure(crtConn, new IOException("An exception occurred when making the request", e), requestFuture, asyncRequest.responseHandler());
        }
        catch (Throwable throwable) {
            this.reportAsyncFailure(crtConn, throwable, requestFuture, asyncRequest.responseHandler());
        }
    }

    private CompletableFuture<Void> createAsyncExecutionFuture(AsyncExecuteRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, t) -> {
            if (t == null) {
                return;
            }
            if (future.isCancelled()) {
                request.responseHandler().onError((Throwable)new SdkCancellationException("The request was cancelled"));
            }
        });
        return future;
    }

    private void reportAsyncFailure(HttpClientConnection crtConn, Throwable cause, CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        if (crtConn != null) {
            crtConn.close();
        }
        try {
            responseHandler.onError(cause);
        }
        catch (Exception e) {
            log.error(() -> "SdkAsyncHttpResponseHandler " + responseHandler + " threw an exception in onError. It will be ignored.", (Throwable)e);
        }
        executeFuture.completeExceptionally(cause);
    }
}

