/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.RequestStats;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SearchStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SearchStats> {
    @Nullable
    private final Long concurrentAvgSliceCount;
    @Nullable
    private final Long concurrentQueryCurrent;
    @Nullable
    private final Time concurrentQueryTime;
    @Nullable
    private final Long concurrentQueryTimeInMillis;
    @Nullable
    private final Long concurrentQueryTotal;
    private final long fetchCurrent;
    @Nullable
    private final Time fetchTime;
    private final long fetchTimeInMillis;
    private final long fetchTotal;
    @Nonnull
    private final Map<String, SearchStats> groups;
    @Nullable
    private final Long openContexts;
    @Nullable
    private final Long pointInTimeCurrent;
    @Nullable
    private final Time pointInTimeTime;
    @Nullable
    private final Long pointInTimeTimeInMillis;
    @Nullable
    private final Long pointInTimeTotal;
    private final long queryCurrent;
    @Nullable
    private final Time queryTime;
    private final long queryTimeInMillis;
    private final long queryTotal;
    @Nonnull
    private final Map<String, RequestStats> request;
    private final long scrollCurrent;
    @Nullable
    private final Time scrollTime;
    private final long scrollTimeInMillis;
    private final long scrollTotal;
    @Nullable
    private final Long searchIdleReactivateCountTotal;
    private final long suggestCurrent;
    @Nullable
    private final Time suggestTime;
    private final long suggestTimeInMillis;
    private final long suggestTotal;
    public static final JsonpDeserializer<SearchStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchStats::setupSearchStatsDeserializer);

    private SearchStats(Builder builder) {
        this.concurrentAvgSliceCount = builder.concurrentAvgSliceCount;
        this.concurrentQueryCurrent = builder.concurrentQueryCurrent;
        this.concurrentQueryTime = builder.concurrentQueryTime;
        this.concurrentQueryTimeInMillis = builder.concurrentQueryTimeInMillis;
        this.concurrentQueryTotal = builder.concurrentQueryTotal;
        this.fetchCurrent = ApiTypeHelper.requireNonNull(builder.fetchCurrent, this, "fetchCurrent");
        this.fetchTime = builder.fetchTime;
        this.fetchTimeInMillis = ApiTypeHelper.requireNonNull(builder.fetchTimeInMillis, this, "fetchTimeInMillis");
        this.fetchTotal = ApiTypeHelper.requireNonNull(builder.fetchTotal, this, "fetchTotal");
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.openContexts = builder.openContexts;
        this.pointInTimeCurrent = builder.pointInTimeCurrent;
        this.pointInTimeTime = builder.pointInTimeTime;
        this.pointInTimeTimeInMillis = builder.pointInTimeTimeInMillis;
        this.pointInTimeTotal = builder.pointInTimeTotal;
        this.queryCurrent = ApiTypeHelper.requireNonNull(builder.queryCurrent, this, "queryCurrent");
        this.queryTime = builder.queryTime;
        this.queryTimeInMillis = ApiTypeHelper.requireNonNull(builder.queryTimeInMillis, this, "queryTimeInMillis");
        this.queryTotal = ApiTypeHelper.requireNonNull(builder.queryTotal, this, "queryTotal");
        this.request = ApiTypeHelper.unmodifiable(builder.request);
        this.scrollCurrent = ApiTypeHelper.requireNonNull(builder.scrollCurrent, this, "scrollCurrent");
        this.scrollTime = builder.scrollTime;
        this.scrollTimeInMillis = ApiTypeHelper.requireNonNull(builder.scrollTimeInMillis, this, "scrollTimeInMillis");
        this.scrollTotal = ApiTypeHelper.requireNonNull(builder.scrollTotal, this, "scrollTotal");
        this.searchIdleReactivateCountTotal = builder.searchIdleReactivateCountTotal;
        this.suggestCurrent = ApiTypeHelper.requireNonNull(builder.suggestCurrent, this, "suggestCurrent");
        this.suggestTime = builder.suggestTime;
        this.suggestTimeInMillis = ApiTypeHelper.requireNonNull(builder.suggestTimeInMillis, this, "suggestTimeInMillis");
        this.suggestTotal = ApiTypeHelper.requireNonNull(builder.suggestTotal, this, "suggestTotal");
    }

    public static SearchStats of(Function<Builder, ObjectBuilder<SearchStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long concurrentAvgSliceCount() {
        return this.concurrentAvgSliceCount;
    }

    @Nullable
    public final Long concurrentQueryCurrent() {
        return this.concurrentQueryCurrent;
    }

    @Nullable
    public final Time concurrentQueryTime() {
        return this.concurrentQueryTime;
    }

    @Nullable
    public final Long concurrentQueryTimeInMillis() {
        return this.concurrentQueryTimeInMillis;
    }

    @Nullable
    public final Long concurrentQueryTotal() {
        return this.concurrentQueryTotal;
    }

    public final long fetchCurrent() {
        return this.fetchCurrent;
    }

    @Nullable
    public final Time fetchTime() {
        return this.fetchTime;
    }

    public final long fetchTimeInMillis() {
        return this.fetchTimeInMillis;
    }

    public final long fetchTotal() {
        return this.fetchTotal;
    }

    @Nonnull
    public final Map<String, SearchStats> groups() {
        return this.groups;
    }

    @Nullable
    public final Long openContexts() {
        return this.openContexts;
    }

    @Nullable
    public final Long pointInTimeCurrent() {
        return this.pointInTimeCurrent;
    }

    @Nullable
    public final Time pointInTimeTime() {
        return this.pointInTimeTime;
    }

    @Nullable
    public final Long pointInTimeTimeInMillis() {
        return this.pointInTimeTimeInMillis;
    }

    @Nullable
    public final Long pointInTimeTotal() {
        return this.pointInTimeTotal;
    }

    public final long queryCurrent() {
        return this.queryCurrent;
    }

    @Nullable
    public final Time queryTime() {
        return this.queryTime;
    }

    public final long queryTimeInMillis() {
        return this.queryTimeInMillis;
    }

    public final long queryTotal() {
        return this.queryTotal;
    }

    @Nonnull
    public final Map<String, RequestStats> request() {
        return this.request;
    }

    public final long scrollCurrent() {
        return this.scrollCurrent;
    }

    @Nullable
    public final Time scrollTime() {
        return this.scrollTime;
    }

    public final long scrollTimeInMillis() {
        return this.scrollTimeInMillis;
    }

    public final long scrollTotal() {
        return this.scrollTotal;
    }

    @Nullable
    public final Long searchIdleReactivateCountTotal() {
        return this.searchIdleReactivateCountTotal;
    }

    public final long suggestCurrent() {
        return this.suggestCurrent;
    }

    @Nullable
    public final Time suggestTime() {
        return this.suggestTime;
    }

    public final long suggestTimeInMillis() {
        return this.suggestTimeInMillis;
    }

    public final long suggestTotal() {
        return this.suggestTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.concurrentAvgSliceCount != null) {
            generator.writeKey("concurrent_avg_slice_count");
            generator.write(this.concurrentAvgSliceCount.longValue());
        }
        if (this.concurrentQueryCurrent != null) {
            generator.writeKey("concurrent_query_current");
            generator.write(this.concurrentQueryCurrent.longValue());
        }
        if (this.concurrentQueryTime != null) {
            generator.writeKey("concurrent_query_time");
            this.concurrentQueryTime.serialize(generator, mapper);
        }
        if (this.concurrentQueryTimeInMillis != null) {
            generator.writeKey("concurrent_query_time_in_millis");
            generator.write(this.concurrentQueryTimeInMillis.longValue());
        }
        if (this.concurrentQueryTotal != null) {
            generator.writeKey("concurrent_query_total");
            generator.write(this.concurrentQueryTotal.longValue());
        }
        generator.writeKey("fetch_current");
        generator.write(this.fetchCurrent);
        if (this.fetchTime != null) {
            generator.writeKey("fetch_time");
            this.fetchTime.serialize(generator, mapper);
        }
        generator.writeKey("fetch_time_in_millis");
        generator.write(this.fetchTimeInMillis);
        generator.writeKey("fetch_total");
        generator.write(this.fetchTotal);
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartObject();
            for (Map.Entry<String, SearchStats> entry : this.groups.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.openContexts != null) {
            generator.writeKey("open_contexts");
            generator.write(this.openContexts.longValue());
        }
        if (this.pointInTimeCurrent != null) {
            generator.writeKey("point_in_time_current");
            generator.write(this.pointInTimeCurrent.longValue());
        }
        if (this.pointInTimeTime != null) {
            generator.writeKey("point_in_time_time");
            this.pointInTimeTime.serialize(generator, mapper);
        }
        if (this.pointInTimeTimeInMillis != null) {
            generator.writeKey("point_in_time_time_in_millis");
            generator.write(this.pointInTimeTimeInMillis.longValue());
        }
        if (this.pointInTimeTotal != null) {
            generator.writeKey("point_in_time_total");
            generator.write(this.pointInTimeTotal.longValue());
        }
        generator.writeKey("query_current");
        generator.write(this.queryCurrent);
        if (this.queryTime != null) {
            generator.writeKey("query_time");
            this.queryTime.serialize(generator, mapper);
        }
        generator.writeKey("query_time_in_millis");
        generator.write(this.queryTimeInMillis);
        generator.writeKey("query_total");
        generator.write(this.queryTotal);
        if (ApiTypeHelper.isDefined(this.request)) {
            generator.writeKey("request");
            generator.writeStartObject();
            for (Map.Entry<String, ToCopyableBuilder<Builder, SearchStats>> entry : this.request.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RequestStats)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("scroll_current");
        generator.write(this.scrollCurrent);
        if (this.scrollTime != null) {
            generator.writeKey("scroll_time");
            this.scrollTime.serialize(generator, mapper);
        }
        generator.writeKey("scroll_time_in_millis");
        generator.write(this.scrollTimeInMillis);
        generator.writeKey("scroll_total");
        generator.write(this.scrollTotal);
        if (this.searchIdleReactivateCountTotal != null) {
            generator.writeKey("search_idle_reactivate_count_total");
            generator.write(this.searchIdleReactivateCountTotal.longValue());
        }
        generator.writeKey("suggest_current");
        generator.write(this.suggestCurrent);
        if (this.suggestTime != null) {
            generator.writeKey("suggest_time");
            this.suggestTime.serialize(generator, mapper);
        }
        generator.writeKey("suggest_time_in_millis");
        generator.write(this.suggestTimeInMillis);
        generator.writeKey("suggest_total");
        generator.write(this.suggestTotal);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSearchStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::concurrentAvgSliceCount, JsonpDeserializer.longDeserializer(), "concurrent_avg_slice_count");
        op.add(Builder::concurrentQueryCurrent, JsonpDeserializer.longDeserializer(), "concurrent_query_current");
        op.add(Builder::concurrentQueryTime, Time._DESERIALIZER, "concurrent_query_time");
        op.add(Builder::concurrentQueryTimeInMillis, JsonpDeserializer.longDeserializer(), "concurrent_query_time_in_millis");
        op.add(Builder::concurrentQueryTotal, JsonpDeserializer.longDeserializer(), "concurrent_query_total");
        op.add(Builder::fetchCurrent, JsonpDeserializer.longDeserializer(), "fetch_current");
        op.add(Builder::fetchTime, Time._DESERIALIZER, "fetch_time");
        op.add(Builder::fetchTimeInMillis, JsonpDeserializer.longDeserializer(), "fetch_time_in_millis");
        op.add(Builder::fetchTotal, JsonpDeserializer.longDeserializer(), "fetch_total");
        op.add(Builder::groups, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "groups");
        op.add(Builder::openContexts, JsonpDeserializer.longDeserializer(), "open_contexts");
        op.add(Builder::pointInTimeCurrent, JsonpDeserializer.longDeserializer(), "point_in_time_current");
        op.add(Builder::pointInTimeTime, Time._DESERIALIZER, "point_in_time_time");
        op.add(Builder::pointInTimeTimeInMillis, JsonpDeserializer.longDeserializer(), "point_in_time_time_in_millis");
        op.add(Builder::pointInTimeTotal, JsonpDeserializer.longDeserializer(), "point_in_time_total");
        op.add(Builder::queryCurrent, JsonpDeserializer.longDeserializer(), "query_current");
        op.add(Builder::queryTime, Time._DESERIALIZER, "query_time");
        op.add(Builder::queryTimeInMillis, JsonpDeserializer.longDeserializer(), "query_time_in_millis");
        op.add(Builder::queryTotal, JsonpDeserializer.longDeserializer(), "query_total");
        op.add(Builder::request, JsonpDeserializer.stringMapDeserializer(RequestStats._DESERIALIZER), "request");
        op.add(Builder::scrollCurrent, JsonpDeserializer.longDeserializer(), "scroll_current");
        op.add(Builder::scrollTime, Time._DESERIALIZER, "scroll_time");
        op.add(Builder::scrollTimeInMillis, JsonpDeserializer.longDeserializer(), "scroll_time_in_millis");
        op.add(Builder::scrollTotal, JsonpDeserializer.longDeserializer(), "scroll_total");
        op.add(Builder::searchIdleReactivateCountTotal, JsonpDeserializer.longDeserializer(), "search_idle_reactivate_count_total");
        op.add(Builder::suggestCurrent, JsonpDeserializer.longDeserializer(), "suggest_current");
        op.add(Builder::suggestTime, Time._DESERIALIZER, "suggest_time");
        op.add(Builder::suggestTimeInMillis, JsonpDeserializer.longDeserializer(), "suggest_time_in_millis");
        op.add(Builder::suggestTotal, JsonpDeserializer.longDeserializer(), "suggest_total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.concurrentAvgSliceCount);
        result = 31 * result + Objects.hashCode(this.concurrentQueryCurrent);
        result = 31 * result + Objects.hashCode(this.concurrentQueryTime);
        result = 31 * result + Objects.hashCode(this.concurrentQueryTimeInMillis);
        result = 31 * result + Objects.hashCode(this.concurrentQueryTotal);
        result = 31 * result + Long.hashCode(this.fetchCurrent);
        result = 31 * result + Objects.hashCode(this.fetchTime);
        result = 31 * result + Long.hashCode(this.fetchTimeInMillis);
        result = 31 * result + Long.hashCode(this.fetchTotal);
        result = 31 * result + Objects.hashCode(this.groups);
        result = 31 * result + Objects.hashCode(this.openContexts);
        result = 31 * result + Objects.hashCode(this.pointInTimeCurrent);
        result = 31 * result + Objects.hashCode(this.pointInTimeTime);
        result = 31 * result + Objects.hashCode(this.pointInTimeTimeInMillis);
        result = 31 * result + Objects.hashCode(this.pointInTimeTotal);
        result = 31 * result + Long.hashCode(this.queryCurrent);
        result = 31 * result + Objects.hashCode(this.queryTime);
        result = 31 * result + Long.hashCode(this.queryTimeInMillis);
        result = 31 * result + Long.hashCode(this.queryTotal);
        result = 31 * result + Objects.hashCode(this.request);
        result = 31 * result + Long.hashCode(this.scrollCurrent);
        result = 31 * result + Objects.hashCode(this.scrollTime);
        result = 31 * result + Long.hashCode(this.scrollTimeInMillis);
        result = 31 * result + Long.hashCode(this.scrollTotal);
        result = 31 * result + Objects.hashCode(this.searchIdleReactivateCountTotal);
        result = 31 * result + Long.hashCode(this.suggestCurrent);
        result = 31 * result + Objects.hashCode(this.suggestTime);
        result = 31 * result + Long.hashCode(this.suggestTimeInMillis);
        result = 31 * result + Long.hashCode(this.suggestTotal);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchStats other = (SearchStats)o;
        return Objects.equals(this.concurrentAvgSliceCount, other.concurrentAvgSliceCount) && Objects.equals(this.concurrentQueryCurrent, other.concurrentQueryCurrent) && Objects.equals(this.concurrentQueryTime, other.concurrentQueryTime) && Objects.equals(this.concurrentQueryTimeInMillis, other.concurrentQueryTimeInMillis) && Objects.equals(this.concurrentQueryTotal, other.concurrentQueryTotal) && this.fetchCurrent == other.fetchCurrent && Objects.equals(this.fetchTime, other.fetchTime) && this.fetchTimeInMillis == other.fetchTimeInMillis && this.fetchTotal == other.fetchTotal && Objects.equals(this.groups, other.groups) && Objects.equals(this.openContexts, other.openContexts) && Objects.equals(this.pointInTimeCurrent, other.pointInTimeCurrent) && Objects.equals(this.pointInTimeTime, other.pointInTimeTime) && Objects.equals(this.pointInTimeTimeInMillis, other.pointInTimeTimeInMillis) && Objects.equals(this.pointInTimeTotal, other.pointInTimeTotal) && this.queryCurrent == other.queryCurrent && Objects.equals(this.queryTime, other.queryTime) && this.queryTimeInMillis == other.queryTimeInMillis && this.queryTotal == other.queryTotal && Objects.equals(this.request, other.request) && this.scrollCurrent == other.scrollCurrent && Objects.equals(this.scrollTime, other.scrollTime) && this.scrollTimeInMillis == other.scrollTimeInMillis && this.scrollTotal == other.scrollTotal && Objects.equals(this.searchIdleReactivateCountTotal, other.searchIdleReactivateCountTotal) && this.suggestCurrent == other.suggestCurrent && Objects.equals(this.suggestTime, other.suggestTime) && this.suggestTimeInMillis == other.suggestTimeInMillis && this.suggestTotal == other.suggestTotal;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SearchStats> {
        @Nullable
        private Long concurrentAvgSliceCount;
        @Nullable
        private Long concurrentQueryCurrent;
        @Nullable
        private Time concurrentQueryTime;
        @Nullable
        private Long concurrentQueryTimeInMillis;
        @Nullable
        private Long concurrentQueryTotal;
        private Long fetchCurrent;
        @Nullable
        private Time fetchTime;
        private Long fetchTimeInMillis;
        private Long fetchTotal;
        @Nullable
        private Map<String, SearchStats> groups;
        @Nullable
        private Long openContexts;
        @Nullable
        private Long pointInTimeCurrent;
        @Nullable
        private Time pointInTimeTime;
        @Nullable
        private Long pointInTimeTimeInMillis;
        @Nullable
        private Long pointInTimeTotal;
        private Long queryCurrent;
        @Nullable
        private Time queryTime;
        private Long queryTimeInMillis;
        private Long queryTotal;
        @Nullable
        private Map<String, RequestStats> request;
        private Long scrollCurrent;
        @Nullable
        private Time scrollTime;
        private Long scrollTimeInMillis;
        private Long scrollTotal;
        @Nullable
        private Long searchIdleReactivateCountTotal;
        private Long suggestCurrent;
        @Nullable
        private Time suggestTime;
        private Long suggestTimeInMillis;
        private Long suggestTotal;

        public Builder() {
        }

        private Builder(SearchStats o) {
            this.concurrentAvgSliceCount = o.concurrentAvgSliceCount;
            this.concurrentQueryCurrent = o.concurrentQueryCurrent;
            this.concurrentQueryTime = o.concurrentQueryTime;
            this.concurrentQueryTimeInMillis = o.concurrentQueryTimeInMillis;
            this.concurrentQueryTotal = o.concurrentQueryTotal;
            this.fetchCurrent = o.fetchCurrent;
            this.fetchTime = o.fetchTime;
            this.fetchTimeInMillis = o.fetchTimeInMillis;
            this.fetchTotal = o.fetchTotal;
            this.groups = Builder._mapCopy(o.groups);
            this.openContexts = o.openContexts;
            this.pointInTimeCurrent = o.pointInTimeCurrent;
            this.pointInTimeTime = o.pointInTimeTime;
            this.pointInTimeTimeInMillis = o.pointInTimeTimeInMillis;
            this.pointInTimeTotal = o.pointInTimeTotal;
            this.queryCurrent = o.queryCurrent;
            this.queryTime = o.queryTime;
            this.queryTimeInMillis = o.queryTimeInMillis;
            this.queryTotal = o.queryTotal;
            this.request = Builder._mapCopy(o.request);
            this.scrollCurrent = o.scrollCurrent;
            this.scrollTime = o.scrollTime;
            this.scrollTimeInMillis = o.scrollTimeInMillis;
            this.scrollTotal = o.scrollTotal;
            this.searchIdleReactivateCountTotal = o.searchIdleReactivateCountTotal;
            this.suggestCurrent = o.suggestCurrent;
            this.suggestTime = o.suggestTime;
            this.suggestTimeInMillis = o.suggestTimeInMillis;
            this.suggestTotal = o.suggestTotal;
        }

        private Builder(Builder o) {
            this.concurrentAvgSliceCount = o.concurrentAvgSliceCount;
            this.concurrentQueryCurrent = o.concurrentQueryCurrent;
            this.concurrentQueryTime = o.concurrentQueryTime;
            this.concurrentQueryTimeInMillis = o.concurrentQueryTimeInMillis;
            this.concurrentQueryTotal = o.concurrentQueryTotal;
            this.fetchCurrent = o.fetchCurrent;
            this.fetchTime = o.fetchTime;
            this.fetchTimeInMillis = o.fetchTimeInMillis;
            this.fetchTotal = o.fetchTotal;
            this.groups = Builder._mapCopy(o.groups);
            this.openContexts = o.openContexts;
            this.pointInTimeCurrent = o.pointInTimeCurrent;
            this.pointInTimeTime = o.pointInTimeTime;
            this.pointInTimeTimeInMillis = o.pointInTimeTimeInMillis;
            this.pointInTimeTotal = o.pointInTimeTotal;
            this.queryCurrent = o.queryCurrent;
            this.queryTime = o.queryTime;
            this.queryTimeInMillis = o.queryTimeInMillis;
            this.queryTotal = o.queryTotal;
            this.request = Builder._mapCopy(o.request);
            this.scrollCurrent = o.scrollCurrent;
            this.scrollTime = o.scrollTime;
            this.scrollTimeInMillis = o.scrollTimeInMillis;
            this.scrollTotal = o.scrollTotal;
            this.searchIdleReactivateCountTotal = o.searchIdleReactivateCountTotal;
            this.suggestCurrent = o.suggestCurrent;
            this.suggestTime = o.suggestTime;
            this.suggestTimeInMillis = o.suggestTimeInMillis;
            this.suggestTotal = o.suggestTotal;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder concurrentAvgSliceCount(@Nullable Long value) {
            this.concurrentAvgSliceCount = value;
            return this;
        }

        @Nonnull
        public final Builder concurrentQueryCurrent(@Nullable Long value) {
            this.concurrentQueryCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder concurrentQueryTime(@Nullable Time value) {
            this.concurrentQueryTime = value;
            return this;
        }

        @Nonnull
        public final Builder concurrentQueryTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.concurrentQueryTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder concurrentQueryTimeInMillis(@Nullable Long value) {
            this.concurrentQueryTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder concurrentQueryTotal(@Nullable Long value) {
            this.concurrentQueryTotal = value;
            return this;
        }

        @Nonnull
        public final Builder fetchCurrent(long value) {
            this.fetchCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder fetchTime(@Nullable Time value) {
            this.fetchTime = value;
            return this;
        }

        @Nonnull
        public final Builder fetchTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fetchTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder fetchTimeInMillis(long value) {
            this.fetchTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder fetchTotal(long value) {
            this.fetchTotal = value;
            return this;
        }

        @Nonnull
        public final Builder groups(Map<String, SearchStats> map) {
            this.groups = Builder._mapPutAll(this.groups, map);
            return this;
        }

        @Nonnull
        public final Builder groups(String key, SearchStats value) {
            this.groups = Builder._mapPut(this.groups, key, value);
            return this;
        }

        @Nonnull
        public final Builder groups(String key, Function<Builder, ObjectBuilder<SearchStats>> fn) {
            return this.groups(key, fn.apply(new Builder()).build());
        }

        @Nonnull
        public final Builder openContexts(@Nullable Long value) {
            this.openContexts = value;
            return this;
        }

        @Nonnull
        public final Builder pointInTimeCurrent(@Nullable Long value) {
            this.pointInTimeCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder pointInTimeTime(@Nullable Time value) {
            this.pointInTimeTime = value;
            return this;
        }

        @Nonnull
        public final Builder pointInTimeTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.pointInTimeTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder pointInTimeTimeInMillis(@Nullable Long value) {
            this.pointInTimeTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder pointInTimeTotal(@Nullable Long value) {
            this.pointInTimeTotal = value;
            return this;
        }

        @Nonnull
        public final Builder queryCurrent(long value) {
            this.queryCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder queryTime(@Nullable Time value) {
            this.queryTime = value;
            return this;
        }

        @Nonnull
        public final Builder queryTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.queryTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder queryTimeInMillis(long value) {
            this.queryTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder queryTotal(long value) {
            this.queryTotal = value;
            return this;
        }

        @Nonnull
        public final Builder request(Map<String, RequestStats> map) {
            this.request = Builder._mapPutAll(this.request, map);
            return this;
        }

        @Nonnull
        public final Builder request(String key, RequestStats value) {
            this.request = Builder._mapPut(this.request, key, value);
            return this;
        }

        @Nonnull
        public final Builder request(String key, Function<RequestStats.Builder, ObjectBuilder<RequestStats>> fn) {
            return this.request(key, fn.apply(new RequestStats.Builder()).build());
        }

        @Nonnull
        public final Builder scrollCurrent(long value) {
            this.scrollCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder scrollTime(@Nullable Time value) {
            this.scrollTime = value;
            return this;
        }

        @Nonnull
        public final Builder scrollTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scrollTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder scrollTimeInMillis(long value) {
            this.scrollTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder scrollTotal(long value) {
            this.scrollTotal = value;
            return this;
        }

        @Nonnull
        public final Builder searchIdleReactivateCountTotal(@Nullable Long value) {
            this.searchIdleReactivateCountTotal = value;
            return this;
        }

        @Nonnull
        public final Builder suggestCurrent(long value) {
            this.suggestCurrent = value;
            return this;
        }

        @Nonnull
        public final Builder suggestTime(@Nullable Time value) {
            this.suggestTime = value;
            return this;
        }

        @Nonnull
        public final Builder suggestTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.suggestTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder suggestTimeInMillis(long value) {
            this.suggestTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder suggestTotal(long value) {
            this.suggestTotal = value;
            return this;
        }

        @Override
        @Nonnull
        public SearchStats build() {
            this._checkSingleUse();
            return new SearchStats(this);
        }
    }
}

