/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.remote.metadata.client.DataObjectRequest;

public abstract class WriteDataObjectRequest<R extends WriteDataObjectRequest<R>>
extends DataObjectRequest {
    protected final Long ifSeqNo;
    protected final Long ifPrimaryTerm;
    protected WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    protected TimeValue timeout = TimeValue.timeValueMinutes((long)1L);

    protected WriteDataObjectRequest(String index, String id, String tenantId, Long ifSeqNo, Long ifPrimaryTerm, WriteRequest.RefreshPolicy refreshPolicy, TimeValue timeout, boolean isCreateOperation) {
        super(index, id, tenantId);
        WriteDataObjectRequest.validateSeqNoAndPrimaryTerm(ifSeqNo, ifPrimaryTerm, isCreateOperation);
        this.ifSeqNo = ifSeqNo;
        this.ifPrimaryTerm = ifPrimaryTerm;
        if (refreshPolicy != null) {
            this.refreshPolicy = refreshPolicy;
        }
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    public Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public R setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return (R)this;
    }

    public final R timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (R)this;
    }

    public final R timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public boolean isWriteRequest() {
        return true;
    }

    protected static void validateSeqNoAndPrimaryTerm(Long ifSeqNo, Long ifPrimaryTerm, boolean createOperation) {
        if (!(!createOperation || WriteDataObjectRequest.isUnassignedSeqNo(ifSeqNo) && WriteDataObjectRequest.isUnassignedPrimaryTerm(ifPrimaryTerm))) {
            throw new IllegalArgumentException("create operations (overwriteIfExists=false) do not support compare and set with seqNo and primaryTerm.");
        }
        if (WriteDataObjectRequest.isUnassignedSeqNo(ifSeqNo) != WriteDataObjectRequest.isUnassignedPrimaryTerm(ifPrimaryTerm)) {
            throw new IllegalArgumentException("Both ifSeqNo and ifPrimaryTerm must be set or unassigned.");
        }
    }

    private static boolean isUnassignedSeqNo(Long seqNo) {
        return seqNo == null || seqNo == -2L;
    }

    private static boolean isUnassignedPrimaryTerm(Long primaryTerm) {
        return primaryTerm == null || primaryTerm == 0L;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends DataObjectRequest.Builder<T> {
        protected Long ifSeqNo = null;
        protected Long ifPrimaryTerm = null;
        protected WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
        protected TimeValue timeout = TimeValue.timeValueMinutes((long)1L);

        public T ifSeqNo(long seqNo) {
            if (seqNo < 0L && seqNo != -2L) {
                throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
            }
            this.ifSeqNo = seqNo;
            return (T)((Builder)this.self());
        }

        public T ifPrimaryTerm(long term) {
            if (term < 0L) {
                throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
            }
            this.ifPrimaryTerm = term;
            return (T)((Builder)this.self());
        }

        public T refreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return (T)((Builder)this.self());
        }

        public T timeout(TimeValue timeout) {
            this.timeout = timeout;
            return (T)((Builder)this.self());
        }

        public final T timeout(String timeout) {
            return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
        }
    }
}

