/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.preprocessor.InitialSegmentPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import java.util.Arrays;
import lombok.Generated;

public class ImputePreprocessor
extends InitialSegmentPreprocessor {
    public static ImputationMethod DEFAULT_INITIAL = ImputationMethod.LINEAR;
    public static ImputationMethod DEFAULT_DYNAMIC = ImputationMethod.PREVIOUS;
    ThresholdedRandomCutForest thresholdedRandomCutForest;

    public ImputePreprocessor(Preprocessor.Builder<?> builder) {
        super(builder);
        this.thresholdedRandomCutForest = builder.thresholdedRandomCutForest;
        this.numberOfImputed = this.shingleSize;
    }

    protected void storeInitial(double[] inputPoint, long timestamp, int[] missingValues) {
        this.initialTimeStamps[this.valuesSeen] = timestamp;
        CommonUtils.checkArgument((inputPoint.length == this.inputLength ? 1 : 0) != 0, (String)"incorrect length");
        CommonUtils.checkArgument((missingValues == null || missingValues.length <= this.inputLength ? 1 : 0) != 0, (String)"unusual missing values list");
        int length = this.inputLength + (missingValues == null ? 0 : missingValues.length);
        double[] temp = new double[length];
        System.arraycopy(inputPoint, 0, temp, 0, this.inputLength);
        if (missingValues != null) {
            for (int i = 0; i < length - this.inputLength; ++i) {
                temp[this.inputLength + i] = missingValues[i];
            }
        }
        this.initialValues[this.valuesSeen] = temp;
        ++this.valuesSeen;
    }

    void prepareInitialInput() {
        int i;
        int j;
        boolean[][] missing = new boolean[this.initialValues.length][this.inputLength];
        for (int i2 = 0; i2 < this.initialValues.length; ++i2) {
            Arrays.fill(missing[i2], false);
            int length = this.initialValues[i2].length - this.inputLength;
            for (j = 0; j < length; ++j) {
                missing[i2][(int)this.initialValues[i2][this.inputLength + j]] = true;
            }
        }
        boolean[] startingValuesSet = new boolean[this.inputLength];
        if (this.imputationMethod == ImputationMethod.ZERO) {
            for (i = 0; i < this.initialValues.length - 1; ++i) {
                for (j = 0; j < this.inputLength; ++j) {
                    this.initialValues[i][j] = missing[i][j] ? this.initialValues[i][j] : 0.0;
                }
            }
        } else if (this.imputationMethod == ImputationMethod.FIXED_VALUES || this.defaultFill != null) {
            for (i = 0; i < this.initialValues.length - 1; ++i) {
                for (j = 0; j < this.inputLength; ++j) {
                    this.initialValues[i][j] = missing[i][j] ? this.initialValues[i][j] : this.defaultFill[j];
                }
            }
        } else {
            for (int j2 = 0; j2 < this.inputLength; ++j2) {
                int next;
                for (next = 0; next < this.initialValues.length && missing[next][j2]; ++next) {
                }
                boolean bl = startingValuesSet[j2] = next < this.initialValues.length;
                if (startingValuesSet[j2]) {
                    this.initialValues[0][j2] = this.initialValues[next][j2];
                    missing[0][j2] = false;
                    int start = 0;
                    while (start < this.initialValues.length - 1) {
                        int end;
                        for (end = start + 1; end < this.initialValues.length && missing[end][j2]; ++end) {
                        }
                        if (end < this.initialValues.length && end > start + 1) {
                            for (int y = start + 1; y < end; ++y) {
                                double factor = (1.0 * (double)this.initialTimeStamps[start] - (double)this.initialTimeStamps[y]) / (double)(this.initialTimeStamps[start] - this.initialTimeStamps[end]);
                                this.initialValues[y][j2] = factor * this.initialValues[start][j2] + (1.0 - factor) * this.initialValues[end][j2];
                            }
                        }
                        start = end;
                    }
                    continue;
                }
                for (int y = 0; y < this.initialValues.length; ++y) {
                    this.initialValues[y][j2] = 0.0;
                }
            }
        }
        for (i = 0; i < this.initialValues.length; ++i) {
            this.initialValues[i] = Arrays.copyOf(this.initialValues[i], this.inputLength);
        }
    }

    @Override
    public AnomalyDescriptor preProcess(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        this.initialSetup(description, lastAnomalyDescriptor, forest);
        if (this.valuesSeen < this.startNormalization) {
            this.storeInitial(description.getCurrentInput(), description.getInputTimestamp(), description.getMissingValues());
            return description;
        }
        if (this.valuesSeen == this.startNormalization) {
            this.dischargeInitial(forest);
        }
        CommonUtils.checkArgument((description.getInputTimestamp() > this.previousTimeStamps[this.shingleSize - 1] ? 1 : 0) != 0, (String)"incorrect ordering of time");
        long[] savedTimestamps = Arrays.copyOf(this.previousTimeStamps, this.previousTimeStamps.length);
        double[] savedShingledInput = Arrays.copyOf(this.lastShingledInput, this.lastShingledInput.length);
        double[] savedShingle = Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
        int savedNumberOfImputed = this.numberOfImputed;
        int lastActualInternal = this.internalTimeStamp;
        double[] point = this.generateShingle(description, this.timeStampDeviation.getMean(), false, forest);
        this.internalTimeStamp = lastActualInternal;
        this.numberOfImputed = savedNumberOfImputed;
        this.previousTimeStamps = Arrays.copyOf(savedTimestamps, savedTimestamps.length);
        this.lastShingledInput = Arrays.copyOf(savedShingledInput, savedShingledInput.length);
        this.lastShingledPoint = Arrays.copyOf(savedShingle, savedShingle.length);
        if (point == null) {
            return description;
        }
        description.setRCFPoint(point);
        description.setInternalTimeStamp(this.internalTimeStamp + description.getNumberOfNewImputes());
        return description;
    }

    @Override
    protected void updateTimestamps(long timestamp) {
        if (this.previousTimeStamps[0] == this.previousTimeStamps[1]) {
            --this.numberOfImputed;
        }
        super.updateTimestamps(timestamp);
    }

    protected boolean updateAllowed() {
        double fraction = (double)this.numberOfImputed * 1.0 / (double)this.shingleSize;
        if (this.numberOfImputed == this.shingleSize - 1 && this.previousTimeStamps[0] != this.previousTimeStamps[1] && (this.transformMethod == TransformMethod.DIFFERENCE || this.transformMethod == TransformMethod.NORMALIZE_DIFFERENCE)) {
            return false;
        }
        this.dataQuality.update(1.0 - fraction);
        return fraction < this.useImputedFraction && this.internalTimeStamp >= this.shingleSize;
    }

    void updateForest(boolean changeForest, double[] input, long timestamp, RandomCutForest forest, boolean isImputed) {
        double[] scaledInput = this.transformValues(input, null);
        this.updateShingle(input, scaledInput);
        this.updateTimestamps(timestamp);
        if (isImputed) {
            ++this.numberOfImputed;
        }
        if (changeForest && this.updateAllowed()) {
            forest.update(this.lastShingledPoint);
        }
    }

    @Override
    public AnomalyDescriptor postProcess(AnomalyDescriptor result, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point = result.getRCFPoint();
        if (point == null) {
            return result;
        }
        if (result.getAnomalyGrade() > 0.0 && (this.numberOfImputed == 0 || result.getTransformMethod() != TransformMethod.DIFFERENCE && result.getTransformMethod() != TransformMethod.NORMALIZE_DIFFERENCE)) {
            this.addRelevantAttribution(result);
        }
        this.generateShingle(result, this.timeStampDeviation.getMean(), true, forest);
        ++this.valuesSeen;
        return result;
    }

    @Override
    protected void dischargeInitial(RandomCutForest forest) {
        Deviation tempTimeDeviation = new Deviation();
        for (int i = 0; i < this.initialTimeStamps.length - 1; ++i) {
            tempTimeDeviation.update(this.initialTimeStamps[i + 1] - this.initialTimeStamps[i]);
        }
        double timeFactor = tempTimeDeviation.getMean();
        this.prepareInitialInput();
        double[] factors = this.getFactors();
        Arrays.fill(this.previousTimeStamps, this.initialTimeStamps[0]);
        this.numberOfImputed = this.shingleSize;
        for (int i = 0; i < this.valuesSeen; ++i) {
            long lastInputTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
            if (this.internalTimeStamp > 0) {
                double[] previous = new double[this.inputLength];
                System.arraycopy(this.lastShingledInput, this.lastShingledInput.length - this.inputLength, previous, 0, this.inputLength);
                int numberToImpute = this.determineGap(this.initialTimeStamps[i] - lastInputTimeStamp, timeFactor) - 1;
                if (numberToImpute > 0) {
                    double step = 1.0 / (double)(numberToImpute + 1);
                    for (int j = 0; j < numberToImpute; ++j) {
                        double[] result = this.basicImpute(step * (double)(j + 1), previous, this.initialValues[i], DEFAULT_INITIAL);
                        double[] scaledInput = this.transformValues(result, factors);
                        this.updateShingle(result, scaledInput);
                        this.updateTimestamps(this.initialTimeStamps[i]);
                        ++this.numberOfImputed;
                        if (!this.updateAllowed()) continue;
                        forest.update(this.lastShingledPoint);
                    }
                }
            }
            double[] scaledInput = this.transformValues(this.initialValues[i], factors);
            this.updateState(this.initialValues[i], scaledInput, this.initialTimeStamps[i], lastInputTimeStamp);
            if (!this.updateAllowed()) continue;
            forest.update(this.lastShingledPoint);
        }
        this.initialTimeStamps = null;
        this.initialValues = null;
    }

    protected int determineGap(long timestampGap, double averageGap) {
        if (this.internalTimeStamp <= 1) {
            return 1;
        }
        double gap = (double)timestampGap / averageGap;
        return gap >= 1.5 ? (int)Math.ceil(gap) : 1;
    }

    protected double[] generateShingle(AnomalyDescriptor descriptor, double averageGap, boolean changeForest, RandomCutForest forest) {
        double[] input = descriptor.getCurrentInput();
        long timestamp = descriptor.getInputTimestamp();
        long lastInputTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
        int[] missingValues = descriptor.getMissingValues();
        CommonUtils.checkArgument((missingValues == null || this.imputationMethod != ImputationMethod.LINEAR && this.imputationMethod != ImputationMethod.NEXT ? 1 : 0) != 0, (String)" cannot perform imputation on most recent missing value with this method");
        CommonUtils.checkArgument((this.internalTimeStamp > 0 ? 1 : 0) != 0, (String)"imputation should have forced normalization");
        double[] savedInputShingle = Arrays.copyOf(this.lastShingledInput, this.lastShingledInput.length);
        double[] previous = new double[this.inputLength];
        System.arraycopy(this.lastShingledInput, this.lastShingledInput.length - this.inputLength, previous, 0, this.inputLength);
        int numberToImpute = this.determineGap(timestamp - lastInputTimeStamp, averageGap) - 1;
        if (numberToImpute > 0) {
            descriptor.setNumberOfNewImputes(numberToImpute);
            double step = 1.0 / (double)(numberToImpute + 1);
            for (int i = 0; i < numberToImpute; ++i) {
                double[] result = this.impute(false, descriptor, step * (double)(i + 1), previous, forest);
                this.updateForest(changeForest, result, timestamp, forest, true);
            }
        }
        double[] newInput = missingValues == null ? input : this.impute(true, descriptor, 0.0, previous, forest);
        this.updateForest(changeForest, newInput, timestamp, forest, false);
        if (changeForest) {
            this.timeStampDeviation.update(timestamp - lastInputTimeStamp);
            if (this.deviationList != null) {
                this.updateDeviation(newInput, savedInputShingle);
            }
        }
        return Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
    }

    protected double[] impute(boolean isPartial, AnomalyDescriptor descriptor, double stepFraction, double[] previous, RandomCutForest forest) {
        double[] input = descriptor.getCurrentInput();
        int[] missingValues = descriptor.getMissingValues();
        double[] partialInput = isPartial ? Arrays.copyOf(input, this.inputLength) : null;
        ImputationMethod method = descriptor.getImputationMethod();
        if (method == ImputationMethod.RCF) {
            if (descriptor.isReasonableForecast()) {
                return this.imputeRCF(forest, partialInput, missingValues);
            }
            return this.basicImpute(stepFraction, previous, partialInput, DEFAULT_DYNAMIC);
        }
        return this.basicImpute(stepFraction, previous, input, method);
    }

    protected double[] basicImpute(double stepFraction, double[] previous, double[] input, ImputationMethod method) {
        double[] result = new double[this.inputLength];
        if (method == ImputationMethod.FIXED_VALUES) {
            System.arraycopy(this.defaultFill, 0, result, 0, this.inputLength);
        } else if (method == ImputationMethod.LINEAR) {
            for (int z = 0; z < this.inputLength; ++z) {
                result[z] = previous[z] + stepFraction * (input[z] - previous[z]);
            }
        } else if (method == ImputationMethod.PREVIOUS) {
            System.arraycopy(previous, 0, result, 0, this.inputLength);
        } else if (method == ImputationMethod.NEXT) {
            System.arraycopy(input, 0, result, 0, this.inputLength);
        }
        return result;
    }

    protected double[] imputeRCF(RandomCutForest forest, double[] partialInput, int[] missingValues) {
        int[] missingIndices;
        double[] temp = Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
        this.shiftLeft(temp, this.inputLength);
        int startPosition = this.inputLength * (this.shingleSize - 1);
        if (missingValues == null) {
            missingIndices = new int[this.inputLength];
            for (int i = 0; i < this.inputLength; ++i) {
                missingIndices[i] = startPosition + i;
            }
        } else {
            CommonUtils.checkArgument((partialInput != null ? 1 : 0) != 0, (String)"incorrect input");
            missingIndices = Arrays.copyOf(missingValues, missingValues.length);
            double[] scaledInput = this.transformValues(partialInput, null);
            this.copyAtEnd(temp, scaledInput);
        }
        double[] newPoint = forest.imputeMissingValues(temp, missingIndices.length, missingIndices);
        return this.invert(this.inputLength, startPosition, 0, newPoint);
    }

    @Generated
    public ThresholdedRandomCutForest getThresholdedRandomCutForest() {
        return this.thresholdedRandomCutForest;
    }

    @Generated
    public void setThresholdedRandomCutForest(ThresholdedRandomCutForest thresholdedRandomCutForest) {
        this.thresholdedRandomCutForest = thresholdedRandomCutForest;
    }
}

