/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xypoint;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.index.IndexableField;
import org.opensearch.geometry.Point;
import org.opensearch.geospatial.index.common.xyshape.XYShapeConverter;
import org.opensearch.geospatial.index.mapper.xypoint.XYPoint;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.ParseContext;

public class XYPointIndexer
implements AbstractGeometryFieldMapper.Indexer<List<XYPoint>, List<? extends org.apache.lucene.geo.XYPoint>> {
    private final String fieldName;

    public List<? extends org.apache.lucene.geo.XYPoint> prepareForIndexing(List<XYPoint> points) {
        Objects.requireNonNull(points, "XYPoint cannot be null");
        if (points.isEmpty()) {
            throw new IllegalArgumentException("XYPoint cannot be empty");
        }
        return points.stream().map(parsedXYPoint -> new Point(parsedXYPoint.getX(), parsedXYPoint.getY())).map(XYShapeConverter::toXYPoint).collect(Collectors.toList());
    }

    public Class<List<? extends org.apache.lucene.geo.XYPoint>> processedClass() {
        Class<List> listToObjectClass = List.class;
        return listToObjectClass.getClass();
    }

    public List<IndexableField> indexShape(ParseContext context, List<? extends org.apache.lucene.geo.XYPoint> xyPoints) {
        return xyPoints.stream().map(xyPoint -> new XYPointField(this.fieldName, xyPoint.getX(), xyPoint.getY())).collect(Collectors.toList());
    }

    @Generated
    public XYPointIndexer(String fieldName) {
        this.fieldName = fieldName;
    }
}

