/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AbstractProfileRunner;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.ProfileUtil;
import org.opensearch.timeseries.TaskProfile;
import org.opensearch.timeseries.TaskProfileRunner;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.function.BiCheckedFunction;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ConfigProfile;
import org.opensearch.timeseries.model.ConfigState;
import org.opensearch.timeseries.model.InitProgressProfile;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.model.Mergeable;
import org.opensearch.timeseries.model.ModelProfileOnNode;
import org.opensearch.timeseries.model.ProfileName;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.ProfileRequest;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class ProfileRunner<TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskProfileType extends TaskProfile<TaskClass>, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, ConfigProfileType extends ConfigProfile<TaskClass, TaskProfileType>, ProfileActionType extends ActionType<ProfileResponse>, TaskProfileRunnerType extends TaskProfileRunner<TaskClass, TaskProfileType>>
extends AbstractProfileRunner {
    private final Logger logger = LogManager.getLogger(ProfileRunner.class);
    protected Client client;
    protected SecurityClientUtil clientUtil;
    protected NamedXContentRegistry xContentRegistry;
    protected DiscoveryNodeFilterer nodeFilter;
    protected final TransportService transportService;
    protected final TaskManagerType taskManager;
    protected final int maxTotalEntitiesToTrack;
    protected final AnalysisType analysisType;
    protected final List<TaskTypeEnum> realTimeTaskTypes;
    protected final List<TaskTypeEnum> batchConfigTaskTypes;
    protected int maxCategoricalFields;
    protected ProfileName taskProfile;
    protected TaskProfileRunnerType taskProfileRunner;
    protected ProfileActionType profileAction;
    protected BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser;
    protected String configIndexName;

    public ProfileRunner(Client client, SecurityClientUtil clientUtil, NamedXContentRegistry xContentRegistry, DiscoveryNodeFilterer nodeFilter, long requiredSamples, TransportService transportService, TaskManagerType taskManager, AnalysisType analysisType, List<TaskTypeEnum> realTimeTaskTypes, List<TaskTypeEnum> batchConfigTaskTypes, int maxCategoricalFields, ProfileName taskProfile, ProfileActionType profileAction, BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser, TaskProfileRunnerType taskProfileRunner, String configIndexName) {
        super(requiredSamples);
        this.client = client;
        this.clientUtil = clientUtil;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        if (requiredSamples <= 0L) {
            throw new IllegalArgumentException("required samples should be a positive number, but was " + requiredSamples);
        }
        this.transportService = transportService;
        this.taskManager = taskManager;
        this.maxTotalEntitiesToTrack = 10000;
        this.analysisType = analysisType;
        this.realTimeTaskTypes = realTimeTaskTypes;
        this.batchConfigTaskTypes = batchConfigTaskTypes;
        this.maxCategoricalFields = maxCategoricalFields;
        this.taskProfile = taskProfile;
        this.profileAction = profileAction;
        this.configParser = configParser;
        this.taskProfileRunner = taskProfileRunner;
        this.configIndexName = configIndexName;
    }

    public void profile(String configId, ActionListener<ConfigProfileType> listener, Set<ProfileName> profilesToCollect) {
        if (profilesToCollect.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException(CommonMessages.EMPTY_PROFILES_COLLECT));
            return;
        }
        this.calculateTotalResponsesToWait(configId, profilesToCollect, listener);
    }

    private void calculateTotalResponsesToWait(String configId, Set<ProfileName> profilesToCollect, ActionListener<ConfigProfileType> listener) {
        GetRequest getConfigRequest = new GetRequest(this.configIndexName, configId);
        this.client.get(getConfigRequest, ActionListener.wrap(getConfigResponse -> {
            if (getConfigResponse != null && getConfigResponse.isExists()) {
                try (XContentParser xContentParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getConfigResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xContentParser.nextToken(), (XContentParser)xContentParser);
                    Config config = this.configParser.apply(xContentParser, configId);
                    this.prepareProfile(config, listener, profilesToCollect);
                }
                catch (Exception e) {
                    this.logger.error(CommonMessages.FAIL_TO_PARSE_CONFIG_MSG + configId, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_PARSE_CONFIG_MSG + configId, RestStatus.BAD_REQUEST, new Object[0]));
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
            }
        }, exception -> {
            this.logger.error(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, (Throwable)exception);
            listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
        }));
    }

    protected void prepareProfile(Config config, ActionListener<ConfigProfileType> listener, Set<ProfileName> profilesToCollect) {
        String configId = config.getId();
        GetRequest getRequest = new GetRequest(".opendistro-anomaly-detector-jobs", configId);
        this.client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (getResponse != null && getResponse.isExists()) {
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Job job = Job.parse(parser);
                    long enabledTimeMs = job.getEnabledTime().toEpochMilli();
                    int totalResponsesToWait = 0;
                    if (profilesToCollect.contains(ProfileName.ERROR)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(ProfileName.TOTAL_ENTITIES)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(ProfileName.COORDINATING_NODE) || profilesToCollect.contains(ProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(ProfileName.MODELS) || profilesToCollect.contains(ProfileName.ACTIVE_ENTITIES) || profilesToCollect.contains(ProfileName.INIT_PROGRESS) || profilesToCollect.contains(ProfileName.STATE)) {
                        ++totalResponsesToWait;
                    }
                    if (profilesToCollect.contains(this.taskProfile)) {
                        ++totalResponsesToWait;
                    }
                    MultiResponsesDelegateActionListener delegateListener = new MultiResponsesDelegateActionListener(listener, totalResponsesToWait, CommonMessages.FAIL_FETCH_ERR_MSG + configId, false);
                    if (profilesToCollect.contains(ProfileName.ERROR)) {
                        ((TaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(configId, this.realTimeTaskTypes, task -> {
                            ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder = this.createProfileBuilder();
                            if (task.isPresent()) {
                                long lastUpdateTimeMs = ((TimeSeriesTask)task.get()).getLastUpdateTime().toEpochMilli();
                                if (lastUpdateTimeMs > enabledTimeMs && ((TimeSeriesTask)task.get()).getError() != null) {
                                    profileBuilder.error(((TimeSeriesTask)task.get()).getError());
                                }
                                delegateListener.onResponse(profileBuilder.build());
                            } else {
                                delegateListener.onResponse(profileBuilder.build());
                            }
                        }, this.transportService, false, delegateListener);
                    }
                    if (profilesToCollect.contains(ProfileName.TOTAL_ENTITIES)) {
                        this.profileEntityStats(delegateListener, config);
                    }
                    if (profilesToCollect.contains(ProfileName.COORDINATING_NODE) || profilesToCollect.contains(ProfileName.TOTAL_SIZE_IN_BYTES) || profilesToCollect.contains(ProfileName.MODELS) || profilesToCollect.contains(ProfileName.ACTIVE_ENTITIES) || profilesToCollect.contains(ProfileName.INIT_PROGRESS) || profilesToCollect.contains(ProfileName.STATE)) {
                        this.profileModels(config, profilesToCollect, job, delegateListener);
                    }
                    if (profilesToCollect.contains(this.taskProfile)) {
                        this.getLatestHistoricalTaskProfile(configId, this.transportService, null, delegateListener);
                    }
                }
                catch (Exception e) {
                    this.logger.error(CommonMessages.FAIL_TO_GET_PROFILE_MSG, (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                this.onGetDetectorForPrepare(configId, listener, profilesToCollect);
            }
        }, exception -> {
            if (ExceptionUtil.isIndexNotAvailable(exception)) {
                this.logger.info(exception.getMessage());
                this.onGetDetectorForPrepare(configId, listener, profilesToCollect);
            } else {
                this.logger.error(CommonMessages.FAIL_TO_GET_PROFILE_MSG + configId);
                listener.onFailure(exception);
            }
        }));
    }

    private void profileEntityStats(MultiResponsesDelegateActionListener<ConfigProfileType> listener, Config config) {
        List<String> categoryField = config.getCategoryFields();
        if (!config.isHighCardinality() || categoryField.size() > this.maxCategoricalFields) {
            listener.onResponse((ConfigProfileType)this.createProfileBuilder().build());
        } else if (categoryField.size() == 1) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            CardinalityAggregationBuilder aggBuilder = new CardinalityAggregationBuilder("total_entities");
            aggBuilder.field(categoryField.get(0));
            searchSourceBuilder.aggregation((AggregationBuilder)aggBuilder);
            SearchRequest request = new SearchRequest(config.getIndices().toArray(new String[0]), searchSourceBuilder);
            ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> {
                Map aggMap = searchResponse.getAggregations().asMap();
                InternalCardinality totalEntities = (InternalCardinality)aggMap.get("total_entities");
                long value = totalEntities.getValue();
                ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder = this.createProfileBuilder();
                Object profile = profileBuilder.totalEntities(value).build();
                listener.onResponse((ConfigProfileType)profile);
            }, searchException -> {
                this.logger.warn(CommonMessages.FAIL_TO_GET_TOTAL_ENTITIES + config.getId());
                listener.onFailure((Exception)searchException);
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(request, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), config.getId(), this.client, this.analysisType, searchResponseListener);
        } else {
            CompositeAggregationBuilder bucketAggs = AggregationBuilders.composite((String)"total_entities", config.getCategoryFields().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(this.maxTotalEntitiesToTrack);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)bucketAggs).trackTotalHits(false).size(0);
            SearchRequest searchRequest = new SearchRequest().indices(config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
            ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> {
                ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder = this.createProfileBuilder();
                Aggregations aggs = searchResponse.getAggregations();
                if (aggs == null) {
                    this.logger.warn("Unexpected null aggregation.");
                    listener.onResponse((ConfigProfileType)profileBuilder.totalEntities(0L).build());
                    return;
                }
                Aggregation aggrResult = aggs.get("total_entities");
                if (aggrResult == null) {
                    listener.onFailure(new IllegalArgumentException("Fail to find valid aggregation result"));
                    return;
                }
                CompositeAggregation compositeAgg = (CompositeAggregation)aggrResult;
                Object profile = profileBuilder.totalEntities(Long.valueOf(compositeAgg.getBuckets().size())).build();
                listener.onResponse((ConfigProfileType)profile);
            }, searchException -> {
                this.logger.warn(CommonMessages.FAIL_TO_GET_TOTAL_ENTITIES + config.getId());
                listener.onFailure((Exception)searchException);
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), config.getId(), this.client, this.analysisType, searchResponseListener);
        }
    }

    protected void onGetDetectorForPrepare(String configId, ActionListener<ConfigProfileType> listener, Set<ProfileName> profiles) {
        ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder = this.createProfileBuilder();
        if (profiles.contains(ProfileName.STATE)) {
            profileBuilder.state(ConfigState.DISABLED);
        }
        if (profiles.contains(this.taskProfile)) {
            this.getLatestHistoricalTaskProfile(configId, this.transportService, profileBuilder.build(), listener);
        } else {
            listener.onResponse(profileBuilder.build());
        }
    }

    protected void profileModels(Config config, Set<ProfileName> profiles, Job job, MultiResponsesDelegateActionListener<ConfigProfileType> listener) {
        DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
        ProfileRequest profileRequest = new ProfileRequest(config.getId(), profiles, dataNodes);
        if (config.isLongFrequency()) {
            ConfigProfile.Builder<TaskClass, TaskProfileType> profile = this.createProfileBuilder();
            if (profiles.contains(ProfileName.COORDINATING_NODE)) {
                profile.coordinatingNode("");
            }
            if (profiles.contains(ProfileName.TOTAL_SIZE_IN_BYTES)) {
                profile.totalSizeInBytes(0L);
            }
            if (profiles.contains(ProfileName.MODELS)) {
                profile.modelProfile(new ModelProfileOnNode[0]);
                profile.modelCount(0L);
            }
            if (config.isHighCardinality() && profiles.contains(ProfileName.ACTIVE_ENTITIES)) {
                profile.activeEntities(0L);
            }
            if (profiles.contains(ProfileName.INIT_PROGRESS) || profiles.contains(ProfileName.STATE)) {
                this.profileStateRelated(job, profiles, 0L, profile, config, listener);
            } else {
                listener.onResponse((ConfigProfileType)profile.build());
            }
        } else {
            this.client.execute(this.profileAction, (ActionRequest)profileRequest, this.onModelResponse(config, profiles, job, listener));
        }
    }

    private ActionListener<ProfileResponse> onModelResponse(Config config, Set<ProfileName> profilesToCollect, Job job, MultiResponsesDelegateActionListener<ConfigProfileType> listener) {
        boolean isMultientityDetector = config.isHighCardinality();
        return ActionListener.wrap(profileResponse -> {
            ConfigProfile.Builder<TaskClass, TaskProfileType> profile = this.createProfileBuilder();
            if (profilesToCollect.contains(ProfileName.COORDINATING_NODE)) {
                profile.coordinatingNode(profileResponse.getCoordinatingNode());
            }
            if (profilesToCollect.contains(ProfileName.TOTAL_SIZE_IN_BYTES)) {
                profile.totalSizeInBytes(profileResponse.getTotalSizeInBytes());
            }
            if (profilesToCollect.contains(ProfileName.MODELS)) {
                profile.modelProfile(profileResponse.getModelProfile());
                profile.modelCount(profileResponse.getModelCount());
            }
            if (isMultientityDetector && profilesToCollect.contains(ProfileName.ACTIVE_ENTITIES)) {
                profile.activeEntities(profileResponse.getActiveEntities());
            }
            if (profilesToCollect.contains(ProfileName.INIT_PROGRESS) || profilesToCollect.contains(ProfileName.STATE)) {
                this.profileStateRelated(job, profilesToCollect, profileResponse.getTotalUpdates(), profile, config, listener);
            } else {
                listener.onResponse((ConfigProfileType)profile.build());
            }
        }, listener::onFailure);
    }

    private void profileStateRelated(Job job, Set<ProfileName> profilesToCollect, Long totalUpdates, ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder, Config config, MultiResponsesDelegateActionListener<ConfigProfileType> listener) {
        if (job.isEnabled()) {
            if (totalUpdates < this.requiredSamples) {
                long enabledTime = job.getEnabledTime().toEpochMilli();
                ProfileUtil.confirmRealtimeResultStatus(config, enabledTime, this.client, this.analysisType, this.onInittedEver(enabledTime, profileBuilder, profilesToCollect, config, totalUpdates, listener));
            } else {
                this.createRunningStateAndInitProgress(profilesToCollect, profileBuilder);
                listener.onResponse((ConfigProfileType)profileBuilder.build());
            }
        } else {
            if (profilesToCollect.contains(ProfileName.STATE)) {
                profileBuilder.state(ConfigState.DISABLED);
            }
            listener.onResponse((ConfigProfileType)profileBuilder.build());
        }
    }

    private ActionListener<SearchResponse> onInittedEver(long lastUpdateTimeMs, ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder, Set<ProfileName> profilesToCollect, Config config, long totalUpdates, MultiResponsesDelegateActionListener<ConfigProfileType> listener) {
        return ActionListener.wrap(searchResponse -> {
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits().value() == 0L) {
                this.processInitResponse(config, profilesToCollect, totalUpdates, false, profileBuilder, listener);
            } else {
                this.createRunningStateAndInitProgress(profilesToCollect, profileBuilder);
                listener.onResponse((ConfigProfileType)profileBuilder.build());
            }
        }, exception -> {
            if (ExceptionUtil.isIndexNotAvailable(exception)) {
                this.processInitResponse(config, profilesToCollect, totalUpdates, false, profileBuilder, listener);
            } else {
                this.logger.error("Fail to find any anomaly result with anomaly score larger than 0 after AD job enabled time for detector {}", (Object)config.getId());
                listener.onFailure((Exception)exception);
            }
        });
    }

    protected void createRunningStateAndInitProgress(Set<ProfileName> profilesToCollect, ConfigProfile.Builder<TaskClass, TaskProfileType> builder) {
        if (profilesToCollect.contains(ProfileName.STATE)) {
            builder.state(ConfigState.RUNNING).build();
        }
        if (profilesToCollect.contains(ProfileName.INIT_PROGRESS)) {
            InitProgressProfile initProgress = new InitProgressProfile("100%", 0L, 0);
            builder.initProgress(initProgress);
        }
    }

    protected void processInitResponse(Config config, Set<ProfileName> profilesToCollect, long totalUpdates, boolean hideMinutesLeft, ConfigProfile.Builder<TaskClass, TaskProfileType> builder, MultiResponsesDelegateActionListener<ConfigProfileType> listener) {
        if (profilesToCollect.contains(ProfileName.STATE)) {
            builder.state(ConfigState.INIT);
        }
        if (profilesToCollect.contains(ProfileName.INIT_PROGRESS)) {
            if (hideMinutesLeft) {
                InitProgressProfile initProgress = this.computeInitProgressProfile(totalUpdates, 0L);
                builder.initProgress(initProgress);
            } else {
                long intervalMins = ((IntervalTimeConfiguration)config.getInterval()).toDuration().toMinutes();
                InitProgressProfile initProgress = this.computeInitProgressProfile(totalUpdates, intervalMins);
                builder.initProgress(initProgress);
            }
        }
        listener.onResponse((ConfigProfileType)builder.build());
    }

    public void getLatestHistoricalTaskProfile(String configId, TransportService transportService, ConfigProfileType profile, ActionListener<ConfigProfileType> listener) {
        ((TaskManager)this.taskManager).getAndExecuteOnLatestConfigTask(configId, null, null, this.batchConfigTaskTypes, task -> {
            if (task.isPresent()) {
                this.taskProfileRunner.getTaskProfile((TimeSeriesTask)((TimeSeriesTask)task.get()), ActionListener.wrap(taskProfile -> {
                    ConfigProfile.Builder<TaskClass, TaskProfile> profileBuilder = this.createProfileBuilder();
                    profileBuilder.taskProfile((TaskProfile)taskProfile);
                    Object configProfile = profileBuilder.build();
                    ((ConfigProfile)configProfile).merge((Mergeable)profile);
                    listener.onResponse(configProfile);
                }, e -> {
                    this.logger.error("Failed to get task profile for task " + ((TimeSeriesTask)task.get()).getTaskId(), (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                ConfigProfile.Builder<TaskClass, TaskProfileType> profileBuilder = this.createProfileBuilder();
                listener.onResponse(profileBuilder.build());
            }
        }, transportService, false, listener);
    }

    protected abstract ConfigProfile.Builder<TaskClass, TaskProfileType> createProfileBuilder();
}

